/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.util.HashMap;
import org.h2.bnf.Bnf;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleHead;
import org.h2.bnf.Sentence;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RuleFixed
implements Rule {
    public static final int YMD = 0;
    public static final int HMS = 1;
    public static final int NANOS = 2;
    public static final int ANY_EXCEPT_SINGLE_QUOTE = 3;
    public static final int ANY_EXCEPT_DOUBLE_QUOTE = 4;
    public static final int ANY_UNTIL_EOL = 5;
    public static final int ANY_UNTIL_END = 6;
    public static final int ANY_WORD = 7;
    public static final int ANY_EXCEPT_2_DOLLAR = 8;
    public static final int HEX_START = 9;
    public static final int OCTAL_START = 10;
    public static final int BINARY_START = 11;
    public static final int CONCAT = 12;
    public static final int AZ_UNDERSCORE = 13;
    public static final int AF = 14;
    public static final int DIGIT = 15;
    public static final int OPEN_BRACKET = 16;
    public static final int CLOSE_BRACKET = 17;
    public static final int JSON_TEXT = 18;
    private final int type;

    RuleFixed(int type) {
        this.type = type;
    }

    @Override
    public void accept(BnfVisitor visitor) {
        visitor.visitRuleFixed(this.type);
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> ruleMap) {
    }

    @Override
    public boolean autoComplete(Sentence sentence) {
        String query;
        sentence.stopIfRequired();
        String s = query = sentence.getQuery();
        boolean removeTrailingSpaces = false;
        switch (this.type) {
            case 0: {
                while (s.length() > 0 && "0123456789-".indexOf(s.charAt(0)) >= 0) {
                    s = s.substring(1);
                }
                if (s.length() == 0) {
                    sentence.add("2006-01-01", "1", 1);
                }
                removeTrailingSpaces = true;
                break;
            }
            case 1: {
                while (s.length() > 0 && "0123456789:".indexOf(s.charAt(0)) >= 0) {
                    s = s.substring(1);
                }
                if (s.length() != 0) break;
                sentence.add("12:00:00", "1", 1);
                break;
            }
            case 2: {
                while (s.length() > 0 && Character.isDigit(s.charAt(0))) {
                    s = s.substring(1);
                }
                if (s.length() == 0) {
                    sentence.add("nanoseconds", "0", 1);
                }
                removeTrailingSpaces = true;
                break;
            }
            case 3: {
                while (true) {
                    if (s.length() > 0 && s.charAt(0) != '\'') {
                        s = s.substring(1);
                        continue;
                    }
                    if (!s.startsWith("''")) break;
                    s = s.substring(2);
                }
                if (s.length() != 0) break;
                sentence.add("anything", "Hello World", 1);
                sentence.add("'", "'", 1);
                break;
            }
            case 8: {
                while (s.length() > 0 && !s.startsWith("$$")) {
                    s = s.substring(1);
                }
                if (s.length() != 0) break;
                sentence.add("anything", "Hello World", 1);
                sentence.add("$$", "$$", 1);
                break;
            }
            case 4: {
                while (true) {
                    if (s.length() > 0 && s.charAt(0) != '\"') {
                        s = s.substring(1);
                        continue;
                    }
                    if (!s.startsWith("\"\"")) break;
                    s = s.substring(2);
                }
                if (s.length() != 0) break;
                sentence.add("anything", "identifier", 1);
                sentence.add("\"", "\"", 1);
                break;
            }
            case 7: 
            case 18: {
                while (s.length() > 0 && !Bnf.startWithSpace(s)) {
                    s = s.substring(1);
                }
                if (s.length() != 0) break;
                sentence.add("anything", "anything", 1);
                break;
            }
            case 9: {
                if (s.startsWith("0X") || s.startsWith("0x")) {
                    s = s.substring(2);
                    break;
                }
                if ("0".equals(s)) {
                    sentence.add("0x", "x", 1);
                    break;
                }
                if (s.length() != 0) break;
                sentence.add("0x", "0x", 1);
                break;
            }
            case 10: {
                if (s.startsWith("0O") || s.startsWith("0o")) {
                    s = s.substring(2);
                    break;
                }
                if ("0".equals(s)) {
                    sentence.add("0o", "o", 1);
                    break;
                }
                if (s.length() != 0) break;
                sentence.add("0o", "0o", 1);
                break;
            }
            case 11: {
                if (s.startsWith("0B") || s.startsWith("0b")) {
                    s = s.substring(2);
                    break;
                }
                if ("0".equals(s)) {
                    sentence.add("0b", "b", 1);
                    break;
                }
                if (s.length() != 0) break;
                sentence.add("0b", "0b", 1);
                break;
            }
            case 12: {
                if (s.equals("|")) {
                    sentence.add("||", "|", 1);
                } else if (s.startsWith("||")) {
                    s = s.substring(2);
                } else if (s.length() == 0) {
                    sentence.add("||", "||", 1);
                }
                removeTrailingSpaces = true;
                break;
            }
            case 13: {
                if (s.length() > 0 && (Character.isLetter(s.charAt(0)) || s.charAt(0) == '_')) {
                    s = s.substring(1);
                }
                if (s.length() != 0) break;
                sentence.add("character", "A", 1);
                break;
            }
            case 14: {
                char ch;
                if (s.length() > 0 && (ch = Character.toUpperCase(s.charAt(0))) >= 'A' && ch <= 'F') {
                    s = s.substring(1);
                }
                if (s.length() != 0) break;
                sentence.add("hex character", "0A", 1);
                break;
            }
            case 15: {
                if (s.length() > 0 && Character.isDigit(s.charAt(0))) {
                    s = s.substring(1);
                }
                if (s.length() != 0) break;
                sentence.add("digit", "1", 1);
                break;
            }
            case 16: {
                if (s.length() == 0) {
                    sentence.add("[", "[", 1);
                } else if (s.charAt(0) == '[') {
                    s = s.substring(1);
                }
                removeTrailingSpaces = true;
                break;
            }
            case 17: {
                if (s.length() == 0) {
                    sentence.add("]", "]", 1);
                } else if (s.charAt(0) == ']') {
                    s = s.substring(1);
                }
                removeTrailingSpaces = true;
                break;
            }
            default: {
                throw new AssertionError((Object)("type=" + this.type));
            }
        }
        if (!s.equals(query)) {
            if (removeTrailingSpaces) {
                while (Bnf.startWithSpace(s)) {
                    s = s.substring(1);
                }
            }
            sentence.setQuery(s);
            return true;
        }
        return false;
    }

    public String toString() {
        return "#" + this.type;
    }
}

