/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.util.HashMap;
import org.h2.bnf.Bnf;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleHead;
import org.h2.bnf.Sentence;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RuleRepeat
implements Rule {
    private final Rule rule;
    private final boolean comma;

    public RuleRepeat(Rule rule, boolean comma) {
        this.rule = rule;
        this.comma = comma;
    }

    @Override
    public void accept(BnfVisitor visitor) {
        visitor.visitRuleRepeat(this.comma, this.rule);
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> ruleMap) {
    }

    @Override
    public boolean autoComplete(Sentence sentence) {
        sentence.stopIfRequired();
        while (this.rule.autoComplete(sentence)) {
        }
        String s = sentence.getQuery();
        while (Bnf.startWithSpace(s)) {
            s = s.substring(1);
        }
        sentence.setQuery(s);
        return true;
    }

    public String toString() {
        return this.comma ? ", ..." : " ...";
    }
}

