/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.bnf.context.DbContents;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DbColumn {
    private final String name;
    private final String quotedName;
    private final String dataType;
    private final int position;

    private DbColumn(DbContents contents, ResultSet rs, boolean procedureColumn) throws SQLException {
        String scaleColumnName;
        String precisionColumnName;
        this.name = rs.getString("COLUMN_NAME");
        this.quotedName = contents.quoteIdentifier(this.name);
        this.position = rs.getInt("ORDINAL_POSITION");
        if (contents.isH2() && !procedureColumn) {
            this.dataType = rs.getString("COLUMN_TYPE");
            return;
        }
        Object type = rs.getString("TYPE_NAME");
        if (procedureColumn) {
            precisionColumnName = "PRECISION";
            scaleColumnName = "SCALE";
        } else {
            precisionColumnName = "COLUMN_SIZE";
            scaleColumnName = "DECIMAL_DIGITS";
        }
        int precision = rs.getInt(precisionColumnName);
        if (precision > 0 && !contents.isSQLite()) {
            int scale = rs.getInt(scaleColumnName);
            type = scale > 0 ? (String)type + "(" + precision + ", " + scale + ")" : (String)type + "(" + precision + ")";
        }
        if (rs.getInt("NULLABLE") == 0) {
            type = (String)type + " NOT NULL";
        }
        this.dataType = type;
    }

    public static DbColumn getProcedureColumn(DbContents contents, ResultSet rs) throws SQLException {
        return new DbColumn(contents, rs, true);
    }

    public static DbColumn getColumn(DbContents contents, ResultSet rs) throws SQLException {
        return new DbColumn(contents, rs, false);
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName() {
        return this.quotedName;
    }

    public int getPosition() {
        return this.position;
    }
}

