/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.util.HashMap;
import java.util.HashSet;
import org.h2.bnf.Bnf;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleElement;
import org.h2.bnf.RuleHead;
import org.h2.bnf.RuleList;
import org.h2.bnf.Sentence;
import org.h2.bnf.context.DbColumn;
import org.h2.bnf.context.DbContents;
import org.h2.bnf.context.DbProcedure;
import org.h2.bnf.context.DbSchema;
import org.h2.bnf.context.DbTableOrView;
import org.h2.message.DbException;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DbContextRule
implements Rule {
    public static final int COLUMN = 0;
    public static final int TABLE = 1;
    public static final int TABLE_ALIAS = 2;
    public static final int NEW_TABLE_ALIAS = 3;
    public static final int COLUMN_ALIAS = 4;
    public static final int SCHEMA = 5;
    public static final int PROCEDURE = 6;
    private final DbContents contents;
    private final int type;
    private String columnType;

    public DbContextRule(DbContents contents, int type) {
        this.contents = contents;
        this.type = type;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> ruleMap) {
    }

    @Override
    public void accept(BnfVisitor visitor) {
    }

    @Override
    public boolean autoComplete(Sentence sentence) {
        String query;
        String s = query = sentence.getQuery();
        switch (this.type) {
            case 5: {
                Object name;
                Object schema;
                DbSchema[] schemas = this.contents.getSchemas();
                Object best = null;
                Object bestSchema = null;
                Object[] objectArray = schemas;
                int n3 = schemas.length;
                int n2 = 0;
                while (n2 < n3) {
                    schema = objectArray[n2];
                    name = ((DbSchema)schema).name;
                    String quotedName = StringUtils.quoteIdentifier((String)name);
                    if (StringUtils.startsWithIgnoringCase(query, (String)name)) {
                        if (best == null || ((String)name).length() > ((String)best).length()) {
                            best = name;
                            bestSchema = schema;
                        }
                    } else if (StringUtils.startsWith(query, quotedName)) {
                        if (best == null || ((String)name).length() > ((String)best).length()) {
                            best = quotedName;
                            bestSchema = schema;
                        }
                    } else if ((s.isEmpty() || StringUtils.startsWithIgnoringCase((String)name, query) || StringUtils.startsWithIgnoringCase(quotedName, query)) && s.length() < ((String)name).length()) {
                        sentence.add((String)name, ((String)name).substring(s.length()), this.type);
                        sentence.add(((DbSchema)schema).quotedName + ".", ((DbSchema)schema).quotedName.substring(s.length()) + ".", 0);
                    }
                    ++n2;
                }
                if (best == null) break;
                sentence.setLastMatchedSchema((DbSchema)bestSchema);
                s = s.substring(((String)best).length());
                break;
            }
            case 1: {
                DbSchema schema = sentence.getLastMatchedSchema();
                if (schema == null) {
                    schema = this.contents.getDefaultSchema();
                }
                DbTableOrView[] tables = schema.getTables();
                String best = null;
                DbTableOrView bestTable = null;
                Object name = tables;
                int n = tables.length;
                int n3 = 0;
                while (n3 < n) {
                    DbTableOrView table = name[n3];
                    String name2 = table.getName();
                    String quotedName = StringUtils.quoteIdentifier(name2);
                    if (StringUtils.startsWithIgnoringCase(query, name2) || StringUtils.startsWithIgnoringCase("\"" + query, quotedName)) {
                        if (best == null || name2.length() > best.length()) {
                            best = name2;
                            bestTable = table;
                        }
                    } else if ((s.isEmpty() || StringUtils.startsWithIgnoringCase(name2, query) || StringUtils.startsWithIgnoringCase(quotedName, query)) && s.length() < name2.length()) {
                        sentence.add(table.getQuotedName(), table.getQuotedName().substring(s.length()), 0);
                    }
                    ++n3;
                }
                if (best == null) break;
                sentence.setLastMatchedTable(bestTable);
                sentence.addTable(bestTable);
                s = s.substring(best.length());
                break;
            }
            case 3: {
                s = DbContextRule.autoCompleteTableAlias(sentence, true);
                break;
            }
            case 2: {
                s = DbContextRule.autoCompleteTableAlias(sentence, false);
                break;
            }
            case 4: {
                int i = 0;
                if (query.indexOf(32) < 0) break;
                int l = query.length();
                int cp = query.codePointAt(i);
                if (!Character.isJavaIdentifierStart(cp) || cp == 36) break;
                while ((i += Character.charCount(cp)) < l && Character.isJavaIdentifierPart(cp = query.codePointAt(i))) {
                }
                String alias = query.substring(0, i);
                if (ParserUtil.isKeyword(alias, false)) break;
                s = s.substring(alias.length());
                break;
            }
            case 0: {
                int n;
                Object schema;
                int n3;
                Object[] objectArray;
                HashSet<DbTableOrView> set = sentence.getTables();
                String best = null;
                DbTableOrView last = sentence.getLastMatchedTable();
                if (last != null && last.getColumns() != null) {
                    objectArray = last.getColumns();
                    n3 = objectArray.length;
                    n = 0;
                    while (n < n3) {
                        Object column = objectArray[n];
                        String compare = query;
                        String name = ((DbColumn)column).getName();
                        if (((DbColumn)column).getQuotedName().length() > name.length()) {
                            name = ((DbColumn)column).getQuotedName();
                            compare = query;
                        }
                        if (StringUtils.startsWithIgnoringCase(compare, name) && this.testColumnType((DbColumn)column)) {
                            String b = s.substring(name.length());
                            if (best == null || b.length() < best.length()) {
                                best = b;
                            } else if ((s.isEmpty() || StringUtils.startsWithIgnoringCase(name, compare)) && s.length() < name.length()) {
                                sentence.add(((DbColumn)column).getName(), ((DbColumn)column).getName().substring(s.length()), 0);
                            }
                        }
                        ++n;
                    }
                }
                objectArray = this.contents.getSchemas();
                n3 = objectArray.length;
                n = 0;
                while (n < n3) {
                    schema = objectArray[n];
                    DbTableOrView[] dbTableOrViewArray = ((DbSchema)schema).getTables();
                    int n4 = dbTableOrViewArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        DbTableOrView table = dbTableOrViewArray[n5];
                        if ((table == last || set == null || set.contains(table)) && table != null && table.getColumns() != null) {
                            DbColumn[] dbColumnArray = table.getColumns();
                            int n6 = dbColumnArray.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                DbColumn column = dbColumnArray[n7];
                                String name = column.getName();
                                if (this.testColumnType(column)) {
                                    if (StringUtils.startsWithIgnoringCase(query, name)) {
                                        String b = s.substring(name.length());
                                        if (best == null || b.length() < best.length()) {
                                            best = b;
                                        }
                                    } else if ((s.isEmpty() || StringUtils.startsWithIgnoringCase(name, query)) && s.length() < name.length()) {
                                        sentence.add(column.getName(), column.getName().substring(s.length()), 0);
                                    }
                                }
                                ++n7;
                            }
                        }
                        ++n5;
                    }
                    ++n;
                }
                if (best == null) break;
                s = best;
                break;
            }
            case 6: {
                this.autoCompleteProcedure(sentence);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        if (!s.equals(query)) {
            while (Bnf.startWithSpace(s)) {
                s = s.substring(1);
            }
            sentence.setQuery(s);
            return true;
        }
        return false;
    }

    private boolean testColumnType(DbColumn column) {
        if (this.columnType == null) {
            return true;
        }
        String type = column.getDataType();
        if (this.columnType.contains("CHAR") || this.columnType.contains("CLOB")) {
            return type.contains("CHAR") || type.contains("CLOB");
        }
        if (this.columnType.contains("BINARY") || this.columnType.contains("BLOB")) {
            return type.contains("BINARY") || type.contains("BLOB");
        }
        return type.contains(this.columnType);
    }

    private void autoCompleteProcedure(Sentence sentence) {
        String incompleteSentence;
        DbSchema schema = sentence.getLastMatchedSchema();
        if (schema == null) {
            schema = this.contents.getDefaultSchema();
        }
        String incompleteFunctionName = incompleteSentence = sentence.getQueryUpper();
        int bracketIndex = incompleteSentence.indexOf(40);
        if (bracketIndex != -1) {
            incompleteFunctionName = StringUtils.trimSubstring(incompleteSentence, 0, bracketIndex);
        }
        RuleElement openBracket = new RuleElement("(", "Function");
        RuleElement closeBracket = new RuleElement(")", "Function");
        RuleElement comma = new RuleElement(",", "Function");
        DbProcedure[] dbProcedureArray = schema.getProcedures();
        int n = dbProcedureArray.length;
        int n2 = 0;
        while (n2 < n) {
            DbProcedure procedure = dbProcedureArray[n2];
            String procName = procedure.getName();
            if (procName.startsWith(incompleteFunctionName)) {
                RuleElement procedureElement = new RuleElement(procName, "Function");
                RuleList rl = new RuleList(procedureElement, openBracket, false);
                if (incompleteSentence.contains("(")) {
                    DbColumn[] dbColumnArray = procedure.getParameters();
                    int n3 = dbColumnArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        DbColumn parameter = dbColumnArray[n4];
                        if (parameter.getPosition() > 1) {
                            rl = new RuleList(rl, comma, false);
                        }
                        DbContextRule columnRule = new DbContextRule(this.contents, 0);
                        String parameterType = parameter.getDataType();
                        if (parameterType.contains("(")) {
                            parameterType = parameterType.substring(0, parameterType.indexOf(40));
                        }
                        columnRule.setColumnType(parameterType);
                        rl = new RuleList(rl, columnRule, false);
                        ++n4;
                    }
                    rl = new RuleList(rl, closeBracket, false);
                }
                rl.autoComplete(sentence);
            }
            ++n2;
        }
    }

    private static String autoCompleteTableAlias(Sentence sentence, boolean newAlias) {
        HashMap<String, DbTableOrView> map;
        String s = sentence.getQuery();
        String up = sentence.getQueryUpper();
        int i = 0;
        while (i < up.length()) {
            char ch = up.charAt(i);
            if (ch != '_' && !Character.isLetterOrDigit(ch)) break;
            ++i;
        }
        if (i == 0) {
            return s;
        }
        String alias = up.substring(0, i);
        if ("SET".equals(alias) || ParserUtil.isKeyword(alias, false)) {
            return s;
        }
        if (newAlias) {
            sentence.addAlias(alias, sentence.getLastTable());
        }
        if ((map = sentence.getAliases()) != null && map.containsKey(alias) || sentence.getLastTable() == null) {
            if (newAlias && s.length() == alias.length()) {
                return s;
            }
            if ((s = s.substring(alias.length())).isEmpty()) {
                sentence.add(alias + ".", ".", 0);
            }
            return s;
        }
        HashSet<DbTableOrView> tables = sentence.getTables();
        if (tables != null) {
            String best = null;
            for (DbTableOrView table : tables) {
                String tableName = StringUtils.toUpperEnglish(table.getName());
                if (alias.startsWith(tableName) && (best == null || tableName.length() > best.length())) {
                    sentence.setLastMatchedTable(table);
                    best = tableName;
                    continue;
                }
                if (!s.isEmpty() && !tableName.startsWith(alias)) continue;
                sentence.add(tableName + ".", tableName.substring(s.length()) + ".", 0);
            }
            if (best != null) {
                if ((s = s.substring(best.length())).isEmpty()) {
                    sentence.add(alias + ".", ".", 0);
                }
                return s;
            }
        }
        return s;
    }
}

