/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.bnf.context.DbColumn;
import org.h2.bnf.context.DbSchema;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DbProcedure {
    private final DbSchema schema;
    private final String name;
    private final String quotedName;
    private final boolean returnsResult;
    private DbColumn[] parameters;

    public DbProcedure(DbSchema schema, ResultSet rs) throws SQLException {
        this.schema = schema;
        this.name = rs.getString("PROCEDURE_NAME");
        this.returnsResult = rs.getShort("PROCEDURE_TYPE") == 2;
        this.quotedName = schema.getContents().quoteIdentifier(this.name);
    }

    public DbSchema getSchema() {
        return this.schema;
    }

    public DbColumn[] getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName() {
        return this.quotedName;
    }

    public boolean isReturnsResult() {
        return this.returnsResult;
    }

    void readParameters(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = meta.getProcedureColumns(null, this.schema.name, this.name, null);
        ArrayList list = Utils.newSmallArrayList();
        while (rs.next()) {
            DbColumn column = DbColumn.getProcedureColumn(this.schema.getContents(), rs);
            if (column.getPosition() <= 0) continue;
            list.add(column);
        }
        rs.close();
        this.parameters = new DbColumn[list.size()];
        int i = 0;
        while (i < this.parameters.length) {
            DbColumn column = (DbColumn)list.get(i);
            if (column.getPosition() > 0 && column.getPosition() <= this.parameters.length) {
                this.parameters[column.getPosition() - 1] = column;
            }
            ++i;
        }
    }
}

