/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import org.h2.bnf.context.DbContents;
import org.h2.bnf.context.DbProcedure;
import org.h2.bnf.context.DbTableOrView;
import org.h2.engine.SysProperties;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DbSchema {
    private static final String COLUMNS_QUERY_H2_197 = "SELECT COLUMN_NAME, ORDINAL_POSITION, COLUMN_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ?1 AND TABLE_NAME = ?2";
    private static final String COLUMNS_QUERY_H2_202 = "SELECT COLUMN_NAME, ORDINAL_POSITION, DATA_TYPE_SQL(?1, ?2, 'TABLE', ORDINAL_POSITION) COLUMN_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ?1 AND TABLE_NAME = ?2";
    public final String name;
    public final boolean isDefault;
    public final boolean isSystem;
    public final String quotedName;
    private final DbContents contents;
    private DbTableOrView[] tables;
    private DbProcedure[] procedures;

    DbSchema(DbContents contents, String name, boolean isDefault) {
        this.contents = contents;
        this.name = name;
        this.quotedName = contents.quoteIdentifier(name);
        this.isDefault = isDefault;
        this.isSystem = name == null ? true : ("INFORMATION_SCHEMA".equalsIgnoreCase(name) ? true : (!contents.isH2() && StringUtils.toUpperEnglish(name).startsWith("INFO") ? true : (contents.isPostgreSQL() && StringUtils.toUpperEnglish(name).startsWith("PG_") ? true : contents.isDerby() && name.startsWith("SYS"))));
    }

    public DbContents getContents() {
        return this.contents;
    }

    public DbTableOrView[] getTables() {
        return this.tables;
    }

    public DbProcedure[] getProcedures() {
        return this.procedures;
    }

    public void readTables(DatabaseMetaData meta, String[] tableTypes) throws SQLException {
        ResultSet rs = meta.getTables(null, this.name, null, tableTypes);
        ArrayList<DbTableOrView> list = new ArrayList<DbTableOrView>();
        while (rs.next()) {
            DbTableOrView table = new DbTableOrView(this, rs);
            if (this.contents.isOracle() && table.getName().indexOf(36) > 0) continue;
            list.add(table);
        }
        rs.close();
        this.tables = list.toArray(new DbTableOrView[0]);
        if (this.tables.length < SysProperties.CONSOLE_MAX_TABLES_LIST_COLUMNS) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (PreparedStatement ps = this.contents.isH2() ? DbSchema.prepareColumnsQueryH2(meta.getConnection()) : null;){
                DbTableOrView[] dbTableOrViewArray = this.tables;
                int n = this.tables.length;
                int n2 = 0;
                while (n2 < n) {
                    DbTableOrView tab = dbTableOrViewArray[n2];
                    try {
                        tab.readColumns(meta, ps);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static PreparedStatement prepareColumnsQueryH2(Connection connection) throws SQLException {
        try {
            return connection.prepareStatement(COLUMNS_QUERY_H2_202);
        }
        catch (SQLSyntaxErrorException ex) {
            return connection.prepareStatement(COLUMNS_QUERY_H2_197);
        }
    }

    public void readProcedures(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = meta.getProcedures(null, this.name, null);
        ArrayList<DbProcedure> list = Utils.newSmallArrayList();
        while (rs.next()) {
            list.add(new DbProcedure(this, rs));
        }
        rs.close();
        this.procedures = list.toArray(new DbProcedure[0]);
        if (this.procedures.length < SysProperties.CONSOLE_MAX_PROCEDURES_LIST_COLUMNS) {
            DbProcedure[] dbProcedureArray = this.procedures;
            int n = this.procedures.length;
            int n2 = 0;
            while (n2 < n) {
                DbProcedure procedure = dbProcedureArray[n2];
                procedure.readParameters(meta);
                ++n2;
            }
        }
    }
}

