/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.h2.build.BuildBase;
import org.h2.build.doc.XMLParser;

public class Build
extends BuildBase {
    private static final String ASM_VERSION = "9.5";
    private static final String ARGS4J_VERSION = "2.33";
    private static final String DERBY_VERSION = "10.15.2.0";
    private static final String HSQLDB_VERSION = "2.7.2";
    private static final String JACOCO_VERSION = "0.8.10";
    private static final String JTS_VERSION = "1.19.0";
    private static final String JUNIT_VERSION = "5.10.0";
    private static final String LUCENE_VERSION = "9.7.0";
    private static final String MYSQL_CONNECTOR_VERSION = "8.1.0";
    private static final String OSGI_VERSION = "5.0.0";
    private static final String OSGI_JDBC_VERSION = "1.1.0";
    private static final String PGJDBC_VERSION = "42.7.2";
    private static final String PGJDBC_HASH = "86ed42574cd68662b05d3b00432a34e9a34cb12c";
    private static final String JAVAX_SERVLET_VERSION = "4.0.1";
    private static final String JAKARTA_SERVLET_VERSION = "5.0.0";
    private static final String SLF4J_VERSION = "2.0.7";
    private static final String APIGUARDIAN_VERSION = "1.1.2";
    private static final String SQLITE_VERSION = "3.36.0.3";
    private static final String NASHORN_VERSION = "15.4";
    private boolean filesMissing;

    public static void main(String ... args) {
        new Build().run(args);
    }

    @BuildBase.Description(summary="Run the benchmarks.")
    public void benchmark() {
        this.downloadUsingMaven("ext/hsqldb-2.7.2.jar", "org.hsqldb", "hsqldb", HSQLDB_VERSION, "d92d4d2aa515714da2165c9d640d584c2896c9df");
        this.downloadUsingMaven("ext/derby-10.15.2.0.jar", "org.apache.derby", "derby", DERBY_VERSION, "b64da6681994f33ba5783ffae55cdb44885b9e70");
        this.downloadUsingMaven("ext/derbyclient-10.15.2.0.jar", "org.apache.derby", "derbyclient", DERBY_VERSION, "60ad423e9d7acba99a13b8684927206e94c31e03");
        this.downloadUsingMaven("ext/derbynet-10.15.2.0.jar", "org.apache.derby", "derbynet", DERBY_VERSION, "072c8fb0870227477b64edb2d7a5eccdac5de2af");
        this.downloadUsingMaven("ext/derbyshared-10.15.2.0.jar", "org.apache.derby", "derbyshared", DERBY_VERSION, "ff2dfb3e2a92d593cf111baad242d156947abbc1");
        this.downloadUsingMaven("ext/postgresql-42.7.2.jar", "org.postgresql", "postgresql", PGJDBC_VERSION, PGJDBC_HASH);
        this.downloadUsingMaven("ext/mysql-connector-j-8.1.0.jar", "com.mysql", "mysql-connector-j", MYSQL_CONNECTOR_VERSION, "3f78d2963935f44a61edb3961a591cdc392c8941");
        this.downloadUsingMaven("ext/sqlite-3.36.0.3.jar", "org.xerial", "sqlite-jdbc", SQLITE_VERSION, "7fa71c4dfab806490cb909714fb41373ec552c29");
        this.compile();
        String cp = "temp" + File.pathSeparator + "bin/h2" + Build.getJarSuffix() + File.pathSeparator + "ext/hsqldb-2.7.2.jar" + File.pathSeparator + "ext/derby-10.15.2.0.jar" + File.pathSeparator + "ext/derbyclient-10.15.2.0.jar" + File.pathSeparator + "ext/derbynet-10.15.2.0.jar" + File.pathSeparator + "ext/derbyshared-10.15.2.0.jar" + File.pathSeparator + "ext/postgresql-42.7.2.jar" + File.pathSeparator + "ext/mysql-connector-j-8.1.0.jar" + File.pathSeparator + "ext/sqlite-3.36.0.3.jar";
        BuildBase.StringList args = Build.args("-Xmx128m", "-cp", cp, "-Dderby.system.durability=test", "org.h2.test.bench.TestPerformance");
        this.execJava(args.plus("-init", "-db", "1"));
        this.execJava(args.plus("-db", "2"));
        this.execJava(args.plus("-db", "3", "-out", "pe.html"));
        this.execJava(args.plus("-init", "-db", "4"));
        this.execJava(args.plus("-db", "5", "-exit"));
        this.execJava(args.plus("-db", "6"));
        this.execJava(args.plus("-db", "7"));
        this.execJava(args.plus("-db", "8", "-out", "ps.html"));
    }

    @BuildBase.Description(summary="Clean all jar files, classes, and generated documentation.")
    public void clean() {
        this.delete("temp");
        this.delete("docs");
        Build.mkdir("docs");
        Build.mkdir("bin");
        this.delete(this.files(".").keep("*/Thumbs.db"));
    }

    @BuildBase.Description(summary="Compile all classes.")
    public void compile() {
        this.clean();
        Build.mkdir("temp");
        this.download();
        String classpath = "temp" + File.pathSeparator + "ext/javax.servlet-api-4.0.1.jar" + File.pathSeparator + "ext/jakarta.servlet-api-5.0.0.jar" + File.pathSeparator + "ext/lucene-core-9.7.0.jar" + File.pathSeparator + "ext/lucene-analysis-common-9.7.0.jar" + File.pathSeparator + "ext/lucene-queryparser-9.7.0.jar" + File.pathSeparator + "ext/slf4j-api-2.0.7.jar" + File.pathSeparator + "ext/org.osgi.core-5.0.0.jar" + File.pathSeparator + "ext/org.osgi.service.jdbc-1.1.0.jar" + File.pathSeparator + "ext/jts-core-1.19.0.jar" + File.pathSeparator + "ext/asm-9.5.jar" + File.pathSeparator + this.javaToolsJar;
        BuildBase.FileList files = this.files("src/main");
        BuildBase.StringList args = Build.args("-Xlint:unchecked", "-d", "temp", "-sourcepath", "src/main", "-classpath", classpath);
        String version = Build.getTargetJavaVersion();
        if (version != null) {
            args = args.plus("-target", version, "-source", version);
        }
        this.javac(args, files);
        files = this.files("src/main/META-INF/native-image");
        files.addAll(this.files("src/main/META-INF/services"));
        this.copy("temp", files, "src/main");
        files = this.files("src/test");
        files.addAll(this.files("src/tools"));
        files = files.exclude("src/test/org/h2/test/TestAllJunit.java");
        args = Build.args("-Xlint:unchecked", "-Xlint:deprecation", "-d", "temp", "-sourcepath", "src/test" + File.pathSeparator + "src/tools", "-classpath", classpath);
        if (version != null) {
            args = args.plus("-target", version, "-source", version);
        }
        this.javac(args, files);
        files = this.files("src/test").exclude("*.java").exclude("*/package.html");
        this.copy("temp", files, "src/test");
        this.javadoc("-sourcepath", "src/main", "-d", "docs/javadoc", "org.h2.tools", "org.h2.jmx", "-classpath", "ext/lucene-core-9.7.0.jar" + File.pathSeparator + "ext/lucene-analysis-common-9.7.0.jar" + File.pathSeparator + "ext/lucene-queryparser-9.7.0.jar" + File.pathSeparator + "ext/org.osgi.core-5.0.0.jar" + File.pathSeparator + "ext/org.osgi.service.jdbc-1.1.0.jar" + File.pathSeparator + "ext/jts-core-1.19.0.jar");
        files = this.files("src/main").exclude("*.MF").exclude("*.java").exclude("*/package.html").exclude("*/java.sql.Driver").exclude("*.DS_Store");
        this.zip("temp/org/h2/util/data.zip", files, "src/main", true, false);
    }

    private void compileTools() {
        Build.mkdir("temp");
        BuildBase.FileList files = this.files("src/tools").keep("src/tools/org/h2/build/*");
        BuildBase.StringList args = Build.args("-d", "temp", "-sourcepath", "src/tools" + File.pathSeparator + "src/test" + File.pathSeparator + "src/main");
        String version = Build.getTargetJavaVersion();
        if (version != null) {
            args = args.plus("-target", version, "-source", version);
        }
        this.javac(args, files);
    }

    @BuildBase.Description(summary="Run the JaCoco code coverage.")
    public void coverage() {
        this.compile();
        this.downloadTest();
        this.downloadUsingMaven("ext/org.jacoco.agent-0.8.10.jar", "org.jacoco", "org.jacoco.agent", JACOCO_VERSION, "ffdd953dfe502cd7678743c75905bc3304ae2eb7");
        URI uri = URI.create("jar:" + String.valueOf(Paths.get("ext/org.jacoco.agent-0.8.10.jar", new String[0]).toAbsolutePath().toUri()));
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                Files.copy(fs.getPath("jacocoagent.jar", new String[0]), Paths.get("ext/jacocoagent.jar", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.downloadUsingMaven("ext/org.jacoco.cli-0.8.10.jar", "org.jacoco", "org.jacoco.cli", JACOCO_VERSION, "b2e14234f8ab0c72d9ed599d2f01d21f453fecc0");
        this.downloadUsingMaven("ext/org.jacoco.core-0.8.10.jar", "org.jacoco", "org.jacoco.core", JACOCO_VERSION, "669a338279c3f40b154a64c624bab625664a00e6");
        this.downloadUsingMaven("ext/org.jacoco.report-0.8.10.jar", "org.jacoco", "org.jacoco.report", JACOCO_VERSION, "c361019431d1c88e7004ba5a722e7c3f7c22194b");
        this.downloadUsingMaven("ext/args4j-2.33.jar", "args4j", "args4j", ARGS4J_VERSION, "bd87a75374a6d6523de82fef51fc3cfe9baf9fc9");
        this.delete(this.files("coverage"));
        this.copy("coverage/bin", this.files("temp"), "temp");
        this.delete(this.files("coverage/bin/META-INF/versions"));
        Object cp = "coverage/bin" + File.pathSeparator + "ext/postgresql-42.7.2.jar" + File.pathSeparator + "ext/javax.servlet-api-4.0.1.jar" + File.pathSeparator + "ext/jakarta.servlet-api-5.0.0.jar" + File.pathSeparator + "ext/lucene-core-9.7.0.jar" + File.pathSeparator + "ext/lucene-analysis-common-9.7.0.jar" + File.pathSeparator + "ext/lucene-queryparser-9.7.0.jar" + File.pathSeparator + "ext/org.osgi.core-5.0.0.jar" + File.pathSeparator + "ext/org.osgi.service.jdbc-1.1.0.jar" + File.pathSeparator + "ext/jts-core-1.19.0.jar" + File.pathSeparator + "ext/slf4j-api-2.0.7.jar" + File.pathSeparator + "ext/slf4j-nop-2.0.7.jar" + File.pathSeparator + this.javaToolsJar;
        cp = Build.addNashornJavaScriptEngineIfNecessary((String)cp);
        this.execJava(Build.args(new String[]{"-Xmx128m", "-javaagent:ext/jacocoagent.jar=destfile=coverage/jacoco.exec,excludes=org.h2.test.*:org.h2.tools.*:org.h2.sample.*", "-cp", cp, "org.h2.test.TestAll", "codeCoverage"}));
        this.delete(this.files("coverage/bin/org/h2/test"));
        this.delete(this.files("coverage/bin/org/h2/tools"));
        this.delete(this.files("coverage/bin/org/h2/sample"));
        this.execJava(Build.args("-cp", "ext/org.jacoco.cli-0.8.10.jar" + File.pathSeparator + "ext/org.jacoco.core-0.8.10.jar" + File.pathSeparator + "ext/org.jacoco.report-0.8.10.jar" + File.pathSeparator + "ext/asm-9.5.jar" + File.pathSeparator + "ext/asm-commons-9.5.jar" + File.pathSeparator + "ext/asm-tree-9.5.jar" + File.pathSeparator + "ext/args4j-2.33.jar", "org.jacoco.cli.internal.Main", "report", "coverage/jacoco.exec", "--classfiles", "coverage/bin", "--html", "coverage/report", "--sourcefiles", "h2/src/main"));
        try {
            Build.tryOpenCoverageInBrowser();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void tryOpenCoverageInBrowser() throws Exception {
        Class<?> desktop = Class.forName("java.awt.Desktop");
        Method m = desktop.getMethod("getDesktop", new Class[0]);
        Object d = m.invoke(null, new Object[0]);
        m = d.getClass().getMethod("open", File.class);
        m.invoke(d, new File("coverage/report/index.html"));
    }

    private static String getTargetJavaVersion() {
        return System.getProperty("version");
    }

    private void compileMVStore(boolean debugInfo) {
        this.clean();
        Build.mkdir("temp");
        String classpath = "temp" + File.pathSeparator + "ext/jts-core-1.19.0.jar";
        BuildBase.FileList files = this.files("src/main/org/h2/mvstore").exclude("src/main/org/h2/mvstore/db/*");
        BuildBase.StringList args = Build.args(new String[0]);
        args = debugInfo ? args.plus("-Xlint:unchecked", "-d", "temp", "-sourcepath", "src/main", "-classpath", classpath) : args.plus("-Xlint:unchecked", "-g:none", "-d", "temp", "-sourcepath", "src/main", "-classpath", classpath);
        String version = Build.getTargetJavaVersion();
        if (version != null) {
            args = args.plus("-target", version, "-source", version);
        }
        this.javac(args, files);
    }

    private static void filter(String source, String target, String old, String replacement) {
        String text = new String(Build.readFile(Paths.get(source, new String[0])));
        text = Build.replaceAll(text, old, replacement);
        Build.writeFile(Paths.get(target, new String[0]), text.getBytes());
    }

    @BuildBase.Description(summary="Create the documentation from sources (incl. API Javadocs).")
    public void docs() {
        this.javadoc();
        this.copy("docs", this.files("src/docsrc/index.html"), "src/docsrc");
        this.java("org.h2.build.doc.XMLChecker", null);
        this.java("org.h2.build.code.CheckJavadoc", null);
        this.java("org.h2.build.code.CheckTextFiles", null);
        this.java("org.h2.build.doc.GenerateDoc", null);
        this.java("org.h2.build.indexer.Indexer", null);
        this.java("org.h2.build.doc.MergeDocs", null);
        this.java("org.h2.build.doc.WebSite", null);
        this.java("org.h2.build.doc.LinkChecker", null);
        this.java("org.h2.build.doc.XMLChecker", null);
        this.java("org.h2.build.doc.SpellChecker", null);
        this.java("org.h2.build.code.CheckTextFiles", null);
        this.beep();
    }

    @BuildBase.Description(summary="Download all required jar files.")
    public void download() {
        this.downloadOrVerify(false);
    }

    private void downloadOrVerify(boolean offline) {
        this.downloadOrVerify("ext/javax.servlet-api-4.0.1.jar", "javax/servlet", "javax.servlet-api", JAVAX_SERVLET_VERSION, "a27082684a2ff0bf397666c3943496c44541d1ca", offline);
        this.downloadOrVerify("ext/jakarta.servlet-api-5.0.0.jar", "jakarta/servlet", "jakarta.servlet-api", "5.0.0", "2e6b8ccde55522c879434ddec3714683ccae6867", offline);
        this.downloadOrVerify("ext/lucene-core-9.7.0.jar", "org/apache/lucene", "lucene-core", LUCENE_VERSION, "ad391210ffd806931334be9670a35af00c56f959", offline);
        this.downloadOrVerify("ext/lucene-analysis-common-9.7.0.jar", "org/apache/lucene", "lucene-analysis-common", LUCENE_VERSION, "27ba6caaa4587a982cd451f7217b5a982bcfc44a", offline);
        this.downloadOrVerify("ext/lucene-queryparser-9.7.0.jar", "org/apache/lucene", "lucene-queryparser", LUCENE_VERSION, "6e77bde908ff698354e4a2149e6dd4658b56d7b0", offline);
        this.downloadOrVerify("ext/slf4j-api-2.0.7.jar", "org/slf4j", "slf4j-api", SLF4J_VERSION, "41eb7184ea9d556f23e18b5cb99cad1f8581fc00", offline);
        this.downloadOrVerify("ext/org.osgi.core-5.0.0.jar", "org/osgi", "org.osgi.core", "5.0.0", "6e5e8cd3c9059c08e1085540442a490b59a7783c", offline);
        this.downloadOrVerify("ext/org.osgi.service.jdbc-1.1.0.jar", "org/osgi", "org.osgi.service.jdbc", OSGI_JDBC_VERSION, "07673601d60c98d876b82530ff4363ed9e428c1e", offline);
        this.downloadOrVerify("ext/jts-core-1.19.0.jar", "org/locationtech/jts", "jts-core", JTS_VERSION, "3ff3baa0074445384f9e0068df81fbd0a168395a", offline);
        this.downloadOrVerify("ext/junit-jupiter-api-5.10.0.jar", "org.junit.jupiter", "junit-jupiter-api", JUNIT_VERSION, "2fe4ba3d31d5067878e468c96aa039005a9134d3", offline);
        this.downloadUsingMaven("ext/asm-9.5.jar", "org.ow2.asm", "asm", ASM_VERSION, "dc6ea1875f4d64fbc85e1691c95b96a3d8569c90");
        this.downloadUsingMaven("ext/apiguardian-1.1.2.jar", "org.apiguardian", "apiguardian-api", APIGUARDIAN_VERSION, "a231e0d844d2721b0fa1b238006d15c6ded6842a");
    }

    private void downloadOrVerify(String target, String group, String artifact, String version, String sha1Checksum, boolean offline) {
        if (offline) {
            Path targetFile = Paths.get(target, new String[0]);
            if (Files.exists(targetFile, new LinkOption[0])) {
                return;
            }
            this.println("Missing file: " + target);
            this.filesMissing = true;
        } else {
            this.downloadUsingMaven(target, group, artifact, version, sha1Checksum);
        }
    }

    private void downloadTest() {
        this.downloadUsingMaven("ext/h2-1.2.127.jar", "com/h2database", "h2", "1.2.127", "056e784c7cf009483366ab9cd8d21d02fe47031a");
        this.downloadUsingMaven("ext/postgresql-42.7.2.jar", "org.postgresql", "postgresql", PGJDBC_VERSION, PGJDBC_HASH);
        this.downloadUsingMaven("ext/slf4j-nop-2.0.7.jar", "org/slf4j", "slf4j-nop", SLF4J_VERSION, "a5b48a1a935615f0cc70148267bc0f6c4e437239");
        if (Build.requiresNashornJavaScriptEngine()) {
            this.downloadUsingMaven("ext/nashorn-core-15.4.jar", "org/openjdk/nashorn", "nashorn-core", NASHORN_VERSION, "f67f5ffaa5f5130cf6fb9b133da00c7df3b532a5");
            this.downloadUsingMaven("ext/asm-util-9.5.jar", "org.ow2.asm", "asm-util", ASM_VERSION, "64b5a1fc8c1b15ed2efd6a063e976bc8d3dc5ffe");
        }
        this.downloadUsingMaven("ext/asm-commons-9.5.jar", "org.ow2.asm", "asm-commons", ASM_VERSION, "19ab5b5800a3910d30d3a3e64fdb00fd0cb42de0");
        this.downloadUsingMaven("ext/asm-tree-9.5.jar", "org.ow2.asm", "asm-tree", ASM_VERSION, "fd33c8b6373abaa675be407082fdfda35021254a");
    }

    private static String getVersion() {
        return Build.getStaticField("org.h2.engine.Constants", "VERSION");
    }

    private static String getJarSuffix() {
        return "-" + Build.getVersion() + ".jar";
    }

    @BuildBase.Description(summary="Create the h2.zip file and the Windows installer.")
    public void installer() {
        this.delete(this.files("bin").keep("*.jar"));
        this.jar();
        this.docs();
        try {
            this.exec("soffice", Build.args("--invisible", "macro:///Standard.Module1.H2Pdf"));
            this.copy("docs", this.files("../h2web/h2.pdf"), "../h2web");
        }
        catch (Exception e) {
            this.println("OpenOffice / LibreOffice is not available or macros H2Pdf is not installed:");
            this.println(e.toString());
            this.println("********************************************************************************");
            this.println("Install and run LibreOffice or OpenOffice.");
            this.println("Open Tools - Macros - Organize Macros - LibreOffice Basic...");
            this.println("Navigate to My Macros / Standard / Module1 and press Edit button.");
            this.println("Put content of h2/src/installer/openoffice.txt here.");
            this.println("Edit BaseDir variable value:");
            this.println("    BaseDir = \"" + String.valueOf(Paths.get(System.getProperty("user.dir"), new String[0]).getParent().toUri()) + "\"");
            this.println("Close office application and try to build installer again.");
            this.println("********************************************************************************");
        }
        this.delete("docs/html/onePage.html");
        BuildBase.FileList files = this.files("../h2").keep("../h2/build.*");
        files.addAll(this.files("../h2/bin").keep("../h2/bin/h2*"));
        files.addAll(this.files("../h2/docs").exclude("*.jar"));
        files.addAll(this.files("../h2/service"));
        files.addAll(this.files("../h2/src"));
        this.zip("../h2web/h2.zip", files, "../", false, false);
        boolean installer = false;
        try {
            this.exec("makensis", Build.args(Build.isWindows() ? "/V2" : "-V2", "src/installer/h2.nsi"));
            installer = true;
        }
        catch (Exception e) {
            this.println("NSIS is not available: " + String.valueOf(e));
        }
        String buildDate = Build.getStaticField("org.h2.engine.Constants", "BUILD_DATE");
        byte[] data = Build.readFile(Paths.get("../h2web/h2.zip", new String[0]));
        String sha1Zip = Build.getSHA1(data);
        String sha1Exe = null;
        Build.writeFile(Paths.get("../h2web/h2-" + buildDate + ".zip", new String[0]), data);
        if (installer) {
            data = Build.readFile(Paths.get("../h2web/h2-setup.exe", new String[0]));
            sha1Exe = Build.getSHA1(data);
            Build.writeFile(Paths.get("../h2web/h2-setup-" + buildDate + ".exe", new String[0]), data);
        }
        Build.updateChecksum("../h2web/html/download.html", sha1Zip, sha1Exe);
    }

    private static void updateChecksum(String fileName, String sha1Zip, String sha1Exe) {
        Path file = Paths.get(fileName, new String[0]);
        String checksums = new String(Build.readFile(file));
        checksums = Build.replaceAll(checksums, "<!-- sha1Zip -->", "(SHA1 checksum: " + sha1Zip + ")");
        if (sha1Exe != null) {
            checksums = Build.replaceAll(checksums, "<!-- sha1Exe -->", "(SHA1 checksum: " + sha1Exe + ")");
        }
        Build.writeFile(file, checksums.getBytes());
    }

    private static String canonicalPath(Path file) {
        try {
            return file.toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private BuildBase.FileList excludeTestMetaInfFiles(BuildBase.FileList files) {
        BuildBase.FileList testMetaInfFiles = this.files("src/test/META-INF");
        int basePathLength = Build.canonicalPath(Paths.get("src/test", new String[0])).length();
        for (Path file : testMetaInfFiles) {
            files = files.exclude(Build.canonicalPath(file).substring(basePathLength + 1));
        }
        return files;
    }

    private void addVersions() {
        this.copy("temp/META-INF/versions/21", this.files("src/java21/precompiled"), "src/java21/precompiled");
    }

    @BuildBase.Description(summary="Create the regular h2.jar file.")
    public void jar() {
        this.compile();
        this.addVersions();
        Build.manifest("src/main/META-INF/MANIFEST.MF");
        BuildBase.FileList files = this.files("temp").exclude("temp/org/h2/build/*").exclude("temp/org/h2/dev/*").exclude("temp/org/h2/jcr/*").exclude("temp/org/h2/java/*").exclude("temp/org/h2/jcr/*").exclude("temp/org/h2/samples/*").exclude("temp/org/h2/server/ftp/*").exclude("temp/org/h2/test/*").exclude("*.bat").exclude("*.sh").exclude("*.txt").exclude("*.DS_Store");
        files = this.excludeTestMetaInfFiles(files);
        this.jar("bin/h2" + Build.getJarSuffix(), files, "temp");
        Build.filter("src/installer/h2.sh", "bin/h2.sh", "h2.jar", "h2" + Build.getJarSuffix());
        Build.filter("src/installer/h2.bat", "bin/h2.bat", "h2.jar", "h2" + Build.getJarSuffix());
        Build.filter("src/installer/h2w.bat", "bin/h2w.bat", "h2.jar", "h2" + Build.getJarSuffix());
    }

    @BuildBase.Description(summary="Create h2mvstore.jar containing only the MVStore.")
    public void jarMVStore() {
        this.compileMVStore(true);
        this.addVersions();
        Build.manifest("src/installer/mvstore/MANIFEST.MF");
        BuildBase.FileList files = this.files("temp");
        files.exclude("*.DS_Store");
        files = this.excludeTestMetaInfFiles(files);
        this.jar("bin/h2-mvstore" + Build.getJarSuffix(), files, "temp");
    }

    @BuildBase.Description(summary="Create the API Javadocs (incl. JDBC API and tools).")
    public void javadoc() {
        this.compileTools();
        this.delete("docs");
        Build.mkdir("docs/javadoc");
        this.javadoc("-sourcepath", "src/main", "-d", "docs/javadoc", "org.h2.jdbc", "org.h2.jdbcx", "org.h2.tools", "org.h2.api", "org.h2.engine", "org.h2.fulltext", "-classpath", "ext/lucene-core-9.7.0.jar" + File.pathSeparator + "ext/lucene-analysis-common-9.7.0.jar" + File.pathSeparator + "ext/lucene-queryparser-9.7.0.jar" + File.pathSeparator + "ext/org.osgi.core-5.0.0.jar" + File.pathSeparator + "ext/org.osgi.service.jdbc-1.1.0.jar" + File.pathSeparator + "ext/jts-core-1.19.0.jar");
    }

    @BuildBase.Description(summary="Create the Javadocs of the implementation.")
    public void javadocImpl() {
        this.compileTools();
        Build.mkdir("docs/javadocImpl2");
        this.javadoc("-sourcepath", "src/main" + File.pathSeparator + "src/test" + File.pathSeparator + "src/tools", "-noindex", "-d", "docs/javadocImpl2", "-classpath", this.javaToolsJar + File.pathSeparator + "ext/slf4j-api-2.0.7.jar" + File.pathSeparator + "ext/javax.servlet-api-4.0.1.jar" + File.pathSeparator + "ext/jakarta.servlet-api-5.0.0.jar" + File.pathSeparator + "ext/lucene-core-9.7.0.jar" + File.pathSeparator + "ext/lucene-analysis-common-9.7.0.jar" + File.pathSeparator + "ext/lucene-queryparser-9.7.0.jar" + File.pathSeparator + "ext/org.osgi.core-5.0.0.jar" + File.pathSeparator + "ext/org.osgi.service.jdbc-1.1.0.jar" + File.pathSeparator + "ext/jts-core-1.19.0.jar" + File.pathSeparator + "ext/asm-9.5.jar" + File.pathSeparator + "ext/junit-jupiter-api-5.10.0.jar" + File.pathSeparator + "ext/apiguardian-api-1.1.2.jar", "-subpackages", "org.h2", "-exclude", "org.h2.dev:org.h2.java:org.h2.test:org.h2.build.code:org.h2.build.doc");
        Build.mkdir("docs/javadocImpl3");
        this.javadoc("-sourcepath", "src/main", "-noindex", "-d", "docs/javadocImpl3", "-classpath", this.javaToolsJar + File.pathSeparator + "ext/slf4j-api-2.0.7.jar" + File.pathSeparator + "ext/javax.servlet-api-4.0.1.jar" + File.pathSeparator + "ext/jakarta.servlet-api-5.0.0.jar" + File.pathSeparator + "ext/lucene-core-9.7.0.jar" + File.pathSeparator + "ext/lucene-analysis-common-9.7.0.jar" + File.pathSeparator + "ext/lucene-queryparser-9.7.0.jar" + File.pathSeparator + "ext/org.osgi.core-5.0.0.jar" + File.pathSeparator + "ext/org.osgi.service.jdbc-1.1.0.jar" + File.pathSeparator + "ext/jts-core-1.19.0.jar", "-subpackages", "org.h2.mvstore", "-exclude", "org.h2.mvstore.db");
        System.setProperty("h2.interfacesOnly", "false");
        System.setProperty("h2.javadocDestDir", "docs/javadocImpl");
        this.javadoc("-sourcepath", "src/main" + File.pathSeparator + "src/test" + File.pathSeparator + "src/tools", "-Xdoclint:all,-missing", "-d", "docs/javadoc", "-classpath", this.javaToolsJar + File.pathSeparator + "ext/slf4j-api-2.0.7.jar" + File.pathSeparator + "ext/javax.servlet-api-4.0.1.jar" + File.pathSeparator + "ext/jakarta.servlet-api-5.0.0.jar" + File.pathSeparator + "ext/lucene-core-9.7.0.jar" + File.pathSeparator + "ext/lucene-analysis-common-9.7.0.jar" + File.pathSeparator + "ext/lucene-queryparser-9.7.0.jar" + File.pathSeparator + "ext/org.osgi.core-5.0.0.jar" + File.pathSeparator + "ext/org.osgi.service.jdbc-1.1.0.jar" + File.pathSeparator + "ext/jts-core-1.19.0.jar" + File.pathSeparator + "ext/asm-9.5.jar" + File.pathSeparator + "ext/junit-jupiter-api-5.10.0.jar" + File.pathSeparator + "ext/apiguardian-api-1.1.2.jar", "-subpackages", "org.h2", "-package");
    }

    private static void manifest(String path) {
        String manifest = new String(Build.readFile(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
        manifest = Build.replaceAll(manifest, "${version}", Build.getVersion());
        manifest = Build.replaceAll(manifest, "${buildJdk}", Build.getJavaSpecVersion());
        String createdBy = System.getProperty("java.runtime.version") + " (" + System.getProperty("java.vm.vendor") + ")";
        manifest = Build.replaceAll(manifest, "${createdBy}", createdBy);
        Build.mkdir("temp/META-INF");
        Build.writeFile(Paths.get("temp/META-INF/MANIFEST.MF", new String[0]), manifest.getBytes());
    }

    @BuildBase.Description(summary="Build H2 release jars and upload to file:///data/h2database/m2-repo.")
    public void mavenDeployCentral() {
        BuildBase.FileList files = this.files("src/main");
        this.copy("docs", files, "src/main");
        files = this.files("docs").keep("docs/org/*").keep("*.java");
        files.addAll(this.files("docs").keep("docs/META-INF/*"));
        String manifest = new String(Build.readFile(Paths.get("src/installer/source-manifest.mf", new String[0])));
        manifest = Build.replaceAll(manifest, "${version}", Build.getVersion());
        Build.writeFile(Paths.get("docs/META-INF/MANIFEST.MF", new String[0]), manifest.getBytes());
        this.jar("docs/h2-" + Build.getVersion() + "-sources.jar", files, "docs");
        this.delete("docs/org");
        this.delete("docs/META-INF");
        this.execScript("mvn", Build.args("deploy:deploy-file", "-Dfile=docs/h2-" + Build.getVersion() + "-sources.jar", "-Durl=file:///data/h2database/m2-repo", "-Dpackaging=jar", "-Dclassifier=sources", "-Dversion=" + Build.getVersion(), "-DartifactId=h2", "-DgroupId=com.h2database"));
        this.javadocImpl();
        files = this.files("docs/javadocImpl2");
        this.jar("docs/h2-" + Build.getVersion() + "-javadoc.jar", files, "docs/javadocImpl2");
        this.execScript("mvn", Build.args("deploy:deploy-file", "-Dfile=docs/h2-" + Build.getVersion() + "-javadoc.jar", "-Durl=file:///data/h2database/m2-repo", "-Dpackaging=jar", "-Dclassifier=javadoc", "-Dversion=" + Build.getVersion(), "-DartifactId=h2", "-DgroupId=com.h2database"));
        this.jar();
        String pom = new String(Build.readFile(Paths.get("src/installer/pom-template.xml", new String[0])));
        pom = Build.replaceAll(pom, "@version@", Build.getVersion());
        Build.writeFile(Paths.get("bin/pom.xml", new String[0]), pom.getBytes());
        this.execScript("mvn", Build.args("deploy:deploy-file", "-Dfile=bin/h2" + Build.getJarSuffix(), "-Durl=file:///data/h2database/m2-repo", "-Dpackaging=jar", "-Dversion=" + Build.getVersion(), "-DpomFile=bin/pom.xml", "-DartifactId=h2", "-DgroupId=com.h2database"));
        files = this.files("src/main");
        this.copy("docs", files, "src/main");
        files = this.files("docs").keep("docs/org/h2/mvstore/*").exclude("docs/org/h2/mvstore/db/*").keep("*.java");
        files.addAll(this.files("docs").keep("docs/META-INF/*"));
        manifest = new String(Build.readFile(Paths.get("src/installer/source-mvstore-manifest.mf", new String[0])));
        manifest = Build.replaceAll(manifest, "${version}", Build.getVersion());
        Build.writeFile(Paths.get("docs/META-INF/MANIFEST.MF", new String[0]), manifest.getBytes());
        this.jar("docs/h2-mvstore-" + Build.getVersion() + "-sources.jar", files, "docs");
        this.delete("docs/org");
        this.delete("docs/META-INF");
        this.execScript("mvn", Build.args("deploy:deploy-file", "-Dfile=docs/h2-mvstore-" + Build.getVersion() + "-sources.jar", "-Durl=file:///data/h2database/m2-repo", "-Dpackaging=jar", "-Dclassifier=sources", "-Dversion=" + Build.getVersion(), "-DartifactId=h2-mvstore", "-DgroupId=com.h2database"));
        this.javadocImpl();
        files = this.files("docs/javadocImpl3");
        this.jar("docs/h2-mvstore-" + Build.getVersion() + "-javadoc.jar", files, "docs/javadocImpl3");
        this.execScript("mvn", Build.args("deploy:deploy-file", "-Dfile=docs/h2-mvstore-" + Build.getVersion() + "-javadoc.jar", "-Durl=file:///data/h2database/m2-repo", "-Dpackaging=jar", "-Dclassifier=javadoc", "-Dversion=" + Build.getVersion(), "-DartifactId=h2-mvstore", "-DgroupId=com.h2database"));
        this.jarMVStore();
        pom = new String(Build.readFile(Paths.get("src/installer/pom-mvstore-template.xml", new String[0])));
        pom = Build.replaceAll(pom, "@version@", Build.getVersion());
        Build.writeFile(Paths.get("bin/pom.xml", new String[0]), pom.getBytes());
        this.execScript("mvn", Build.args("deploy:deploy-file", "-Dfile=bin/h2-mvstore" + Build.getJarSuffix(), "-Durl=file:///data/h2database/m2-repo", "-Dpackaging=jar", "-Dversion=" + Build.getVersion(), "-DpomFile=bin/pom.xml", "-DartifactId=h2-mvstore", "-DgroupId=com.h2database"));
    }

    @BuildBase.Description(summary="Build a snapshot H2 jar and upload to local Maven 2 repo.")
    public void mavenInstallLocal() {
        this.jarMVStore();
        String pom = new String(Build.readFile(Paths.get("src/installer/pom-mvstore-template.xml", new String[0])));
        pom = Build.replaceAll(pom, "@version@", Build.getVersion());
        Build.writeFile(Paths.get("bin/pom.xml", new String[0]), pom.getBytes());
        this.execScript("mvn", Build.args("install:install-file", "-Dversion=" + Build.getVersion(), "-Dfile=bin/h2-mvstore" + Build.getJarSuffix(), "-Dpackaging=jar", "-DpomFile=bin/pom.xml", "-DartifactId=h2-mvstore", "-DgroupId=com.h2database"));
        this.jar();
        pom = new String(Build.readFile(Paths.get("src/installer/pom-template.xml", new String[0])));
        pom = Build.replaceAll(pom, "@version@", Build.getVersion());
        Build.writeFile(Paths.get("bin/pom.xml", new String[0]), pom.getBytes());
        this.execScript("mvn", Build.args("install:install-file", "-Dversion=" + Build.getVersion(), "-Dfile=bin/h2" + Build.getJarSuffix(), "-Dpackaging=jar", "-DpomFile=bin/pom.xml", "-DartifactId=h2", "-DgroupId=com.h2database"));
    }

    @BuildBase.Description(summary="Build H2 jar avoiding downloads (list missing files).")
    public void offline() {
        this.downloadOrVerify(true);
        if (this.filesMissing) {
            this.println("Required files are missing");
        } else {
            this.jar();
        }
    }

    @BuildBase.Description(summary="Run the spellchecker.")
    public void spellcheck() {
        this.java("org.h2.build.doc.SpellChecker", null);
    }

    @BuildBase.Description(summary="Compile and run all tests (excluding the compile step).")
    public void test() {
        this.test(false);
    }

    @BuildBase.Description(summary="Compile and run all tests for CI (excl. the compile step).")
    public void testCI() {
        this.test(true);
    }

    private void test(boolean ci) {
        int ret;
        this.downloadTest();
        Object cp = "temp" + File.pathSeparator + "bin" + File.pathSeparator + "ext/postgresql-42.7.2.jar" + File.pathSeparator + "ext/javax.servlet-api-4.0.1.jar" + File.pathSeparator + "ext/jakarta.servlet-api-5.0.0.jar" + File.pathSeparator + "ext/lucene-core-9.7.0.jar" + File.pathSeparator + "ext/lucene-analysis-common-9.7.0.jar" + File.pathSeparator + "ext/lucene-queryparser-9.7.0.jar" + File.pathSeparator + "ext/org.osgi.core-5.0.0.jar" + File.pathSeparator + "ext/org.osgi.service.jdbc-1.1.0.jar" + File.pathSeparator + "ext/jts-core-1.19.0.jar" + File.pathSeparator + "ext/slf4j-api-2.0.7.jar" + File.pathSeparator + "ext/slf4j-nop-2.0.7.jar" + File.pathSeparator + "ext/asm-9.5.jar" + File.pathSeparator + this.javaToolsJar;
        cp = Build.addNashornJavaScriptEngineIfNecessary((String)cp);
        int version = Build.getJavaVersion();
        if (version >= 9) {
            cp = "src/java9/precompiled" + File.pathSeparator + (String)cp;
            if (version >= 10) {
                cp = "src/java10/precompiled" + File.pathSeparator + (String)cp;
                if (version >= 21) {
                    cp = "src/java21/precompiled" + File.pathSeparator + (String)cp;
                }
            }
        }
        if ((ret = ci ? this.execJava(Build.args(new String[]{"-ea", "-Xmx128m", "-XX:MaxDirectMemorySize=2g", "-cp", cp, "org.h2.test.TestAll", "ci"})) : this.execJava(Build.args(new String[]{"-ea", "-Xmx128m", "-cp", cp, "org.h2.test.TestAll"}))) != 0) {
            System.exit(ret);
        }
    }

    @BuildBase.Description(summary="Print the system properties.")
    public void testSysProperties() {
        System.out.println("environment settings:");
        for (Map.Entry<Object, Object> e : new TreeMap<Object, Object>(System.getProperties()).entrySet()) {
            System.out.println(e);
        }
    }

    @BuildBase.Description(summary="Test the local network of this machine.")
    public void testNetwork() {
        try {
            ServerSocket serverSocket;
            long start = System.nanoTime();
            System.out.println("localhost:");
            System.out.println("  " + String.valueOf(InetAddress.getByName("localhost")));
            InetAddress[] inetAddressArray = InetAddress.getAllByName("localhost");
            int n = inetAddressArray.length;
            int n2 = 0;
            while (n2 < n) {
                InetAddress address = inetAddressArray[n2];
                System.out.println("  " + String.valueOf(address));
                ++n2;
            }
            InetAddress localhost = InetAddress.getLocalHost();
            System.out.println("getLocalHost:" + String.valueOf(localhost));
            InetAddress[] inetAddressArray2 = InetAddress.getAllByName(localhost.getHostAddress());
            int n3 = inetAddressArray2.length;
            n = 0;
            while (n < n3) {
                InetAddress address = inetAddressArray2[n];
                System.out.println("  " + String.valueOf(address));
                ++n;
            }
            InetAddress address = InetAddress.getByName(localhost.getHostAddress());
            System.out.println("byName:" + String.valueOf(address));
            try {
                serverSocket = new ServerSocket(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                serverSocket = new ServerSocket(0);
            }
            System.out.println(serverSocket);
            int port = serverSocket.getLocalPort();
            final ServerSocket accept = serverSocket;
            start = System.nanoTime();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        System.out.println("server accepting");
                        Socket s = accept.accept();
                        Thread.sleep(100L);
                        System.out.println("server accepted:" + String.valueOf(s));
                        System.out.println("server read:" + s.getInputStream().read());
                        Thread.sleep(200L);
                        s.getOutputStream().write(234);
                        Thread.sleep(100L);
                        System.out.println("server closing");
                        s.close();
                        System.out.println("server done");
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            };
            thread.start();
            System.out.println("time: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            Thread.sleep(1000L);
            start = System.nanoTime();
            final Socket socket = new Socket();
            socket.setSoTimeout(2000);
            final InetSocketAddress socketAddress = new InetSocketAddress(address, port);
            System.out.println("client:" + String.valueOf(socketAddress));
            try {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            socket.connect(socketAddress, 2000);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
                t.start();
                t.join(5000L);
                if (!socket.isConnected()) {
                    InetSocketAddress localhostAddress = new InetSocketAddress("localhost", port);
                    System.out.println("not connected, trying localhost:" + String.valueOf(socketAddress));
                    socket.connect(localhostAddress, 2000);
                }
                System.out.println("time: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                Thread.sleep(200L);
                start = System.nanoTime();
                System.out.println("client:" + socket.toString());
                socket.getOutputStream().write(123);
                System.out.println("time: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                Thread.sleep(100L);
                start = System.nanoTime();
                System.out.println("client read:" + socket.getInputStream().read());
                socket.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            thread.join(5000L);
            System.out.println("time: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            if (thread.isAlive()) {
                System.out.println("thread is still alive, interrupting");
                thread.interrupt();
            }
            Thread.sleep(100L);
            System.out.println("done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @BuildBase.Description(summary="Upload all build results to the public website.")
    public void uploadBuild() {
        String password = System.getProperty("h2.ftpPassword");
        if (password == null) {
            throw new RuntimeException("h2.ftpPassword not set");
        }
        this.downloadTest();
        Build.mkdir("temp");
        BuildBase.FileList files = this.files("src/tools").keep("*/UploadBuild.java");
        BuildBase.StringList args = Build.args("-d", "temp", "-sourcepath", "src/tools" + File.pathSeparator + "src/test" + File.pathSeparator + "src/main");
        String version = Build.getTargetJavaVersion();
        if (version != null) {
            args = args.plus("-target", version, "-source", version);
        }
        this.javac(args, files);
        String cp = "bin" + File.pathSeparator + "temp";
        this.execJava(Build.args("-Xmx512m", "-cp", cp, "-Dh2.ftpPassword=" + password, "org.h2.build.doc.UploadBuild"));
    }

    @BuildBase.Description(summary="Build the h2console.war file.")
    public void warConsole() {
        this.jar();
        this.copy("temp/WEB-INF", this.files("src/tools/WEB-INF/web.xml"), "src/tools/WEB-INF");
        this.copy("temp", this.files("src/tools/WEB-INF/console.html"), "src/tools/WEB-INF");
        this.copy("temp/WEB-INF/lib", this.files("bin/h2" + Build.getJarSuffix()), "bin");
        BuildBase.FileList files = this.files("temp").exclude("temp/org*").exclude("temp/META-INF*");
        files.exclude("*.DS_Store");
        this.jar("bin/h2console.war", files, "temp");
    }

    @Override
    protected String getLocalMavenDir() {
        String userHome = System.getProperty("user.home", "");
        Path file = Paths.get(userHome, ".m2/settings.xml");
        if (!Files.exists(file, new LinkOption[0])) {
            return super.getLocalMavenDir();
        }
        XMLParser p = new XMLParser(new String(BuildBase.readFile(file)));
        HashMap<Object, String> prop = new HashMap<Object, String>();
        Object name = "";
        while (p.hasNext()) {
            String text;
            int event = p.next();
            if (event == 1) {
                name = (String)name + "/" + p.getName();
                continue;
            }
            if (event == 2) {
                name = ((String)name).substring(0, ((String)name).lastIndexOf(47));
                continue;
            }
            if (event != 4 || (text = p.getText().trim()).length() <= 0) continue;
            prop.put(name, text);
        }
        String local = (String)prop.get("/settings/localRepository");
        if (local == null) {
            local = "${user.home}/.m2/repository";
        }
        local = Build.replaceAll(local, "${user.home}", userHome);
        return local;
    }

    private static String addNashornJavaScriptEngineIfNecessary(String cp) {
        if (Build.requiresNashornJavaScriptEngine()) {
            return cp + File.pathSeparator + "ext/nashorn-core-15.4.jar" + File.pathSeparator + "ext/asm-commons-9.5.jar" + File.pathSeparator + "ext/asm-tree-9.5.jar" + File.pathSeparator + "ext/asm-util-9.5.jar";
        }
        return cp;
    }

    private static boolean requiresNashornJavaScriptEngine() {
        return Build.getJavaVersion() >= 15;
    }
}

