/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BuildBase {
    protected final PrintStream sysOut = System.out;
    protected boolean quiet;
    protected final String javaExecutable = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    protected final String javaToolsJar = System.getProperty("java.home") + File.separator + ".." + File.separator + "lib" + File.separator + "tools.jar";

    protected void run(String ... args) {
        long time = System.nanoTime();
        if (args.length == 0) {
            this.all();
        } else {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String a = stringArray[n2];
                if ("-quiet".equals(a)) {
                    this.quiet = true;
                } else {
                    if ("-".equals(a)) {
                        this.runShell();
                        return;
                    }
                    if (a.startsWith("-D")) {
                        String value;
                        String key = a.substring(2);
                        int valueIndex = key.indexOf(61);
                        if (valueIndex >= 0) {
                            value = key.substring(valueIndex + 1);
                            key = key.substring(0, valueIndex);
                        } else {
                            value = "true";
                        }
                        System.setProperty(key, value);
                    } else if (!this.runTarget(a)) break;
                }
                ++n2;
            }
        }
        this.println("Done in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time) + " ms");
    }

    private boolean runTarget(String target) {
        Method m = null;
        try {
            m = this.getClass().getMethod(target, new Class[0]);
        }
        catch (Exception e) {
            this.sysOut.println("Unknown target: " + target);
            this.projectHelp();
            return false;
        }
        this.println("Target: " + target);
        BuildBase.invoke(m, this, new Object[0]);
        return true;
    }

    private void runShell() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String last = "";
        System.out.println("Shell mode. Type the target, then [Enter]. Just [Enter] repeats the last target.");
        while (true) {
            String line;
            System.out.print("build> ");
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (line == null || line.equals("exit") || line.equals("quit")) break;
            if (line.length() == 0) {
                line = last;
            }
            long time = System.nanoTime();
            try {
                this.runTarget(line);
            }
            catch (Exception e) {
                System.out.println(e);
            }
            this.println("Done in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time) + " ms");
            last = line;
        }
    }

    private static Object invoke(Method m, Object instance, Object[] args) {
        try {
            try {
                return m.invoke(instance, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void all() {
        this.projectHelp();
    }

    protected void beep() {
        this.sysOut.print("\u0007");
        this.sysOut.flush();
    }

    protected void projectHelp() {
        Method[] methods = this.getClass().getDeclaredMethods();
        Arrays.sort(methods, Comparator.comparing(Method::getName));
        this.sysOut.println("Targets:");
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) && Modifier.isPublic(mod) && m.getParameterTypes().length == 0) {
                String description = m.isAnnotationPresent(Description.class) ? String.format("%1$-20s %2$s", m.getName(), m.getAnnotation(Description.class).summary()) : m.getName();
                this.sysOut.println(description);
            }
            ++n2;
        }
        this.sysOut.println();
    }

    protected static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    protected int execScript(String script, StringList args) {
        if (BuildBase.isWindows()) {
            StringList newArgs = new StringList(new String[0]);
            newArgs.add("/C");
            newArgs.add(script);
            newArgs.addAll(args);
            return this.exec("cmd", newArgs);
        }
        return this.exec(script, args);
    }

    protected int execJava(StringList args) {
        return this.exec(this.javaExecutable, args);
    }

    protected int exec(String command, StringList args) {
        try {
            this.print(command);
            StringList cmd = new StringList(new String[0]);
            cmd = cmd.plus(command);
            if (args != null) {
                for (String a : args) {
                    this.print(" " + a);
                }
                cmd.addAll(args);
            }
            this.println("");
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(cmd.array());
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BuildBase.copyInThread(p.getInputStream(), this.quiet ? null : this.sysOut);
            p.waitFor();
            return p.exitValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyInThread(final InputStream in, final OutputStream out) {
        new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        int x;
                        if ((x = in.read()) < 0) {
                            return;
                        }
                        if (out == null) continue;
                        out.write(x);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }.start();
    }

    protected static String getStaticField(String className, String fieldName) {
        try {
            Class<?> clazz = Class.forName(className);
            Field field = clazz.getField(fieldName);
            return field.get(null).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not read field " + className + "." + fieldName, e);
        }
    }

    protected void copy(String targetDir, FileList files, String baseDir) {
        Path target = Paths.get(targetDir, new String[0]);
        Path base = Paths.get(baseDir, new String[0]);
        this.println("Copying " + files.size() + " files to " + String.valueOf(target));
        for (Path f : files) {
            Path t = target.resolve(base.relativize(f));
            byte[] data = BuildBase.readFile(f);
            BuildBase.mkdirs(t.getParent());
            BuildBase.writeFile(t, data);
        }
    }

    private static PrintStream filter(PrintStream out, final String[] exclude) {
        return new PrintStream(new FilterOutputStream(out){
            private ByteArrayOutputStream buff;
            {
                super($anonymous0);
                this.buff = new ByteArrayOutputStream();
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                int i = off;
                while (i < len) {
                    this.write(b[i]);
                    ++i;
                }
            }

            public void write(byte b) throws IOException {
                this.buff.write(b);
                if (b == 10) {
                    byte[] data = this.buff.toByteArray();
                    String line = new String(data, StandardCharsets.UTF_8);
                    boolean print = true;
                    String[] stringArray = exclude;
                    int n = exclude.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String l = stringArray[n2];
                        if (line.startsWith(l)) {
                            print = false;
                            break;
                        }
                        ++n2;
                    }
                    if (print) {
                        this.out.write(data);
                    }
                    this.buff.reset();
                }
            }

            @Override
            public void close() throws IOException {
                this.write(10);
            }
        });
    }

    protected void javadoc(String ... args) {
        int result;
        block10: {
            PrintStream old = System.out;
            try {
                try {
                    Class<?> clazz;
                    this.println("Javadoc");
                    if (this.quiet) {
                        System.setOut(BuildBase.filter(System.out, new String[]{"Loading source files for package", "Constructing Javadoc information...", "Generating ", "Standard Doclet", "Building tree for all the packages and classes...", "Building index for all the packages and classes...", "Building index for all classes..."}));
                    } else {
                        System.setOut(BuildBase.filter(System.out, new String[]{"Loading source files for package ", "Generating "}));
                    }
                    try {
                        clazz = Class.forName("jdk.javadoc.internal.tool.Main");
                    }
                    catch (Exception e) {
                        clazz = Class.forName("com.sun.tools.javadoc.Main");
                    }
                    Method execute = clazz.getMethod("execute", String[].class);
                    result = (Integer)BuildBase.invoke(execute, null, new Object[]{args});
                }
                catch (Exception e) {
                    result = this.exec("javadoc", BuildBase.args(args));
                    System.setOut(old);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                System.setOut(old);
                throw throwable;
            }
            System.setOut(old);
        }
        if (result != 0) {
            throw new RuntimeException("An error occurred, result=" + result);
        }
    }

    private static String convertBytesToString(byte[] value) {
        StringBuilder buff = new StringBuilder(value.length * 2);
        byte[] byArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            byte c = byArray[n2];
            int x = c & 0xFF;
            buff.append(Integer.toString(x >> 4, 16)).append(Integer.toString(x & 0xF, 16));
            ++n2;
        }
        return buff.toString();
    }

    protected static String getSHA1(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return BuildBase.convertBytesToString(md.digest(data));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected void downloadUsingMaven(String target, String group, String artifact, String version, String sha1Checksum) {
        String repoDir = "https://repo1.maven.org/maven2";
        Path targetFile = Paths.get(target, new String[0]);
        if (Files.exists(targetFile, new LinkOption[0])) {
            return;
        }
        String repoFile = group.replace('.', '/') + "/" + artifact + "/" + version + "/" + artifact + "-" + version + ".jar";
        BuildBase.mkdirs(targetFile.toAbsolutePath().getParent());
        Path localMavenDir = Paths.get(this.getLocalMavenDir(), new String[0]);
        if (Files.isDirectory(localMavenDir, new LinkOption[0])) {
            Path f = localMavenDir.resolve(repoFile);
            if (!Files.exists(f, new LinkOption[0])) {
                try {
                    this.execScript("mvn", BuildBase.args("org.apache.maven.plugins:maven-dependency-plugin:2.1:get", "-DrepoUrl=" + repoDir, "-Dartifact=" + group + ":" + artifact + ":" + version));
                }
                catch (RuntimeException e) {
                    this.println("Could not download using Maven: " + e.toString());
                }
            }
            if (Files.exists(f, new LinkOption[0])) {
                byte[] data = BuildBase.readFile(f);
                String got = BuildBase.getSHA1(data);
                if (sha1Checksum == null) {
                    this.println("SHA1 checksum: " + got);
                } else if (!got.equals(sha1Checksum)) {
                    throw new RuntimeException("SHA1 checksum mismatch; got: " + got + " expected: " + sha1Checksum + " for file " + String.valueOf(f.toAbsolutePath()));
                }
                BuildBase.writeFile(targetFile, data);
                return;
            }
        }
        String fileURL = repoDir + "/" + repoFile;
        this.download(target, fileURL, sha1Checksum);
    }

    protected String getLocalMavenDir() {
        return System.getProperty("user.home") + "/.m2/repository";
    }

    protected void download(String target, String fileURL, String sha1Checksum) {
        Path targetFile = Paths.get(target, new String[0]);
        if (Files.exists(targetFile, new LinkOption[0])) {
            return;
        }
        BuildBase.mkdirs(targetFile.toAbsolutePath().getParent());
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        try {
            this.println("Downloading " + fileURL);
            URL url = new URL(fileURL);
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            long last = System.nanoTime();
            int len = 0;
            while (true) {
                long now;
                if ((now = System.nanoTime()) - last > 1000000000L) {
                    this.println("Downloaded " + len + " bytes");
                    last = now;
                }
                int x = ((InputStream)in).read();
                ++len;
                if (x < 0) break;
                buff.write(x);
            }
            ((InputStream)in).close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error downloading " + fileURL + " to " + target, e);
        }
        byte[] data = buff.toByteArray();
        String got = BuildBase.getSHA1(data);
        if (sha1Checksum == null) {
            this.println("SHA1 checksum: " + got);
        } else if (!got.equals(sha1Checksum)) {
            throw new RuntimeException("SHA1 checksum mismatch; got: " + got + " expected: " + sha1Checksum + " for file " + target);
        }
        BuildBase.writeFile(targetFile, data);
    }

    protected FileList files(String dir) {
        FileList list = new FileList();
        BuildBase.addFiles(list, Paths.get(dir, new String[0]));
        return list;
    }

    protected static StringList args(String ... args) {
        return new StringList(args);
    }

    private static void addFiles(final FileList list, Path file) {
        if (!file.getFileName().toString().startsWith(".svn")) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                try {
                    Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            list.add(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading directory " + String.valueOf(file), e);
                }
            } else {
                list.add(file);
            }
        }
    }

    public static void writeFile(Path file, byte[] data) {
        try {
            Files.write(file, data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing to file " + String.valueOf(file), e);
        }
    }

    public static byte[] readFile(Path file) {
        try {
            return Files.readAllBytes(file);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from file " + String.valueOf(file), e);
        }
    }

    static String getSuffix(String fileName) {
        int idx = fileName.lastIndexOf(46);
        return idx < 0 ? "" : fileName.substring(idx);
    }

    protected long jar(String destFile, FileList files, String basePath) {
        long kb = BuildBase.zipOrJar(destFile, files, basePath, false, false, true);
        this.println("Jar " + destFile + " (" + kb + " KB)");
        return kb;
    }

    protected void zip(String destFile, FileList files, String basePath, boolean storeOnly, boolean sortBySuffix) {
        long kb = BuildBase.zipOrJar(destFile, files, basePath, storeOnly, sortBySuffix, false);
        this.println("Zip " + destFile + " (" + kb + " KB)");
    }

    private static long zipOrJar(String destFile, FileList files, String basePath, boolean storeOnly, boolean sortBySuffix, boolean jar) {
        if (sortBySuffix) {
            files.sort((f1, f2) -> {
                String p1 = f1.toString();
                String p2 = f2.toString();
                int comp = BuildBase.getSuffix(p1).compareTo(BuildBase.getSuffix(p2));
                if (comp == 0) {
                    comp = p1.compareTo(p2);
                }
                return comp;
            });
        } else if (jar) {
            files.sort(new Comparator<Path>(){

                private int priority(String path) {
                    if (path.startsWith("META-INF/")) {
                        if (path.equals("META-INF/MANIFEST.MF")) {
                            return 0;
                        }
                        if (path.startsWith("services/", 9)) {
                            return 1;
                        }
                        return 2;
                    }
                    if (!path.endsWith(".zip")) {
                        return 3;
                    }
                    return 4;
                }

                @Override
                public int compare(Path f1, Path f2) {
                    String p1 = f1.toString();
                    String p2 = f2.toString();
                    int comp = Integer.compare(this.priority(p1), this.priority(p2));
                    if (comp != 0) {
                        return comp;
                    }
                    return p1.compareTo(p2);
                }
            });
        }
        Path dest = Paths.get(destFile, new String[0]).toAbsolutePath();
        BuildBase.mkdirs(dest.getParent());
        Path base = Paths.get(basePath, new String[0]);
        try {
            if (Files.isDirectory(dest, new LinkOption[0])) {
                throw new IOException("Can't create the file as a directory with this name already exists: " + destFile);
            }
            BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(dest, new OpenOption[0]));
            ZipOutputStream zipOut = jar ? new JarOutputStream(out) : new ZipOutputStream(out);
            if (storeOnly) {
                zipOut.setMethod(0);
            }
            zipOut.setLevel(9);
            for (Path file : files) {
                String entryName = base.relativize(file).toString().replace('\\', '/');
                byte[] data = BuildBase.readFile(file);
                ZipEntry entry = new ZipEntry(entryName);
                CRC32 crc = new CRC32();
                crc.update(data);
                entry.setSize(data.length);
                entry.setCrc(crc.getValue());
                zipOut.putNextEntry(entry);
                zipOut.write(data);
                zipOut.closeEntry();
            }
            zipOut.closeEntry();
            zipOut.close();
            return Files.size(dest) / 1024L;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating file " + destFile, e);
        }
    }

    protected static String getJavaSpecVersion() {
        return System.getProperty("java.specification.version");
    }

    public static int getJavaVersion() {
        int version = 11;
        String v = BuildBase.getJavaSpecVersion();
        if (v != null) {
            version = Integer.parseInt(v);
        }
        return version;
    }

    private static List<String> getPaths(FileList files) {
        StringList list = new StringList(new String[0]);
        for (Path f : files) {
            list.add(f.toString());
        }
        return list;
    }

    protected void javac(StringList args, FileList files) {
        int result;
        block7: {
            this.println("Compiling " + files.size() + " classes");
            StringList params = new StringList(new String[0]);
            params.addAll(args);
            params.addAll(BuildBase.getPaths(files.keep(".java")));
            String[] array = params.array();
            PrintStream old = System.err;
            try {
                try {
                    Class<?> clazz = Class.forName("com.sun.tools.javac.Main");
                    if (this.quiet) {
                        System.setErr(BuildBase.filter(System.err, new String[]{"Note:"}));
                    }
                    Method compile = clazz.getMethod("compile", String[].class);
                    Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    result = (Integer)BuildBase.invoke(compile, instance, new Object[]{array});
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = this.exec("javac", new StringList(array));
                    System.setErr(old);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                System.setErr(old);
                throw throwable;
            }
            System.setErr(old);
        }
        if (result != 0) {
            throw new RuntimeException("An error occurred");
        }
    }

    protected void java(String className, StringList args) {
        this.println("Running " + className);
        String[] array = args == null ? new String[]{} : args.array();
        try {
            Method main = Class.forName(className).getMethod("main", String[].class);
            BuildBase.invoke(main, null, new Object[]{array});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static void mkdir(String dir) {
        BuildBase.mkdirs(Paths.get(dir, new String[0]));
    }

    private static void mkdirs(Path f) {
        try {
            Files.createDirectories(f, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            throw new RuntimeException("Can not create directory " + e.getFile() + " because a file with this name exists");
        }
        catch (IOException e) {
            throw new RuntimeException("Can not create directory " + String.valueOf(f.toAbsolutePath()));
        }
    }

    protected void delete(String dir) {
        this.println("Deleting " + dir);
        BuildBase.deleteRecursive(Paths.get(dir, new String[0]));
    }

    protected void delete(FileList files) {
        for (Path f : files) {
            BuildBase.deleteRecursive(f);
        }
    }

    public static void deleteRecursive(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (exc == null) {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                        throw exc;
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Can not delete " + String.valueOf(file));
            }
        }
    }

    protected static String replaceAll(String s, String before, String after) {
        int index = 0;
        int next;
        while ((next = ((String)s).indexOf(before, index)) >= 0) {
            s = ((String)s).substring(0, next) + after + ((String)s).substring(next + before.length());
            index = next + after.length();
        }
        return s;
    }

    protected void println(String s) {
        if (!this.quiet) {
            this.sysOut.println(s);
        }
    }

    protected void print(String s) {
        if (!this.quiet) {
            this.sysOut.print(s);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface Description {
        public String summary() default "";
    }

    public static class FileList
    extends ArrayList<Path> {
        private static final long serialVersionUID = 1L;

        public FileList exclude(String pattern) {
            return this.filter(false, pattern);
        }

        public FileList keep(String pattern) {
            return this.filter(true, pattern);
        }

        private FileList filter(boolean keep, String pattern) {
            boolean start = false;
            if (pattern.endsWith("*")) {
                pattern = pattern.substring(0, pattern.length() - 1);
                start = true;
            } else if (pattern.startsWith("*")) {
                pattern = pattern.substring(1);
            }
            if (pattern.indexOf(42) >= 0) {
                throw new RuntimeException("Unsupported pattern, may only start or end with *:" + pattern);
            }
            pattern = BuildBase.replaceAll(pattern, "/", File.separator);
            FileList list = new FileList();
            for (Path f : this) {
                boolean match;
                String path = f.toString();
                boolean bl = match = start ? path.startsWith(pattern) : path.endsWith(pattern);
                if (match != keep) continue;
                list.add(f);
            }
            return list;
        }
    }

    public static class StringList
    extends ArrayList<String> {
        private static final long serialVersionUID = 1L;

        StringList(String ... args) {
            this.addAll(Arrays.asList(args));
        }

        public StringList plus(String ... args) {
            StringList newList = new StringList(new String[0]);
            newList.addAll(this);
            newList.addAll(Arrays.asList(args));
            return newList;
        }

        public String[] array() {
            String[] list = new String[this.size()];
            int i = 0;
            while (i < this.size()) {
                list[i] = (String)this.get(i);
                ++i;
            }
            return list;
        }
    }
}

