/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.code;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class AbbaDetect {
    public static void main(String ... args) throws Exception {
        String baseDir = "src/main";
        Files.walkFileTree(Paths.get(baseDir, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                AbbaDetect.process(file, true);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static void process(Path file, boolean enable) throws IOException {
        String source;
        String name = file.getFileName().toString();
        if (!name.endsWith(".java")) {
            return;
        }
        if (name.endsWith("AbbaDetector.java")) {
            return;
        }
        String original = source = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        source = AbbaDetect.disable(source);
        if (enable) {
            String s2 = AbbaDetect.enable(source);
            if (!source.equals(AbbaDetect.disable(s2))) {
                throw new IOException("Could not revert changes for file " + String.valueOf(file));
            }
            source = s2;
        }
        if (source.equals(original)) {
            return;
        }
        Path newFile = Paths.get(file.toString() + ".new", new String[0]);
        Files.write(newFile, source.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Path oldFile = Paths.get(file.toString() + ".old", new String[0]);
        Files.move(file, oldFile, new CopyOption[0]);
        Files.move(newFile, file, new CopyOption[0]);
        Files.delete(oldFile);
    }

    private static String disable(String source) {
        source = source.replaceAll("\\{org.h2.util.AbbaDetector.begin\\(.*\\);", "{");
        source = source.replaceAll("org.h2.util.AbbaDetector.begin\\((.*\\(\\))\\)", "$1");
        source = source.replaceAll("org.h2.util.AbbaDetector.begin\\((.*)\\)", "$1");
        source = source.replaceAll("synchronized  ", "synchronized ");
        return source;
    }

    private static String enable(String source) {
        source = source.replaceAll("(// .* synchronized )([^ ])", "$1 $2");
        source = source.replaceAll("synchronized \\((.*)\\(\\)\\)", "synchronized  \\(org.h2.util.AbbaDetector.begin\\($1\\(\\)\\)\\)");
        source = source.replaceAll("synchronized \\((.*)\\)", "synchronized  \\(org.h2.util.AbbaDetector.begin\\($1\\)\\)");
        source = source.replaceAll("static synchronized ([^ (].*)\\{", "static synchronized  $1{org.h2.util.AbbaDetector.begin\\(null\\);");
        source = source.replaceAll("synchronized ([^ (].*)\\{", "synchronized  $1{org.h2.util.AbbaDetector.begin\\(this\\);");
        return source;
    }
}

