/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.code;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;

public class CheckTextFiles {
    private static final int MAX_SOURCE_LINE_SIZE = 120;
    private static final String COPYRIGHT1 = "Copyright 2004-2024";
    private static final String COPYRIGHT2 = "H2 Group.";
    private static final String LICENSE = "Multiple-Licensed under the MPL 2.0";
    private static final String[] SUFFIX_CHECK = new String[]{"html", "jsp", "js", "css", "bat", "nsi", "java", "txt", "properties", "sql", "xml", "csv", "Driver", "Processor", "prefs"};
    private static final String[] SUFFIX_IGNORE = new String[]{"gif", "png", "odg", "ico", "sxd", "layout", "res", "win", "jar", "task", "svg", "MF", "mf", "sh", "DS_Store", "prop", "class", "json"};
    private static final String[] SUFFIX_CRLF = new String[]{"bat"};
    private static final boolean ALLOW_TAB = false;
    private static final boolean ALLOW_CR = true;
    private static final boolean ALLOW_TRAILING_SPACES = false;
    private static final int SPACES_PER_TAB = 4;
    private static final boolean AUTO_FIX = true;
    private boolean failOnError;
    private boolean useCRLF;
    private final String[] suffixIgnoreLicense = new String[]{"bat", "nsi", "txt", "properties", "xml", "java.sql.Driver", "task", "sh", "prefs"};
    private boolean hasError;

    public static void main(String ... args) throws Exception {
        new CheckTextFiles().run();
    }

    private void run() throws Exception {
        Files.walkFileTree(Paths.get("src", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                CheckTextFiles.this.check(file);
                return FileVisitResult.CONTINUE;
            }
        });
        if (this.hasError) {
            throw new Exception("Errors found");
        }
    }

    void check(Path file) throws IOException {
        String s;
        String name = file.getFileName().toString();
        String suffix = "";
        int lastDot = name.lastIndexOf(46);
        if (lastDot >= 0) {
            suffix = name.substring(lastDot + 1);
        }
        boolean check = false;
        boolean ignore = false;
        String[] stringArray = SUFFIX_CHECK;
        int n = SUFFIX_CHECK.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (suffix.equals(s)) {
                check = true;
            }
            ++n2;
        }
        stringArray = SUFFIX_IGNORE;
        n = SUFFIX_IGNORE.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (suffix.equals(s)) {
                ignore = true;
            }
            ++n2;
        }
        boolean checkLicense = true;
        String[] stringArray2 = this.suffixIgnoreLicense;
        int n3 = this.suffixIgnoreLicense.length;
        n = 0;
        while (n < n3) {
            String ig = stringArray2[n];
            if (suffix.equals(ig) || name.endsWith(ig)) {
                checkLicense = false;
                break;
            }
            ++n;
        }
        if (ignore == check) {
            throw new RuntimeException("Unknown suffix: " + suffix + " for file: " + String.valueOf(file.toAbsolutePath()));
        }
        this.useCRLF = false;
        stringArray2 = SUFFIX_CRLF;
        n3 = SUFFIX_CRLF.length;
        n = 0;
        while (n < n3) {
            String s2 = stringArray2[n];
            if (suffix.equals(s2)) {
                this.useCRLF = true;
                break;
            }
            ++n;
        }
        if (check) {
            this.checkOrFixFile(file, true, checkLicense);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void checkOrFixFile(Path file, boolean fix, boolean checkLicense) throws IOException {
        data = Files.readAllBytes(file);
        v0 = out = fix != false ? new ByteArrayOutputStream() : null;
        if (checkLicense && data.length > "Copyright 2004-2024".length() + "Multiple-Licensed under the MPL 2.0".length()) {
            text = new String(data);
            if (text.indexOf("Copyright 2004-2024") < 0) {
                this.fail(file, "copyright is missing", 0);
            }
            if (text.indexOf("H2 Group.") < 0) {
                this.fail(file, "copyright is missing", 0);
            }
            if (text.indexOf("Multiple-Licensed under the MPL 2.0") < 0) {
                this.fail(file, "license is missing", 0);
            }
            if (text.indexOf("// ##") > 0) {
                this.fail(file, "unexpected space between // and ##", 0);
            }
            if (text.indexOf("/* ##") > 0) {
                this.fail(file, "unexpected space between /* and ##", 0);
            }
            if (text.indexOf("## */") > 0) {
                this.fail(file, "unexpected space between ## and */", 0);
            }
        }
        line = 1;
        startLinePos = 0;
        lastWasWhitespace = false;
        i = 0;
        while (i < data.length) {
            ch = (char)(data[i] & 255);
            isWhitespace = Character.isWhitespace(ch);
            if (ch > '\u007f') {
                this.fail(file, "contains character " + ch + " at " + new String(data, i - 10, 20), line);
                return;
            }
            if (ch >= ' ') ** GOTO lbl66
            if (ch == '\n') {
                if (lastWasWhitespace) {
                    this.fail(file, "contains trailing white space", line);
                    return;
                }
                if (fix) {
                    if (this.useCRLF) {
                        out.write(13);
                    }
                    out.write(ch);
                }
                lastWasWhitespace = false;
                ++line;
                lineLength = i - startLinePos;
                if (file.getFileName().toString().endsWith(".java")) {
                    if (i > 0 && data[i - 1] == 13) {
                        --lineLength;
                    }
                    if (lineLength > 120 && !(s = new String(data, startLinePos, lineLength).trim()).startsWith("// http://") && !s.startsWith("// https://")) {
                        this.fail(file, "line too long: " + lineLength, line);
                    }
                }
                startLinePos = i;
            } else if (ch == '\r') {
                if (lastWasWhitespace) {
                    this.fail(file, "contains trailing white space", line);
                    return;
                }
                lastWasWhitespace = false;
            } else if (ch == '\t') {
                if (fix) {
                    j = 0;
                    while (j < 4) {
                        out.write(32);
                        ++j;
                    }
                } else {
                    this.fail(file, "contains TAB", line);
                    return;
                }
                lastWasWhitespace = true;
            } else {
                this.fail(file, "contains character " + ch, line);
                return;
lbl66:
                // 1 sources

                if (isWhitespace) {
                    lastWasWhitespace = true;
                    if (fix) {
                        write = true;
                        j = i + 1;
                        while (j < data.length) {
                            ch2 = (char)(data[j] & 255);
                            if (ch2 == '\n' || ch2 == '\r') {
                                write = false;
                                lastWasWhitespace = false;
                                ch = ch2;
                                i = j - 1;
                                break;
                            }
                            if (!Character.isWhitespace(ch2)) break;
                            ++j;
                        }
                        if (write) {
                            out.write(ch);
                        }
                    }
                } else {
                    if (fix) {
                        out.write(ch);
                    }
                    lastWasWhitespace = false;
                }
            }
            ++i;
        }
        if (lastWasWhitespace) {
            this.fail(file, "contains trailing white space at the very end", line);
            return;
        }
        if (fix && !Arrays.equals(data, changed = out.toByteArray())) {
            Files.write(file, changed, new OpenOption[0]);
            System.out.println("CHANGED: " + String.valueOf(file.getFileName()));
        }
        line = 1;
        i = 0;
        while (i < data.length) {
            if (data[i] < 32) {
                ++line;
                j = i + 1;
                while (j < data.length) {
                    if (data[j] != 32) {
                        mod = j - i - 1 & 3;
                        if (mod == 0 || mod == 1 && data[j] == 42) break;
                        this.fail(file, "contains wrong number of heading spaces: " + (j - i - 1), line);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void fail(Path file, String error, int line) {
        Object name;
        int idx;
        file = file.toAbsolutePath();
        if (line <= 0) {
            line = 1;
        }
        if ((idx = ((String)(name = file.toString())).lastIndexOf(File.separatorChar)) >= 0) {
            name = ((String)name).replace(File.separatorChar, '.');
            if ((idx = ((String)(name = (String)name + "(" + ((String)name).substring(idx + 1) + ":" + line + ")")).indexOf("org.")) > 0) {
                name = ((String)name).substring(idx);
            }
        }
        System.out.println("FAIL at " + (String)name + " " + error + " " + String.valueOf(file.toAbsolutePath()));
        this.hasError = true;
        if (this.failOnError) {
            throw new RuntimeException("FAIL");
        }
    }
}

