/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.doc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.h2.build.indexer.HtmlConverter;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;

public class FileConverter {
    private String inFile = "~/temp/in.txt";
    private String outFile = "~/temp/out.txt";

    public static void main(String ... args) throws Exception {
        new FileConverter().run(args);
    }

    private void run(String ... args) throws Exception {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-in")) {
                this.inFile = args[++i];
            } else if (args[i].equals("-out")) {
                this.outFile = args[++i];
            }
            ++i;
        }
        String languageCode = Locale.KOREA.getLanguage();
        String language = new Locale(languageCode).getDisplayLanguage(new Locale(languageCode));
        System.out.println(language);
        System.out.println(StringUtils.javaEncode(language));
        this.convert();
    }

    private void convert() throws IOException {
        InputStream in = FileUtils.newInputStream(this.inFile);
        byte[] bytes = IOUtils.readBytesAndClose(in, -1);
        String s = new String(bytes, StandardCharsets.UTF_8);
        String s2 = HtmlConverter.convertHtmlToString(s);
        String s3 = StringUtils.javaDecode(s2);
        byte[] result = s3.getBytes(StandardCharsets.UTF_8);
        OutputStream out = FileUtils.newOutputStream(this.outFile, false);
        out.write(result);
        out.close();
    }
}

