/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.doc;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.h2.util.StringUtils;

public class LinkChecker {
    private static final boolean TEST_EXTERNAL_LINKS = false;
    private static final boolean OPEN_EXTERNAL_LINKS = false;
    private static final String[] IGNORE_MISSING_LINKS_TO = new String[]{"SysProperties", "ErrorCode", "#build_index", "#datatypes_index", "#faq_index", "#commands_index", "#grammar_index", "#functions_index", "#functions_aggregate_index", "#functions_window_index", "#tutorial_index", "docs/javadoc/"};
    private final HashMap<String, TargetKind> targets = new HashMap();
    private final HashMap<String, String> links = new HashMap();

    public static void main(String ... args) throws Exception {
        new LinkChecker().run(args);
    }

    private void run(String ... args) throws Exception {
        Path dir = Paths.get("docs", new String[0]);
        int i = 0;
        while (i < args.length) {
            if ("-dir".equals(args[i])) {
                dir = Paths.get(args[++i], new String[0]);
            }
            ++i;
        }
        this.process(dir);
        this.listExternalLinks();
        this.listBadLinks();
    }

    private void listExternalLinks() {
        for (String link : this.links.keySet()) {
            if (link.startsWith("http") && link.indexOf("//localhost") <= 0) continue;
        }
    }

    private void listBadLinks() throws Exception {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (String string : this.links.keySet()) {
            if (string.startsWith("http") || string.endsWith("h2.pdf") || string.startsWith("docs/javadoc") || this.targets.get(string) != null) continue;
            errors.add((CallSite)((Object)(this.links.get(string) + ": Link missing " + string)));
        }
        for (String string : this.links.keySet()) {
            if (string.startsWith("http")) continue;
            this.targets.remove(string);
        }
        for (String string : this.targets.keySet()) {
            if (this.targets.get(string) != TargetKind.ID) continue;
            boolean ignore = false;
            String[] stringArray = IGNORE_MISSING_LINKS_TO;
            int n = IGNORE_MISSING_LINKS_TO.length;
            int n2 = 0;
            while (n2 < n) {
                String to = stringArray[n2];
                if (string.contains(to)) {
                    ignore = true;
                    break;
                }
                ++n2;
            }
            if (ignore) continue;
            errors.add((CallSite)((Object)("No link to " + string)));
        }
        Collections.sort(errors);
        for (String string : errors) {
            System.out.println(string);
        }
        if (!errors.isEmpty()) {
            throw new Exception("Problems where found by the Link Checker");
        }
    }

    private void process(Path path) throws Exception {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                LinkChecker.this.processFile(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    void processFile(Path file) throws IOException {
        Object ref;
        int end;
        int start;
        String path = file.toString();
        this.targets.put(path, TargetKind.FILE);
        String fileName = file.getFileName().toString();
        String lower = StringUtils.toLowerEnglish(fileName);
        if (!lower.endsWith(".html") && !lower.endsWith(".htm")) {
            return;
        }
        Path parent = file.getParent();
        String html = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        int idx = -1;
        while ((idx = html.indexOf(" id=\"", idx + 1)) >= 0) {
            start = idx + " id=\"".length();
            end = html.indexOf(34, start);
            if (end < 0) {
                LinkChecker.error(fileName, "Expected \" after id= " + html.substring(idx, idx + 100));
            }
            if (((String)(ref = html.substring(start, end))).startsWith("_")) continue;
            this.targets.put(path + "#" + ((String)ref).replaceAll("%3C|&lt;", "<").replaceAll("%3E|&gt;", ">"), TargetKind.ID);
        }
        idx = -1;
        while ((idx = html.indexOf(" href=\"", idx + 1)) >= 0) {
            start = html.indexOf(34, idx);
            if (start < 0) {
                LinkChecker.error(fileName, "Expected \" after href= at " + html.substring(idx, idx + 100));
            }
            if ((end = html.indexOf(34, start + 1)) < 0) {
                LinkChecker.error(fileName, "Expected \" after href= at " + html.substring(idx, idx + 100));
            }
            if (!((String)(ref = html.substring(start + 1, end))).startsWith("http:") && !((String)ref).startsWith("https:")) {
                if (((String)ref).startsWith("javascript:")) {
                    ref = null;
                } else if (((String)ref).length() == 0) {
                    ref = null;
                } else if (((String)ref).startsWith("#")) {
                    ref = path + (String)ref;
                } else {
                    Path p = parent;
                    while (((String)ref).startsWith(".")) {
                        if (((String)ref).startsWith("./")) {
                            ref = ((String)ref).substring(2);
                            continue;
                        }
                        if (!((String)ref).startsWith("../")) continue;
                        ref = ((String)ref).substring(3);
                        p = p.getParent();
                    }
                    ref = String.valueOf(p) + File.separator + (String)ref;
                }
            }
            if (ref == null) continue;
            this.links.put(((String)ref).replace('/', File.separatorChar).replaceAll("%5B", "[").replaceAll("%5D", "]").replaceAll("%3C", "<").replaceAll("%3E", ">"), path);
        }
        idx = -1;
        while ((idx = html.indexOf("<a ", idx + 1)) >= 0) {
            int end2;
            int equals = html.indexOf(61, idx);
            if (equals < 0) {
                LinkChecker.error(fileName, "Expected = after <a at " + html.substring(idx, idx + 100));
            }
            String type = html.substring(idx + 2, equals).trim();
            int start2 = html.indexOf(34, idx);
            if (start2 < 0) {
                LinkChecker.error(fileName, "Expected \" after <a at " + html.substring(idx, idx + 100));
            }
            if ((end2 = html.indexOf(34, start2 + 1)) < 0) {
                LinkChecker.error(fileName, "Expected \" after <a at " + html.substring(idx, idx + 100));
            }
            String ref2 = html.substring(start2 + 1, end2);
            if (type.equals("href")) continue;
            if (type.equals("id")) {
                this.targets.put(path + "#" + ref2, TargetKind.ID);
                continue;
            }
            if (type.equals("name")) continue;
            LinkChecker.error(fileName, "Unsupported <a ?: " + html.substring(idx, idx + 100));
        }
    }

    private static void error(String fileName, String string) {
        System.out.println("ERROR with " + fileName + ": " + string);
    }

    private static enum TargetKind {
        FILE,
        ID;

    }
}

