/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.doc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.build.BuildBase;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class SpellChecker {
    private static final String[] SUFFIX = new String[]{"html", "java", "sql", "txt", "xml", "jsp", "css", "bat", "csv", "xml", "js", "Driver", "Processor", "properties", "task", "MF", "mf", "sh", ""};
    private static final String[] IGNORE = new String[]{"dev", "nsi", "gif", "png", "odg", "ico", "sxd", "zip", "bz2", "rc", "layout", "res", "dll", "jar", "svg", "prefs", "prop", "iml", "class", "json"};
    private static final String DELIMITERS = " \n.();-\"=,*/{}_<>+\r:'@[]&\\!#|?$^%~`\t";
    private static final String PREFIX_IGNORE = "abc";
    private static final String[] IGNORE_FILES = new String[]{"mainWeb.html"};
    public boolean debug;
    public boolean printDictionary;
    private final HashSet<String> dictionary = new HashSet();
    private final HashSet<String> used = new HashSet();
    private final HashMap<String, Integer> unknown = new HashMap();
    private boolean addToDictionary;
    private int errorCount;
    private int contextCount;

    public static void main(String ... args) throws IOException {
        String dir = Utils.getProperty("spellcheckDir", "src");
        new SpellChecker().run("src/tools/org/h2/build/doc/dictionary.txt", dir);
    }

    private void run(String dictionaryFileName, String dir) throws IOException {
        this.process(Paths.get(dictionaryFileName, new String[0]));
        this.process(Paths.get(dir, new String[0]));
        HashSet<String> unused = new HashSet<String>();
        unused.addAll(this.dictionary);
        unused.removeAll(this.used);
        if (this.printDictionary) {
            System.out.println("USED WORDS");
            Object[] list = this.used.toArray(new String[this.used.size()]);
            Arrays.sort(list);
            StringBuilder buff = new StringBuilder();
            Object[] objectArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                if (buff.length() > 0) {
                    if (buff.length() + ((String)s).length() > 80) {
                        System.out.println(buff.toString());
                        buff.setLength(0);
                    } else {
                        buff.append(' ');
                    }
                }
                buff.append((String)s);
                ++n2;
            }
            System.out.println(buff.toString());
        }
        if (this.unknown.size() > 0) {
            System.out.println();
            System.out.println("UNKNOWN WORDS");
            for (String s : this.unknown.keySet()) {
                System.out.print(s + " ");
                ++this.errorCount;
            }
            System.out.println();
            System.out.println();
        }
        if (this.errorCount > 0) {
            throw new IOException(this.errorCount + " error found");
        }
    }

    private void process(Path file) throws IOException {
        String name = file.getFileName().toString();
        if (name.endsWith(".svn") || name.endsWith(".DS_Store")) {
            return;
        }
        if (name.startsWith("_") && name.indexOf("_en") < 0) {
            return;
        }
        if (Files.isDirectory(file, new LinkOption[0])) {
            for (Path f : Files.newDirectoryStream(file)) {
                this.process(f);
            }
        } else {
            String fileName = file.toAbsolutePath().toString();
            int idx = fileName.lastIndexOf(46);
            String suffix = idx < 0 ? "" : fileName.substring(idx + 1);
            String[] stringArray = IGNORE;
            int n = IGNORE.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals(suffix)) {
                    return;
                }
                ++n2;
            }
            stringArray = IGNORE_FILES;
            n = IGNORE_FILES.length;
            n2 = 0;
            while (n2 < n) {
                String ignoreFile = stringArray[n2];
                if (fileName.endsWith(ignoreFile)) {
                    return;
                }
                ++n2;
            }
            boolean ok = false;
            String[] stringArray2 = SUFFIX;
            int n3 = SUFFIX.length;
            n = 0;
            while (n < n3) {
                String s = stringArray2[n];
                if (s.equals(suffix)) {
                    ok = true;
                    break;
                }
                ++n;
            }
            if (!ok) {
                throw new IOException("Unsupported suffix: " + suffix + " for file: " + fileName);
            }
            String text = new String(BuildBase.readFile(file));
            this.addToDictionary = fileName.endsWith("dictionary.txt");
            this.scan(fileName, text);
        }
    }

    private void scan(String fileName, String text) {
        HashSet<String> notFound = new HashSet<String>();
        text = this.removeLinks(fileName, text);
        StringTokenizer tokenizer = new StringTokenizer(text, DELIMITERS);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            char first = token.charAt(0);
            if (Character.isDigit(first)) continue;
            if (!this.addToDictionary && this.debug) {
                System.out.print(token + " ");
            }
            this.scanCombinedToken(notFound, token);
            if (this.addToDictionary || !this.debug) continue;
            System.out.println();
        }
        if (!notFound.isEmpty()) {
            System.out.println("file: " + fileName);
            for (String s : notFound) {
                System.out.print(s + " ");
            }
            System.out.println();
        }
    }

    private String removeLinks(String fileName, String text) {
        Matcher m;
        Pattern linkPattern = Pattern.compile("http[s]?://");
        StringBuilder buff = new StringBuilder(text.length());
        int pos = 0;
        int last = 0;
        if (fileName.endsWith(".properties")) {
            text = StringUtils.replaceAll(text, "\\:", ":");
        }
        while ((m = linkPattern.matcher(text.substring(pos))).find()) {
            char c;
            int start = m.start() + pos;
            pos = m.end() + pos;
            buff.append(text.substring(last, start));
            while (Character.isJavaIdentifierPart(c = text.charAt(pos)) || ".#/?&=%+_-:".indexOf(c) >= 0) {
                ++pos;
            }
            String link = text.substring(start, pos);
            if (link.endsWith(".")) {
                System.out.println("Link ending with dot in " + fileName + ": " + link);
                ++this.errorCount;
            }
            last = pos;
        }
        buff.append(text.substring(last));
        String changed = buff.toString();
        return changed;
    }

    private void scanCombinedToken(HashSet<String> notFound, String token) {
        int i = 1;
        while (i < token.length()) {
            char charLeft = token.charAt(i - 1);
            char charRight = token.charAt(i);
            if (Character.isLowerCase(charLeft) && Character.isUpperCase(charRight)) {
                this.scanToken(notFound, token.substring(0, i));
                token = token.substring(i);
                i = 1;
            } else if (Character.isUpperCase(charLeft) && Character.isLowerCase(charRight)) {
                this.scanToken(notFound, token.substring(0, i - 1));
                token = token.substring(i - 1);
                i = 1;
            }
            ++i;
        }
        this.scanToken(notFound, token);
    }

    private void scanToken(HashSet<String> notFound, String token) {
        char last;
        if (token.length() < 3) {
            return;
        }
        if (this.contextCount > 0) {
            --this.contextCount;
        }
        while (Character.isDigit(last = token.charAt(token.length() - 1))) {
            token = token.substring(0, token.length() - 1);
        }
        if (token.length() < 3) {
            return;
        }
        int i = 0;
        while (i < token.length()) {
            if (Character.isDigit(token.charAt(i))) {
                return;
            }
            ++i;
        }
        token = token.toLowerCase();
        if (!this.addToDictionary && this.debug) {
            System.out.print(token + " ");
        }
        if (token.startsWith(PREFIX_IGNORE)) {
            return;
        }
        if (StringUtils.replaceAll(token, token.substring(0, 1), "").length() == 0) {
            return;
        }
        if (this.addToDictionary) {
            this.dictionary.add(token);
        } else if (!this.dictionary.contains(token)) {
            notFound.add(token);
            this.increment(this.unknown, token);
        } else {
            this.used.add(token);
        }
    }

    private void increment(HashMap<String, Integer> map, String key) {
        Integer value = map.get(key);
        value = value == null ? 0 : value + 1;
        map.put(key, value);
        this.contextCount = 10;
    }
}

