/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.doc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.dev.ftp.FtpClient;
import org.h2.engine.Constants;
import org.h2.store.fs.FileUtils;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;

public class UploadBuild {
    public static void main(String ... args) throws Exception {
        String mavenRepoDir;
        boolean mavenSnapshot;
        String s;
        Connection conn;
        int end;
        boolean error;
        String testOutput;
        boolean coverageFailed;
        System.exit(0);
        System.setProperty("h2.socketConnectTimeout", "30000");
        String password = System.getProperty("h2.ftpPassword");
        if (password == null) {
            return;
        }
        FtpClient ftp = FtpClient.open("h2database.com");
        ftp.login("h2database", password);
        ftp.changeWorkingDirectory("/httpdocs");
        Path coverageFile = Paths.get("coverage/index.html", new String[0]);
        boolean coverage = Files.exists(coverageFile, new LinkOption[0]);
        if (coverage) {
            int idx;
            Object index = new String(Files.readAllBytes(coverageFile), StandardCharsets.ISO_8859_1);
            coverageFailed = ((String)index).contains("CLASS=\"h\"");
            while ((idx = ((String)index).indexOf("<A HREF=\"")) >= 0) {
                int end2 = ((String)index).indexOf(62, idx) + 1;
                index = ((String)index).substring(0, idx) + ((String)index).substring(end2);
                idx = ((String)index).indexOf("</A>");
                index = ((String)index).substring(0, idx) + ((String)index).substring(idx + "</A>".length());
            }
            index = StringUtils.replaceAll((String)index, "[all", "");
            index = StringUtils.replaceAll((String)index, "classes]", "");
            Files.write(Paths.get("coverage/overview.html", new String[0]), ((String)index).getBytes(StandardCharsets.ISO_8859_1), new OpenOption[0]);
            Files.createDirectories(Paths.get("details", new String[0]), new FileAttribute[0]);
            UploadBuild.zip("details/coverage_files.zip", "coverage", true);
            UploadBuild.zip("coverage.zip", "details", false);
            FileUtils.delete("coverage.txt");
            FileUtils.delete("details/coverage_files.zip");
            FileUtils.delete("details");
            if (ftp.exists("/httpdocs", "coverage")) {
                ftp.removeDirectoryRecursive("/httpdocs/coverage");
            }
            ftp.makeDirectory("/httpdocs/coverage");
        } else {
            coverageFailed = true;
        }
        Path testOutputFile = Paths.get("docs/html/testOutput.html", new String[0]);
        if (Files.exists(testOutputFile, new LinkOption[0])) {
            testOutput = new String(Files.readAllBytes(testOutputFile), StandardCharsets.UTF_8);
            error = testOutput.contains("<span style=\"color:red;\">");
        } else {
            Path logFile = Paths.get("log.txt", new String[0]);
            if (Files.exists(logFile, new LinkOption[0])) {
                testOutput = new String(Files.readAllBytes(logFile));
                testOutput = testOutput.replaceAll("\n", "<br />");
                error = true;
            } else {
                testOutput = "No log.txt";
                error = true;
            }
        }
        if (!ftp.exists("/httpdocs", "automated")) {
            ftp.makeDirectory("/httpdocs/automated");
        }
        Object buildSql = ftp.exists("/httpdocs/automated", "history.sql") ? new String(ftp.retrieve("/httpdocs/automated/history.sql")) : "create table item(id identity, title varchar, issued timestamp, desc varchar);\n";
        String ts = new Timestamp(System.currentTimeMillis()).toString();
        Object now = ts.substring(0, 16);
        int idx = testOutput.indexOf("Statements per second: ");
        if (idx >= 0 && (end = testOutput.indexOf("<br />", idx)) >= 0) {
            String result = testOutput.substring(idx + "Statements per second: ".length(), end);
            now = (String)now + " " + result + " op/s";
        }
        String sql = "insert into item(title, issued, desc) values('Build " + (String)now + (error ? " FAILED" : "") + (coverageFailed ? " COVERAGE" : "") + "', '" + ts + "', '<a href=\"https://h2database.com/html/testOutput.html\">Output</a> - <a href=\"https://h2database.com/coverage/overview.html\">Coverage</a> - <a href=\"https://h2database.com/automated/h2-latest.jar\">Jar</a>');\n";
        buildSql = (String)buildSql + sql;
        try {
            Class.forName("org.h2.Driver");
            conn = DriverManager.getConnection("jdbc:h2:mem:");
        }
        catch (Exception e) {
            Class.forName("org.h2.upgrade.v1_1.Driver");
            conn = DriverManager.getConnection("jdbc:h2v1_1:mem:");
        }
        conn.createStatement().execute((String)buildSql);
        String newsfeed = new String(Files.readAllBytes(Paths.get("src/tools/org/h2/build/doc/buildNewsfeed.sql", new String[0])), StandardCharsets.UTF_8);
        ScriptReader r = new ScriptReader(new StringReader(newsfeed));
        Statement stat = conn.createStatement();
        ResultSet rs = null;
        while ((s = r.readStatement()) != null) {
            if (!stat.execute(s)) continue;
            rs = stat.getResultSet();
        }
        rs.next();
        String content = rs.getString("content");
        conn.close();
        ftp.store("/httpdocs/automated/history.sql", new ByteArrayInputStream(((String)buildSql).getBytes()));
        ftp.store("/httpdocs/automated/news.xml", new ByteArrayInputStream(content.getBytes()));
        ftp.store("/httpdocs/html/testOutput.html", new ByteArrayInputStream(testOutput.getBytes()));
        String jarFileName = "bin/h2-" + Constants.VERSION + ".jar";
        if (FileUtils.exists(jarFileName)) {
            ftp.store("/httpdocs/automated/h2-latest.jar", Files.newInputStream(Paths.get(jarFileName, new String[0]), new OpenOption[0]));
        }
        if (coverage) {
            ftp.store("/httpdocs/coverage/overview.html", Files.newInputStream(Paths.get("coverage/overview.html", new String[0]), new OpenOption[0]));
            ftp.store("/httpdocs/coverage/coverage.zip", Files.newInputStream(Paths.get("coverage.zip", new String[0]), new OpenOption[0]));
            FileUtils.delete("coverage.zip");
        }
        if (mavenSnapshot = Files.exists(Paths.get((mavenRepoDir = System.getProperty("user.home") + "/.m2/repository/") + "com/h2database/h2/1.0-SNAPSHOT/h2-1.0-SNAPSHOT.jar", new String[0]), new LinkOption[0])) {
            if (!ftp.exists("/httpdocs", "m2-repo")) {
                ftp.makeDirectory("/httpdocs/m2-repo");
            }
            if (!ftp.exists("/httpdocs/m2-repo", "com")) {
                ftp.makeDirectory("/httpdocs/m2-repo/com");
            }
            if (!ftp.exists("/httpdocs/m2-repo/com", "h2database")) {
                ftp.makeDirectory("/httpdocs/m2-repo/com/h2database");
            }
            if (!ftp.exists("/httpdocs/m2-repo/com/h2database", "h2")) {
                ftp.makeDirectory("/httpdocs/m2-repo/com/h2database/h2");
            }
            if (!ftp.exists("/httpdocs/m2-repo/com/h2database/h2", "1.0-SNAPSHOT")) {
                ftp.makeDirectory("/httpdocs/m2-repo/com/h2database/h2/1.0-SNAPSHOT");
            }
            if (!ftp.exists("/httpdocs/m2-repo/com/h2database", "h2-mvstore")) {
                ftp.makeDirectory("/httpdocs/m2-repo/com/h2database/h2-mvstore");
            }
            if (!ftp.exists("/httpdocs/m2-repo/com/h2database/h2-mvstore", "1.0-SNAPSHOT")) {
                ftp.makeDirectory("/httpdocs/m2-repo/com/h2database/h2-mvstore/1.0-SNAPSHOT");
            }
            ftp.store("/httpdocs/m2-repo/com/h2database/h2/1.0-SNAPSHOT/h2-1.0-SNAPSHOT.pom", Files.newInputStream(Paths.get(mavenRepoDir + "com/h2database/h2/1.0-SNAPSHOT/h2-1.0-SNAPSHOT.pom", new String[0]), new OpenOption[0]));
            ftp.store("/httpdocs/m2-repo/com/h2database/h2/1.0-SNAPSHOT/h2-1.0-SNAPSHOT.jar", Files.newInputStream(Paths.get(mavenRepoDir + "com/h2database/h2/1.0-SNAPSHOT/h2-1.0-SNAPSHOT.jar", new String[0]), new OpenOption[0]));
            ftp.store("/httpdocs/m2-repo/com/h2database/h2-mvstore/1.0-SNAPSHOT/h2-mvstore-1.0-SNAPSHOT.pom", Files.newInputStream(Paths.get(mavenRepoDir + "com/h2database/h2-mvstore/1.0-SNAPSHOT/h2-mvstore-1.0-SNAPSHOT.pom", new String[0]), new OpenOption[0]));
            ftp.store("/httpdocs/m2-repo/com/h2database/h2-mvstore/1.0-SNAPSHOT/h2-mvstore-1.0-SNAPSHOT.jar", Files.newInputStream(Paths.get(mavenRepoDir + "com/h2database/h2-mvstore/1.0-SNAPSHOT/h2-mvstore-1.0-SNAPSHOT.jar", new String[0]), new OpenOption[0]));
        }
        ftp.close();
    }

    private static void zip(String destFile, String directory, boolean storeOnly) throws IOException {
        final ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(Paths.get(destFile, new String[0]), new OpenOption[0]));
        if (storeOnly) {
            zipOut.setMethod(0);
        }
        zipOut.setLevel(9);
        final Path base = Paths.get(directory, new String[0]);
        Files.walkFileTree(base, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                byte[] data = Files.readAllBytes(file);
                ZipEntry entry = new ZipEntry(base.relativize(file).toString().replace('\\', '/'));
                CRC32 crc = new CRC32();
                crc.update(data);
                entry.setSize(data.length);
                entry.setCrc(crc.getValue());
                zipOut.putNextEntry(entry);
                zipOut.write(data);
                zipOut.closeEntry();
                return FileVisitResult.CONTINUE;
            }
        });
        zipOut.finish();
        zipOut.close();
    }
}

