/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.indexer;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.h2.build.indexer.HtmlConverter;
import org.h2.build.indexer.Page;
import org.h2.build.indexer.Weight;
import org.h2.build.indexer.Word;
import org.h2.util.StringUtils;

public class Indexer {
    private static final int MIN_WORD_SIZE = 3;
    private static final int MAX_RELATIONS = 30;
    private static final String VERY_COMMON = ";the;be;to;of;and;a;in;that;have;i;it;for;not;on;with;he;as;you;do;at;this;but;his;by;from;they;we;say;her;she;or;an;will;my;one;all;would;there;their;what;so;up;out;if;about;who;get;which;go;me;when;make;can;like;no;just;him;know;take;into;your;good;some;could;them;see;other;than;then;now;look;only;come;its;over;think;also;back;after;use;two;how;our;work;first;well;way;even;new;want;because;any;these;give;most;us;";
    private final ArrayList<Page> pages = new ArrayList();
    private final HashMap<String, Word> words = new HashMap();
    private final HashSet<String> noIndex = new HashSet();
    private ArrayList<Word> wordList;
    private PrintWriter output;
    private Page page;
    private boolean title;
    private boolean heading;
    private String ignored;

    public static void main(String ... args) throws Exception {
        new Indexer().run(args);
    }

    private void run(String ... args) throws Exception {
        String dir = "docs";
        String destDir = "docs/html";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-dir")) {
                dir = args[++i];
            } else if (args[i].equals("-destDir")) {
                destDir = args[++i];
            }
            ++i;
        }
        final Path directory = Paths.get(dir, new String[0]);
        this.setNoIndex("index.html", "html/header.html", "html/search.html", "html/frame.html", "html/fragments.html", "html/sourceError.html", "html/source.html", "html/mainWeb.html", "javadoc/index.html", "javadoc/classes.html", "javadoc/allclasses-frame.html", "javadoc/allclasses-noframe.html", "javadoc/constant-values.html", "javadoc/overview-frame.html", "javadoc/overview-summary.html", "javadoc/serialized-form.html");
        this.output = new PrintWriter(Files.newBufferedWriter(Paths.get(destDir + "/index.js", new String[0]), new OpenOption[0]));
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Indexer.this.readPages(directory.relativize(file).toString().replace('\\', '/'), file);
                return FileVisitResult.CONTINUE;
            }
        });
        this.output.println("var pages=new Array();");
        this.output.println("var ref=new Array();");
        this.output.println("var ignored='';");
        this.output.println("function Page(title, file) { ");
        this.output.println("    this.title=title; this.file=file;");
        this.output.println("}");
        this.output.println("function load() {");
        this.sortWords();
        this.removeOverflowRelations();
        this.sortPages();
        this.listPages();
        this.listWords();
        this.output.println("}");
        this.output.close();
    }

    private void setNoIndex(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.noIndex.add(s);
            ++n2;
        }
    }

    private void sortWords() {
        for (String name : new ArrayList<String>(this.words.keySet())) {
            if (name.endsWith("s")) {
                String singular = name.substring(0, name.length() - 1);
                if (!this.words.containsKey(singular)) continue;
                Word wp = this.words.get(name);
                Word ws = this.words.get(singular);
                ws.addAll(wp);
                this.words.remove(name);
                continue;
            }
            if (!name.startsWith("abc")) continue;
            this.words.remove(name);
        }
        this.wordList = new ArrayList<Word>(this.words.values());
        StringBuilder ignoredBuff = new StringBuilder(";");
        int maxSize = this.pages.size() / 4;
        int i = 0;
        while (i < this.wordList.size()) {
            Word word = this.wordList.get(i);
            String search = ";" + word.name.toLowerCase() + ";";
            int idxCommon = VERY_COMMON.indexOf(search);
            if (word.pages.size() >= maxSize || idxCommon >= 0) {
                this.wordList.remove(i);
                ignoredBuff.append(word.name);
                ignoredBuff.append(';');
                --i;
            }
            ++i;
        }
        this.ignored = ignoredBuff.toString();
        this.wordList.sort((w0, w1) -> w0.name.compareToIgnoreCase(w1.name));
    }

    private void removeOverflowRelations() {
        for (Word word : this.wordList) {
            Weight weight;
            ArrayList<Weight> weights = word.getSortedWeights();
            int max = 30;
            if (weights.size() > max) {
                while (max < weights.size()) {
                    weight = weights.get(max);
                    if (weight.value < 100) break;
                    ++max;
                }
            }
            while (max < weights.size()) {
                weight = weights.get(max);
                weights.remove(max);
                --weight.page.relations;
            }
        }
    }

    private void sortPages() {
        this.pages.sort((p0, p1) -> Integer.compare(p1.relations, p0.relations));
        int i = 0;
        while (i < this.pages.size()) {
            this.pages.get((int)i).id = i;
            ++i;
        }
    }

    private void listPages() {
        for (Page p : this.pages) {
            this.output.println("pages[" + p.id + "]=new Page('" + Indexer.convertUTF(p.title) + "', '" + p.fileName + "');");
        }
    }

    void readPages(String fileName, Path file) throws IOException {
        String lower = StringUtils.toLowerEnglish(fileName);
        if (!lower.endsWith(".html") && !lower.endsWith(".htm")) {
            return;
        }
        if (!this.noIndex.contains(fileName)) {
            this.page = new Page(this.pages.size(), fileName);
            this.pages.add(this.page);
            this.readPage(file);
        }
    }

    private void listWords() {
        this.output.println("// words: " + this.wordList.size());
        StringBuilder buff = new StringBuilder();
        String first = "";
        int firstLen = 1;
        int totalRelations = 0;
        for (Word word : this.wordList) {
            ArrayList<Weight> weights = word.getSortedWeights();
            String lower = StringUtils.toLowerEnglish(word.name);
            if (!first.equals(lower.substring(0, firstLen))) {
                if (buff.length() > 0) {
                    this.output.println("ref['" + Indexer.convertUTF(first) + "']='" + buff.toString() + "';");
                    buff = new StringBuilder();
                }
                first = lower.substring(0, firstLen);
            }
            if (buff.length() > 0) {
                buff.append(';');
            }
            buff.append(Indexer.convertUTF(word.name));
            buff.append('=');
            String weightString = "r";
            totalRelations += weights.size();
            int j = 0;
            while (j < weights.size()) {
                String ws;
                Weight weight = weights.get(j);
                Page p = weight.page;
                if (j > 0) {
                    buff.append(",");
                }
                if (!(ws = weight.value >= 10000 ? "t" : (weight.value >= 100 ? "h" : "r")).equals(weightString)) {
                    weightString = ws;
                    buff.append(ws);
                }
                buff.append(p.id);
                ++j;
            }
        }
        this.output.println("ref['" + Indexer.convertUTF(first) + "']='" + buff.toString() + "';");
        this.output.println("// totalRelations: " + totalRelations);
        this.output.println("ignored='" + this.ignored.toLowerCase() + "';");
    }

    private void readPage(Path file) throws IOException {
        String text = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        StringTokenizer t = new StringTokenizer(text, "<> \r\n", true);
        boolean inTag = false;
        this.title = false;
        this.heading = false;
        block5: while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (token.length() == 1) {
                char c = token.charAt(0);
                switch (c) {
                    case '<': {
                        if (inTag) {
                            this.process("???");
                        }
                        inTag = true;
                        if (!t.hasMoreTokens()) continue block5;
                        token = t.nextToken();
                        if (token.startsWith("/")) {
                            this.title = false;
                            this.heading = false;
                            break;
                        }
                        if (token.equalsIgnoreCase("title")) {
                            this.title = true;
                            break;
                        }
                        if (token.length() != 2 || Character.toLowerCase(token.charAt(0)) != 'h' || !Character.isDigit(token.charAt(1))) continue block5;
                        this.heading = true;
                        break;
                    }
                    case '>': {
                        if (!inTag) {
                            this.process("???");
                        }
                        inTag = false;
                        break;
                    }
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        if (inTag) continue block5;
                        this.process(token);
                        break;
                    }
                }
                continue;
            }
            if (inTag) continue;
            this.process(token);
        }
        if (this.page.title == null || this.page.title.trim().length() == 0) {
            String title = file.getFileName().toString();
            System.out.println("Error: not title found in " + title);
            this.page.title = title;
        }
        this.page.title = this.page.title.trim();
    }

    private void process(String text) {
        text = HtmlConverter.convertHtmlToString(text);
        if (this.title) {
            this.page.title = this.page.title == null ? text : this.page.title + " " + text;
        }
        int weight = this.title ? 10000 : (this.heading ? 100 : 1);
        StringTokenizer t = new StringTokenizer(text, " \t\r\n\"'.,:;!&/\\?%@`[]{}()+-=<>|*^~#$\u00a0", false);
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (token.length() < 3 || Character.isDigit(token.charAt(0))) continue;
            String lower = StringUtils.toLowerEnglish(token);
            Word word = this.words.get(lower);
            if (word == null) {
                word = new Word(token);
                this.words.put(lower, word);
            } else if (!word.name.equals(token)) {
                word.name = token.compareTo(word.name) > 0 ? token : word.name;
            }
            this.page.totalWeight += weight;
            word.addPage(this.page, weight);
        }
    }

    private static String convertUTF(String s) {
        s = StringUtils.quoteJavaString(s);
        s = s.substring(1, s.length() - 1);
        return s;
    }
}

