/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.Token;
import org.h2.command.dml.DataChangeStatement;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbSettings;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.table.Column;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.Table;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CommandContainer
extends Command {
    private Prepared prepared;
    private boolean readOnlyKnown;
    private boolean readOnly;

    public CommandContainer(SessionLocal session, String sql, Prepared prepared) {
        super(session, sql);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        ArrayList<Parameter> parameters = this.prepared.getParameters();
        if (!parameters.isEmpty() && this.prepared.isWithParamValues()) {
            parameters = new ArrayList();
        }
        return parameters;
    }

    @Override
    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    @Override
    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    private void recompileIfRequired() {
        if (this.prepared.needRecompile()) {
            this.prepared.setModificationMetaId(0L);
            String sql = this.prepared.getSQL();
            ArrayList<Token> tokens = this.prepared.getSQLTokens();
            Parser parser = new Parser(this.session);
            parser.setSuppliedParameters(this.prepared.getParameters());
            this.prepared = parser.parse(sql, tokens);
            long mod = this.prepared.getModificationMetaId();
            this.prepared.setModificationMetaId(0L);
            this.prepared.prepare();
            this.prepared.setModificationMetaId(mod);
        }
    }

    @Override
    public ResultWithGeneratedKeys update(Object generatedKeysRequest) {
        this.recompileIfRequired();
        Database database = this.getDatabase();
        this.setProgress(database, 5);
        this.start();
        this.prepared.checkParameters();
        ResultWithGeneratedKeys result = generatedKeysRequest != null && !Boolean.FALSE.equals(generatedKeysRequest) ? (this.prepared instanceof DataChangeStatement && this.prepared.getType() != 58 ? this.executeUpdateWithGeneratedKeys((DataChangeStatement)this.prepared, generatedKeysRequest) : new ResultWithGeneratedKeys.WithKeys(this.prepared.update(), new LocalResult())) : ResultWithGeneratedKeys.of(this.prepared.update());
        this.prepared.trace(database, this.startTimeNanos, result.getUpdateCount());
        this.setProgress(database, 6);
        return result;
    }

    private ResultWithGeneratedKeys executeUpdateWithGeneratedKeys(DataChangeStatement statement, Object generatedKeysRequest) {
        ArrayList<Object> expressionColumns;
        block25: {
            int idx;
            Object e;
            Table table;
            Database db;
            block22: {
                db = this.getDatabase();
                table = statement.getTable();
                if (!Boolean.TRUE.equals(generatedKeysRequest)) break block22;
                expressionColumns = Utils.newSmallArrayList();
                Column[] columns = table.getColumns();
                Index primaryKey = table.findPrimaryKey();
                Column[] columnArray = columns;
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    block24: {
                        Column column;
                        block23: {
                            column = columnArray[n2];
                            if (column.isIdentity()) break block23;
                            Expression expression = column.getEffectiveDefaultExpression();
                            e = expression;
                            if ((expression == null || ((Expression)e).isConstant()) && (primaryKey == null || primaryKey.getColumnIndex(column) < 0)) break block24;
                        }
                        expressionColumns.add(new ExpressionColumn(db, column));
                    }
                    ++n2;
                }
                break block25;
            }
            if (generatedKeysRequest instanceof int[]) {
                int[] indexes = (int[])generatedKeysRequest;
                Column[] columns = table.getColumns();
                int cnt = columns.length;
                expressionColumns = new ArrayList(indexes.length);
                e = indexes;
                int n = indexes.length;
                int n3 = 0;
                while (n3 < n) {
                    idx = e[n3];
                    if (idx < 1 || idx > cnt) {
                        throw DbException.get(42122, "Index: " + idx);
                    }
                    expressionColumns.add(new ExpressionColumn(db, columns[idx - 1]));
                    ++n3;
                }
            } else if (generatedKeysRequest instanceof String[]) {
                String[] names = (String[])generatedKeysRequest;
                expressionColumns = new ArrayList(names.length);
                String[] stringArray = names;
                idx = names.length;
                int cnt = 0;
                while (cnt < idx) {
                    Column column;
                    block21: {
                        String name = stringArray[cnt];
                        column = table.findColumn(name);
                        if (column == null) {
                            DbSettings settings = db.getSettings();
                            if (settings.databaseToUpper) {
                                column = table.findColumn(StringUtils.toUpperEnglish(name));
                            } else if (settings.databaseToLower) {
                                column = table.findColumn(StringUtils.toLowerEnglish(name));
                            }
                            if (column == null) {
                                Column[] columnArray = table.getColumns();
                                int n = columnArray.length;
                                int n4 = 0;
                                while (n4 < n) {
                                    Column c = columnArray[n4];
                                    if (c.getName().equalsIgnoreCase(name)) {
                                        column = c;
                                        break block21;
                                    }
                                    ++n4;
                                }
                                throw DbException.get(42122, name);
                            }
                        }
                    }
                    expressionColumns.add(new ExpressionColumn(db, column));
                    ++cnt;
                }
            } else {
                throw DbException.getInternalError();
            }
        }
        int columnCount = expressionColumns.size();
        if (columnCount == 0) {
            return new ResultWithGeneratedKeys.WithKeys(statement.update(), new LocalResult());
        }
        int[] indexes = new int[columnCount];
        Expression[] expressions = expressionColumns.toArray(new ExpressionColumn[0]);
        int i = 0;
        while (i < columnCount) {
            indexes[i] = expressions[i].getColumn().getColumnId();
            ++i;
        }
        LocalResult result = new LocalResult(this.session, expressions, columnCount, columnCount);
        return new ResultWithGeneratedKeys.WithKeys(statement.update(new GeneratedKeysCollector(indexes, result), DataChangeDeltaTable.ResultOption.FINAL), result);
    }

    @Override
    public ResultInterface query(long maxrows) {
        this.recompileIfRequired();
        Database database = this.getDatabase();
        this.setProgress(database, 5);
        this.start();
        this.prepared.checkParameters();
        ResultInterface result = this.prepared.query(maxrows);
        this.prepared.trace(database, this.startTimeNanos, result.isLazy() ? 0L : result.getRowCount());
        this.setProgress(database, 6);
        return result;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.readOnlyKnown) {
            this.readOnly = this.prepared.isReadOnly();
            this.readOnlyKnown = true;
        }
        return this.readOnly;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.prepared.queryMeta();
    }

    @Override
    public boolean isCacheable() {
        return this.prepared.isCacheable();
    }

    @Override
    public int getCommandType() {
        return this.prepared.getType();
    }

    @Override
    public Set<DbObject> getDependencies() {
        HashSet<DbObject> dependencies = new HashSet<DbObject>();
        this.prepared.collectDependencies(dependencies);
        return dependencies;
    }

    @Override
    protected boolean isRetryable() {
        return this.prepared.isRetryable();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class GeneratedKeysCollector
    implements ResultTarget {
        private final int[] indexes;
        private final LocalResult result;

        GeneratedKeysCollector(int[] indexes, LocalResult result) {
            this.indexes = indexes;
            this.result = result;
        }

        @Override
        public void limitsWereApplied() {
        }

        @Override
        public long getRowCount() {
            return 0L;
        }

        @Override
        public void addRow(Value ... values) {
            int length = this.indexes.length;
            Value[] row = new Value[length];
            int i = 0;
            while (i < length) {
                row[i] = values[this.indexes[i]];
                ++i;
            }
            this.result.addRow(row);
        }
    }
}

