/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.command.CommandInterface;
import org.h2.engine.GeneratedKeysMode;
import org.h2.engine.SessionRemote;
import org.h2.engine.SysProperties;
import org.h2.expression.ParameterInterface;
import org.h2.expression.ParameterRemote;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.BatchResult;
import org.h2.result.MergedResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultRemote;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.util.Utils;
import org.h2.value.Transfer;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CommandRemote
implements CommandInterface {
    private final ArrayList<Transfer> transferList;
    private final ArrayList<ParameterInterface> parameters;
    private final Trace trace;
    private final String sql;
    private final int fetchSize;
    private SessionRemote session;
    private int id;
    private boolean isQuery;
    private int cmdType = 0;
    private boolean readonly;
    private final int created;

    public CommandRemote(SessionRemote session, ArrayList<Transfer> transferList, String sql, int fetchSize) {
        this.transferList = transferList;
        this.trace = session.getTrace();
        this.sql = sql;
        this.parameters = Utils.newSmallArrayList();
        this.prepare(session, true);
        this.session = session;
        this.fetchSize = fetchSize;
        this.created = session.getLastReconnect();
    }

    @Override
    public void stop(boolean commitIfAutoCommit) {
    }

    private void prepare(SessionRemote s, boolean createParams) {
        this.id = s.getNextId();
        int i = 0;
        int count = 0;
        while (i < this.transferList.size()) {
            try {
                Transfer transfer = this.transferList.get(i);
                if (createParams) {
                    s.traceOperation("SESSION_PREPARE_READ_PARAMS2", this.id);
                    transfer.writeInt(18).writeInt(this.id).writeString(this.sql);
                } else {
                    s.traceOperation("SESSION_PREPARE", this.id);
                    transfer.writeInt(0).writeInt(this.id).writeString(this.sql);
                }
                s.done(transfer);
                this.isQuery = transfer.readBoolean();
                this.readonly = transfer.readBoolean();
                this.cmdType = createParams ? transfer.readInt() : 0;
                int paramCount = transfer.readInt();
                if (createParams) {
                    this.parameters.clear();
                    int j = 0;
                    while (j < paramCount) {
                        ParameterRemote p = new ParameterRemote(j);
                        p.readMetaData(transfer);
                        this.parameters.add(p);
                        ++j;
                    }
                }
            }
            catch (IOException e) {
                s.removeServer(e, i--, ++count);
            }
            ++i;
        }
    }

    @Override
    public boolean isQuery() {
        return this.isQuery;
    }

    public ArrayList<ParameterInterface> getParameters() {
        return this.parameters;
    }

    private void prepareIfRequired() {
        if (this.session.getLastReconnect() != this.created) {
            this.id = Integer.MIN_VALUE;
        }
        this.session.checkClosed();
        if (this.id <= this.session.getCurrentId() - SysProperties.SERVER_CACHED_OBJECTS) {
            this.prepare(this.session, false);
        }
    }

    @Override
    public ResultInterface getMetaData() {
        SessionRemote session = this.session;
        session.lock();
        try {
            if (!this.isQuery) {
                return null;
            }
            int objectId = session.getNextId();
            ResultRemote result = null;
            int i = 0;
            int count = 0;
            while (i < this.transferList.size()) {
                this.prepareIfRequired();
                Transfer transfer = this.transferList.get(i);
                try {
                    session.traceOperation("COMMAND_GET_META_DATA", this.id);
                    transfer.writeInt(10).writeInt(this.id).writeInt(objectId);
                    session.done(transfer);
                    int columnCount = transfer.readInt();
                    result = new ResultRemote(session, transfer, objectId, columnCount, Integer.MAX_VALUE);
                    break;
                }
                catch (IOException e) {
                    session.removeServer(e, i--, ++count);
                    ++i;
                }
            }
            session.autoCommitIfCluster();
            ResultRemote resultRemote = result;
            return resultRemote;
        }
        finally {
            session.unlock();
        }
    }

    @Override
    public ResultInterface executeQuery(long maxRows, boolean scrollable) {
        this.checkParameters();
        SessionRemote session = this.session;
        session.lock();
        try {
            int objectId = session.getNextId();
            ResultRemote result = null;
            int i = 0;
            int count = 0;
            while (i < this.transferList.size()) {
                this.prepareIfRequired();
                Transfer transfer = this.transferList.get(i);
                try {
                    session.traceOperation("COMMAND_EXECUTE_QUERY", this.id);
                    transfer.writeInt(2).writeInt(this.id).writeInt(objectId);
                    transfer.writeRowCount(maxRows);
                    int fetch = session.isClustered() || scrollable ? Integer.MAX_VALUE : this.fetchSize;
                    transfer.writeInt(fetch);
                    this.sendParameters(transfer);
                    session.done(transfer);
                    int columnCount = transfer.readInt();
                    if (result != null) {
                        result.close();
                        result = null;
                    }
                    result = new ResultRemote(session, transfer, objectId, columnCount, fetch);
                    if (this.readonly) {
                        break;
                    }
                }
                catch (IOException e) {
                    session.removeServer(e, i--, ++count);
                }
                ++i;
            }
            session.autoCommitIfCluster();
            session.readSessionState();
            ResultRemote resultRemote = result;
            return resultRemote;
        }
        finally {
            session.unlock();
        }
    }

    @Override
    public ResultWithGeneratedKeys executeUpdate(Object generatedKeysRequest) {
        this.checkParameters();
        int generatedKeysMode = GeneratedKeysMode.valueOf(generatedKeysRequest);
        boolean readGeneratedKeys = generatedKeysMode != 0;
        int objectId = readGeneratedKeys ? this.session.getNextId() : 0;
        SessionRemote session = this.session;
        session.lock();
        try {
            long updateCount = 0L;
            ResultRemote generatedKeys = null;
            boolean autoCommit = false;
            int i = 0;
            int count = 0;
            while (i < this.transferList.size()) {
                this.prepareIfRequired();
                Transfer transfer = this.transferList.get(i);
                try {
                    session.traceOperation("COMMAND_EXECUTE_UPDATE", this.id);
                    transfer.writeInt(3).writeInt(this.id);
                    this.sendParameters(transfer);
                    CommandRemote.sendGeneratedKeysRequest(generatedKeysRequest, generatedKeysMode, transfer);
                    session.done(transfer);
                    updateCount = transfer.readRowCount();
                    autoCommit = transfer.readBoolean();
                    if (readGeneratedKeys) {
                        int columnCount = transfer.readInt();
                        if (generatedKeys != null) {
                            generatedKeys.close();
                            generatedKeys = null;
                        }
                        generatedKeys = new ResultRemote(session, transfer, objectId, columnCount, Integer.MAX_VALUE);
                    }
                }
                catch (IOException e) {
                    session.removeServer(e, i--, ++count);
                }
                ++i;
            }
            session.setAutoCommitFromServer(autoCommit);
            session.autoCommitIfCluster();
            session.readSessionState();
            if (generatedKeys != null) {
                ResultWithGeneratedKeys.WithKeys withKeys = new ResultWithGeneratedKeys.WithKeys(updateCount, generatedKeys);
                return withKeys;
            }
            ResultWithGeneratedKeys resultWithGeneratedKeys = ResultWithGeneratedKeys.of(updateCount);
            return resultWithGeneratedKeys;
        }
        finally {
            session.unlock();
        }
    }

    @Override
    public BatchResult executeBatchUpdate(ArrayList<Value[]> batchParameters, Object generatedKeysRequest) {
        int generatedKeysMode = GeneratedKeysMode.valueOf(generatedKeysRequest);
        boolean readGeneratedKeys = generatedKeysMode != 0;
        int size = batchParameters.size();
        int objectId = readGeneratedKeys ? this.session.getNextId() : 0;
        SessionRemote session = this.session;
        session.lock();
        try {
            long[] updateCounts = new long[size];
            MergedResult generatedKeys = null;
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            boolean autoCommit = false;
            int i = 0;
            int count = 0;
            while (i < this.transferList.size()) {
                block15: {
                    this.prepareIfRequired();
                    Transfer transfer = this.transferList.get(i);
                    MergedResult oldGeneratedKeys = generatedKeys;
                    generatedKeys = readGeneratedKeys ? new MergedResult() : null;
                    ArrayList<SQLException> oldExceptions = exceptions;
                    exceptions = new ArrayList();
                    try {
                        int len;
                        if (transfer.getVersion() >= 21) {
                            session.traceOperation("COMMAND_EXECUTE_BATCH_UPDATE", this.id);
                            transfer.writeInt(20).writeInt(this.id);
                            transfer.writeInt(size);
                            for (Value[] parameters : batchParameters) {
                                len = parameters.length;
                                transfer.writeInt(len);
                                this.sendParameters(transfer, parameters);
                            }
                            CommandRemote.sendGeneratedKeysRequest(generatedKeysRequest, generatedKeysMode, transfer);
                            session.done(transfer);
                            int j = 0;
                            while (j < size) {
                                updateCounts[j] = transfer.readRowCount();
                                ++j;
                            }
                            if (readGeneratedKeys) {
                                int columnCount = transfer.readInt();
                                ResultRemote remoteGeneratedKeys = new ResultRemote(session, transfer, objectId, columnCount, Integer.MAX_VALUE);
                                generatedKeys.add(remoteGeneratedKeys);
                                remoteGeneratedKeys.close();
                            }
                            int exceptionCount = transfer.readInt();
                            int k = 0;
                            while (k < exceptionCount) {
                                exceptions.add(SessionRemote.readSQLException(transfer));
                                ++k;
                            }
                            autoCommit = transfer.readBoolean();
                            break block15;
                        }
                        int j = 0;
                        while (j < size) {
                            session.traceOperation("COMMAND_EXECUTE_UPDATE", this.id);
                            transfer.writeInt(3).writeInt(this.id);
                            Value[] parameters = batchParameters.get(j);
                            len = parameters.length;
                            transfer.writeInt(len);
                            this.sendParameters(transfer, parameters);
                            CommandRemote.sendGeneratedKeysRequest(generatedKeysRequest, generatedKeysMode, transfer);
                            try {
                                session.done(transfer);
                                updateCounts[j] = transfer.readRowCount();
                                autoCommit = transfer.readBoolean();
                                if (readGeneratedKeys) {
                                    int columnCount = transfer.readInt();
                                    ResultRemote remoteGeneratedKeys = new ResultRemote(session, transfer, objectId, columnCount, Integer.MAX_VALUE);
                                    generatedKeys.add(remoteGeneratedKeys);
                                    remoteGeneratedKeys.close();
                                }
                            }
                            catch (DbException e) {
                                updateCounts[j] = -3L;
                                exceptions.add(DbException.toSQLException(e));
                            }
                            ++j;
                        }
                    }
                    catch (IOException e) {
                        session.removeServer(e, i--, ++count);
                        generatedKeys = oldGeneratedKeys;
                        exceptions = oldExceptions;
                    }
                }
                ++i;
            }
            session.setAutoCommitFromServer(autoCommit);
            session.autoCommitIfCluster();
            session.readSessionState();
            BatchResult batchResult = new BatchResult(updateCounts, generatedKeys != null ? generatedKeys.getResult() : null, exceptions);
            return batchResult;
        }
        finally {
            session.unlock();
        }
    }

    private void checkParameters() {
        if (this.cmdType != 60) {
            for (ParameterInterface p : this.parameters) {
                p.checkSet();
            }
        }
    }

    private void sendParameters(Transfer transfer) throws IOException {
        int len = this.parameters.size();
        transfer.writeInt(len);
        for (ParameterInterface p : this.parameters) {
            Value pVal = p.getParamValue();
            if (pVal == null && this.cmdType == 60) {
                pVal = ValueNull.INSTANCE;
            }
            transfer.writeValue(pVal);
        }
    }

    private void sendParameters(Transfer transfer, Value[] parameters) throws IOException {
        Value[] valueArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Value pVal = valueArray[n2];
            if (pVal == null && this.cmdType == 60) {
                pVal = ValueNull.INSTANCE;
            }
            transfer.writeValue(pVal);
            ++n2;
        }
    }

    private static void sendGeneratedKeysRequest(Object generatedKeysRequest, int generatedKeysMode, Transfer transfer) throws IOException {
        transfer.writeInt(generatedKeysMode);
        switch (generatedKeysMode) {
            case 2: {
                int[] keys = (int[])generatedKeysRequest;
                transfer.writeInt(keys.length);
                int[] nArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    int key = nArray[n2];
                    transfer.writeInt(key);
                    ++n2;
                }
                break;
            }
            case 3: {
                String[] keys = (String[])generatedKeysRequest;
                transfer.writeInt(keys.length);
                String[] stringArray = keys;
                int n = keys.length;
                int n3 = 0;
                while (n3 < n) {
                    String key = stringArray[n3];
                    transfer.writeString(key);
                    ++n3;
                }
                break;
            }
        }
    }

    @Override
    public void close() {
        SessionRemote session = this.session;
        if (session == null || session.isClosed()) {
            return;
        }
        session.lock();
        try {
            session.traceOperation("COMMAND_CLOSE", this.id);
            for (Transfer transfer : this.transferList) {
                try {
                    transfer.writeInt(4).writeInt(this.id);
                }
                catch (IOException e) {
                    this.trace.error(e, "close");
                }
            }
        }
        finally {
            session.unlock();
        }
        this.session = null;
        try {
            for (ParameterInterface p : this.parameters) {
                Value v = p.getParamValue();
                if (!(v instanceof ValueLob)) continue;
                ((ValueLob)v).remove();
            }
        }
        catch (DbException e) {
            this.trace.error(e, "close");
        }
        this.parameters.clear();
    }

    @Override
    public void cancel() {
        this.session.cancelStatement(this.id);
    }

    public String toString() {
        return this.sql + Trace.formatParams(this.getParameters());
    }

    @Override
    public int getCommandType() {
        return this.cmdType;
    }
}

