/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.StringJoiner;
import org.h2.command.Token;
import org.h2.command.Tokenizer;
import org.h2.engine.Database;
import org.h2.engine.DbSettings;
import org.h2.engine.SessionLocal;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ParserBase {
    final Database database;
    final SessionLocal session;
    private final boolean identifiersToLower;
    private final boolean identifiersToUpper;
    final boolean variableBinary;
    final BitSet nonKeywords;
    ArrayList<Token> tokens;
    int tokenIndex;
    Token token;
    int currentTokenType;
    String currentToken;
    String sqlCommand;
    ArrayList<Parameter> parameters;
    BitSet usedParameters = new BitSet();
    private boolean literalsChecked;
    ArrayList<String> expectedList;

    public static String quoteIdentifier(String s, int sqlFlags) {
        if (s == null) {
            return "\"\"";
        }
        if ((sqlFlags & 1) != 0 && ParserUtil.isSimpleIdentifier(s, false, false)) {
            return s;
        }
        return StringUtils.quoteIdentifier(s);
    }

    public static BitSet parseNonKeywords(String[] nonKeywords) {
        if (nonKeywords.length == 0) {
            return null;
        }
        BitSet set = new BitSet();
        String[] stringArray = nonKeywords;
        int n = nonKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            String nonKeyword = stringArray[n2];
            int index = Arrays.binarySearch(Token.TOKENS, 3, 92, nonKeyword);
            if (index >= 0) {
                set.set(index);
            }
            ++n2;
        }
        return set.isEmpty() ? null : set;
    }

    public static String formatNonKeywords(BitSet nonKeywords) {
        if (nonKeywords == null || nonKeywords.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = -1;
        while ((i = nonKeywords.nextSetBit(i + 1)) >= 0) {
            if (i < 3 || i > 91) continue;
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(Token.TOKENS[i]);
        }
        return builder.toString();
    }

    static boolean isKeyword(int tokenType) {
        return tokenType >= 3 && tokenType <= 91;
    }

    ParserBase(SessionLocal session) {
        this.database = session.getDatabase();
        DbSettings settings = this.database.getSettings();
        this.identifiersToLower = settings.databaseToLower;
        this.identifiersToUpper = settings.databaseToUpper;
        this.variableBinary = session.isVariableBinary();
        this.nonKeywords = session.getNonKeywords();
        this.session = session;
    }

    public ParserBase() {
        this.database = null;
        this.identifiersToLower = false;
        this.identifiersToUpper = false;
        this.variableBinary = false;
        this.nonKeywords = null;
        this.session = null;
    }

    public final void setLiteralsChecked(boolean literalsChecked) {
        this.literalsChecked = literalsChecked;
    }

    public final void setSuppliedParameters(ArrayList<Parameter> suppliedParameters) {
        int max = Parameter.getMaxIndex(suppliedParameters);
        if (max > suppliedParameters.size()) {
            ArrayList<Parameter> parameters = new ArrayList<Parameter>(max);
            int i = 0;
            while (i < max) {
                parameters.add(null);
                ++i;
            }
            for (Parameter p : suppliedParameters) {
                parameters.set(p.getIndex(), p);
            }
            this.parameters = parameters;
        } else {
            this.parameters = suppliedParameters;
        }
    }

    public Object parseColumnList(String sql, int offset) {
        this.initialize(sql, null, true);
        int i = 0;
        int l = this.tokens.size();
        while (i < l) {
            if (this.tokens.get(i).start() >= offset) {
                this.setTokenIndex(i);
                break;
            }
            ++i;
        }
        this.read(105);
        if (this.readIf(106)) {
            return Utils.EMPTY_INT_ARRAY;
        }
        if (this.isIdentifier()) {
            ArrayList<String> list = Utils.newSmallArrayList();
            do {
                if (!this.isIdentifier()) {
                    throw this.getSyntaxError();
                }
                list.add(this.currentToken);
                this.read();
            } while (this.readIfMore());
            return list.toArray(new String[0]);
        }
        if (this.currentTokenType == 94) {
            ArrayList list = Utils.newSmallArrayList();
            do {
                list.add(this.readInt());
            } while (this.readIfMore());
            int count = list.size();
            int[] array = new int[count];
            int i2 = 0;
            while (i2 < count) {
                array[i2] = (Integer)list.get(i2);
                ++i2;
            }
            return array;
        }
        throw this.getSyntaxError();
    }

    final void initialize(String sql, ArrayList<Token> tokens, boolean stopOnCloseParen) {
        if (sql == null) {
            sql = "";
        }
        this.sqlCommand = sql;
        if (tokens == null) {
            BitSet usedParameters = new BitSet();
            this.tokens = new Tokenizer(this.database, this.identifiersToUpper, this.identifiersToLower, this.nonKeywords).tokenize(sql, stopOnCloseParen, usedParameters);
            if (this.parameters == null) {
                int l = usedParameters.length();
                if (l > 100000) {
                    throw DbException.getInvalidValueException("parameter index", l);
                }
                if (l > 0) {
                    this.parameters = new ArrayList(l);
                    int i = 0;
                    while (i < l) {
                        this.parameters.add(new Parameter(i));
                        ++i;
                    }
                } else {
                    this.parameters = new ArrayList();
                }
            }
        } else {
            this.tokens = tokens;
        }
        this.resetTokenIndex();
    }

    final void resetTokenIndex() {
        this.tokenIndex = -1;
        this.token = null;
        this.currentTokenType = -1;
        this.currentToken = null;
    }

    final void setTokenIndex(int index) {
        if (index != this.tokenIndex) {
            if (this.expectedList != null) {
                this.expectedList.clear();
            }
            this.token = this.tokens.get(index);
            this.tokenIndex = index;
            this.currentTokenType = this.token.tokenType();
            this.currentToken = this.token.asIdentifier();
        }
    }

    final BitSet openParametersScope() {
        BitSet outerUsedParameters = this.usedParameters;
        this.usedParameters = new BitSet();
        return outerUsedParameters;
    }

    final ArrayList<Parameter> closeParametersScope(BitSet outerUsedParameters) {
        BitSet innerUsedParameters = this.usedParameters;
        int size = innerUsedParameters.cardinality();
        ArrayList<Parameter> params = new ArrayList<Parameter>(size);
        if (size > 0) {
            int i = -1;
            while ((i = innerUsedParameters.nextSetBit(i + 1)) >= 0) {
                params.add(this.parameters.get(i));
            }
        }
        outerUsedParameters.or(innerUsedParameters);
        this.usedParameters = outerUsedParameters;
        return params;
    }

    final void read(String expected) {
        if (!this.testToken(expected, this.token)) {
            this.addExpected(expected);
            throw this.getSyntaxError();
        }
        this.read();
    }

    final void read(int tokenType) {
        if (tokenType != this.currentTokenType) {
            this.addExpected(tokenType);
            throw this.getSyntaxError();
        }
        this.read();
    }

    final void readCompat(int tokenType) {
        if (tokenType != this.currentTokenType) {
            throw this.getSyntaxError();
        }
        this.read();
    }

    final boolean readIf(String tokenName) {
        if (this.testToken(tokenName, this.token)) {
            this.read();
            return true;
        }
        this.addExpected(tokenName);
        return false;
    }

    final boolean readIfCompat(String tokenName) {
        if (this.testToken(tokenName, this.token)) {
            this.read();
            return true;
        }
        return false;
    }

    final boolean readIf(String tokenName1, String tokenName2) {
        int i = this.tokenIndex + 1;
        if (i + 1 < this.tokens.size() && this.testToken(tokenName1, this.token) && this.testToken(tokenName2, this.tokens.get(i))) {
            this.setTokenIndex(i + 1);
            return true;
        }
        this.addExpected(tokenName1, tokenName2);
        return false;
    }

    final boolean readIf(String tokenName1, int tokenType2) {
        int i = this.tokenIndex + 1;
        if (i + 1 < this.tokens.size() && this.tokens.get(i).tokenType() == tokenType2 && this.testToken(tokenName1, this.token)) {
            this.setTokenIndex(i + 1);
            return true;
        }
        this.addExpected(tokenName1, Token.TOKENS[tokenType2]);
        return false;
    }

    final boolean readIf(int tokenType) {
        if (tokenType == this.currentTokenType) {
            this.read();
            return true;
        }
        this.addExpected(tokenType);
        return false;
    }

    final boolean readIfCompat(int tokenType) {
        if (tokenType == this.currentTokenType) {
            this.read();
            return true;
        }
        return false;
    }

    final boolean readIf(int tokenType1, int tokenType2) {
        int i;
        if (tokenType1 == this.currentTokenType && this.tokens.get(i = this.tokenIndex + 1).tokenType() == tokenType2) {
            this.setTokenIndex(i + 1);
            return true;
        }
        this.addExpected(tokenType1, tokenType2);
        return false;
    }

    final boolean readIfCompat(int tokenType1, int tokenType2) {
        int i;
        if (tokenType1 == this.currentTokenType && this.tokens.get(i = this.tokenIndex + 1).tokenType() == tokenType2) {
            this.setTokenIndex(i + 1);
            return true;
        }
        return false;
    }

    final boolean readIf(int tokenType1, String tokenName2) {
        int i;
        if (tokenType1 == this.currentTokenType && this.testToken(tokenName2, this.tokens.get(i = this.tokenIndex + 1))) {
            this.setTokenIndex(i + 1);
            return true;
        }
        this.addExpected(Token.TOKENS[tokenType1], tokenName2);
        return false;
    }

    final boolean readIfCompat(int tokenType1, String tokenName2) {
        int i;
        if (tokenType1 == this.currentTokenType && this.testToken(tokenName2, this.tokens.get(i = this.tokenIndex + 1))) {
            this.setTokenIndex(i + 1);
            return true;
        }
        return false;
    }

    final boolean readIf(Object ... tokensTypesOrNames) {
        block3: {
            int i = this.tokenIndex;
            int count = tokensTypesOrNames.length;
            int size = this.tokens.size();
            if (i + count < size) {
                Object[] objectArray = tokensTypesOrNames;
                int n = tokensTypesOrNames.length;
                int n2 = 0;
                while (n2 < n) {
                    Object tokenTypeOrName = objectArray[n2];
                    if (this.testToken(tokenTypeOrName, this.tokens.get(i++))) {
                        ++n2;
                        continue;
                    }
                    break block3;
                }
                this.setTokenIndex(i);
                return true;
            }
        }
        this.addExpected(tokensTypesOrNames);
        return false;
    }

    final boolean readIfCompat(Object ... tokensTypesOrNames) {
        block3: {
            int i = this.tokenIndex;
            int count = tokensTypesOrNames.length;
            int size = this.tokens.size();
            if (i + count < size) {
                Object[] objectArray = tokensTypesOrNames;
                int n = tokensTypesOrNames.length;
                int n2 = 0;
                while (n2 < n) {
                    Object tokenTypeOrName = objectArray[n2];
                    if (this.testToken(tokenTypeOrName, this.tokens.get(i++))) {
                        ++n2;
                        continue;
                    }
                    break block3;
                }
                this.setTokenIndex(i);
                return true;
            }
        }
        return false;
    }

    final boolean isToken(String tokenName) {
        if (this.testToken(tokenName, this.token)) {
            return true;
        }
        this.addExpected(tokenName);
        return false;
    }

    final boolean isTokenCompat(String tokenName) {
        return this.testToken(tokenName, this.token);
    }

    private boolean testToken(Object expected, Token token) {
        return expected instanceof Integer ? ((Integer)expected).intValue() == token.tokenType() : this.testToken((String)expected, token);
    }

    private boolean testToken(String tokenName, Token token) {
        if (!token.isQuoted()) {
            String s = token.asIdentifier();
            return this.identifiersToUpper ? tokenName.equals(s) : tokenName.equalsIgnoreCase(s);
        }
        return false;
    }

    final boolean isToken(int tokenType) {
        if (tokenType == this.currentTokenType) {
            return true;
        }
        this.addExpected(tokenType);
        return false;
    }

    final boolean equalsToken(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b) || !this.identifiersToUpper && a.equalsIgnoreCase(b);
    }

    final boolean isIdentifier() {
        return this.currentTokenType == 2 || this.nonKeywords != null && this.nonKeywords.get(this.currentTokenType);
    }

    final void addExpected(String token) {
        if (this.expectedList != null) {
            this.expectedList.add(token);
        }
    }

    final void addExpected(int tokenType) {
        if (this.expectedList != null) {
            this.expectedList.add(Token.TOKENS[tokenType]);
        }
    }

    private void addExpected(int tokenType1, int tokenType2) {
        if (this.expectedList != null) {
            this.expectedList.add(Token.TOKENS[tokenType1] + " " + Token.TOKENS[tokenType2]);
        }
    }

    private void addExpected(String tokenType1, String tokenType2) {
        if (this.expectedList != null) {
            this.expectedList.add(tokenType1 + " " + tokenType2);
        }
    }

    private void addExpected(Object ... tokens) {
        if (this.expectedList != null) {
            StringJoiner j = new StringJoiner(" ");
            Object[] objectArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                Object token = objectArray[n2];
                j.add(token instanceof Integer ? Token.TOKENS[(Integer)token] : (String)token);
                ++n2;
            }
            this.expectedList.add(j.toString());
        }
    }

    final void addMultipleExpected(int ... tokenTypes) {
        int[] nArray = tokenTypes;
        int n = tokenTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int tokenType = nArray[n2];
            this.expectedList.add(Token.TOKENS[tokenType]);
            ++n2;
        }
    }

    final void read() {
        int size;
        if (this.expectedList != null) {
            this.expectedList.clear();
        }
        if (this.tokenIndex + 1 < (size = this.tokens.size())) {
            this.token = this.tokens.get(++this.tokenIndex);
            this.currentTokenType = this.token.tokenType();
            this.currentToken = this.token.asIdentifier();
            if (this.currentToken != null && this.currentToken.length() > 256) {
                throw DbException.get(42622, this.currentToken.substring(0, 32), "256");
            }
            if (this.currentTokenType == 94) {
                this.checkLiterals();
            }
        } else {
            throw this.getSyntaxError();
        }
    }

    private void checkLiterals() {
        int allowed;
        if (!this.literalsChecked && this.session != null && !this.session.getAllowLiterals() && ((allowed = this.database.getAllowLiterals()) == 0 || (this.token instanceof Token.CharacterStringToken || this.token instanceof Token.BinaryStringToken) && allowed != 2)) {
            throw DbException.get(90116);
        }
    }

    final boolean readIfMore() {
        if (this.readIf(109)) {
            return true;
        }
        this.read(106);
        return false;
    }

    final int readNonNegativeInt() {
        int v = this.readInt();
        if (v < 0) {
            throw DbException.getInvalidValueException("non-negative integer", v);
        }
        return v;
    }

    final int readInt() {
        boolean minus = false;
        if (this.currentTokenType == 102) {
            minus = true;
            this.read();
        } else if (this.currentTokenType == 103) {
            this.read();
        }
        if (this.currentTokenType != 94) {
            throw DbException.getSyntaxError(this.sqlCommand, this.token.start(), "integer");
        }
        Value value = this.token.value(this.session);
        if (minus) {
            value = value.negate();
        }
        int i = value.getInt();
        this.read();
        return i;
    }

    final long readPositiveLong() {
        long v = this.readLong();
        if (v <= 0L) {
            throw DbException.getInvalidValueException("positive long", v);
        }
        return v;
    }

    final long readLong() {
        boolean minus = false;
        if (this.currentTokenType == 102) {
            minus = true;
            this.read();
        } else if (this.currentTokenType == 103) {
            this.read();
        }
        if (this.currentTokenType != 94) {
            throw DbException.getSyntaxError(this.sqlCommand, this.token.start(), "long");
        }
        Value value = this.token.value(this.session);
        if (minus) {
            value = value.negate();
        }
        long i = value.getLong();
        this.read();
        return i;
    }

    final boolean readBooleanSetting() {
        switch (this.currentTokenType) {
            case 60: 
            case 77: {
                this.read();
                return true;
            }
            case 31: {
                this.read();
                return false;
            }
            case 94: {
                boolean result = this.token.value(this.session).getBoolean();
                this.read();
                return result;
            }
        }
        if (this.readIf("OFF")) {
            return false;
        }
        if (this.expectedList != null) {
            this.addMultipleExpected(60, 77, 31);
        }
        throw this.getSyntaxError();
    }

    final Parameter readParameter() {
        int index = ((Token.ParameterToken)this.token).index() - 1;
        this.read();
        this.usedParameters.set(index);
        return this.parameters.get(index);
    }

    final boolean isKeyword(String s) {
        return ParserUtil.isKeyword(s, !this.identifiersToUpper);
    }

    final String upperName(String name) {
        return this.identifiersToUpper ? name : StringUtils.toUpperEnglish(name);
    }

    public final int getLastParseIndex() {
        return this.token.start();
    }

    final ArrayList<Token> getRemainingTokens(int offset) {
        List<Token> subList = this.tokens.subList(this.tokenIndex, this.tokens.size());
        ArrayList<Token> remainingTokens = new ArrayList<Token>(subList);
        subList.clear();
        this.tokens.add(new Token.EndOfInputToken(offset));
        for (Token token : remainingTokens) {
            token.subtractFromStart(offset);
        }
        return remainingTokens;
    }

    final DbException getSyntaxError() {
        if (this.expectedList == null || this.expectedList.isEmpty()) {
            return DbException.getSyntaxError(this.sqlCommand, this.token.start());
        }
        return DbException.getSyntaxError(this.sqlCommand, this.token.start(), String.join((CharSequence)", ", this.expectedList));
    }

    public final String toString() {
        return StringUtils.addAsterisk(this.sqlCommand, this.token.start());
    }
}

