/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.ListIterator;
import org.h2.command.Token;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.value.ValueBigint;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueNumeric;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Tokenizer {
    private final CastDataProvider provider;
    private final boolean identifiersToUpper;
    private final boolean identifiersToLower;
    private final BitSet nonKeywords;

    Tokenizer(CastDataProvider provider, boolean identifiersToUpper, boolean identifiersToLower, BitSet nonKeywords) {
        this.provider = provider;
        this.identifiersToUpper = identifiersToUpper;
        this.identifiersToLower = identifiersToLower;
        this.nonKeywords = nonKeywords;
    }

    /*
     * Exception decompiling
     */
    ArrayList<Token> tokenize(String sql, boolean stopOnCloseParen, BitSet parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CASE]], but top level block is 59[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int readIdentifier(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        tokens.add(new Token.IdentifierToken(tokenStart, this.extractIdentifier(sql, tokenStart, endIndex), false, false));
        return endIndex;
    }

    private int readA(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = length == 2 ? ((sql.charAt(tokenStart + 1) & 0xFFDF) == 83 ? 7 : 2) : (Tokenizer.eq("ALL", sql, tokenStart, length) ? 3 : (Tokenizer.eq("AND", sql, tokenStart, length) ? 4 : (Tokenizer.eq("ANY", sql, tokenStart, length) ? 5 : (Tokenizer.eq("ARRAY", sql, tokenStart, length) ? 6 : (Tokenizer.eq("ASYMMETRIC", sql, tokenStart, length) ? 8 : (Tokenizer.eq("AUTHORIZATION", sql, tokenStart, length) ? 9 : 2))))));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readB(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("BETWEEN", sql, tokenStart, length) ? 10 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readC(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("CASE", sql, tokenStart, length) ? 11 : (Tokenizer.eq("CAST", sql, tokenStart, length) ? 12 : (Tokenizer.eq("CHECK", sql, tokenStart, length) ? 13 : (Tokenizer.eq("CONSTRAINT", sql, tokenStart, length) ? 14 : (Tokenizer.eq("CROSS", sql, tokenStart, length) ? 15 : (length >= 12 && Tokenizer.eq("CURRENT_", sql, tokenStart, 8) ? Tokenizer.getTokenTypeCurrent(sql, tokenStart, length) : 2)))));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private static int getTokenTypeCurrent(String s, int tokenStart, int length) {
        tokenStart += 8;
        switch (length) {
            case 12: {
                if (Tokenizer.eqCurrent("CURRENT_DATE", s, tokenStart, length)) {
                    return 17;
                }
                if (Tokenizer.eqCurrent("CURRENT_PATH", s, tokenStart, length)) {
                    return 18;
                }
                if (Tokenizer.eqCurrent("CURRENT_ROLE", s, tokenStart, length)) {
                    return 19;
                }
                if (Tokenizer.eqCurrent("CURRENT_TIME", s, tokenStart, length)) {
                    return 21;
                }
                if (!Tokenizer.eqCurrent("CURRENT_USER", s, tokenStart, length)) break;
                return 23;
            }
            case 14: {
                if (!Tokenizer.eqCurrent("CURRENT_SCHEMA", s, tokenStart, length)) break;
                return 20;
            }
            case 15: {
                if (!Tokenizer.eqCurrent("CURRENT_CATALOG", s, tokenStart, length)) break;
                return 16;
            }
            case 17: {
                if (!Tokenizer.eqCurrent("CURRENT_TIMESTAMP", s, tokenStart, length)) break;
                return 22;
            }
        }
        return 2;
    }

    private static boolean eqCurrent(String expected, String s, int start, int length) {
        int i = 8;
        while (i < length) {
            if (expected.charAt(i) != (s.charAt(start++) & 0xFFDF)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int readD(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("DAY", sql, tokenStart, length) ? 24 : (Tokenizer.eq("DEFAULT", sql, tokenStart, length) ? 25 : (Tokenizer.eq("DISTINCT", sql, tokenStart, length) ? 26 : 2));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readE(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("ELSE", sql, tokenStart, length) ? 27 : (Tokenizer.eq("END", sql, tokenStart, length) ? 28 : (Tokenizer.eq("EXCEPT", sql, tokenStart, length) ? 29 : (Tokenizer.eq("EXISTS", sql, tokenStart, length) ? 30 : 2)));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readF(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("FETCH", sql, tokenStart, length) ? 32 : (Tokenizer.eq("FROM", sql, tokenStart, length) ? 35 : (Tokenizer.eq("FOR", sql, tokenStart, length) ? 33 : (Tokenizer.eq("FOREIGN", sql, tokenStart, length) ? 34 : (Tokenizer.eq("FULL", sql, tokenStart, length) ? 36 : (Tokenizer.eq("FALSE", sql, tokenStart, length) ? 31 : 2)))));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readG(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("GROUP", sql, tokenStart, length) ? 37 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readH(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("HAVING", sql, tokenStart, length) ? 38 : (Tokenizer.eq("HOUR", sql, tokenStart, length) ? 39 : 2);
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readI(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int type;
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        if (length == 2) {
            switch (sql.charAt(tokenStart + 1) & 0xFFDF) {
                case 70: {
                    type = 40;
                    break;
                }
                case 78: {
                    type = 41;
                    break;
                }
                case 83: {
                    type = 45;
                    break;
                }
                default: {
                    type = 2;
                    break;
                }
            }
        } else {
            type = Tokenizer.eq("INNER", sql, tokenStart, length) ? 42 : (Tokenizer.eq("INTERSECT", sql, tokenStart, length) ? 43 : (Tokenizer.eq("INTERVAL", sql, tokenStart, length) ? 44 : 2));
        }
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readJ(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("JOIN", sql, tokenStart, length) ? 46 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readK(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("KEY", sql, tokenStart, length) ? 47 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readL(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("LEFT", sql, tokenStart, length) ? 48 : (Tokenizer.eq("LIMIT", sql, tokenStart, length) ? (this.provider.getMode().limit ? 50 : 2) : (Tokenizer.eq("LIKE", sql, tokenStart, length) ? 49 : (Tokenizer.eq("LOCALTIME", sql, tokenStart, length) ? 51 : (Tokenizer.eq("LOCALTIMESTAMP", sql, tokenStart, length) ? 52 : 2))));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readM(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("MINUS", sql, tokenStart, length) ? (this.provider.getMode().minusIsExcept ? 53 : 2) : (Tokenizer.eq("MINUTE", sql, tokenStart, length) ? 54 : (Tokenizer.eq("MONTH", sql, tokenStart, length) ? 55 : 2));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readN(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("NOT", sql, tokenStart, length) ? 57 : (Tokenizer.eq("NATURAL", sql, tokenStart, length) ? 56 : (Tokenizer.eq("NULL", sql, tokenStart, length) ? 58 : 2));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readO(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int type;
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        if (length == 2) {
            switch (sql.charAt(tokenStart + 1) & 0xFFDF) {
                case 78: {
                    type = 60;
                    break;
                }
                case 82: {
                    type = 61;
                    break;
                }
                default: {
                    type = 2;
                    break;
                }
            }
        } else {
            type = Tokenizer.eq("OFFSET", sql, tokenStart, length) ? 59 : (Tokenizer.eq("ORDER", sql, tokenStart, length) ? 62 : 2);
        }
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readP(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("PRIMARY", sql, tokenStart, length) ? 63 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readQ(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("QUALIFY", sql, tokenStart, length) ? 64 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readR(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("RIGHT", sql, tokenStart, length) ? 65 : (Tokenizer.eq("ROW", sql, tokenStart, length) ? 66 : (Tokenizer.eq("ROWNUM", sql, tokenStart, length) ? 67 : 2));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readS(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("SECOND", sql, tokenStart, length) ? 68 : (Tokenizer.eq("SELECT", sql, tokenStart, length) ? 69 : (Tokenizer.eq("SESSION_USER", sql, tokenStart, length) ? 70 : (Tokenizer.eq("SET", sql, tokenStart, length) ? 71 : (Tokenizer.eq("SOME", sql, tokenStart, length) ? 72 : (Tokenizer.eq("SYMMETRIC", sql, tokenStart, length) ? 73 : (Tokenizer.eq("SYSTEM_USER", sql, tokenStart, length) ? 74 : 2))))));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readT(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = length == 2 ? ((sql.charAt(tokenStart + 1) & 0xFFDF) == 79 ? 76 : 2) : (Tokenizer.eq("TABLE", sql, tokenStart, length) ? 75 : (Tokenizer.eq("TRUE", sql, tokenStart, length) ? 77 : 2));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readU(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("UESCAPE", sql, tokenStart, length) ? 78 : (Tokenizer.eq("UNION", sql, tokenStart, length) ? 79 : (Tokenizer.eq("UNIQUE", sql, tokenStart, length) ? 80 : (Tokenizer.eq("UNKNOWN", sql, tokenStart, length) ? 81 : (Tokenizer.eq("USER", sql, tokenStart, length) ? 82 : (Tokenizer.eq("USING", sql, tokenStart, length) ? 83 : 2)))));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readV(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("VALUE", sql, tokenStart, length) ? 84 : (Tokenizer.eq("VALUES", sql, tokenStart, length) ? 85 : 2);
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readW(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("WHEN", sql, tokenStart, length) ? 86 : (Tokenizer.eq("WHERE", sql, tokenStart, length) ? 87 : (Tokenizer.eq("WINDOW", sql, tokenStart, length) ? 88 : (Tokenizer.eq("WITH", sql, tokenStart, length) ? 89 : 2)));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readY(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("YEAR", sql, tokenStart, length) ? 90 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int read_(String sql, int end, int tokenStart, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, tokenStart);
        int type = endIndex - tokenStart == 7 && "_ROWID_".regionMatches(true, 1, sql, tokenStart + 1, 6) ? 91 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readIdentifierOrKeyword(String sql, int tokenStart, ArrayList<Token> tokens, int endIndex, int type) {
        Token token = type == 2 ? new Token.IdentifierToken(tokenStart, this.extractIdentifier(sql, tokenStart, endIndex), false, false) : (this.nonKeywords != null && this.nonKeywords.get(type) ? new Token.KeywordOrIdentifierToken(tokenStart, type, this.extractIdentifier(sql, tokenStart, endIndex)) : new Token.KeywordToken(tokenStart, type));
        tokens.add(token);
        return endIndex;
    }

    private static boolean eq(String expected, String s, int start, int length) {
        if (length != expected.length()) {
            return false;
        }
        int i = 1;
        while (i < length) {
            if (expected.charAt(i) != (s.charAt(++start) & 0xFFDF)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int findIdentifierEnd(String sql, int end, int i) {
        int cp;
        ++i;
        while (i <= end && (Character.isJavaIdentifierPart(cp = sql.codePointAt(i)) || cp == 35 && this.provider.getMode().supportPoundSymbolForColumnNames)) {
            i += Character.charCount(cp);
        }
        return i;
    }

    private String extractIdentifier(String sql, int beginIndex, int endIndex) {
        return this.convertCase(sql.substring(beginIndex, endIndex));
    }

    private int readQuotedIdentifier(String sql, int end, int tokenStart, int i, char c, boolean unicode, ArrayList<Token> tokens) {
        int identifierEnd;
        if ((identifierEnd = sql.indexOf(c, ++i)) < 0) {
            throw DbException.getSyntaxError(sql, tokenStart);
        }
        String s = sql.substring(i, identifierEnd);
        i = identifierEnd + 1;
        if (i <= end && sql.charAt(i) == c) {
            StringBuilder builder = new StringBuilder(s);
            do {
                if ((identifierEnd = sql.indexOf(c, i + 1)) < 0) {
                    throw DbException.getSyntaxError(sql, tokenStart);
                }
                builder.append(sql, i, identifierEnd);
            } while ((i = identifierEnd + 1) <= end && sql.charAt(i) == c);
            s = builder.toString();
        }
        if (c == '`') {
            s = this.convertCase(s);
        }
        tokens.add(new Token.IdentifierToken(tokenStart, s, true, unicode));
        return i;
    }

    private String convertCase(String s) {
        if (this.identifiersToUpper) {
            s = StringUtils.toUpperEnglish(s);
        } else if (this.identifiersToLower) {
            s = StringUtils.toLowerEnglish(s);
        }
        return s;
    }

    private static int readBinaryString(String sql, int tokenStart, int end, int i, ArrayList<Token> tokens) {
        int stringEnd;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        do {
            if ((stringEnd = sql.indexOf(39, ++i)) < 0 || stringEnd < end && sql.charAt(stringEnd + 1) == '\'') {
                throw DbException.getSyntaxError(sql, tokenStart);
            }
            StringUtils.convertHexWithSpacesToBytes(result, sql, i, stringEnd);
        } while ((i = Tokenizer.skipWhitespace(sql, end, stringEnd + 1)) <= end && sql.charAt(i) == '\'');
        tokens.add(new Token.BinaryStringToken(tokenStart, result.toByteArray()));
        return i;
    }

    private static int readCharacterString(String sql, int tokenStart, int end, int i, boolean unicode, ArrayList<Token> tokens) {
        String s = null;
        StringBuilder builder = null;
        do {
            int stringEnd;
            if ((stringEnd = sql.indexOf(39, ++i)) < 0) {
                throw DbException.getSyntaxError(sql, tokenStart);
            }
            if (s == null) {
                s = sql.substring(i, stringEnd);
            } else {
                if (builder == null) {
                    builder = new StringBuilder(s);
                }
                builder.append(sql, i, stringEnd);
            }
            i = stringEnd + 1;
            if (i > end || sql.charAt(i) != '\'') continue;
            if (builder == null) {
                builder = new StringBuilder(s);
            }
            do {
                if ((stringEnd = sql.indexOf(39, i + 1)) < 0) {
                    throw DbException.getSyntaxError(sql, tokenStart);
                }
                builder.append(sql, i, stringEnd);
            } while ((i = stringEnd + 1) <= end && sql.charAt(i) == '\'');
        } while ((i = Tokenizer.skipWhitespace(sql, end, i)) <= end && sql.charAt(i) == '\'');
        if (builder != null) {
            s = builder.toString();
        }
        tokens.add(new Token.CharacterStringToken(tokenStart, s, unicode));
        return i;
    }

    private static int skipWhitespace(String sql, int end, int i) {
        while (i <= end) {
            int cp = sql.codePointAt(i);
            if (!Character.isWhitespace(cp)) {
                if (cp != 47 || i >= end) break;
                char c2 = sql.charAt(i + 1);
                if (c2 == '*') {
                    i = Tokenizer.skipBracketedComment(sql, end, i);
                    continue;
                }
                if (c2 != '/') break;
                i = Tokenizer.skipSimpleComment(sql, end, i);
                continue;
            }
            i += Character.charCount(cp);
        }
        return i;
    }

    private static int read0xBinaryString(String sql, int end, int i, ArrayList<Token> tokens) {
        char c;
        int start = i;
        while (i <= end && ((c = sql.charAt(i)) >= '0' && c <= '9' || (c = (char)(c & 0xFFDF)) >= 'A' && c <= 'F')) {
            ++i;
        }
        if (i <= end && Character.isJavaIdentifierPart(sql.codePointAt(i))) {
            throw DbException.get(90004, sql.substring(start, i + 1));
        }
        tokens.add(new Token.BinaryStringToken(start, StringUtils.convertHexToBytes(sql.substring(start, i))));
        return i;
    }

    private static int readIntegerNumber(String sql, int tokenStart, int end, int i, ArrayList<Token> tokens, String name, int radix) {
        boolean bigint;
        char c;
        int maxLetter;
        char maxDigit;
        if (i > end) {
            throw DbException.getSyntaxError(sql, tokenStart, name);
        }
        if (radix > 10) {
            maxDigit = '9';
            maxLetter = 54 + radix;
        } else {
            maxDigit = 47 + radix;
            maxLetter = -1;
        }
        int start = i;
        long number = 0L;
        int lastUnderscore = Integer.MIN_VALUE;
        do {
            if ((c = sql.charAt(i)) >= '0' && c <= maxDigit) {
                number = number * (long)radix + (long)c - 48L;
            } else {
                if (c == '_') {
                    if (lastUnderscore == i - 1) {
                        throw DbException.getSyntaxError(sql, tokenStart, name);
                    }
                    lastUnderscore = i;
                    continue;
                }
                if (maxLetter >= 0 && (c = (char)(c & 0xFFDF)) >= 'A' && c <= maxLetter) {
                    number = number * (long)radix + (long)c - 55L;
                } else {
                    if (i != start) break;
                    throw DbException.getSyntaxError(sql, tokenStart, name);
                }
            }
            if (number <= Integer.MAX_VALUE) continue;
            while (++i <= end) {
                c = sql.charAt(i);
                if (c >= '0' && c <= maxDigit) continue;
                if (c == '_') {
                    if (lastUnderscore == i - 1) {
                        throw DbException.getSyntaxError(sql, tokenStart, name);
                    }
                    lastUnderscore = i;
                    continue;
                }
                if (maxLetter < 0 || (c = (char)(c & 0xFFDF)) < 'A' || c > 'F') break;
            }
            if (lastUnderscore == i - 1) {
                throw DbException.getSyntaxError(sql, tokenStart, name);
            }
            return Tokenizer.finishBigInteger(sql, tokenStart, end, i, start, i <= end && c == 'L', lastUnderscore >= 0, radix, tokens);
        } while (++i <= end);
        if (lastUnderscore == i - 1) {
            throw DbException.getSyntaxError(sql, tokenStart, name);
        }
        boolean bl = bigint = i <= end && c == 'L';
        if (bigint) {
            ++i;
        }
        if (i <= end && Character.isJavaIdentifierPart(sql.codePointAt(i))) {
            throw DbException.getSyntaxError(sql, tokenStart, name);
        }
        tokens.add(bigint ? new Token.BigintToken(start, number) : new Token.IntegerToken(start, (int)number));
        return i;
    }

    private static int readNumeric(String sql, int tokenStart, int end, int i, char c, ArrayList<Token> tokens) {
        long number = c - 48;
        int lastUnderscore = Integer.MIN_VALUE;
        while (i <= end) {
            block19: {
                block18: {
                    c = sql.charAt(i);
                    if (c >= '0' && c <= '9') break block18;
                    if (lastUnderscore == i - 1) {
                        throw DbException.getSyntaxError(sql, tokenStart, "Numeric");
                    }
                    switch (c) {
                        case '.': {
                            return Tokenizer.readFloat(sql, tokenStart, end, i, lastUnderscore >= 0, tokens);
                        }
                        case 'E': 
                        case 'e': {
                            return Tokenizer.readApproximateNumeric(sql, tokenStart, end, i, lastUnderscore >= 0, tokens);
                        }
                        case 'L': 
                        case 'l': {
                            return Tokenizer.finishBigInteger(sql, tokenStart, end, i, tokenStart, true, lastUnderscore >= 0, 10, tokens);
                        }
                        case '_': {
                            lastUnderscore = i;
                            break block19;
                        }
                    }
                    break;
                }
                if ((number = number * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                    block12: while (++i <= end) {
                        c = sql.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        if (lastUnderscore == i - 1) {
                            throw DbException.getSyntaxError(sql, tokenStart, "Numeric");
                        }
                        switch (c) {
                            case '.': {
                                return Tokenizer.readFloat(sql, tokenStart, end, i, lastUnderscore >= 0, tokens);
                            }
                            case 'E': 
                            case 'e': {
                                return Tokenizer.readApproximateNumeric(sql, tokenStart, end, i, lastUnderscore >= 0, tokens);
                            }
                            case '_': {
                                lastUnderscore = i;
                                break;
                            }
                            default: {
                                break block12;
                            }
                        }
                    }
                    if (lastUnderscore == i - 1) {
                        throw DbException.getSyntaxError(sql, tokenStart, "Numeric");
                    }
                    return Tokenizer.finishBigInteger(sql, tokenStart, end, i, tokenStart, c == 'L' || c == 'l', lastUnderscore >= 0, 10, tokens);
                }
            }
            ++i;
        }
        if (lastUnderscore == i - 1) {
            throw DbException.getSyntaxError(sql, tokenStart, "Numeric");
        }
        tokens.add(new Token.IntegerToken(tokenStart, (int)number));
        return i;
    }

    private static int readFloat(String sql, int tokenStart, int end, int i, boolean withUnderscore, ArrayList<Token> tokens) {
        int start = i + 1;
        int lastUnderscore = Integer.MIN_VALUE;
        block4: while (++i <= end) {
            char c = sql.charAt(i);
            if (c >= '0' && c <= '9') continue;
            if (lastUnderscore == i - 1) {
                throw DbException.getSyntaxError(sql, tokenStart, "Numeric");
            }
            switch (c) {
                case 'E': 
                case 'e': {
                    return Tokenizer.readApproximateNumeric(sql, tokenStart, end, i, withUnderscore, tokens);
                }
                case '_': {
                    if (i == start) {
                        throw DbException.getSyntaxError(sql, tokenStart, "Numeric");
                    }
                    lastUnderscore = i;
                    withUnderscore = true;
                    break;
                }
                default: {
                    break block4;
                }
            }
        }
        if (lastUnderscore == i - 1) {
            throw DbException.getSyntaxError(sql, tokenStart, "Numeric");
        }
        tokens.add(new Token.ValueToken(tokenStart, ValueNumeric.get(Tokenizer.readBigDecimal(sql, tokenStart, i, withUnderscore))));
        return i;
    }

    private static int readApproximateNumeric(String sql, int tokenStart, int end, int i, boolean withUnderscore, ArrayList<Token> tokens) {
        char c;
        if (i == end) {
            throw DbException.getSyntaxError(sql, tokenStart, "Approximate numeric");
        }
        if ((c = sql.charAt(++i)) == '+' || c == '-') {
            if (i == end) {
                throw DbException.getSyntaxError(sql, tokenStart, "Approximate numeric");
            }
            c = sql.charAt(++i);
        }
        if (c < '0' || c > '9') {
            throw DbException.getSyntaxError(sql, tokenStart, "Approximate numeric");
        }
        int lastUnderscore = Integer.MIN_VALUE;
        while (++i <= end) {
            c = sql.charAt(i);
            if (c >= '0' && c <= '9') continue;
            if (lastUnderscore == i - 1) {
                throw DbException.getSyntaxError(sql, tokenStart, "Approximate numeric");
            }
            if (c != '_') break;
            lastUnderscore = i;
            withUnderscore = true;
        }
        if (lastUnderscore == i - 1) {
            throw DbException.getSyntaxError(sql, tokenStart, "Approximate numeric");
        }
        tokens.add(new Token.ValueToken(tokenStart, ValueDecfloat.get(Tokenizer.readBigDecimal(sql, tokenStart, i, withUnderscore))));
        return i;
    }

    private static BigDecimal readBigDecimal(String sql, int tokenStart, int i, boolean withUnderscore) {
        BigDecimal bd;
        String string = Tokenizer.readAndRemoveUnderscores(sql, tokenStart, i, withUnderscore);
        try {
            bd = new BigDecimal(string);
        }
        catch (NumberFormatException e) {
            throw DbException.getSyntaxError(sql, tokenStart, "Numeric");
        }
        return bd;
    }

    private static int finishBigInteger(String sql, int tokenStart, int end, int i, int start, boolean asBigint, boolean withUnderscore, int radix, ArrayList<Token> tokens) {
        Token.LiteralToken token;
        int endIndex = i++;
        if (asBigint) {
            // empty if block
        }
        if (radix == 16 && i <= end && Character.isJavaIdentifierPart(sql.codePointAt(i))) {
            throw DbException.getSyntaxError(sql, tokenStart, "Hex number");
        }
        BigInteger bigInteger = new BigInteger(Tokenizer.readAndRemoveUnderscores(sql, start, endIndex, withUnderscore), radix);
        if (bigInteger.compareTo(ValueBigint.MAX_BI) > 0) {
            if (asBigint) {
                throw DbException.getSyntaxError(sql, tokenStart, "BIGINT");
            }
            token = new Token.ValueToken(tokenStart, ValueNumeric.get(bigInteger));
        } else {
            token = new Token.BigintToken(tokenStart, bigInteger.longValue());
        }
        tokens.add(token);
        return i;
    }

    private static String readAndRemoveUnderscores(String sql, int start, int endIndex, boolean withUnderscore) {
        if (!withUnderscore) {
            return sql.substring(start, endIndex);
        }
        StringBuilder builder = new StringBuilder(endIndex - start - 1);
        while (start < endIndex) {
            char c = sql.charAt(start);
            if (c != '_') {
                builder.append(c);
            }
            ++start;
        }
        return builder.toString();
    }

    private static int skipBracketedComment(String sql, int end, int i) {
        int tokenStart = i;
        i += 2;
        int level = 1;
        block0: while (level > 0) {
            while (true) {
                char c;
                if (i >= end) {
                    throw DbException.getSyntaxError(sql, tokenStart);
                }
                if ((c = sql.charAt(i++)) == '*') {
                    if (sql.charAt(i) != '/') continue;
                    --level;
                    ++i;
                    continue block0;
                }
                if (c != '/' || sql.charAt(i) != '*') continue;
                ++level;
                ++i;
            }
        }
        return i;
    }

    private static int skipSimpleComment(String sql, int end, int i) {
        char c;
        i += 2;
        while (i <= end && (c = sql.charAt(i)) != '\n' && c != '\r') {
            ++i;
        }
        return i;
    }

    private static int parseParameterIndex(String sql, int end, int i, ArrayList<Token> tokens) {
        char c;
        int tokenStart = i;
        long number = 0L;
        while (++i <= end && (c = sql.charAt(i)) >= '0' && c <= '9') {
            if ((number = number * 10L + (long)(c - 48)) <= Integer.MAX_VALUE) continue;
            throw DbException.getInvalidValueException("parameter index", number);
        }
        if (i > tokenStart + 1 && number == 0L) {
            throw DbException.getInvalidValueException("parameter index", number);
        }
        tokens.add(new Token.ParameterToken(tokenStart, (int)number));
        return i;
    }

    private static int assignParameterIndex(ArrayList<Token> tokens, int lastParameter, BitSet parameters) {
        Token.ParameterToken parameter = (Token.ParameterToken)tokens.get(tokens.size() - 1);
        int index = parameter.index;
        if (index == 0) {
            if (lastParameter < 0) {
                throw DbException.get(90123);
            }
            parameter.index = index = ++lastParameter;
        } else {
            if (lastParameter > 0) {
                throw DbException.get(90123);
            }
            lastParameter = -1;
        }
        parameters.set(index - 1);
        return lastParameter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processUescape(String sql, ArrayList<Token> tokens) {
        ListIterator<Token> i = tokens.listIterator();
        while (i.hasNext()) {
            Token t2;
            Token token = i.next();
            if (!token.needsUnicodeConversion()) continue;
            int uescape = 92;
            if (i.hasNext() && (t2 = i.next()).tokenType() == 78) {
                int escape;
                String s;
                i.remove();
                if (!i.hasNext()) throw DbException.getSyntaxError(sql, t2.start() + 7, "'<Unicode escape character>'");
                Token t3 = i.next();
                i.remove();
                if (!(t3 instanceof Token.CharacterStringToken) || (s = ((Token.CharacterStringToken)t3).string).codePointCount(0, s.length()) != 1 || Character.isWhitespace(escape = s.codePointAt(0)) || escape >= 48 && escape <= 57 || escape >= 65 && escape <= 70 || escape >= 97 && escape <= 102) throw DbException.getSyntaxError(sql, t2.start() + 7, "'<Unicode escape character>'");
                switch (escape) {
                    default: {
                        uescape = escape;
                        break;
                    }
                    case 34: 
                    case 39: 
                    case 43: {
                        throw DbException.getSyntaxError(sql, t2.start() + 7, "'<Unicode escape character>'");
                    }
                }
            }
            token.convertUnicode(uescape);
        }
    }
}

