/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.function.BiPredicate;
import org.h2.command.ddl.SchemaOwnerCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AlterDomain
extends SchemaOwnerCommand {
    String domainName;
    boolean ifDomainExists;

    public static void forAllDependencies(SessionLocal session, Domain domain, BiPredicate<Domain, Column> columnProcessor, BiPredicate<Domain, Domain> domainProcessor, boolean recompileExpressions) {
        Database db = session.getDatabase();
        for (Schema schema : db.getAllSchemasNoMeta()) {
            for (Domain targetDomain : schema.getAllDomains()) {
                if (targetDomain.getDomain() != domain || domainProcessor != null && !domainProcessor.test(domain, targetDomain)) continue;
                if (recompileExpressions) {
                    domain.prepareExpressions(session);
                }
                db.updateMeta(session, targetDomain);
            }
            for (Table t : schema.getAllTablesAndViews(null)) {
                if (!AlterDomain.forTable(session, domain, columnProcessor, recompileExpressions, t)) continue;
                db.updateMeta(session, t);
            }
        }
        for (Table t : session.getLocalTempTables()) {
            AlterDomain.forTable(session, domain, columnProcessor, recompileExpressions, t);
        }
    }

    private static boolean forTable(SessionLocal session, Domain domain, BiPredicate<Domain, Column> columnProcessor, boolean recompileExpressions, Table t) {
        boolean modified = false;
        Column[] columnArray = t.getColumns();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column targetColumn = columnArray[n2];
            if (targetColumn.getDomain() == domain) {
                boolean m;
                boolean bl = m = columnProcessor == null || columnProcessor.test(domain, targetColumn);
                if (m) {
                    if (recompileExpressions) {
                        targetColumn.prepareExpressions(session);
                    }
                    modified = true;
                }
            }
            ++n2;
        }
        return modified;
    }

    AlterDomain(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public final void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public final void setIfDomainExists(boolean b) {
        this.ifDomainExists = b;
    }

    @Override
    final long update(Schema schema) {
        Domain domain = this.getSchema().findDomain(this.domainName);
        if (domain == null) {
            if (this.ifDomainExists) {
                return 0L;
            }
            throw DbException.get(90120, this.domainName);
        }
        return this.update(schema, domain);
    }

    abstract long update(Schema var1, Domain var2);
}

