/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.AlterDomain;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.ColumnTemplate;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AlterDomainExpressions
extends AlterDomain {
    private final int type;
    private Expression expression;

    public AlterDomainExpressions(SessionLocal session, Schema schema, int type) {
        super(session, schema);
        this.type = type;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    long update(Schema schema, Domain domain) {
        switch (this.type) {
            case 94: {
                domain.setDefaultExpression(this.session, this.expression);
                break;
            }
            case 95: {
                domain.setOnUpdateExpression(this.session, this.expression);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        if (this.expression != null) {
            AlterDomainExpressions.forAllDependencies(this.session, domain, this::copyColumn, this::copyDomain, true);
        }
        this.getDatabase().updateMeta(this.session, domain);
        return 0L;
    }

    private boolean copyColumn(Domain domain, Column targetColumn) {
        return this.copyExpressions(this.session, domain, targetColumn);
    }

    private boolean copyDomain(Domain domain, Domain targetDomain) {
        return this.copyExpressions(this.session, domain, targetDomain);
    }

    private boolean copyExpressions(SessionLocal session, Domain domain, ColumnTemplate targetColumn) {
        switch (this.type) {
            case 94: {
                Expression e = domain.getDefaultExpression();
                if (e == null || targetColumn.getDefaultExpression() != null) break;
                targetColumn.setDefaultExpression(session, e);
                return true;
            }
            case 95: {
                Expression e = domain.getOnUpdateExpression();
                if (e == null || targetColumn.getOnUpdateExpression() != null) break;
                targetColumn.setOnUpdateExpression(session, e);
                return true;
            }
        }
        return false;
    }

    @Override
    public int getType() {
        return this.type;
    }
}

