/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CreateRole
extends DefineCommand {
    private String roleName;
    private boolean ifNotExists;

    public CreateRole(SessionLocal session) {
        super(session);
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setRoleName(String name) {
        this.roleName = name;
    }

    @Override
    public long update() {
        this.session.getUser().checkAdmin();
        Database db = this.getDatabase();
        RightOwner rightOwner = db.findUserOrRole(this.roleName);
        if (rightOwner != null) {
            if (rightOwner instanceof Role) {
                if (this.ifNotExists) {
                    return 0L;
                }
                throw DbException.get(90069, this.roleName);
            }
            throw DbException.get(90033, this.roleName);
        }
        int id = this.getObjectId();
        Role role = new Role(db, id, this.roleName, false);
        db.addDatabaseObject(this.session, role);
        return 0L;
    }

    @Override
    public int getType() {
        return 27;
    }
}

