/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.RightOwner;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CreateUser
extends DefineCommand {
    private String userName;
    private boolean admin;
    private Expression password;
    private Expression salt;
    private Expression hash;
    private boolean ifNotExists;
    private String comment;

    public CreateUser(SessionLocal session) {
        super(session);
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(Expression password) {
        this.password = password;
    }

    static void setSaltAndHash(User user, SessionLocal session, Expression salt, Expression hash) {
        user.setSaltAndHash(CreateUser.getByteArray(session, salt), CreateUser.getByteArray(session, hash));
    }

    private static byte[] getByteArray(SessionLocal session, Expression e) {
        Value value = e.optimize(session).getValue(session);
        if (DataType.isBinaryStringType(value.getValueType())) {
            byte[] b = value.getBytes();
            return b == null ? new byte[]{} : b;
        }
        String s = value.getString();
        return s == null ? new byte[]{} : StringUtils.convertHexToBytes(s);
    }

    static void setPassword(User user, SessionLocal session, Expression password) {
        String pwd = password.optimize(session).getValue(session).getString();
        char[] passwordChars = pwd == null ? new char[]{} : pwd.toCharArray();
        String userName = user.getName();
        byte[] userPasswordHash = userName.isEmpty() && passwordChars.length == 0 ? new byte[]{} : SHA256.getKeyPasswordHash(userName, passwordChars);
        user.setUserPasswordHash(userPasswordHash);
    }

    @Override
    public long update() {
        this.session.getUser().checkAdmin();
        Database db = this.getDatabase();
        RightOwner rightOwner = db.findUserOrRole(this.userName);
        if (rightOwner != null) {
            if (rightOwner instanceof User) {
                if (this.ifNotExists) {
                    return 0L;
                }
                throw DbException.get(90033, this.userName);
            }
            throw DbException.get(90069, this.userName);
        }
        int id = this.getObjectId();
        User user = new User(db, id, this.userName, false);
        user.setAdmin(this.admin);
        user.setComment(this.comment);
        if (this.hash != null && this.salt != null) {
            CreateUser.setSaltAndHash(user, this.session, this.salt, this.hash);
        } else if (this.password != null) {
            CreateUser.setPassword(user, this.session, this.password);
        } else {
            throw DbException.getInternalError();
        }
        db.addDatabaseObject(this.session, user);
        return 0L;
    }

    public void setSalt(Expression e) {
        this.salt = e;
    }

    public void setHash(Expression e) {
        this.hash = e;
    }

    public void setAdmin(boolean b) {
        this.admin = b;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public int getType() {
        return 32;
    }
}

