/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaOwnerCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Constant;
import org.h2.schema.Schema;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DropConstant
extends SchemaOwnerCommand {
    private String constantName;
    private boolean ifExists;

    public DropConstant(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setConstantName(String constantName) {
        this.constantName = constantName;
    }

    @Override
    long update(Schema schema) {
        Database db = this.getDatabase();
        Constant constant = schema.findConstant(this.constantName);
        if (constant == null) {
            if (!this.ifExists) {
                throw DbException.get(90115, this.constantName);
            }
        } else {
            db.removeSchemaObject(this.session, constant);
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 37;
    }
}

