/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.Collection;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DropDatabase
extends DefineCommand {
    private boolean dropAllObjects;
    private boolean deleteFiles;

    public DropDatabase(SessionLocal session) {
        super(session);
    }

    @Override
    public long update() {
        if (this.dropAllObjects) {
            this.dropAllObjects();
        }
        if (this.deleteFiles) {
            this.getDatabase().setDeleteFilesOnDisconnect(true);
        }
        return 0L;
    }

    private void dropAllObjects() {
        boolean runLoopAgain;
        User user = this.session.getUser();
        user.checkAdmin();
        Database db = this.getDatabase();
        db.lockMeta(this.session);
        do {
            ArrayList<Table> tables = db.getAllTablesAndViews();
            ArrayList<Table> toRemove = new ArrayList<Table>(tables.size());
            for (Table table : tables) {
                if (table.getName() == null || TableType.VIEW != table.getTableType()) continue;
                toRemove.add(table);
            }
            for (Table table : tables) {
                if (table.getName() == null || TableType.TABLE_LINK != table.getTableType()) continue;
                toRemove.add(table);
            }
            for (Table table : tables) {
                if (table.getName() == null || TableType.TABLE != table.getTableType()) continue;
                toRemove.add(table);
            }
            for (Table table : tables) {
                if (table.getName() == null || TableType.EXTERNAL_TABLE_ENGINE != table.getTableType()) continue;
                toRemove.add(table);
            }
            runLoopAgain = false;
            for (Table table : toRemove) {
                if (table.getName() == null) continue;
                if (db.getDependentTable(table, table) == null) {
                    db.removeSchemaObject(this.session, table);
                    continue;
                }
                runLoopAgain = true;
            }
        } while (runLoopAgain);
        Collection<Schema> schemas = db.getAllSchemasNoMeta();
        for (Schema schema : schemas) {
            if (!schema.canDrop()) continue;
            db.removeDatabaseObject(this.session, schema);
        }
        ArrayList<SchemaObject> list = new ArrayList<SchemaObject>();
        for (Schema schema : schemas) {
            for (Sequence sequence : schema.getAllSequences()) {
                if (sequence.getBelongsToTable()) continue;
                list.add(sequence);
            }
        }
        DropDatabase.addAll(schemas, 5, list);
        DropDatabase.addAll(schemas, 4, list);
        DropDatabase.addAll(schemas, 11, list);
        DropDatabase.addAll(schemas, 9, list);
        DropDatabase.addAll(schemas, 12, list);
        for (SchemaObject schemaObject : list) {
            if (!schemaObject.getSchema().isValid()) continue;
            db.removeSchemaObject(this.session, schemaObject);
        }
        Role role = db.getPublicRole();
        for (RightOwner rightOwner : db.getAllUsersAndRoles()) {
            if (rightOwner == user || rightOwner == role) continue;
            db.removeDatabaseObject(this.session, rightOwner);
        }
        for (Right right : db.getAllRights()) {
            db.removeDatabaseObject(this.session, right);
        }
        SessionLocal[] sessionLocalArray = db.getSessions(false);
        int n = sessionLocalArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionLocal s = sessionLocalArray[n2];
            s.setLastIdentity(ValueNull.INSTANCE);
            ++n2;
        }
    }

    private static void addAll(Collection<Schema> schemas, int type, ArrayList<SchemaObject> list) {
        for (Schema schema : schemas) {
            schema.getAll(type, list);
        }
    }

    public void setDropAllObjects(boolean b) {
        this.dropAllObjects = b;
    }

    public void setDeleteFiles(boolean b) {
        this.deleteFiles = b;
    }

    @Override
    public int getType() {
        return 38;
    }
}

