/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.MaterializedView;
import org.h2.table.Table;
import org.h2.table.TableType;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DropMaterializedView
extends SchemaCommand {
    private String viewName;
    private boolean ifExists;

    public DropMaterializedView(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public long update() {
        Table view = this.getSchema().findTableOrView(this.session, this.viewName);
        if (view == null) {
            if (!this.ifExists) {
                throw DbException.get(90037, this.viewName);
            }
        } else {
            if (TableType.MATERIALIZED_VIEW != view.getTableType()) {
                throw DbException.get(90037, this.viewName);
            }
            this.session.getUser().checkSchemaOwner(view.getSchema());
            MaterializedView materializedView = (MaterializedView)view;
            for (Table table : materializedView.getSelect().getTables()) {
                table.removeDependentMaterializedView(materializedView);
            }
            Database database = this.getDatabase();
            database.lockMeta(this.session);
            database.removeSchemaObject(this.session, view);
            database.unlockMeta(this.session);
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 104;
    }
}

