/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DropRole
extends DefineCommand {
    private String roleName;
    private boolean ifExists;

    public DropRole(SessionLocal session) {
        super(session);
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Override
    public long update() {
        this.session.getUser().checkAdmin();
        Database db = this.getDatabase();
        Role role = db.findRole(this.roleName);
        if (role == null) {
            if (!this.ifExists) {
                throw DbException.get(90070, this.roleName);
            }
        } else {
            if (role == db.getPublicRole()) {
                throw DbException.get(90091, this.roleName);
            }
            role.checkOwnsNoSchemas();
            db.removeDatabaseObject(this.session, role);
        }
        return 0L;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    @Override
    public int getType() {
        return 41;
    }
}

