/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaOwnerCommand;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.TableSynonym;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DropSynonym
extends SchemaOwnerCommand {
    private String synonymName;
    private boolean ifExists;

    public DropSynonym(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public void setSynonymName(String name) {
        this.synonymName = name;
    }

    @Override
    long update(Schema schema) {
        TableSynonym synonym = schema.getSynonym(this.synonymName);
        if (synonym == null) {
            if (!this.ifExists) {
                throw DbException.get(42102, this.synonymName);
            }
        } else {
            this.getDatabase().removeSchemaObject(this.session, synonym);
        }
        return 0L;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    @Override
    public int getType() {
        return 89;
    }
}

