/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.mvstore.db.Store;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.value.TypeInfo;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Explain
extends Prepared {
    private Prepared command;
    private LocalResult result;
    private boolean executeCommand;

    public Explain(SessionLocal session) {
        super(session);
    }

    public void setCommand(Prepared command) {
        this.command = command;
    }

    public Prepared getCommand() {
        return this.command;
    }

    @Override
    public void prepare() {
        this.command.prepare();
    }

    public void setExecuteCommand(boolean executeCommand) {
        this.executeCommand = executeCommand;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.query(-1L);
    }

    @Override
    protected void checkParameters() {
        if (this.executeCommand) {
            super.checkParameters();
        }
    }

    @Override
    public ResultInterface query(long maxrows) {
        Database db = this.getDatabase();
        Expression[] expressions = new Expression[]{new ExpressionColumn(db, new Column("PLAN", TypeInfo.TYPE_VARCHAR))};
        this.result = new LocalResult(this.session, expressions, 1, 1);
        int sqlFlags = 8;
        if (maxrows >= 0L) {
            Object plan;
            if (this.executeCommand) {
                Store store = null;
                if (db.isPersistent()) {
                    store = db.getStore();
                    store.statisticsStart();
                }
                if (this.command.isQuery()) {
                    this.command.query(maxrows);
                } else {
                    this.command.update();
                }
                plan = this.command.getPlanSQL(sqlFlags);
                Map<String, Integer> statistics = null;
                if (store != null) {
                    statistics = store.statisticsEnd();
                }
                if (statistics != null) {
                    int total = 0;
                    for (Integer value : statistics.values()) {
                        total += value.intValue();
                    }
                    if (total > 0) {
                        statistics = new TreeMap<String, Integer>(statistics);
                        StringBuilder buff = new StringBuilder();
                        if (statistics.size() > 1) {
                            buff.append("total: ").append(total).append('\n');
                        }
                        for (Map.Entry<String, Integer> e : statistics.entrySet()) {
                            int value = e.getValue();
                            int percent = (int)(100L * (long)value / (long)total);
                            buff.append(e.getKey()).append(": ").append(value);
                            if (statistics.size() > 1) {
                                buff.append(" (").append(percent).append("%)");
                            }
                            buff.append('\n');
                        }
                        plan = (String)plan + "\n/*\n" + String.valueOf(buff) + "*/";
                    }
                }
            } else {
                plan = this.command.getPlanSQL(sqlFlags);
            }
            this.add((String)plan);
        }
        this.result.done();
        return this.result;
    }

    private void add(String text) {
        this.result.addRow(ValueVarchar.get(text));
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.command.isReadOnly();
    }

    @Override
    public int getType() {
        return this.executeCommand ? 86 : 60;
    }

    @Override
    public void collectDependencies(HashSet<DbObject> dependencies) {
        this.command.collectDependencies(dependencies);
    }
}

