/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.tools.Csv;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Help
extends Prepared {
    private final String[] conditions;
    private final Expression[] expressions;

    public Help(SessionLocal session, String[] conditions) {
        super(session);
        this.conditions = conditions;
        Database db = this.getDatabase();
        this.expressions = new Expression[]{new ExpressionColumn(db, new Column("SECTION", TypeInfo.TYPE_VARCHAR)), new ExpressionColumn(db, new Column("TOPIC", TypeInfo.TYPE_VARCHAR)), new ExpressionColumn(db, new Column("SYNTAX", TypeInfo.TYPE_VARCHAR)), new ExpressionColumn(db, new Column("TEXT", TypeInfo.TYPE_VARCHAR))};
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult result = new LocalResult(this.session, this.expressions, 4, 4);
        result.done();
        return result;
    }

    @Override
    public ResultInterface query(long maxrows) {
        LocalResult result = new LocalResult(this.session, this.expressions, 4, 4);
        try {
            ResultSet rs = Help.getTable();
            block2: while (rs.next()) {
                String topic = rs.getString(2).trim();
                String[] stringArray = this.conditions;
                int n = this.conditions.length;
                int n2 = 0;
                while (n2 < n) {
                    String condition = stringArray[n2];
                    if (!topic.contains(condition)) continue block2;
                    ++n2;
                }
                result.addRow(ValueVarchar.get(rs.getString(1).trim(), this.session), ValueVarchar.get(topic, this.session), ValueVarchar.get(Help.stripAnnotationsFromSyntax(rs.getString(3)), this.session), ValueVarchar.get(Help.processHelpText(rs.getString(4)), this.session));
            }
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
        result.done();
        return result;
    }

    public static String stripAnnotationsFromSyntax(String s) {
        return s.replaceAll("@c@ ", "").replaceAll("@h2@ ", "").replaceAll("@c@", "").replaceAll("@h2@", "").trim();
    }

    public static String processHelpText(String s) {
        int len = s.length();
        int end = 0;
        while (end < len) {
            char ch = s.charAt(end);
            if (ch == '.') {
                ++end;
                break;
            }
            if (ch == '\"') {
                while (++end < len && s.charAt(end) != '\"') {
                }
            }
            ++end;
        }
        s = s.substring(0, end);
        return s.trim();
    }

    public static ResultSet getTable() throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(Utils.getResource("/org/h2/res/help.csv")), StandardCharsets.UTF_8);
        Csv csv = new Csv();
        csv.setLineCommentCharacter('#');
        return csv.read(reader, null);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public int getType() {
        return 57;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }
}

