/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.h2.command.Command;
import org.h2.command.dml.CommandWithValues;
import org.h2.command.dml.Update;
import org.h2.command.query.Query;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVPrimaryIndex;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.Table;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Insert
extends CommandWithValues
implements ResultTarget {
    private Table table;
    private Column[] columns;
    private Query query;
    private long rowNumber;
    private boolean insertFromSelect;
    private Boolean overridingSystem;
    private HashMap<Column, Expression> duplicateKeyAssignmentMap;
    private Value[] onDuplicateKeyRow;
    private boolean ignore;
    private ResultTarget deltaChangeCollector;
    private DataChangeDeltaTable.ResultOption deltaChangeCollectionMode;

    public Insert(SessionLocal session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setOverridingSystem(Boolean overridingSystem) {
        this.overridingSystem = overridingSystem;
    }

    public void addAssignmentForDuplicate(Column column, Expression expression) {
        if (this.duplicateKeyAssignmentMap == null) {
            this.duplicateKeyAssignmentMap = new HashMap();
        }
        if (this.duplicateKeyAssignmentMap.putIfAbsent(column, expression) != null) {
            throw DbException.get(42121, column.getName());
        }
    }

    @Override
    public long update(ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode) {
        this.deltaChangeCollector = deltaChangeCollector;
        this.deltaChangeCollectionMode = deltaChangeCollectionMode;
        try {
            long l = this.insertRows();
            return l;
        }
        finally {
            this.deltaChangeCollector = null;
            this.deltaChangeCollectionMode = null;
        }
    }

    private long insertRows() {
        this.session.getUser().checkTableRight(this.table, 4);
        this.setCurrentRowNumber(0L);
        this.table.fire(this.session, 1, true);
        this.rowNumber = 0L;
        int listSize = this.valuesExpressionList.size();
        if (listSize > 0) {
            int columnLen = this.columns.length;
            int x = 0;
            while (x < listSize) {
                block18: {
                    Row newRow = this.table.getTemplateRow();
                    Expression[] expr = (Expression[])this.valuesExpressionList.get(x);
                    this.setCurrentRowNumber(x + 1);
                    int i = 0;
                    while (i < columnLen) {
                        Column c = this.columns[i];
                        int index = c.getColumnId();
                        Expression e = expr[i];
                        if (e != ValueExpression.DEFAULT) {
                            try {
                                newRow.setValue(index, e.getValue(this.session));
                            }
                            catch (DbException ex) {
                                throw this.setRow(ex, x, Insert.getSimpleSQL(expr));
                            }
                        }
                        ++i;
                    }
                    ++this.rowNumber;
                    this.table.convertInsertRow(this.session, newRow, this.overridingSystem);
                    if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.NEW) {
                        this.deltaChangeCollector.addRow((Value[])newRow.getValueList().clone());
                    }
                    if (!this.table.fireBeforeRow(this.session, null, newRow)) {
                        this.table.lock(this.session, 1);
                        try {
                            this.table.addRow(this.session, newRow);
                        }
                        catch (DbException de) {
                            this.rowNumber = this.handleOnDuplicate(de, null) ? ++this.rowNumber : --this.rowNumber;
                            break block18;
                        }
                        DataChangeDeltaTable.collectInsertedFinalRow(this.session, this.table, this.deltaChangeCollector, this.deltaChangeCollectionMode, newRow);
                        this.table.fireAfterRow(this.session, null, newRow, false);
                    } else {
                        DataChangeDeltaTable.collectInsertedFinalRow(this.session, this.table, this.deltaChangeCollector, this.deltaChangeCollectionMode, newRow);
                    }
                }
                ++x;
            }
        } else {
            this.table.lock(this.session, 1);
            if (this.insertFromSelect) {
                this.query.query(0L, this);
            } else {
                ResultInterface rows = this.query.query(0L);
                while (rows.next()) {
                    Value[] r = rows.currentRow();
                    try {
                        this.addRow(r);
                    }
                    catch (DbException de) {
                        if (this.handleOnDuplicate(de, r)) {
                            ++this.rowNumber;
                            continue;
                        }
                        --this.rowNumber;
                    }
                }
                rows.close();
            }
        }
        this.table.fire(this.session, 1, false);
        return this.rowNumber;
    }

    @Override
    public void addRow(Value ... values) {
        Row newRow = this.table.getTemplateRow();
        this.setCurrentRowNumber(++this.rowNumber);
        int j = 0;
        int len = this.columns.length;
        while (j < len) {
            newRow.setValue(this.columns[j].getColumnId(), values[j]);
            ++j;
        }
        this.table.convertInsertRow(this.session, newRow, this.overridingSystem);
        if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.NEW) {
            this.deltaChangeCollector.addRow((Value[])newRow.getValueList().clone());
        }
        if (!this.table.fireBeforeRow(this.session, null, newRow)) {
            this.table.addRow(this.session, newRow);
            DataChangeDeltaTable.collectInsertedFinalRow(this.session, this.table, this.deltaChangeCollector, this.deltaChangeCollectionMode, newRow);
            this.table.fireAfterRow(this.session, null, newRow, false);
        } else {
            DataChangeDeltaTable.collectInsertedFinalRow(this.session, this.table, this.deltaChangeCollector, this.deltaChangeCollectionMode, newRow);
        }
    }

    @Override
    public long getRowCount() {
        return this.rowNumber;
    }

    @Override
    public void limitsWereApplied() {
    }

    @Override
    public StringBuilder getPlanSQL(StringBuilder builder, int sqlFlags) {
        this.table.getSQL(builder.append("INSERT INTO "), sqlFlags).append('(');
        Column.writeColumns(builder, this.columns, sqlFlags);
        builder.append(")\n");
        if (this.insertFromSelect) {
            builder.append("DIRECT ");
        }
        if (!this.valuesExpressionList.isEmpty()) {
            builder.append("VALUES ");
            int row = 0;
            if (this.valuesExpressionList.size() > 1) {
                builder.append('\n');
            }
            for (Expression[] expr : this.valuesExpressionList) {
                if (row++ > 0) {
                    builder.append(",\n");
                }
                Expression.writeExpressions(builder.append('('), expr, sqlFlags).append(')');
            }
        } else {
            this.query.getPlanSQL(builder, sqlFlags);
        }
        return builder;
    }

    @Override
    void doPrepare() {
        if (this.columns == null) {
            this.columns = !this.valuesExpressionList.isEmpty() && ((Expression[])this.valuesExpressionList.get(0)).length == 0 ? new Column[0] : this.table.getVisibleColumns();
        }
        if (!this.valuesExpressionList.isEmpty()) {
            for (Expression[] expr : this.valuesExpressionList) {
                if (expr.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                int i = 0;
                int len = expr.length;
                while (i < len) {
                    Expression e = expr[i];
                    if (e != null) {
                        if ((e = e.optimize(this.session)) instanceof Parameter) {
                            Parameter p = (Parameter)e;
                            p.setColumn(this.columns[i]);
                        }
                        expr[i] = e;
                    }
                    ++i;
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
    }

    @Override
    public int getType() {
        return 61;
    }

    @Override
    public String getStatementName() {
        return "INSERT";
    }

    public void setInsertFromSelect(boolean value) {
        this.insertFromSelect = value;
    }

    @Override
    public boolean isCacheable() {
        return this.duplicateKeyAssignmentMap == null;
    }

    private boolean handleOnDuplicate(DbException de, Value[] currentRow) {
        if (de.getErrorCode() != 23505) {
            throw de;
        }
        if (this.duplicateKeyAssignmentMap == null) {
            if (this.ignore) {
                return false;
            }
            throw de;
        }
        int columnCount = this.columns.length;
        Expression[] row = currentRow == null ? (Expression[])this.valuesExpressionList.get((int)this.getCurrentRowNumber() - 1) : new Expression[columnCount];
        this.onDuplicateKeyRow = new Value[this.table.getColumns().length];
        int i = 0;
        while (i < columnCount) {
            Value value;
            if (currentRow != null) {
                value = currentRow[i];
                row[i] = ValueExpression.get(value);
            } else {
                value = row[i].getValue(this.session);
            }
            this.onDuplicateKeyRow[this.columns[i].getColumnId()] = value;
            ++i;
        }
        StringBuilder builder = new StringBuilder("UPDATE ");
        this.table.getSQL(builder, 0).append(" SET ");
        boolean f = false;
        for (Map.Entry<Column, Expression> entry : this.duplicateKeyAssignmentMap.entrySet()) {
            if (f) {
                builder.append(", ");
            }
            f = true;
            entry.getKey().getSQL(builder, 0).append('=');
            entry.getValue().getUnenclosedSQL(builder, 0);
        }
        builder.append(" WHERE ");
        Index foundIndex = (Index)de.getSource();
        if (foundIndex == null) {
            throw DbException.getUnsupportedException("Unable to apply ON DUPLICATE KEY UPDATE, no index found!");
        }
        this.prepareUpdateCondition(foundIndex, row).getUnenclosedSQL(builder, 0);
        String sql = builder.toString();
        Update command = (Update)this.session.prepare(sql);
        command.setOnDuplicateKeyInsert(this);
        for (Parameter param : command.getParameters()) {
            Parameter insertParam = (Parameter)this.parameters.get(param.getIndex());
            param.setValue(insertParam.getValue(this.session));
        }
        boolean result = command.update() > 0L;
        this.onDuplicateKeyRow = null;
        return result;
    }

    private Expression prepareUpdateCondition(Index foundIndex, Expression[] row) {
        Column[] indexedColumns;
        if (foundIndex instanceof MVPrimaryIndex) {
            MVPrimaryIndex foundMV = (MVPrimaryIndex)foundIndex;
            indexedColumns = new Column[]{foundMV.getIndexColumns()[foundMV.getMainIndexColumn()].column};
        } else {
            indexedColumns = foundIndex.getColumns();
        }
        Condition condition = null;
        Column[] columnArray = indexedColumns;
        int n = indexedColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            ExpressionColumn expr = new ExpressionColumn(this.getDatabase(), this.table.getSchema().getName(), this.table.getName(), column.getName());
            int i = 0;
            while (i < this.columns.length) {
                if (expr.getColumnName(this.session, i).equals(this.columns[i].getName())) {
                    if (condition == null) {
                        condition = new Comparison(0, expr, row[i], false);
                        break;
                    }
                    condition = new ConditionAndOr(0, condition, new Comparison(0, expr, row[i], false));
                    break;
                }
                ++i;
            }
            ++n2;
        }
        return condition;
    }

    public Value getOnDuplicateKeyValue(int columnIndex) {
        return this.onDuplicateKeyRow[columnIndex];
    }

    @Override
    public void collectDependencies(HashSet<DbObject> dependencies) {
        ExpressionVisitor visitor = ExpressionVisitor.getDependenciesVisitor(dependencies);
        if (!this.valuesExpressionList.isEmpty()) {
            Iterator iterator = this.valuesExpressionList.iterator();
            while (iterator.hasNext()) {
                Expression[] expr;
                Expression[] expressionArray = expr = (Expression[])iterator.next();
                int n = expr.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression e = expressionArray[n2];
                    e.isEverything(visitor);
                    ++n2;
                }
            }
        } else {
            this.query.isEverything(visitor);
        }
    }
}

