/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.HashSet;
import org.h2.command.Prepared;
import org.h2.command.dml.FilteredDataChangeStatement;
import org.h2.command.dml.Insert;
import org.h2.command.dml.SetClauseList;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Update
extends FilteredDataChangeStatement {
    private SetClauseList setClauseList;
    private Insert onDuplicateKeyInsert;

    public Update(SessionLocal session) {
        super(session);
    }

    public void setSetClauseList(SetClauseList setClauseList) {
        this.setClauseList = setClauseList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long update(ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode) {
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        Table table = this.targetTableFilter.getTable();
        Throwable throwable = null;
        Object var5_6 = null;
        try (LocalResult rows = LocalResult.forTable(this.session, table);){
            this.session.getUser().checkTableRight(table, 8);
            table.fire(this.session, 2, true);
            table.lock(this.session, 1);
            this.setCurrentRowNumber(0L);
            long count = 0L;
            long limitRows = -1L;
            if (this.fetchExpr != null) {
                Value v = this.fetchExpr.getValue(this.session);
                if (v == ValueNull.INSTANCE) throw DbException.getInvalidValueException("FETCH", v);
                limitRows = v.getLong();
                if (limitRows < 0L) {
                    throw DbException.getInvalidValueException("FETCH", v);
                }
            }
            while (true) {
                if (!this.nextRow(limitRows, count)) {
                    Update.doUpdate(this, this.session, table, rows);
                    table.fire(this.session, 2, false);
                    return count;
                }
                Row oldRow = this.targetTableFilter.get();
                if (table.isRowLockable()) {
                    Row lockedRow = table.lockRow(this.session, oldRow, -1);
                    if (lockedRow == null) continue;
                    if (!oldRow.hasSharedData(lockedRow)) {
                        oldRow = lockedRow;
                        this.targetTableFilter.set(oldRow);
                        if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                    }
                }
                if (!this.setClauseList.prepareUpdate(table, this.session, deltaChangeCollector, deltaChangeCollectionMode, rows, oldRow, this.onDuplicateKeyInsert != null)) continue;
                ++count;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    static void doUpdate(Prepared prepared, SessionLocal session, Table table, LocalResult rows) {
        rows.done();
        table.updateRows(prepared, session, rows);
        if (table.fireRow()) {
            rows.reset();
            while (rows.next()) {
                Row o = rows.currentRowForTable();
                rows.next();
                Row n = rows.currentRowForTable();
                table.fireAfterRow(session, o, n, false);
            }
        }
    }

    @Override
    public StringBuilder getPlanSQL(StringBuilder builder, int sqlFlags) {
        this.targetTableFilter.getPlanSQL(builder.append("UPDATE "), false, sqlFlags);
        this.setClauseList.getSQL(builder, sqlFlags);
        return this.appendFilterCondition(builder, sqlFlags);
    }

    @Override
    void doPrepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.targetTableFilter, 0, 0);
            this.condition = this.condition.optimizeCondition(this.session);
            if (this.condition != null) {
                this.condition.createIndexConditions(this.session, this.targetTableFilter);
            }
        }
        this.setClauseList.mapAndOptimize(this.session, this.targetTableFilter, null);
        TableFilter[] filters = new TableFilter[]{this.targetTableFilter};
        PlanItem item = this.targetTableFilter.getBestPlanItem(this.session, filters, 0, new AllColumnsForPlan(filters));
        this.targetTableFilter.setPlanItem(item);
        this.targetTableFilter.prepare();
    }

    @Override
    public int getType() {
        return 68;
    }

    @Override
    public String getStatementName() {
        return "UPDATE";
    }

    @Override
    public void collectDependencies(HashSet<DbObject> dependencies) {
        ExpressionVisitor visitor = ExpressionVisitor.getDependenciesVisitor(dependencies);
        if (this.condition != null) {
            this.condition.isEverything(visitor);
        }
        this.setClauseList.isEverything(visitor);
    }

    public Insert getOnDuplicateKeyInsert() {
        return this.onDuplicateKeyInsert;
    }

    void setOnDuplicateKeyInsert(Insert onDuplicateKeyInsert) {
        this.onDuplicateKeyInsert = onDuplicateKeyInsert;
    }
}

