/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.query;

import org.h2.message.DbException;
import org.h2.util.HasSQL;
import org.h2.util.StringUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ForUpdate
implements HasSQL {
    public static final ForUpdate DEFAULT = new ForUpdate(Type.DEFAULT, -1);
    public static final ForUpdate NOWAIT = new ForUpdate(Type.NOWAIT, 0);
    public static final ForUpdate SKIP_LOCKED = new ForUpdate(Type.SKIP_LOCKED, -2);
    private final Type type;
    private final int timeoutMillis;

    public static final ForUpdate wait(int timeoutMillis) {
        if (timeoutMillis < 0) {
            throw DbException.getInvalidValueException("timeout", timeoutMillis);
        }
        if (timeoutMillis == 0) {
            return NOWAIT;
        }
        return new ForUpdate(Type.WAIT, timeoutMillis);
    }

    private ForUpdate(Type type, int timeoutMillis) {
        this.type = type;
        this.timeoutMillis = timeoutMillis;
    }

    public Type getType() {
        return this.type;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        builder.append(" FOR UPDATE");
        switch (this.type) {
            case WAIT: {
                builder.append(" WAIT ").append(this.timeoutMillis / 1000);
                int millis = this.timeoutMillis % 1000;
                if (millis <= 0) break;
                StringUtils.appendZeroPadded(builder.append('.'), 3, millis);
                break;
            }
            case NOWAIT: {
                builder.append(" NOWAIT");
                break;
            }
            case SKIP_LOCKED: {
                builder.append(" SKIP LOCKED");
            }
        }
        return builder;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Type {
        DEFAULT,
        WAIT,
        NOWAIT,
        SKIP_LOCKED;

    }
}

