/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.query;

import java.util.BitSet;
import java.util.Random;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.table.Plan;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;
import org.h2.util.Permutations;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Optimizer {
    private static final int MAX_BRUTE_FORCE_FILTERS = 7;
    private static final int MAX_BRUTE_FORCE = 2000;
    private static final int MAX_GENETIC = 500;
    private long startNs;
    private BitSet switched;
    private final TableFilter[] filters;
    private final Expression condition;
    private final SessionLocal session;
    private Plan bestPlan;
    private TableFilter topFilter;
    private double cost;
    private Random random;
    private final AllColumnsForPlan allColumnsSet;

    Optimizer(TableFilter[] filters, Expression condition, SessionLocal session) {
        this.filters = filters;
        this.condition = condition;
        this.session = session;
        this.allColumnsSet = new AllColumnsForPlan(filters);
    }

    private static int getMaxBruteForceFilters(int filterCount) {
        int i = 0;
        int j = filterCount;
        int total = filterCount;
        while (j > 0 && total * (j * (j - 1) / 2) < 2000) {
            total *= --j;
            ++i;
        }
        return i;
    }

    private void calculateBestPlan() {
        this.cost = -1.0;
        if (this.filters.length == 1) {
            this.testPlan(this.filters);
        } else {
            this.startNs = System.nanoTime();
            if (this.filters.length <= 7) {
                this.calculateBruteForceAll();
            } else {
                this.calculateBruteForceSome();
                this.random = new Random(0L);
                this.calculateGenetic();
            }
        }
    }

    private void calculateFakePlan() {
        this.cost = -1.0;
        this.bestPlan = new Plan(this.filters, this.filters.length, this.condition);
    }

    private boolean canStop(int x) {
        return (x & 0x7F) == 0 && this.cost >= 0.0 && (double)(System.nanoTime() - this.startNs) > this.cost * 100000.0;
    }

    private void calculateBruteForceAll() {
        TableFilter[] list = new TableFilter[this.filters.length];
        Permutations<TableFilter> p = Permutations.create(this.filters, list);
        int x = 0;
        while (!this.canStop(x) && p.next()) {
            this.testPlan(list);
            ++x;
        }
    }

    private void calculateBruteForceSome() {
        int bruteForce = Optimizer.getMaxBruteForceFilters(this.filters.length);
        TableFilter[] list = new TableFilter[this.filters.length];
        Permutations<TableFilter> p = Permutations.create(this.filters, list, bruteForce);
        int x = 0;
        while (!this.canStop(x) && p.next()) {
            TableFilter[] tableFilterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                TableFilter f = tableFilterArray[n2];
                f.setUsed(false);
                ++n2;
            }
            int i = 0;
            while (i < bruteForce) {
                list[i].setUsed(true);
                ++i;
            }
            i = bruteForce;
            while (i < this.filters.length) {
                double costPart = -1.0;
                int bestPart = -1;
                int j = 0;
                while (j < this.filters.length) {
                    if (!this.filters[j].isUsed()) {
                        if (i == this.filters.length - 1) {
                            bestPart = j;
                            break;
                        }
                        list[i] = this.filters[j];
                        Plan part = new Plan(list, i + 1, this.condition);
                        double costNow = part.calculateCost(this.session, this.allColumnsSet);
                        if (costPart < 0.0 || costNow < costPart) {
                            costPart = costNow;
                            bestPart = j;
                        }
                    }
                    ++j;
                }
                this.filters[bestPart].setUsed(true);
                list[i] = this.filters[bestPart];
                ++i;
            }
            this.testPlan(list);
            ++x;
        }
    }

    private void calculateGenetic() {
        TableFilter[] best = new TableFilter[this.filters.length];
        TableFilter[] list = new TableFilter[this.filters.length];
        int x = 0;
        while (x < 500) {
            boolean generateRandom;
            if (this.canStop(x)) break;
            boolean bl = generateRandom = (x & 0x7F) == 0;
            if (!generateRandom) {
                System.arraycopy(best, 0, list, 0, this.filters.length);
                if (!this.shuffleTwo(list)) {
                    generateRandom = true;
                }
            }
            if (generateRandom) {
                this.switched = new BitSet();
                System.arraycopy(this.filters, 0, best, 0, this.filters.length);
                this.shuffleAll(best);
                System.arraycopy(best, 0, list, 0, this.filters.length);
            }
            if (this.testPlan(list)) {
                this.switched = new BitSet();
                System.arraycopy(list, 0, best, 0, this.filters.length);
            }
            ++x;
        }
    }

    private boolean testPlan(TableFilter[] list) {
        Plan p = new Plan(list, list.length, this.condition);
        double costNow = p.calculateCost(this.session, this.allColumnsSet);
        if (this.cost < 0.0 || costNow < this.cost) {
            this.cost = costNow;
            this.bestPlan = p;
            return true;
        }
        return false;
    }

    private void shuffleAll(TableFilter[] f) {
        int i = 0;
        while (i < f.length - 1) {
            int j = i + this.random.nextInt(f.length - i);
            if (j != i) {
                TableFilter temp = f[i];
                f[i] = f[j];
                f[j] = temp;
            }
            ++i;
        }
    }

    private boolean shuffleTwo(TableFilter[] f) {
        int a = 0;
        int b = 0;
        int i = 0;
        while (i < 20) {
            a = this.random.nextInt(f.length);
            if (a != (b = this.random.nextInt(f.length))) {
                int s;
                if (a < b) {
                    int temp = a;
                    a = b;
                    b = temp;
                }
                if (!this.switched.get(s = a * f.length + b)) {
                    this.switched.set(s);
                    break;
                }
            }
            ++i;
        }
        if (i == 20) {
            return false;
        }
        TableFilter temp = f[a];
        f[a] = f[b];
        f[b] = temp;
        return true;
    }

    void optimize(boolean parse) {
        if (parse) {
            this.calculateFakePlan();
        } else {
            this.calculateBestPlan();
            this.bestPlan.removeUnusableIndexConditions();
        }
        TableFilter[] f2 = this.bestPlan.getFilters();
        this.topFilter = f2[0];
        int i = 0;
        while (i < f2.length - 1) {
            f2[i].addJoin(f2[i + 1], false, null);
            ++i;
        }
        if (parse) {
            return;
        }
        TableFilter[] tableFilterArray = f2;
        int n = f2.length;
        int n2 = 0;
        while (n2 < n) {
            TableFilter f = tableFilterArray[n2];
            PlanItem item = this.bestPlan.getItem(f);
            f.setPlanItem(item);
            ++n2;
        }
    }

    public TableFilter getTopFilter() {
        return this.topFilter;
    }

    double getCost() {
        return this.cost;
    }
}

