/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.h2.command.query.ForUpdate;
import org.h2.command.query.Optimizer;
import org.h2.command.query.Query;
import org.h2.command.query.SelectGroups;
import org.h2.command.query.SelectListColumnResolver;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.SessionLocal;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.Wildcard;
import org.h2.expression.analysis.DataAnalysisOperation;
import org.h2.expression.analysis.Window;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.expression.condition.ConditionLocalAndGlobal;
import org.h2.expression.function.CoalesceFunction;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexSort;
import org.h2.index.QueryExpressionIndex;
import org.h2.message.DbException;
import org.h2.mode.DefaultNullOrdering;
import org.h2.result.LazyResult;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableType;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueRow;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Select
extends Query {
    TableFilter topTableFilter;
    private final ArrayList<TableFilter> filters = Utils.newSmallArrayList();
    private final ArrayList<TableFilter> topFilters = Utils.newSmallArrayList();
    private Select parentSelect;
    private Expression condition;
    private Expression having;
    private Expression qualify;
    private Expression[] distinctExpressions;
    private int[] distinctIndexes;
    private ArrayList<Expression> group;
    int[] groupIndex;
    boolean[] groupByExpression;
    SelectGroups groupData;
    private int havingIndex;
    private int qualifyIndex;
    private int[] groupByCopies;
    private boolean isExplicitTable;
    boolean isGroupQuery;
    private boolean isGroupSortedQuery;
    private boolean isWindowQuery;
    private ForUpdate forUpdate;
    private double cost;
    private boolean isQuickAggregateQuery;
    private boolean isDistinctQuery;
    private int indexSortedColumns;
    private boolean isGroupWindowStage2;
    private HashMap<String, Window> windows;

    public Select(SessionLocal session, Select parentSelect) {
        super(session);
        this.parentSelect = parentSelect;
    }

    @Override
    public boolean isUnion() {
        return false;
    }

    public void addTableFilter(TableFilter filter, boolean isTop) {
        this.filters.add(filter);
        if (isTop) {
            this.topFilters.add(filter);
        }
    }

    public ArrayList<TableFilter> getTopFilters() {
        return this.topFilters;
    }

    public void setExpressions(ArrayList<Expression> expressions) {
        this.expressions = expressions;
    }

    public void setExplicitTable() {
        this.setWildcard();
        this.isExplicitTable = true;
    }

    public void setWildcard() {
        this.expressions = new ArrayList(1);
        this.expressions.add(new Wildcard(null, null));
    }

    public void setGroupQuery() {
        this.isGroupQuery = true;
    }

    public void setWindowQuery() {
        this.isWindowQuery = true;
    }

    public void setGroupBy(ArrayList<Expression> group) {
        this.group = group;
    }

    public ArrayList<Expression> getGroupBy() {
        return this.group;
    }

    public SelectGroups getGroupDataIfCurrent(boolean window) {
        return this.groupData != null && (window || this.groupData.isCurrentGroup()) ? this.groupData : null;
    }

    public void setDistinct() {
        if (this.distinctExpressions != null) {
            throw DbException.getUnsupportedException("DISTINCT ON together with DISTINCT");
        }
        this.distinct = true;
    }

    public void setDistinct(Expression[] distinctExpressions) {
        if (this.distinct) {
            throw DbException.getUnsupportedException("DISTINCT ON together with DISTINCT");
        }
        this.distinctExpressions = distinctExpressions;
    }

    @Override
    public boolean isAnyDistinct() {
        return this.distinct || this.distinctExpressions != null;
    }

    public boolean addWindow(String name, Window window) {
        if (this.windows == null) {
            this.windows = new HashMap();
        }
        return this.windows.put(name, window) == null;
    }

    public Window getWindow(String name) {
        return this.windows != null ? this.windows.get(name) : null;
    }

    public void addCondition(Expression cond) {
        this.condition = this.condition == null ? cond : new ConditionAndOr(0, cond, this.condition);
    }

    public Expression getCondition() {
        return this.condition;
    }

    /*
     * Unable to fully structure code
     */
    private LazyResult queryGroupSorted(int columnCount, ResultTarget result, long offset, boolean quickOffset) {
        lazyResult = new LazyResultGroupSorted(this.expressionArray, columnCount);
        Select.skipOffset(lazyResult, offset, quickOffset);
        if (result != null) ** GOTO lbl6
        return lazyResult;
lbl-1000:
        // 1 sources

        {
            result.addRow(lazyResult.currentRow());
lbl6:
            // 2 sources

            ** while (lazyResult.next())
        }
lbl7:
        // 1 sources

        return null;
    }

    Value[] createGroupSortedRow(Value[] keyValues, int columnCount) {
        Value[] row = this.constructGroupResultRow(keyValues, columnCount);
        if (this.isHavingNullOrFalse(row)) {
            return null;
        }
        return this.rowForResult(row, columnCount);
    }

    private Value[] rowForResult(Value[] row, int columnCount) {
        if (columnCount == this.resultColumnCount) {
            return row;
        }
        return Arrays.copyOf(row, this.resultColumnCount);
    }

    private boolean isHavingNullOrFalse(Value[] row) {
        return this.havingIndex >= 0 && !row[this.havingIndex].isTrue();
    }

    private Index getGroupSortedIndex() {
        if (this.groupIndex == null || this.groupByExpression == null) {
            return null;
        }
        ArrayList<Index> indexes = this.topTableFilter.getTable().getIndexes();
        if (indexes != null) {
            for (Index index : indexes) {
                if (index.getIndexType().isScan() || index.getIndexType().isHash() || !this.isGroupSortedIndex(this.topTableFilter, index)) continue;
                return index;
            }
        }
        return null;
    }

    private boolean isGroupSortedIndex(TableFilter tableFilter, Index index) {
        Column[] indexColumns = index.getColumns();
        boolean[] grouped = new boolean[indexColumns.length];
        int i = 0;
        int size = this.expressions.size();
        while (i < size) {
            block7: {
                if (this.groupByExpression[i]) {
                    Expression expr = ((Expression)this.expressions.get(i)).getNonAliasExpression();
                    if (!(expr instanceof ExpressionColumn)) {
                        return false;
                    }
                    ExpressionColumn exprCol = (ExpressionColumn)expr;
                    int j = 0;
                    while (j < indexColumns.length) {
                        if (tableFilter == exprCol.getTableFilter() && indexColumns[j].equals(exprCol.getColumn())) {
                            grouped[j] = true;
                            break block7;
                        }
                        ++j;
                    }
                    return false;
                }
            }
            ++i;
        }
        i = 1;
        while (i < grouped.length) {
            if (!grouped[i - 1] && grouped[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean isConditionMetForUpdate() {
        if (this.isConditionMet()) {
            int count = this.filters.size();
            boolean notChanged = true;
            int i = 0;
            while (i < count) {
                TableFilter tableFilter = this.filters.get(i);
                if (!tableFilter.isJoinOuter() && !tableFilter.isJoinOuterIndirect()) {
                    Row row = tableFilter.get();
                    Table table = tableFilter.getTable();
                    if (table.isRowLockable()) {
                        Row lockedRow = table.lockRow(this.session, row, this.forUpdate.getTimeoutMillis());
                        if (lockedRow == null) {
                            return false;
                        }
                        if (!row.hasSharedData(lockedRow)) {
                            tableFilter.set(lockedRow);
                            notChanged = false;
                        }
                    }
                }
                ++i;
            }
            return notChanged || this.isConditionMet();
        }
        return false;
    }

    boolean isConditionMet() {
        return this.condition == null || this.condition.getBooleanValue(this.session);
    }

    private void queryWindow(int columnCount, LocalResult result, long offset, boolean quickOffset) {
        this.initGroupData(columnCount);
        try {
            this.gatherGroup(columnCount, 2);
            this.processGroupResult(columnCount, result, offset, quickOffset, false);
        }
        finally {
            this.groupData.reset();
        }
    }

    private void queryGroupWindow(int columnCount, LocalResult result, long offset, boolean quickOffset) {
        this.initGroupData(columnCount);
        try {
            this.gatherGroup(columnCount, 1);
            try {
                this.isGroupWindowStage2 = true;
                while (this.groupData.next() != null) {
                    if (this.havingIndex < 0 || ((Expression)this.expressions.get(this.havingIndex)).getBooleanValue(this.session)) {
                        this.updateAgg(columnCount, 2);
                        continue;
                    }
                    this.groupData.remove();
                }
                this.groupData.done();
                this.processGroupResult(columnCount, result, offset, quickOffset, false);
            }
            finally {
                this.isGroupWindowStage2 = false;
            }
        }
        finally {
            this.groupData.reset();
        }
    }

    private void queryGroup(int columnCount, LocalResult result, long offset, boolean quickOffset) {
        this.initGroupData(columnCount);
        try {
            this.gatherGroup(columnCount, 1);
            this.processGroupResult(columnCount, result, offset, quickOffset, true);
        }
        finally {
            this.groupData.reset();
        }
    }

    private void initGroupData(int columnCount) {
        if (this.groupData == null) {
            this.setGroupData(SelectGroups.getInstance(this.session, this.expressions, this.isGroupQuery, this.groupIndex));
        } else {
            this.updateAgg(columnCount, 0);
        }
        this.groupData.reset();
    }

    void setGroupData(SelectGroups groupData) {
        this.groupData = groupData;
        this.topTableFilter.visit(f -> {
            Select s = f.getSelect();
            if (s != null) {
                s.groupData = groupData;
            }
        });
    }

    private void gatherGroup(int columnCount, int stage) {
        long rowNumber = 0L;
        this.setCurrentRowNumber(0L);
        while (this.topTableFilter.next()) {
            this.setCurrentRowNumber(rowNumber + 1L);
            if (!(this.forUpdate != null ? this.isConditionMetForUpdate() : this.isConditionMet())) continue;
            ++rowNumber;
            this.groupData.nextSource();
            this.updateAgg(columnCount, stage);
        }
        this.groupData.done();
    }

    void updateAgg(int columnCount, int stage) {
        int i = 0;
        while (i < columnCount) {
            if (!(this.groupByExpression != null && this.groupByExpression[i] || this.groupByCopies != null && this.groupByCopies[i] >= 0)) {
                Expression expr = (Expression)this.expressions.get(i);
                expr.updateAggregate(this.session, stage);
            }
            ++i;
        }
    }

    private void processGroupResult(int columnCount, LocalResult result, long offset, boolean quickOffset, boolean withHaving) {
        ValueRow currentGroupsKey;
        while ((currentGroupsKey = this.groupData.next()) != null) {
            Value[] row = this.constructGroupResultRow(currentGroupsKey.getList(), columnCount);
            if (withHaving && this.isHavingNullOrFalse(row) || this.qualifyIndex >= 0 && !row[this.qualifyIndex].isTrue()) continue;
            if (quickOffset && offset > 0L) {
                --offset;
                continue;
            }
            result.addRow(this.rowForResult(row, columnCount));
        }
    }

    private Value[] constructGroupResultRow(Value[] keyValues, int columnCount) {
        int i;
        Value[] row = new Value[columnCount];
        if (this.groupIndex != null) {
            i = 0;
            int l = this.groupIndex.length;
            while (i < l) {
                row[this.groupIndex[i]] = keyValues[i];
                ++i;
            }
        }
        i = 0;
        while (i < columnCount) {
            if (this.groupByExpression == null || !this.groupByExpression[i]) {
                int original;
                row[i] = this.groupByCopies != null && (original = this.groupByCopies[i]) >= 0 ? row[original] : ((Expression)this.expressions.get(i)).getValue(this.session);
            }
            ++i;
        }
        return row;
    }

    private List<IndexSort> getIndexSorts() {
        Column[] sortCols;
        if (this.sort == null) {
            return null;
        }
        ArrayList<Column> sortColumns = Utils.newSmallArrayList();
        int[] queryColumnIndexes = this.sort.getQueryColumnIndexes();
        int queryIndexesLength = queryColumnIndexes.length;
        int[] sortIndex = new int[queryIndexesLength];
        int sortedColumns = 0;
        boolean needMore = false;
        int i = 0;
        while (i < queryIndexesLength) {
            int idx = queryColumnIndexes[i];
            if (idx < 0 || idx >= this.expressions.size()) {
                throw DbException.getInvalidValueException("ORDER BY", idx + 1);
            }
            Expression expr = (Expression)this.expressions.get(idx);
            if (!(expr = expr.getNonAliasExpression()).isConstant()) {
                if (!(expr instanceof ExpressionColumn)) {
                    needMore = true;
                    break;
                }
                ExpressionColumn exprCol = (ExpressionColumn)expr;
                if (exprCol.getTableFilter() != this.topTableFilter) {
                    needMore = true;
                    break;
                }
                sortColumns.add(exprCol.getColumn());
                sortIndex[sortedColumns++] = i;
            }
            ++i;
        }
        if (sortedColumns == 0) {
            if (needMore) {
                return null;
            }
            return List.of(new IndexSort(this.topTableFilter.getTable().getScanIndex(this.session), false));
        }
        int[] sortTypes = this.sort.getSortTypesWithNullOrdering();
        if (sortedColumns == 1) {
            Index index;
            Column column = (Column)sortColumns.get(0);
            if (column.getColumnId() == -1 && (index = this.topTableFilter.getTable().getScanIndex(this.session)).isRowIdIndex()) {
                return List.of(new IndexSort(index, needMore ? sortedColumns : Integer.MAX_VALUE, (sortTypes[sortIndex[0]] & 1) != 0));
            }
            sortCols = new Column[]{column};
        } else {
            sortCols = sortColumns.toArray(new Column[0]);
        }
        ArrayList<Index> list = this.topTableFilter.getTable().getIndexes();
        if (list == null) {
            return null;
        }
        DefaultNullOrdering defaultNullOrdering = this.getDatabase().getDefaultNullOrdering();
        ArrayList<IndexSort> indexSorts = Utils.newSmallArrayList();
        block1: for (Index index : list) {
            if (index.getCreateSQL() == null || index.getIndexType().isHash()) continue;
            IndexColumn[] indexCols = index.getIndexColumns();
            int count = Math.min(indexCols.length, sortedColumns);
            boolean reverse = false;
            int j = 0;
            while (j < count) {
                boolean mismatch;
                IndexColumn idxCol = indexCols[j];
                Column sortCol = sortCols[j];
                boolean bl = mismatch = idxCol.column != sortCol;
                if (!mismatch) {
                    if (sortCol.isNullable()) {
                        int o1 = defaultNullOrdering.addExplicitNullOrdering(idxCol.sortType);
                        int o2 = sortTypes[sortIndex[j]];
                        if (j == 0) {
                            if (o1 != o2) {
                                if (o1 == SortOrder.inverse(o2)) {
                                    reverse = true;
                                } else {
                                    mismatch = true;
                                }
                            }
                        } else if (o1 != (reverse ? SortOrder.inverse(o2) : o2)) {
                            mismatch = true;
                        }
                    } else {
                        boolean different;
                        boolean bl2 = different = (idxCol.sortType & 1) != (sortTypes[sortIndex[j]] & 1);
                        if (j == 0) {
                            reverse = different;
                        } else {
                            mismatch = different ^ reverse;
                        }
                    }
                }
                if (mismatch) {
                    if (j <= 0) continue block1;
                    indexSorts.add(new IndexSort(index, j, reverse));
                    continue block1;
                }
                ++j;
            }
            indexSorts.add(new IndexSort(index, needMore || count < sortedColumns ? count : Integer.MAX_VALUE, reverse));
        }
        indexSorts.sort(null);
        return indexSorts;
    }

    private void queryDistinct(ResultTarget result, long offset, long limitRows, boolean withTies, boolean quickOffset) {
        if (limitRows > 0L && offset > 0L && (limitRows += offset) < 0L) {
            limitRows = Long.MAX_VALUE;
        }
        long rowNumber = 0L;
        this.setCurrentRowNumber(0L);
        Index index = this.topTableFilter.getIndex();
        SearchRow first = null;
        int columnIndex = index.getColumns()[0].getColumnId();
        if (!quickOffset) {
            offset = 0L;
        }
        while (true) {
            this.setCurrentRowNumber(++rowNumber);
            Cursor cursor = index.findNext(this.session, first, null);
            if (!cursor.next()) break;
            SearchRow found = cursor.getSearchRow();
            Value value = found.getValue(columnIndex);
            if (first == null) {
                first = index.getRowFactory().createRow();
            }
            first.setValue(columnIndex, value);
            if (offset > 0L) {
                --offset;
                continue;
            }
            result.addRow(value);
            if (!(this.sort != null && this.indexSortedColumns != Integer.MAX_VALUE || limitRows <= 0L || rowNumber < limitRows || withTies)) break;
        }
    }

    private LazyResult queryFlat(int columnCount, ResultTarget result, long offset, long limitRows, boolean withTies, QuickOffset quickOffset) {
        if (limitRows > 0L && offset > 0L && quickOffset != QuickOffset.YES && (limitRows += offset) < 0L) {
            limitRows = Long.MAX_VALUE;
        }
        LazyResultQueryFlat lazyResult = new LazyResultQueryFlat(this.expressionArray, columnCount, this.forUpdate != null);
        Select.skipOffset(lazyResult, offset, quickOffset == QuickOffset.YES);
        if (result == null) {
            return lazyResult;
        }
        if (limitRows == Long.MAX_VALUE || limitRows < 0L || this.sort != null && this.indexSortedColumns == 0 || withTies && quickOffset == QuickOffset.NO) {
            while (lazyResult.next()) {
                result.addRow(lazyResult.currentRow());
            }
        } else {
            this.readWithLimit(result, limitRows, withTies, lazyResult);
        }
        return null;
    }

    private void readWithLimit(ResultTarget result, long limitRows, boolean withTies, LazyResultQueryFlat lazyResult) {
        Value[] last = null;
        while (result.getRowCount() < limitRows && lazyResult.next()) {
            last = lazyResult.currentRow();
            result.addRow(last);
        }
        if (this.sort != null && last != null) {
            if (this.indexSortedColumns < Integer.MAX_VALUE) {
                while (lazyResult.next()) {
                    Value[] row = lazyResult.currentRow();
                    if (this.sort.compare(last, row, this.indexSortedColumns) == 0) {
                        result.addRow(row);
                        continue;
                    }
                    break;
                }
            } else if (withTies) {
                while (lazyResult.next()) {
                    Value[] row = lazyResult.currentRow();
                    if (this.sort.compare(last, row) != 0) break;
                    result.addRow(row);
                }
                result.limitsWereApplied();
            }
        }
    }

    private static void skipOffset(LazyResultSelect lazyResult, long offset, boolean quickOffset) {
        if (quickOffset) {
            while (offset > 0L && lazyResult.skip()) {
                --offset;
            }
        }
    }

    private void queryQuick(int columnCount, ResultTarget result, boolean skipResult) {
        Value[] row = new Value[columnCount];
        int i = 0;
        while (i < columnCount) {
            Expression expr = (Expression)this.expressions.get(i);
            row[i] = expr.getValue(this.session);
            ++i;
        }
        if (!skipResult) {
            result.addRow(row);
        }
    }

    @Override
    protected ResultInterface queryWithoutCache(long maxRows, ResultTarget target) {
        QuickOffset quickOffset;
        this.disableLazyForJoinSubqueries(this.topTableFilter);
        Query.OffsetFetch offsetFetch = this.getOffsetFetch(maxRows);
        long offset = offsetFetch.offset;
        long fetch = offsetFetch.fetch;
        boolean fetchPercent = offsetFetch.fetchPercent;
        boolean lazy = this.session.isLazyQueryExecution() && target == null && this.forUpdate == null && !this.isQuickAggregateQuery && fetch != 0L && !fetchPercent && !this.withTies && offset == 0L && this.isReadOnly();
        int columnCount = this.expressions.size();
        LocalResult result = null;
        if (!(lazy || target != null && this.getDatabase().getSettings().optimizeInsertFromSelect)) {
            result = this.createLocalResult(result);
        }
        QuickOffset quickOffset2 = quickOffset = fetchPercent ? QuickOffset.NO : QuickOffset.YES;
        if (this.sort != null && (this.indexSortedColumns != Integer.MAX_VALUE || this.isAnyDistinct())) {
            result = this.createLocalResult(result);
            result.setSortOrder(this.sort);
            if (this.indexSortedColumns != Integer.MAX_VALUE) {
                QuickOffset quickOffset3 = quickOffset = this.indexSortedColumns > 0 ? QuickOffset.PARTIAL : QuickOffset.NO;
            }
        }
        if (this.distinct) {
            result = this.createLocalResult(result);
            if (!this.isDistinctQuery) {
                quickOffset = QuickOffset.NO;
                result.setDistinct();
            }
        } else if (this.distinctExpressions != null) {
            quickOffset = QuickOffset.NO;
            result = this.createLocalResult(result);
            result.setDistinct(this.distinctIndexes);
        }
        if (this.isWindowQuery || this.isGroupQuery && !this.isGroupSortedQuery) {
            result = this.createLocalResult(result);
        }
        if (!(lazy || fetch < 0L && offset <= 0L)) {
            result = this.createLocalResult(result);
        }
        this.topTableFilter.startQuery(this.session);
        this.topTableFilter.reset();
        this.topTableFilter.lock(this.session);
        ResultTarget to = result != null ? result : target;
        lazy &= to == null;
        LazyResult lazyResult = null;
        if (fetch != 0L) {
            long limit;
            long l = limit = fetchPercent ? -1L : fetch;
            if (this.isQuickAggregateQuery) {
                this.queryQuick(columnCount, to, quickOffset == QuickOffset.YES && offset > 0L);
            } else if (this.isWindowQuery) {
                if (this.isGroupQuery) {
                    this.queryGroupWindow(columnCount, result, offset, quickOffset == QuickOffset.YES);
                } else {
                    this.queryWindow(columnCount, result, offset, quickOffset == QuickOffset.YES);
                }
            } else if (this.isGroupQuery) {
                if (this.isGroupSortedQuery) {
                    lazyResult = this.queryGroupSorted(columnCount, to, offset, quickOffset == QuickOffset.YES);
                } else {
                    this.queryGroup(columnCount, result, offset, quickOffset == QuickOffset.YES);
                }
            } else if (this.isDistinctQuery) {
                this.queryDistinct(to, offset, limit, this.withTies, quickOffset == QuickOffset.YES);
            } else {
                lazyResult = this.queryFlat(columnCount, to, offset, limit, this.withTies, quickOffset);
            }
            if (quickOffset == QuickOffset.YES) {
                offset = 0L;
            }
        }
        assert (lazy == (lazyResult != null)) : lazy;
        if (lazyResult != null) {
            if (fetch > 0L) {
                lazyResult.setLimit(fetch);
            }
            if (this.randomAccessResult) {
                return this.convertToDistinct(lazyResult);
            }
            return lazyResult;
        }
        if (result != null) {
            return this.finishResult(result, offset, fetch, fetchPercent, target);
        }
        return null;
    }

    private void disableLazyForJoinSubqueries(TableFilter top) {
        if (this.session.isLazyQueryExecution()) {
            top.visit(f -> {
                QueryExpressionIndex idx;
                if (f != top && f.getTable().getTableType() == TableType.VIEW && (idx = (QueryExpressionIndex)f.getIndex()) != null && idx.getQuery() != null) {
                    idx.getQuery().setNeverLazy(true);
                }
            });
        }
    }

    private LocalResult createLocalResult(LocalResult old) {
        return old != null ? old : new LocalResult(this.session, this.expressionArray, this.visibleColumnCount, this.resultColumnCount);
    }

    private void expandColumnList() {
        int i = 0;
        while (i < this.expressions.size()) {
            Expression expr = (Expression)this.expressions.get(i);
            if (!(expr instanceof Wildcard)) {
                ++i;
                continue;
            }
            this.expressions.remove(i);
            Wildcard w = (Wildcard)expr;
            String tableAlias = w.getTableAlias();
            boolean hasExceptColumns = w.getExceptColumns() != null;
            HashMap<Column, ExpressionColumn> exceptTableColumns = null;
            if (tableAlias == null) {
                if (hasExceptColumns) {
                    for (TableFilter filter : this.filters) {
                        w.mapColumns(filter, 1, 0);
                    }
                    exceptTableColumns = w.mapExceptColumns();
                }
                for (TableFilter filter : this.filters) {
                    i = this.expandColumnList(filter, i, false, exceptTableColumns);
                }
                continue;
            }
            Database db = this.getDatabase();
            String schemaName = w.getSchemaName();
            TableFilter filter = null;
            for (TableFilter f : this.filters) {
                if (!db.equalsIdentifiers(tableAlias, f.getTableAlias()) || schemaName != null && !db.equalsIdentifiers(schemaName, f.getSchemaName())) continue;
                if (hasExceptColumns) {
                    w.mapColumns(f, 1, 0);
                    exceptTableColumns = w.mapExceptColumns();
                }
                filter = f;
                break;
            }
            if (filter == null) {
                throw DbException.get(42102, tableAlias);
            }
            i = this.expandColumnList(filter, i, true, exceptTableColumns);
        }
    }

    private int expandColumnList(TableFilter filter, int index, boolean forAlias, HashMap<Column, ExpressionColumn> except) {
        String schema = filter.getSchemaName();
        String alias = filter.getTableAlias();
        if (forAlias) {
            Column[] columnArray = filter.getTable().getColumns();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column c = columnArray[n2];
                index = this.addExpandedColumn(filter, index, except, schema, alias, c);
                ++n2;
            }
        } else {
            LinkedHashMap<Column, Column> commonJoinColumns = filter.getCommonJoinColumns();
            if (commonJoinColumns != null) {
                TableFilter replacementFilter = filter.getCommonJoinColumnsFilter();
                String replacementSchema = replacementFilter.getSchemaName();
                String replacementAlias = replacementFilter.getTableAlias();
                for (Map.Entry<Column, Column> entry : commonJoinColumns.entrySet()) {
                    Column left = entry.getKey();
                    Column right = entry.getValue();
                    if (filter.isCommonJoinColumnToExclude(right) || except != null && (except.remove(left) != null || except.remove(right) != null)) continue;
                    Database database = this.getDatabase();
                    Expression e = left == right || DataType.hasTotalOrdering(left.getType().getValueType()) && DataType.hasTotalOrdering(right.getType().getValueType()) ? new ExpressionColumn(database, replacementSchema, replacementAlias, replacementFilter.getColumnName(right)) : new Alias(new CoalesceFunction(0, new ExpressionColumn(database, schema, alias, filter.getColumnName(left)), new ExpressionColumn(database, replacementSchema, replacementAlias, replacementFilter.getColumnName(right))), left.getName(), true);
                    this.expressions.add(index++, e);
                }
            }
            Column[] columnArray = filter.getTable().getColumns();
            int n = columnArray.length;
            int n3 = 0;
            while (n3 < n) {
                Column c = columnArray[n3];
                if (!(commonJoinColumns != null && commonJoinColumns.containsKey(c) || filter.isCommonJoinColumnToExclude(c))) {
                    index = this.addExpandedColumn(filter, index, except, schema, alias, c);
                }
                ++n3;
            }
        }
        return index;
    }

    private int addExpandedColumn(TableFilter filter, int index, HashMap<Column, ExpressionColumn> except, String schema, String alias, Column c) {
        if ((except == null || except.remove(c) == null) && c.getVisible()) {
            ExpressionColumn ec = new ExpressionColumn(this.getDatabase(), schema, alias, filter.getColumnName(c));
            this.expressions.add(index++, ec);
        }
        return index;
    }

    @Override
    public void init() {
        ArrayList<String> expressionSQL;
        if (this.checkInit) {
            throw DbException.getInternalError();
        }
        this.filters.sort(TableFilter.ORDER_IN_FROM_COMPARATOR);
        this.expandColumnList();
        this.visibleColumnCount = this.expressions.size();
        if (this.visibleColumnCount > 16384) {
            throw DbException.get(54011, "16384");
        }
        if (this.distinctExpressions != null || this.orderList != null || this.group != null) {
            expressionSQL = new ArrayList<String>(this.visibleColumnCount);
            int i = 0;
            while (i < this.visibleColumnCount) {
                Expression expr = (Expression)this.expressions.get(i);
                expr = expr.getNonAliasExpression();
                expressionSQL.add(expr.getSQL(0, 2));
                ++i;
            }
        } else {
            expressionSQL = null;
        }
        if (this.distinctExpressions != null) {
            BitSet set = new BitSet();
            Expression[] expressionArray = this.distinctExpressions;
            int n = this.distinctExpressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression e = expressionArray[n2];
                set.set(this.initExpression(expressionSQL, e, false, this.filters));
                ++n2;
            }
            int idx = 0;
            int cnt = set.cardinality();
            this.distinctIndexes = new int[cnt];
            int i = 0;
            while (i < cnt) {
                idx = set.nextSetBit(idx);
                this.distinctIndexes[i] = idx++;
                ++i;
            }
        }
        if (this.orderList != null) {
            this.initOrder(expressionSQL, this.isAnyDistinct(), this.filters);
        }
        this.resultColumnCount = this.expressions.size();
        if (this.having != null) {
            this.expressions.add(this.having);
            this.havingIndex = this.expressions.size() - 1;
            this.having = null;
        } else {
            this.havingIndex = -1;
        }
        if (this.qualify != null) {
            this.expressions.add(this.qualify);
            this.qualifyIndex = this.expressions.size() - 1;
            this.qualify = null;
        } else {
            this.qualifyIndex = -1;
        }
        if (this.withTies && !this.hasOrder()) {
            throw DbException.get(90122);
        }
        Database db = this.getDatabase();
        if (this.group != null) {
            block31: {
                int size = this.group.size();
                int expSize = expressionSQL.size();
                int fullExpSize = this.expressions.size();
                if (fullExpSize > expSize) {
                    expressionSQL.ensureCapacity(fullExpSize);
                    int i = expSize;
                    while (i < fullExpSize) {
                        expressionSQL.add(((Expression)this.expressions.get(i)).getSQL(0, 2));
                        ++i;
                    }
                }
                this.groupIndex = new int[size];
                int i = 0;
                while (i < size) {
                    Expression expr = this.group.get(i);
                    String sql = expr.getSQL(0, 2);
                    int found = -1;
                    int j = 0;
                    while (j < expSize) {
                        String s2 = expressionSQL.get(j);
                        if (db.equalsIdentifiers(s2, sql)) {
                            found = this.mergeGroupByExpressions(db, j, expressionSQL, false);
                            break;
                        }
                        ++j;
                    }
                    if (found < 0) {
                        j = 0;
                        while (j < expSize) {
                            Expression e = (Expression)this.expressions.get(j);
                            if (db.equalsIdentifiers(sql, e.getAlias(this.session, j))) {
                                found = this.mergeGroupByExpressions(db, j, expressionSQL, true);
                                break;
                            }
                            sql = expr.getAlias(this.session, j);
                            if (db.equalsIdentifiers(sql, e.getAlias(this.session, j))) {
                                found = this.mergeGroupByExpressions(db, j, expressionSQL, true);
                                break;
                            }
                            ++j;
                        }
                    }
                    if (found < 0) {
                        int index;
                        this.groupIndex[i] = index = this.expressions.size();
                        this.expressions.add(expr);
                    } else {
                        this.groupIndex[i] = found;
                    }
                    ++i;
                }
                if (this.groupByCopies != null) {
                    int[] nArray = this.groupByCopies;
                    int n = this.groupByCopies.length;
                    int n3 = 0;
                    while (n3 < n) {
                        i = nArray[n3];
                        if (i < 0) {
                            ++n3;
                            continue;
                        }
                        break block31;
                    }
                    this.groupByCopies = null;
                }
            }
            this.groupByExpression = new boolean[this.expressions.size()];
            int[] nArray = this.groupIndex;
            int n = this.groupIndex.length;
            int n4 = 0;
            while (n4 < n) {
                int gi = nArray[n4];
                this.groupByExpression[gi] = true;
                ++n4;
            }
            this.group = null;
        }
        for (TableFilter f : this.filters) {
            this.mapColumns(f, 0);
        }
        this.mapCondition(this.havingIndex);
        this.mapCondition(this.qualifyIndex);
        this.checkInit = true;
    }

    private void mapCondition(int index) {
        if (index >= 0) {
            Expression expr = (Expression)this.expressions.get(index);
            SelectListColumnResolver res = new SelectListColumnResolver(this);
            expr.mapColumns(res, 0, 0);
        }
    }

    private int mergeGroupByExpressions(Database db, int index, ArrayList<String> expressionSQL, boolean scanPrevious) {
        if (this.groupByCopies != null) {
            int c = this.groupByCopies[index];
            if (c >= 0) {
                return c;
            }
            if (c == -2) {
                return index;
            }
        } else {
            this.groupByCopies = new int[expressionSQL.size()];
            Arrays.fill(this.groupByCopies, -1);
        }
        String sql = expressionSQL.get(index);
        if (scanPrevious) {
            int i = 0;
            while (i < index) {
                if (db.equalsIdentifiers(sql, expressionSQL.get(i))) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        int l = expressionSQL.size();
        int i = index + 1;
        while (i < l) {
            if (db.equalsIdentifiers(sql, expressionSQL.get(i))) {
                this.groupByCopies[i] = index;
            }
            ++i;
        }
        this.groupByCopies[index] = -2;
        return index;
    }

    @Override
    public void prepareExpressions() {
        Mode.ExpressionNames expressionNames;
        if (this.orderList != null) {
            this.prepareOrder(this.orderList, this.expressions.size());
        }
        if ((expressionNames = this.session.getMode().expressionNames) == Mode.ExpressionNames.ORIGINAL_SQL || expressionNames == Mode.ExpressionNames.POSTGRESQL_STYLE) {
            this.optimizeExpressionsAndPreserveAliases();
        } else {
            int i = 0;
            while (i < this.expressions.size()) {
                this.expressions.set(i, ((Expression)this.expressions.get(i)).optimize(this.session));
                ++i;
            }
        }
        if (this.sort != null) {
            this.cleanupOrder();
        }
        if (this.condition != null) {
            this.condition = this.condition.optimizeCondition(this.session);
        }
        if (this.isGroupQuery && this.groupIndex == null && this.havingIndex < 0 && this.qualifyIndex < 0 && this.condition == null && this.filters.size() == 1) {
            this.isQuickAggregateQuery = this.isEverything(ExpressionVisitor.getOptimizableVisitor(this.filters.get(0).getTable()));
        }
        this.expressionArray = this.expressions.toArray(new Expression[0]);
    }

    @Override
    public void preparePlan() {
        Index index;
        Index current;
        if (this.condition != null) {
            for (TableFilter f : this.filters) {
                if (f.isJoinOuter() || f.isJoinOuterIndirect()) continue;
                this.condition.createIndexConditions(this.session, f);
            }
        }
        this.cost = this.preparePlan(this.session.isParsingCreateView());
        if (this.distinct && this.getDatabase().getSettings().optimizeDistinct && !this.isGroupQuery && this.filters.size() == 1 && this.expressions.size() == 1 && this.condition == null) {
            Expression expr = (Expression)this.expressions.get(0);
            if ((expr = expr.getNonAliasExpression()) instanceof ExpressionColumn) {
                Index current2;
                Column column = ((ExpressionColumn)expr).getColumn();
                int selectivity = column.getSelectivity();
                Index columnIndex = this.topTableFilter.getTable().getIndexForColumn(column, false, true);
                if (columnIndex != null && selectivity != 50 && selectivity < 20 && ((current2 = this.topTableFilter.getIndex()) == null || current2.getIndexType().isScan() || columnIndex == current2)) {
                    this.topTableFilter.setIndex(columnIndex, false);
                    this.isDistinctQuery = true;
                }
            }
        }
        if (this.sort != null && !this.isQuickAggregateQuery && !this.isGroupQuery) {
            List<IndexSort> sortIndexes = this.getIndexSorts();
            current = this.topTableFilter.getIndex();
            if (sortIndexes != null && current != null) {
                block1: for (IndexSort sortIndex : sortIndexes) {
                    Index index2 = sortIndex.getIndex();
                    boolean reverse = sortIndex.isReverse();
                    if (current.getIndexType().isScan() || current == index2) {
                        this.topTableFilter.setIndex(index2, reverse);
                        if (this.topTableFilter.hasInComparisons()) continue;
                        this.indexSortedColumns = sortIndex.getSortedColumns();
                        break;
                    }
                    if (index2.getIndexColumns() == null || index2.getIndexColumns().length < current.getIndexColumns().length) continue;
                    IndexColumn[] sortColumns = index2.getIndexColumns();
                    IndexColumn[] currentColumns = current.getIndexColumns();
                    boolean swapIndex = false;
                    int i = 0;
                    while (i < currentColumns.length) {
                        if (sortColumns[i].column != currentColumns[i].column) continue block1;
                        if (sortColumns[i].sortType != currentColumns[i].sortType) {
                            swapIndex = true;
                        }
                        ++i;
                    }
                    if (!swapIndex) continue;
                    this.topTableFilter.setIndex(index2, reverse);
                    this.indexSortedColumns = sortIndex.getSortedColumns();
                    break;
                }
            }
            if (this.indexSortedColumns > 0 && this.forUpdate != null && !this.topTableFilter.getIndex().isRowIdIndex()) {
                this.indexSortedColumns = 0;
            }
        }
        if (!this.isQuickAggregateQuery && this.isGroupQuery && (index = this.getGroupSortedIndex()) != null && (current = this.topTableFilter.getIndex()) != null && (current.getIndexType().isScan() || current == index)) {
            this.topTableFilter.setIndex(index, false);
            this.isGroupSortedQuery = true;
        }
        this.isPrepared = true;
    }

    private void optimizeExpressionsAndPreserveAliases() {
        int i = 0;
        while (i < this.expressions.size()) {
            Expression optimized;
            Expression original = (Expression)this.expressions.get(i);
            if (i < this.visibleColumnCount) {
                String alias = original.getAlias(this.session, i);
                optimized = original.optimize(this.session);
                if (!optimized.getAlias(this.session, i).equals(alias)) {
                    optimized = new Alias(optimized, alias, true);
                }
            } else {
                optimized = original.optimize(this.session);
            }
            this.expressions.set(i, optimized);
            ++i;
        }
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> set = new HashSet<Table>();
        for (TableFilter filter : this.filters) {
            set.add(filter.getTable());
        }
        return set;
    }

    @Override
    public void fireBeforeSelectTriggers() {
        for (TableFilter filter : this.filters) {
            filter.getTable().fire(this.session, 8, true);
        }
    }

    private double preparePlan(boolean parse) {
        TableFilter[] topArray;
        TableFilter[] tableFilterArray = topArray = this.topFilters.toArray(new TableFilter[0]);
        int n = topArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableFilter t = tableFilterArray[n2];
            t.createIndexConditions();
            t.setFullCondition(this.condition);
            ++n2;
        }
        Optimizer optimizer = new Optimizer(topArray, this.condition, this.session);
        optimizer.optimize(parse);
        this.topTableFilter = optimizer.getTopFilter();
        double planCost = optimizer.getCost();
        this.setEvaluatableRecursive(this.topTableFilter);
        if (!parse) {
            this.topTableFilter.prepare();
        }
        return planCost;
    }

    private void setEvaluatableRecursive(TableFilter f) {
        while (f != null) {
            Expression on;
            TableFilter n;
            f.setEvaluatable(f, true);
            if (this.condition != null) {
                this.condition.setEvaluatable(f, true);
            }
            if ((n = f.getNestedJoin()) != null) {
                this.setEvaluatableRecursive(n);
            }
            if ((on = f.getJoinCondition()) != null && !on.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                on = on.optimize(this.session);
                if (!f.isJoinOuter() && !f.isJoinOuterIndirect()) {
                    f.removeJoinCondition();
                    this.addCondition(on);
                }
            }
            if ((on = f.getFilterCondition()) != null && !on.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                f.removeFilterCondition();
                this.addCondition(on);
            }
            for (Expression e : this.expressions) {
                e.setEvaluatable(f, true);
            }
            f = f.getJoin();
        }
    }

    @Override
    public StringBuilder getPlanSQL(StringBuilder builder, int sqlFlags) {
        this.writeWithList(builder, sqlFlags);
        Expression[] exprList = this.expressions.toArray(new Expression[0]);
        if (this.isExplicitTable) {
            builder.append("TABLE ");
            this.filters.get(0).getPlanSQL(builder, false, sqlFlags);
        } else {
            block31: {
                int l;
                int i;
                builder.append("SELECT");
                if (this.isAnyDistinct()) {
                    builder.append(" DISTINCT");
                    if (this.distinctExpressions != null) {
                        Expression.writeExpressions(builder.append(" ON("), this.distinctExpressions, sqlFlags).append(')');
                    }
                }
                int i2 = 0;
                while (i2 < this.visibleColumnCount) {
                    if (i2 > 0) {
                        builder.append(',');
                    }
                    builder.append('\n');
                    StringUtils.indent(builder, exprList[i2].getSQL(sqlFlags, 2), 4, false);
                    ++i2;
                }
                TableFilter filter = this.topTableFilter;
                if (filter == null) {
                    int count = this.topFilters.size();
                    if (count != 1 || !this.topFilters.get(0).isNoFromClauseFilter()) {
                        builder.append("\nFROM ");
                        boolean isJoin = false;
                        int i3 = 0;
                        while (i3 < count) {
                            isJoin = Select.getPlanFromFilter(builder, sqlFlags, this.topFilters.get(i3), isJoin);
                            ++i3;
                        }
                    }
                } else if (!filter.isNoFromClauseFilter()) {
                    Select.getPlanFromFilter(builder.append("\nFROM "), sqlFlags, filter, false);
                }
                if (this.condition != null) {
                    Select.getFilterSQL(builder, "\nWHERE ", this.condition, sqlFlags);
                }
                if (this.groupIndex != null) {
                    builder.append("\nGROUP BY ");
                    i = 0;
                    l = this.groupIndex.length;
                    while (i < l) {
                        if (i > 0) {
                            builder.append(", ");
                        }
                        exprList[this.groupIndex[i]].getNonAliasExpression().getUnenclosedSQL(builder, sqlFlags);
                        ++i;
                    }
                } else if (this.group != null) {
                    builder.append("\nGROUP BY ");
                    i = 0;
                    l = this.group.size();
                    while (i < l) {
                        if (i > 0) {
                            builder.append(", ");
                        }
                        this.group.get(i).getUnenclosedSQL(builder, sqlFlags);
                        ++i;
                    }
                } else if (this.isGroupQuery && this.having == null && this.havingIndex < 0) {
                    i = 0;
                    while (i < this.visibleColumnCount) {
                        if (!Select.containsAggregate(exprList[i])) {
                            ++i;
                            continue;
                        }
                        break block31;
                    }
                    builder.append("\nGROUP BY ()");
                }
            }
            Select.getFilterSQL(builder, "\nHAVING ", exprList, this.having, this.havingIndex, sqlFlags);
            Select.getFilterSQL(builder, "\nQUALIFY ", exprList, this.qualify, this.qualifyIndex, sqlFlags);
        }
        this.appendEndOfQueryToSQL(builder, sqlFlags, exprList);
        if (this.forUpdate != null) {
            this.forUpdate.getSQL(builder, sqlFlags);
        }
        if ((sqlFlags & 8) != 0) {
            if (this.isQuickAggregateQuery) {
                builder.append("\n/* direct lookup */");
            }
            if (this.isDistinctQuery) {
                builder.append("\n/* distinct */");
            }
            if (this.indexSortedColumns == Integer.MAX_VALUE) {
                builder.append("\n/* index sorted */");
            } else if (this.indexSortedColumns > 0) {
                builder.append("\n/* index sorted: ").append(this.indexSortedColumns).append(" of ").append(this.sort.getOrderList().size()).append(" columns */");
            }
            if (this.isGroupQuery && this.isGroupSortedQuery) {
                builder.append("\n/* group sorted */");
            }
        }
        return builder;
    }

    private static boolean getPlanFromFilter(StringBuilder builder, int sqlFlags, TableFilter f, boolean isJoin) {
        do {
            if (isJoin) {
                builder.append('\n');
            }
            f.getPlanSQL(builder, isJoin, sqlFlags);
            isJoin = true;
        } while ((f = f.getJoin()) != null);
        return isJoin;
    }

    private static void getFilterSQL(StringBuilder builder, String sql, Expression[] exprList, Expression condition, int conditionIndex, int sqlFlags) {
        if (condition != null) {
            Select.getFilterSQL(builder, sql, condition, sqlFlags);
        } else if (conditionIndex >= 0) {
            Select.getFilterSQL(builder, sql, exprList[conditionIndex], sqlFlags);
        }
    }

    private static void getFilterSQL(StringBuilder builder, String sql, Expression condition, int sqlFlags) {
        condition.getNonAliasExpression().getUnenclosedSQL(builder.append(sql), sqlFlags);
    }

    private static boolean containsAggregate(Expression expression) {
        if (expression instanceof DataAnalysisOperation && ((DataAnalysisOperation)expression).isAggregate()) {
            return true;
        }
        int i = 0;
        int l = expression.getSubexpressionCount();
        while (i < l) {
            if (Select.containsAggregate(expression.getSubexpression(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setHaving(Expression having) {
        this.having = having;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setQualify(Expression qualify) {
        this.qualify = qualify;
    }

    public Expression getQualify() {
        return this.qualify;
    }

    public TableFilter getTopTableFilter() {
        return this.topTableFilter;
    }

    @Override
    public ForUpdate getForUpdate() {
        return this.forUpdate;
    }

    @Override
    public void setForUpdate(ForUpdate b) {
        if (b != null && (this.isAnyDistinct() || this.isGroupQuery)) {
            throw DbException.get(90145);
        }
        this.forUpdate = b;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        for (Expression e : this.expressions) {
            e.mapColumns(resolver, level, 0);
        }
        if (this.condition != null) {
            this.condition.mapColumns(resolver, level, 0);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.expressions) {
            e.setEvaluatable(tableFilter, b);
        }
        if (this.condition != null) {
            this.condition.setEvaluatable(tableFilter, b);
        }
    }

    public boolean isQuickAggregateQuery() {
        return this.isQuickAggregateQuery;
    }

    public boolean isGroupQuery() {
        return this.isGroupQuery;
    }

    public boolean isWindowQuery() {
        return this.isWindowQuery;
    }

    public boolean isGroupWindowStage2() {
        return this.isGroupWindowStage2;
    }

    @Override
    public void addGlobalCondition(Parameter param, int columnId, int comparisonType) {
        this.addParameter(param);
        Expression col = (Expression)this.expressions.get(columnId);
        col = col.getNonAliasExpression();
        Expression comp = col.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR) ? new Comparison(comparisonType, col, param, false) : new Comparison(6, param, param, false);
        comp = ((Expression)comp).optimize(this.session);
        if (this.isWindowQuery) {
            this.qualify = Select.addGlobalCondition(this.qualify, comp);
        } else if (this.isGroupQuery) {
            int i = 0;
            while (this.groupIndex != null && i < this.groupIndex.length) {
                if (this.groupIndex[i] == columnId) {
                    this.condition = Select.addGlobalCondition(this.condition, comp);
                    return;
                }
                ++i;
            }
            if (this.havingIndex >= 0) {
                this.having = (Expression)this.expressions.get(this.havingIndex);
            }
            this.having = Select.addGlobalCondition(this.having, comp);
        } else {
            this.condition = Select.addGlobalCondition(this.condition, comp);
        }
    }

    private static Expression addGlobalCondition(Expression condition, Expression additional) {
        Expression oldGlobal;
        Expression oldLocal;
        if (!(condition instanceof ConditionLocalAndGlobal)) {
            return new ConditionLocalAndGlobal(condition, additional);
        }
        if (condition.getSubexpressionCount() == 1) {
            oldLocal = null;
            oldGlobal = condition.getSubexpression(0);
        } else {
            oldLocal = condition.getSubexpression(0);
            oldGlobal = condition.getSubexpression(1);
        }
        return new ConditionLocalAndGlobal(oldLocal, new ConditionAndOr(0, oldGlobal, additional));
    }

    @Override
    public void updateAggregate(SessionLocal s, int stage) {
        for (Expression e : this.expressions) {
            e.updateAggregate(s, stage);
        }
        if (this.condition != null) {
            this.condition.updateAggregate(s, stage);
        }
        if (this.having != null) {
            this.having.updateAggregate(s, stage);
        }
        if (this.qualify != null) {
            this.qualify.updateAggregate(s, stage);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: {
                if (this.forUpdate != null) {
                    return false;
                }
                for (TableFilter f : this.filters) {
                    if (f.getTable().isDeterministic()) continue;
                    return false;
                }
                break;
            }
            case 4: {
                for (TableFilter f : this.filters) {
                    long m = f.getTable().getMaxDataModificationId();
                    visitor.addDataModificationId(m);
                }
                break;
            }
            case 3: {
                if (this.getDatabase().getSettings().optimizeEvaluatableSubqueries) break;
                return false;
            }
            case 7: {
                for (TableFilter f : this.filters) {
                    Table table = f.getTable();
                    visitor.addDependency(table);
                    table.addDependencies(visitor.getDependencies());
                }
                break;
            }
        }
        ExpressionVisitor v2 = visitor.incrementQueryLevel(1);
        for (Expression e : this.expressions) {
            if (e.isEverything(v2)) continue;
            return false;
        }
        for (TableFilter f : this.filters) {
            Expression c = f.getJoinCondition();
            if (c == null || c.isEverything(v2)) continue;
            return false;
        }
        if (this.condition != null && !this.condition.isEverything(v2)) {
            return false;
        }
        if (this.having != null && !this.having.isEverything(v2)) {
            return false;
        }
        return this.qualify == null || this.qualify.isEverything(v2);
    }

    @Override
    public boolean isCacheable() {
        return this.forUpdate == null;
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.offsetExpr == null && this.fetchExpr == null && this.distinctExpressions == null;
    }

    public SortOrder getSortOrder() {
        return this.sort;
    }

    public Select getParentSelect() {
        return this.parentSelect;
    }

    @Override
    public boolean isConstantQuery() {
        if (!super.isConstantQuery() || this.distinctExpressions != null || this.condition != null || this.isGroupQuery || this.isWindowQuery || !this.isNoFromClause()) {
            return false;
        }
        int i = 0;
        while (i < this.visibleColumnCount) {
            if (!((Expression)this.expressions.get(i)).isConstant()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Expression getIfSingleRow() {
        if (this.offsetExpr != null || this.fetchExpr != null || this.condition != null || this.isGroupQuery || this.isWindowQuery || !this.isNoFromClause()) {
            return null;
        }
        if (this.visibleColumnCount == 1) {
            return (Expression)this.expressions.get(0);
        }
        Expression[] array = new Expression[this.visibleColumnCount];
        int i = 0;
        while (i < this.visibleColumnCount) {
            array[i] = (Expression)this.expressions.get(i);
            ++i;
        }
        return new ExpressionList(array, false);
    }

    private boolean isNoFromClause() {
        if (this.topTableFilter != null) {
            return this.topTableFilter.isNoFromClauseFilter();
        }
        if (this.topFilters.size() == 1) {
            return this.topFilters.get(0).isNoFromClauseFilter();
        }
        return false;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class LazyResultGroupSorted
    extends LazyResultSelect {
        private Value[] previousKeyValues;

        LazyResultGroupSorted(Expression[] expressions, int columnCount) {
            super(expressions, columnCount);
            if (Select.this.groupData == null) {
                Select.this.setGroupData(SelectGroups.getInstance(Select.this.getSession(), Select.this.expressions, Select.this.isGroupQuery, Select.this.groupIndex));
            } else {
                Select.this.updateAgg(columnCount, 0);
                Select.this.groupData.resetLazy();
            }
        }

        @Override
        public void reset() {
            super.reset();
            Select.this.groupData.resetLazy();
            this.previousKeyValues = null;
        }

        @Override
        protected Value[] fetchNextRow() {
            while (Select.this.topTableFilter.next()) {
                Select.this.setCurrentRowNumber(this.rowNumber + 1L);
                if (!Select.this.isConditionMet()) continue;
                ++this.rowNumber;
                int groupSize = Select.this.groupIndex.length;
                Value[] keyValues = new Value[groupSize];
                int i = 0;
                while (i < groupSize) {
                    int idx = Select.this.groupIndex[i];
                    Expression expr = (Expression)Select.this.expressions.get(idx);
                    keyValues[i] = expr.getValue(Select.this.getSession());
                    ++i;
                }
                Value[] row = null;
                if (this.previousKeyValues == null) {
                    this.previousKeyValues = keyValues;
                    Select.this.groupData.nextLazyGroup();
                } else {
                    SessionLocal session = Select.this.getSession();
                    int i2 = 0;
                    while (i2 < groupSize) {
                        if (session.compare(this.previousKeyValues[i2], keyValues[i2]) != 0) {
                            row = Select.this.createGroupSortedRow(this.previousKeyValues, this.columnCount);
                            this.previousKeyValues = keyValues;
                            Select.this.groupData.nextLazyGroup();
                            break;
                        }
                        ++i2;
                    }
                }
                Select.this.groupData.nextLazyRow();
                Select.this.updateAgg(this.columnCount, 1);
                if (row == null) continue;
                return row;
            }
            Value[] row = null;
            if (this.previousKeyValues != null) {
                row = Select.this.createGroupSortedRow(this.previousKeyValues, this.columnCount);
                this.previousKeyValues = null;
            }
            return row;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class LazyResultQueryFlat
    extends LazyResultSelect {
        private boolean forUpdate;

        LazyResultQueryFlat(Expression[] expressions, int columnCount, boolean forUpdate) {
            super(expressions, columnCount);
            this.forUpdate = forUpdate;
        }

        @Override
        protected Value[] fetchNextRow() {
            while (Select.this.topTableFilter.next()) {
                Select.this.setCurrentRowNumber(this.rowNumber + 1L);
                if (!(this.forUpdate ? Select.this.isConditionMetForUpdate() : Select.this.isConditionMet())) continue;
                ++this.rowNumber;
                Value[] row = new Value[this.columnCount];
                int i = 0;
                while (i < this.columnCount) {
                    Expression expr = (Expression)Select.this.expressions.get(i);
                    row[i] = expr.getValue(Select.this.getSession());
                    ++i;
                }
                return row;
            }
            return null;
        }

        @Override
        protected boolean skipNextRow() {
            while (Select.this.topTableFilter.next()) {
                Select.this.setCurrentRowNumber(this.rowNumber + 1L);
                if (!Select.this.isConditionMet()) continue;
                ++this.rowNumber;
                return true;
            }
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private abstract class LazyResultSelect
    extends LazyResult {
        long rowNumber;
        int columnCount;

        LazyResultSelect(Expression[] expressions, int columnCount) {
            super(Select.this.getSession(), expressions);
            this.columnCount = columnCount;
            Select.this.setCurrentRowNumber(0L);
        }

        @Override
        public final int getVisibleColumnCount() {
            return Select.this.visibleColumnCount;
        }

        @Override
        public void reset() {
            super.reset();
            Select.this.topTableFilter.reset();
            Select.this.setCurrentRowNumber(0L);
            this.rowNumber = 0L;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum QuickOffset {
        NO,
        YES,
        PARTIAL;

    }
}

