/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.h2.command.query.ForUpdate;
import org.h2.command.query.Query;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableValueConstructorTable;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TableValueConstructor
extends Query {
    private final ArrayList<ArrayList<Expression>> rows;
    TableValueConstructorTable table;
    private TableValueColumnResolver columnResolver;
    private double cost;

    public TableValueConstructor(SessionLocal session, ArrayList<ArrayList<Expression>> rows) {
        super(session);
        this.rows = rows;
        this.visibleColumnCount = rows.get(0).size();
        if (this.visibleColumnCount > 16384) {
            throw DbException.get(54011, "16384");
        }
        for (ArrayList<Expression> row : rows) {
            for (Expression column : row) {
                if (column.isConstant()) continue;
                return;
            }
        }
        this.createTable();
    }

    public static void getVisibleResult(SessionLocal session, ResultTarget result, Column[] columns, ArrayList<ArrayList<Expression>> rows) {
        int count = columns.length;
        for (ArrayList<Expression> row : rows) {
            Value[] values = new Value[count];
            int i = 0;
            while (i < count) {
                values[i] = row.get(i).getValue(session).convertTo(columns[i].getType(), (CastDataProvider)session);
                ++i;
            }
            result.addRow(values);
        }
    }

    public static void getValuesSQL(StringBuilder builder, int sqlFlags, ArrayList<ArrayList<Expression>> rows) {
        builder.append("VALUES ");
        int rowCount = rows.size();
        int i = 0;
        while (i < rowCount) {
            if (i > 0) {
                builder.append(", ");
            }
            Expression.writeExpressions(builder.append('('), (List<? extends Expression>)rows.get(i), sqlFlags).append(')');
            ++i;
        }
    }

    @Override
    public boolean isUnion() {
        return false;
    }

    @Override
    protected ResultInterface queryWithoutCache(long limit, ResultTarget target) {
        Query.OffsetFetch offsetFetch = this.getOffsetFetch(limit);
        long offset = offsetFetch.offset;
        long fetch = offsetFetch.fetch;
        boolean fetchPercent = offsetFetch.fetchPercent;
        int visibleColumnCount = this.visibleColumnCount;
        int resultColumnCount = this.resultColumnCount;
        LocalResult result = new LocalResult(this.session, this.expressionArray, visibleColumnCount, resultColumnCount);
        if (this.sort != null) {
            result.setSortOrder(this.sort);
        }
        if (this.distinct) {
            result.setDistinct();
        }
        Column[] columns = this.table.getColumns();
        if (visibleColumnCount == resultColumnCount) {
            TableValueConstructor.getVisibleResult(this.session, result, columns, this.rows);
        } else {
            for (ArrayList<Expression> row : this.rows) {
                Value[] values = new Value[resultColumnCount];
                int i = 0;
                while (i < visibleColumnCount) {
                    values[i] = row.get(i).getValue(this.session).convertTo(columns[i].getType(), (CastDataProvider)this.session);
                    ++i;
                }
                this.columnResolver.currentRow = values;
                i = visibleColumnCount;
                while (i < resultColumnCount) {
                    values[i] = this.expressionArray[i].getValue(this.session);
                    ++i;
                }
                result.addRow(values);
            }
            this.columnResolver.currentRow = null;
        }
        return this.finishResult(result, offset, fetch, fetchPercent, target);
    }

    @Override
    public void init() {
        if (this.checkInit) {
            throw DbException.getInternalError();
        }
        this.checkInit = true;
        if (this.withTies && !this.hasOrder()) {
            throw DbException.get(90122);
        }
    }

    @Override
    public void prepareExpressions() {
        if (this.columnResolver == null) {
            this.createTable();
        }
        if (this.orderList != null) {
            ArrayList<String> expressionsSQL = new ArrayList<String>();
            for (Expression e : this.expressions) {
                expressionsSQL.add(e.getSQL(0, 2));
            }
            if (this.initOrder(expressionsSQL, false, null)) {
                this.prepareOrder(this.orderList, this.expressions.size());
            }
        }
        this.resultColumnCount = this.expressions.size();
        int i = 0;
        while (i < this.resultColumnCount) {
            ((Expression)this.expressions.get(i)).mapColumns(this.columnResolver, 0, 0);
            ++i;
        }
        i = this.visibleColumnCount;
        while (i < this.resultColumnCount) {
            this.expressions.set(i, ((Expression)this.expressions.get(i)).optimize(this.session));
            ++i;
        }
        if (this.sort != null) {
            this.cleanupOrder();
        }
        this.expressionArray = this.expressions.toArray(new Expression[0]);
    }

    @Override
    public void preparePlan() {
        double cost = 0.0;
        int columnCount = this.visibleColumnCount;
        for (ArrayList<Expression> r : this.rows) {
            int i = 0;
            while (i < columnCount) {
                cost += (double)r.get(i).getCost();
                ++i;
            }
        }
        this.cost = cost + (double)this.rows.size();
        this.isPrepared = true;
    }

    private void createTable() {
        TypeInfo type;
        int rowCount = this.rows.size();
        ArrayList<Expression> row = this.rows.get(0);
        int columnCount = row.size();
        TypeInfo[] types = new TypeInfo[columnCount];
        int c = 0;
        while (c < columnCount) {
            Expression e = row.get(c).optimize(this.session);
            row.set(c, e);
            type = e.getType();
            if (type.getValueType() == -1) {
                type = TypeInfo.TYPE_VARCHAR;
            }
            types[c] = type;
            ++c;
        }
        int r = 1;
        while (r < rowCount) {
            row = this.rows.get(r);
            int c2 = 0;
            while (c2 < columnCount) {
                Expression e = row.get(c2).optimize(this.session);
                row.set(c2, e);
                types[c2] = TypeInfo.getHigherType(types[c2], e.getType());
                ++c2;
            }
            ++r;
        }
        Column[] columns = new Column[columnCount];
        int c3 = 0;
        while (c3 < columnCount) {
            type = types[c3];
            columns[c3++] = new Column("C" + c3, type);
        }
        Database database = this.session.getDatabase();
        ArrayList<ExpressionColumn> expressions = new ArrayList<ExpressionColumn>(columnCount);
        int i = 0;
        while (i < columnCount) {
            expressions.add(new ExpressionColumn(database, null, null, columns[i].getName()));
            ++i;
        }
        this.expressions = expressions;
        this.table = new TableValueConstructorTable(database.getMainSchema(), this.session, columns, this.rows);
        this.columnResolver = new TableValueColumnResolver();
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> tables = new HashSet<Table>(1, 1.0f);
        tables.add(this.table);
        return tables;
    }

    @Override
    public void setForUpdate(ForUpdate forUpdate) {
        throw DbException.get(90140);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        int columnCount = this.visibleColumnCount;
        for (ArrayList<Expression> row : this.rows) {
            int i = 0;
            while (i < columnCount) {
                row.get(i).mapColumns(resolver, level, 0);
                ++i;
            }
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        int columnCount = this.visibleColumnCount;
        for (ArrayList<Expression> row : this.rows) {
            int i = 0;
            while (i < columnCount) {
                row.get(i).setEvaluatable(tableFilter, b);
                ++i;
            }
        }
    }

    @Override
    public void addGlobalCondition(Parameter param, int columnId, int comparisonType) {
    }

    @Override
    public boolean allowGlobalConditions() {
        return false;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        ExpressionVisitor v2 = visitor.incrementQueryLevel(1);
        Expression[] expressionArray = this.expressionArray;
        int n = this.expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            if (!e.isEverything(v2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void updateAggregate(SessionLocal s, int stage) {
        int columnCount = this.visibleColumnCount;
        for (ArrayList<Expression> row : this.rows) {
            int i = 0;
            while (i < columnCount) {
                row.get(i).updateAggregate(s, stage);
                ++i;
            }
        }
    }

    @Override
    public void fireBeforeSelectTriggers() {
    }

    @Override
    public StringBuilder getPlanSQL(StringBuilder builder, int sqlFlags) {
        this.writeWithList(builder, sqlFlags);
        TableValueConstructor.getValuesSQL(builder, sqlFlags, this.rows);
        this.appendEndOfQueryToSQL(builder, sqlFlags, this.expressionArray);
        return builder;
    }

    @Override
    public Table toTable(String alias, Column[] columnTemplates, ArrayList<Parameter> parameters, boolean forCreateView, Query topQuery) {
        if (!this.hasOrder() && this.offsetExpr == null && this.fetchExpr == null && this.table != null) {
            return this.table;
        }
        return super.toTable(alias, columnTemplates, parameters, forCreateView, topQuery);
    }

    @Override
    public boolean isConstantQuery() {
        if (!super.isConstantQuery()) {
            return false;
        }
        for (ArrayList<Expression> row : this.rows) {
            int i = 0;
            while (i < this.visibleColumnCount) {
                if (!row.get(i).isConstant()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public Expression getIfSingleRow() {
        if (this.offsetExpr != null || this.fetchExpr != null || this.rows.size() != 1) {
            return null;
        }
        ArrayList<Expression> row = this.rows.get(0);
        if (this.visibleColumnCount == 1) {
            return row.get(0);
        }
        Expression[] array = new Expression[this.visibleColumnCount];
        int i = 0;
        while (i < this.visibleColumnCount) {
            array[i] = row.get(i);
            ++i;
        }
        return new ExpressionList(array, false);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class TableValueColumnResolver
    implements ColumnResolver {
        Value[] currentRow;

        TableValueColumnResolver() {
        }

        @Override
        public Column[] getColumns() {
            return TableValueConstructor.this.table.getColumns();
        }

        @Override
        public Column findColumn(String name) {
            return TableValueConstructor.this.table.findColumn(name);
        }

        @Override
        public Value getValue(Column column) {
            return this.currentRow[column.getColumnId()];
        }

        @Override
        public Expression optimize(ExpressionColumn expressionColumn, Column column) {
            return (Expression)TableValueConstructor.this.expressions.get(column.getColumnId());
        }
    }
}

