/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.util.HashSet;
import org.h2.constraint.Constraint;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ConstraintCheck
extends Constraint {
    private TableFilter filter;
    private Expression expr;

    public ConstraintCheck(Schema schema, int id, String name, Table table) {
        super(schema, id, name, table);
    }

    @Override
    public Constraint.Type getConstraintType() {
        return Constraint.Type.CHECK;
    }

    public void setTableFilter(TableFilter filter) {
        this.filter = filter;
    }

    public void setExpression(Expression expr) {
        this.expr = expr;
    }

    @Override
    public String getCreateSQLForCopy(Table forTable, String quotedName) {
        StringBuilder buff = new StringBuilder("ALTER TABLE ");
        forTable.getSQL(buff, 0).append(" ADD CONSTRAINT ");
        buff.append(quotedName);
        if (this.comment != null) {
            buff.append(" COMMENT ");
            StringUtils.quoteStringSQL(buff, this.comment);
        }
        buff.append(" CHECK");
        this.expr.getEnclosedSQL(buff, 0).append(" NOCHECK");
        return buff.toString();
    }

    private String getShortDescription() {
        StringBuilder builder = new StringBuilder().append(this.getName()).append(": ");
        this.expr.getTraceSQL();
        return builder.toString();
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQL();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(0));
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        this.table.removeConstraint(this);
        this.database.removeMeta(session, this.getId());
        this.filter = null;
        this.expr = null;
        this.table = null;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkRow(SessionLocal session, Table t, Row oldRow, Row newRow) {
        boolean b;
        if (newRow == null) {
            return;
        }
        try {
            Value v;
            ConstraintCheck constraintCheck = this;
            synchronized (constraintCheck) {
                this.filter.set(newRow);
                v = this.expr.getValue(session);
            }
            b = v.isFalse();
        }
        catch (DbException ex) {
            throw DbException.get(23514, ex, this.getShortDescription());
        }
        if (b) {
            throw DbException.get(23513, this.getShortDescription());
        }
    }

    @Override
    public boolean usesIndex(Index index) {
        return false;
    }

    @Override
    public void setIndexOwner(Index index) {
        throw DbException.getInternalError(this.toString());
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> columns = new HashSet<Column>();
        this.expr.isEverything(ExpressionVisitor.getColumnsVisitor(columns, table));
        return columns;
    }

    @Override
    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public boolean isBefore() {
        return true;
    }

    @Override
    public void checkExistingData(SessionLocal session) {
        if (session.getDatabase().isStarting()) {
            return;
        }
        StringBuilder builder = new StringBuilder().append("SELECT NULL FROM ");
        this.filter.getTable().getSQL(builder, 0).append(" WHERE NOT ");
        this.expr.getSQL(builder, 0, 0);
        String sql = builder.toString();
        ResultInterface r = session.prepare(sql).query(1L);
        if (r.next()) {
            throw DbException.get(23513, this.getName());
        }
    }

    @Override
    public void rebuild() {
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.expr.isEverything(visitor);
    }
}

