/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.cache;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CacheLIRS<K, V>
extends AbstractMap<K, V> {
    private long maxMemory;
    private final Segment<K, V>[] segments;
    private final int segmentCount;
    private final int segmentShift;
    private final int segmentMask;
    private final int stackMoveDistance;

    public CacheLIRS(long maxMemory) {
        this(maxMemory, 16, 8);
    }

    public CacheLIRS(long maxMemory, int segmentCount, int stackMoveDistance) {
        this.setMaxMemory(maxMemory);
        if (Integer.bitCount(segmentCount) != 1) {
            throw new IllegalArgumentException("The segment count must be a power of 2, is " + segmentCount);
        }
        this.segmentCount = segmentCount;
        this.segmentMask = segmentCount - 1;
        this.stackMoveDistance = stackMoveDistance;
        this.segments = new Segment[segmentCount];
        this.clear();
        this.segmentShift = 32 - Integer.bitCount(this.segmentMask);
    }

    @Override
    public void clear() {
        long max = Math.max(1L, this.maxMemory / (long)this.segmentCount);
        int i = 0;
        while (i < this.segmentCount) {
            this.segments[i] = new Segment(this, max, this.stackMoveDistance, 8);
            ++i;
        }
    }

    private Entry<K, V> find(Object key) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).find(key, hash);
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).containsKey(key, hash);
    }

    public V peek(K key) {
        Entry<K, V> e = this.find(key);
        return e == null ? null : (V)e.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value, int memory) {
        Segment<K, V> s;
        int hash = CacheLIRS.getHash(key);
        int segmentIndex = this.getSegmentIndex(hash);
        Segment<K, V> segment = s = this.segments[segmentIndex];
        synchronized (segment) {
            s = this.resizeIfNeeded(s, segmentIndex);
            return s.put(key, hash, value, memory);
        }
    }

    private Segment<K, V> resizeIfNeeded(Segment<K, V> s, int segmentIndex) {
        int newLen = s.getNewMapLen();
        if (newLen == 0) {
            return s;
        }
        Segment<K, V> s2 = this.segments[segmentIndex];
        if (s == s2) {
            s = new Segment<K, V>(s, newLen);
            this.segments[segmentIndex] = s;
        }
        return s;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, this.sizeOf(key, value));
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    protected void onRemove(K key) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Segment<K, V> s;
        int hash = CacheLIRS.getHash(key);
        int segmentIndex = this.getSegmentIndex(hash);
        Segment<K, V> segment = s = this.segments[segmentIndex];
        synchronized (segment) {
            s = this.resizeIfNeeded(s, segmentIndex);
            return s.remove(key, hash);
        }
    }

    public int getMemory(K key) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).getMemory(key, hash);
    }

    @Override
    public V get(Object key) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).get(key, hash);
    }

    private Segment<K, V> getSegment(int hash) {
        return this.segments[this.getSegmentIndex(hash)];
    }

    private int getSegmentIndex(int hash) {
        return hash >>> this.segmentShift & this.segmentMask;
    }

    static int getHash(Object key) {
        int hash = key.hashCode();
        hash = (hash >>> 16 ^ hash) * 73244475;
        hash = (hash >>> 16 ^ hash) * 73244475;
        hash = hash >>> 16 ^ hash;
        return hash;
    }

    public long getUsedMemory() {
        long x = 0L;
        Segment<K, V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<K, V> s = segmentArray[n2];
            x += s.usedMemory;
            ++n2;
        }
        return x;
    }

    public void setMaxMemory(long maxMemory) {
        if (maxMemory <= 0L) {
            throw new IllegalArgumentException("Max memory must be larger than 0");
        }
        this.maxMemory = maxMemory;
        if (this.segments != null) {
            long max = 1L + maxMemory / (long)this.segments.length;
            Segment<K, V>[] segmentArray = this.segments;
            int n = this.segments.length;
            int n2 = 0;
            while (n2 < n) {
                Segment<K, V> s = segmentArray[n2];
                s.setMaxMemory(max);
                ++n2;
            }
        }
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashMap map = new HashMap();
        for (K k : this.keySet()) {
            map.put(k, this.find(k).value);
        }
        return map.entrySet();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> set = new HashSet<K>();
        Segment<K, V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<K, V> s = segmentArray[n2];
            set.addAll(s.keySet());
            ++n2;
        }
        return set;
    }

    public int sizeNonResident() {
        int x = 0;
        Segment<K, V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<K, V> s = segmentArray[n2];
            x += s.queue2Size;
            ++n2;
        }
        return x;
    }

    public int sizeMapArray() {
        int x = 0;
        Segment<K, V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<K, V> s = segmentArray[n2];
            x += s.entries.length;
            ++n2;
        }
        return x;
    }

    public int sizeHot() {
        int x = 0;
        Segment<K, V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<K, V> s = segmentArray[n2];
            x += s.mapSize - s.queueSize - s.queue2Size;
            ++n2;
        }
        return x;
    }

    @Override
    public int size() {
        int x = 0;
        Segment<K, V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<K, V> s = segmentArray[n2];
            x += s.mapSize - s.queue2Size;
            ++n2;
        }
        return x;
    }

    public List<K> keys(boolean cold, boolean nonResident) {
        ArrayList<K> keys = new ArrayList<K>();
        Segment<K, V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<K, V> s = segmentArray[n2];
            keys.addAll(s.keys(cold, nonResident));
            ++n2;
        }
        return keys;
    }

    static class Entry<K, V> {
        K key;
        V value;
        int memory;
        int topMove;
        Entry<K, V> stackNext;
        Entry<K, V> stackPrev;
        Entry<K, V> queueNext;
        Entry<K, V> queuePrev;
        Entry<K, V> mapNext;

        Entry() {
        }

        boolean isHot() {
            return this.queueNext == null;
        }
    }

    private static class Segment<K, V> {
        int mapSize;
        int queueSize;
        int queue2Size;
        final Entry<K, V>[] entries;
        long usedMemory;
        private final CacheLIRS<K, V> cache;
        private final int stackMoveDistance;
        private long maxMemory;
        private final int mask;
        private final Entry<K, V> stack;
        private int stackSize;
        private final Entry<K, V> queue;
        private final Entry<K, V> queue2;
        private int stackMoveCounter;

        Segment(CacheLIRS<K, V> cache, long maxMemory, int stackMoveDistance, int len) {
            this.cache = cache;
            this.setMaxMemory(maxMemory);
            this.stackMoveDistance = stackMoveDistance;
            this.mask = len - 1;
            this.stack = new Entry();
            this.stack.stackNext = this.stack;
            this.stack.stackPrev = this.stack.stackNext;
            this.queue = new Entry();
            this.queue.queueNext = this.queue;
            this.queue.queuePrev = this.queue.queueNext;
            this.queue2 = new Entry();
            this.queue2.queueNext = this.queue2;
            this.queue2.queuePrev = this.queue2.queueNext;
            Entry[] e = new Entry[len];
            this.entries = e;
        }

        Segment(Segment<K, V> old, int len) {
            this(old.cache, old.maxMemory, old.stackMoveDistance, len);
            Entry e;
            Entry s = old.stack.stackPrev;
            while (s != old.stack) {
                e = Segment.copy(s);
                this.addToMap(e);
                this.addToStack(e);
                s = s.stackPrev;
            }
            s = old.queue.queuePrev;
            while (s != old.queue) {
                e = this.find(s.key, CacheLIRS.getHash(s.key));
                if (e == null) {
                    e = Segment.copy(s);
                    this.addToMap(e);
                }
                this.addToQueue(this.queue, e);
                s = s.queuePrev;
            }
            s = old.queue2.queuePrev;
            while (s != old.queue2) {
                e = this.find(s.key, CacheLIRS.getHash(s.key));
                if (e == null) {
                    e = Segment.copy(s);
                    this.addToMap(e);
                }
                this.addToQueue(this.queue2, e);
                s = s.queuePrev;
            }
        }

        int getNewMapLen() {
            int len = this.mask + 1;
            if (len * 3 < this.mapSize * 4 && len < 0x10000000) {
                return len * 2;
            }
            if (len > 32 && len / 8 > this.mapSize) {
                return len / 2;
            }
            return 0;
        }

        private void addToMap(Entry<K, V> e) {
            int index = CacheLIRS.getHash(e.key) & this.mask;
            e.mapNext = this.entries[index];
            this.entries[index] = e;
            this.usedMemory += (long)e.memory;
            ++this.mapSize;
        }

        private static <K, V> Entry<K, V> copy(Entry<K, V> old) {
            Entry e = new Entry();
            e.key = old.key;
            e.value = old.value;
            e.memory = old.memory;
            e.topMove = old.topMove;
            return e;
        }

        int getMemory(K key, int hash) {
            Entry<K, V> e = this.find(key, hash);
            return e == null ? 0 : e.memory;
        }

        V get(Object key, int hash) {
            Entry<K, V> e = this.find(key, hash);
            if (e == null) {
                return null;
            }
            Object value = e.value;
            if (value == null) {
                return null;
            }
            if (e.isHot()) {
                if (e != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - e.topMove > this.stackMoveDistance)) {
                    this.access(key, hash);
                }
            } else {
                this.access(key, hash);
            }
            return value;
        }

        private synchronized void access(Object key, int hash) {
            Entry<K, V> e = this.find(key, hash);
            if (e == null || e.value == null) {
                return;
            }
            if (e.isHot()) {
                if (e != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - e.topMove > this.stackMoveDistance)) {
                    boolean wasEnd = e == this.stack.stackPrev;
                    this.removeFromStack(e);
                    if (wasEnd) {
                        this.pruneStack();
                    }
                    this.addToStack(e);
                }
            } else {
                this.removeFromQueue(e);
                if (e.stackNext != null) {
                    this.removeFromStack(e);
                    this.convertOldestHotToCold();
                } else {
                    this.addToQueue(this.queue, e);
                }
                this.addToStack(e);
            }
        }

        synchronized V put(K key, int hash, V value, int memory) {
            V old;
            if (value == null) {
                throw new NullPointerException("The value may not be null");
            }
            Entry<K, V> e = this.find(key, hash);
            if (e == null) {
                old = null;
            } else {
                old = e.value;
                this.remove(key, hash);
            }
            if ((long)memory > this.maxMemory) {
                return old;
            }
            e = new Entry();
            e.key = key;
            e.value = value;
            e.memory = memory;
            int index = hash & this.mask;
            e.mapNext = this.entries[index];
            this.entries[index] = e;
            this.usedMemory += (long)memory;
            if (this.usedMemory > this.maxMemory) {
                this.evict();
                if (this.stackSize > 0) {
                    this.addToQueue(this.queue, e);
                }
            }
            ++this.mapSize;
            this.addToStack(e);
            return old;
        }

        synchronized V remove(Object key, int hash) {
            Object old;
            int index = hash & this.mask;
            Entry<K, V> e = this.entries[index];
            if (e == null) {
                return null;
            }
            if (e.key.equals(key)) {
                old = e.value;
                this.entries[index] = e.mapNext;
            } else {
                do {
                    Entry<K, V> last = e;
                    e = e.mapNext;
                    if (e != null) continue;
                    return null;
                } while (!e.key.equals(key));
                old = e.value;
                last.mapNext = e.mapNext;
            }
            --this.mapSize;
            this.usedMemory -= (long)e.memory;
            if (e.stackNext != null) {
                this.removeFromStack(e);
            }
            if (e.isHot()) {
                e = this.queue.queueNext;
                if (e != this.queue) {
                    this.removeFromQueue(e);
                    if (e.stackNext == null) {
                        this.addToStackBottom(e);
                    }
                }
            } else {
                this.removeFromQueue(e);
            }
            this.pruneStack();
            return old;
        }

        private void evict() {
            do {
                this.evictBlock();
            } while (this.usedMemory > this.maxMemory);
        }

        private void evictBlock() {
            while (this.queueSize <= this.mapSize >>> 5 && this.stackSize > 0) {
                this.convertOldestHotToCold();
            }
            while (this.usedMemory > this.maxMemory && this.queueSize > 0) {
                Entry e = this.queue.queuePrev;
                this.usedMemory -= (long)e.memory;
                this.removeFromQueue(e);
                this.cache.onRemove(e.key);
                e.value = null;
                e.memory = 0;
                this.addToQueue(this.queue2, e);
                while (this.queue2Size + this.queue2Size > this.stackSize) {
                    e = this.queue2.queuePrev;
                    int hash = CacheLIRS.getHash(e.key);
                    this.remove(e.key, hash);
                }
            }
        }

        private void convertOldestHotToCold() {
            Entry last = this.stack.stackPrev;
            if (last == this.stack) {
                throw new IllegalStateException();
            }
            this.removeFromStack(last);
            this.addToQueue(this.queue, last);
            this.pruneStack();
        }

        private void pruneStack() {
            Entry last;
            while (!(last = this.stack.stackPrev).isHot()) {
                this.removeFromStack(last);
            }
        }

        Entry<K, V> find(Object key, int hash) {
            int index = hash & this.mask;
            Entry<K, V> e = this.entries[index];
            while (e != null && !e.key.equals(key)) {
                e = e.mapNext;
            }
            return e;
        }

        private void addToStack(Entry<K, V> e) {
            e.stackPrev = this.stack;
            e.stackNext = this.stack.stackNext;
            e.stackNext.stackPrev = e;
            this.stack.stackNext = e;
            ++this.stackSize;
            e.topMove = this.stackMoveCounter++;
        }

        private void addToStackBottom(Entry<K, V> e) {
            e.stackNext = this.stack;
            e.stackPrev = this.stack.stackPrev;
            e.stackPrev.stackNext = e;
            this.stack.stackPrev = e;
            ++this.stackSize;
        }

        private void removeFromStack(Entry<K, V> e) {
            e.stackPrev.stackNext = e.stackNext;
            e.stackNext.stackPrev = e.stackPrev;
            e.stackNext = null;
            e.stackPrev = null;
            --this.stackSize;
        }

        private void addToQueue(Entry<K, V> q, Entry<K, V> e) {
            e.queuePrev = q;
            e.queueNext = q.queueNext;
            e.queueNext.queuePrev = e;
            q.queueNext = e;
            if (e.value != null) {
                ++this.queueSize;
            } else {
                ++this.queue2Size;
            }
        }

        private void removeFromQueue(Entry<K, V> e) {
            e.queuePrev.queueNext = e.queueNext;
            e.queueNext.queuePrev = e.queuePrev;
            e.queueNext = null;
            e.queuePrev = null;
            if (e.value != null) {
                --this.queueSize;
            } else {
                --this.queue2Size;
            }
        }

        synchronized List<K> keys(boolean cold, boolean nonResident) {
            ArrayList keys = new ArrayList();
            if (cold) {
                Entry<K, V> start = nonResident ? this.queue2 : this.queue;
                Entry e = start.queueNext;
                while (e != start) {
                    keys.add(e.key);
                    e = e.queueNext;
                }
            } else {
                Entry e = this.stack.stackNext;
                while (e != this.stack) {
                    keys.add(e.key);
                    e = e.stackNext;
                }
            }
            return keys;
        }

        boolean containsKey(Object key, int hash) {
            Entry<K, V> e = this.find(key, hash);
            return e != null && e.value != null;
        }

        synchronized Set<K> keySet() {
            HashSet set = new HashSet();
            Entry e = this.stack.stackNext;
            while (e != this.stack) {
                set.add(e.key);
                e = e.stackNext;
            }
            e = this.queue.queueNext;
            while (e != this.queue) {
                set.add(e.key);
                e = e.queueNext;
            }
            return set;
        }

        void setMaxMemory(long maxMemory) {
            this.maxMemory = maxMemory;
        }
    }
}

