/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.cluster;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.ObjectDataType;

public class ShardedMap<K, V>
extends AbstractMap<K, V> {
    private final DataType<Object> keyType;
    private Shard<K, V>[] shards;

    public ShardedMap() {
        this(new ObjectDataType());
    }

    public ShardedMap(DataType keyType) {
        this.keyType = keyType;
        this.shards = new Shard[0];
    }

    static long getSize(Map<?, ?> map) {
        if (map instanceof LargeMap) {
            return ((LargeMap)((Object)map)).sizeAsLong();
        }
        return map.size();
    }

    public void addMap(Map<K, V> map, K min, K max) {
        if (min != null && max != null && this.keyType.compare(min, max) > 0) {
            DataUtils.newIllegalArgumentException("Invalid range: {0} .. {1}", min, max);
        }
        int len = this.shards.length + 1;
        Shard<K, V>[] newShards = Arrays.copyOf(this.shards, len);
        Shard newShard = new Shard();
        newShard.map = map;
        newShard.minIncluding = min;
        newShard.maxExcluding = max;
        newShards[len - 1] = newShard;
        this.shards = newShards;
    }

    private boolean isInRange(K key, Shard<K, V> shard) {
        if (shard.minIncluding != null && this.keyType.compare(key, shard.minIncluding) < 0) {
            return false;
        }
        return shard.maxExcluding == null || this.keyType.compare(key, shard.maxExcluding) < 0;
    }

    @Override
    public int size() {
        long size = this.sizeAsLong();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    public long sizeAsLong() {
        Shard<K, V>[] copy;
        Shard<K, V>[] shardArray = copy = this.shards;
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            Shard<K, V> s = shardArray[n2];
            if (s.minIncluding == null && s.maxExcluding == null) {
                return ShardedMap.getSize(s.map);
            }
            ++n2;
        }
        if (this.isSimpleSplit(copy)) {
            long size = 0L;
            Shard<K, V>[] shardArray2 = copy;
            int n3 = copy.length;
            int n4 = 0;
            while (n4 < n3) {
                Shard<K, V> s = shardArray2[n4];
                size += ShardedMap.getSize(s.map);
                ++n4;
            }
            return size;
        }
        return -1L;
    }

    private boolean isSimpleSplit(Shard<K, V>[] shards) {
        Object last = null;
        int i = 0;
        while (i < shards.length) {
            Shard<K, V> s = shards[i];
            if (last == null ? s.minIncluding != null : this.keyType.compare(last, s.minIncluding) != 0) {
                return false;
            }
            if (s.maxExcluding == null) {
                return i == shards.length - 1;
            }
            last = s.maxExcluding;
            ++i;
        }
        return last == null;
    }

    @Override
    public V put(K key, V value) {
        Shard<K, V>[] copy;
        V result = null;
        Shard<K, V>[] shardArray = copy = this.shards;
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            Shard<K, V> s = shardArray[n2];
            if (this.isInRange(key, s)) {
                Object r = s.map.put(key, value);
                if (result == null) {
                    result = r;
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public V get(Object key) {
        Shard<K, V>[] copy;
        Object k = key;
        Shard<K, V>[] shardArray = copy = this.shards;
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            Shard<K, V> s = shardArray[n2];
            if (this.isInRange(k, s)) {
                return s.map.get(k);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Shard<K, V>[] copy;
        Shard<K, V>[] shardArray = copy = this.shards;
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            Shard<K, V> s = shardArray[n2];
            if (s.minIncluding == null && s.maxExcluding == null) {
                return s.map.entrySet();
            }
            ++n2;
        }
        if (this.isSimpleSplit(copy)) {
            return new CombinedSet<K, V>(this.size(), copy);
        }
        return null;
    }

    private static class CombinedSet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        final int size;
        final Shard<K, V>[] shards;

        CombinedSet(int size, Shard<K, V>[] shards) {
            this.size = size;
            this.shards = shards;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                boolean init;
                Map.Entry<K, V> current;
                Iterator<Map.Entry<K, V>> currentIterator;
                int shardIndex;

                private void fetchNext() {
                    while (this.currentIterator == null || !this.currentIterator.hasNext()) {
                        if (this.shardIndex >= shards.length) {
                            this.current = null;
                            return;
                        }
                        this.currentIterator = shards[this.shardIndex++].map.entrySet().iterator();
                    }
                    this.current = this.currentIterator.next();
                }

                @Override
                public boolean hasNext() {
                    if (!this.init) {
                        this.fetchNext();
                        this.init = true;
                    }
                    return this.current != null;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Map.Entry e = this.current;
                    this.fetchNext();
                    return e;
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    public static interface CountedMap<K, V> {
        public K getKey(long var1);

        public long getKeyIndex(K var1);
    }

    public static interface LargeMap {
        public long sizeAsLong();
    }

    static class Shard<K, V> {
        K minIncluding;
        K maxExcluding;
        Map<K, V> map;

        Shard() {
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            if (this.minIncluding != null) {
                buff.append('[').append(this.minIncluding);
            }
            buff.append("..");
            if (this.maxExcluding != null) {
                buff.append(this.maxExcluding).append(')');
            }
            return buff.toString();
        }
    }
}

