/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.fs;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.store.fs.FileUtils;

public class ArchiveToolStore {
    private static final int[] RANDOM = new int[256];
    private static final int MB = 1000000;
    private long lastTime;
    private long start;
    private int bucket;
    private String fileName;

    static {
        Random r = new Random(1L);
        int i = 0;
        while (i < RANDOM.length) {
            ArchiveToolStore.RANDOM[i] = r.nextInt();
            ++i;
        }
    }

    public static void main(String ... args) throws Exception {
        String arg;
        ArchiveToolStore app = new ArchiveToolStore();
        String string = arg = args.length != 3 ? null : args[0];
        if ("-compress".equals(arg)) {
            app.fileName = args[1];
            app.compress(args[2]);
        } else if ("-extract".equals(arg)) {
            app.fileName = args[1];
            app.expand(args[2]);
        } else {
            System.out.println("Command line options:");
            System.out.println("-compress <file> <sourceDir>");
            System.out.println("-extract <file> <targetDir>");
        }
    }

    private void compress(String sourceDir) throws Exception {
        this.start();
        long tempSize = 0x800000L;
        String tempFileName = this.fileName + ".temp";
        ArrayList<String> fileNames = new ArrayList<String>();
        System.out.println("Reading the file list");
        long totalSize = ArchiveToolStore.addFiles(sourceDir, fileNames);
        System.out.println("Compressing " + totalSize / 1000000L + " MB");
        FileUtils.delete(tempFileName);
        FileUtils.delete(this.fileName);
        MVStore storeTemp = new MVStore.Builder().fileName(tempFileName).autoCommitDisabled().open();
        MVStore store = new MVStore.Builder().fileName(this.fileName).pageSplitSize(0x200000).compressHigh().autoCommitDisabled().open();
        MVMap<String, int[]> filesTemp = storeTemp.openMap("files");
        long currentSize = 0L;
        int segmentId = 1;
        int segmentLength = 0;
        ByteBuffer buff = ByteBuffer.allocate(0x100000);
        for (String s : fileNames) {
            String name = s.substring(sourceDir.length() + 1);
            if (FileUtils.isDirectory(s)) {
                filesTemp.put(name, new int[1]);
                continue;
            }
            buff.clear();
            buff.flip();
            ArrayList<Integer> posList = new ArrayList<Integer>();
            Throwable throwable = null;
            Object var21_22 = null;
            try (FileChannel fc = FileUtils.open(s, "r");){
                boolean eof = false;
                while (true) {
                    if (!eof && buff.remaining() < 524288) {
                        int remaining = buff.remaining();
                        buff.compact();
                        buff.position(remaining);
                        int l = fc.read(buff);
                        if (l < 0) {
                            eof = true;
                        }
                        buff.flip();
                        continue;
                    }
                    if (buff.remaining() == 0) {
                        break;
                    }
                    int position = buff.position();
                    int c = this.getChunkLength(buff.array(), position, buff.limit()) - position;
                    byte[] bytes = Arrays.copyOfRange(buff.array(), position, position + c);
                    buff.position(position + c);
                    int[] key = ArchiveToolStore.getKey(this.bucket, bytes);
                    key[3] = segmentId;
                    while (true) {
                        MVMap<int[], byte[]> data;
                        byte[] old;
                        if ((old = (byte[])(data = storeTemp.openMap("data" + segmentId)).get(key)) == null) {
                            data.put(key, bytes);
                            break;
                        }
                        if (Arrays.equals(old, bytes)) break;
                        key[2] = key[2] + 1;
                    }
                    int i = 0;
                    while (i < key.length) {
                        posList.add(key[i]);
                        ++i;
                    }
                    currentSize += (long)c;
                    if ((long)(segmentLength += c) > tempSize) {
                        storeTemp.commit();
                        ++segmentId;
                        segmentLength = 0;
                    }
                    this.printProgress(0, 50, currentSize, totalSize);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            int[] posArray = new int[posList.size()];
            int i = 0;
            while (i < posList.size()) {
                posArray[i] = (Integer)posList.get(i);
                ++i;
            }
            filesTemp.put(name, posArray);
        }
        storeTemp.commit();
        ArrayList list = new ArrayList(segmentId - 1);
        totalSize = 0L;
        int i = 1;
        while (i <= segmentId) {
            MVMap data = storeTemp.openMap("data" + i);
            totalSize += data.sizeAsLong();
            Cursor c = data.cursor(null);
            if (c.hasNext()) {
                c.next();
                list.add(c);
            }
            ++i;
        }
        segmentId = 1;
        segmentLength = 0;
        currentSize = 0L;
        MVMap<int[], byte[]> data = store.openMap("data" + segmentId);
        MVMap<int[], Boolean> keepSegment = storeTemp.openMap("keep");
        while (list.size() > 0) {
            list.sort((o1, o2) -> {
                int[] k1 = (int[])o1.getKey();
                int[] k2 = (int[])o2.getKey();
                int comp = 0;
                int i = 0;
                while (i < k1.length - 1) {
                    long x1 = k1[i];
                    long x2 = k2[i];
                    if (x1 > x2) {
                        comp = 1;
                        break;
                    }
                    if (x1 < x2) {
                        comp = -1;
                        break;
                    }
                    ++i;
                }
                return comp;
            });
            Cursor top = (Cursor)list.get(0);
            int[] key = (int[])top.getKey();
            byte[] bytes = (byte[])top.getValue();
            int[] k2 = Arrays.copyOf(key, key.length);
            k2[key.length - 1] = 0;
            byte[] old = (byte[])data.get(k2);
            if (old == null) {
                if ((long)segmentLength > tempSize) {
                    store.commit();
                    segmentLength = 0;
                    data = store.openMap("data" + ++segmentId);
                }
                key = k2;
                data.put(key, bytes);
                segmentLength += bytes.length;
            } else if (!Arrays.equals(old, bytes)) {
                keepSegment.put(key, Boolean.TRUE);
                data.put(key, bytes);
                segmentLength += bytes.length;
            }
            if (!top.hasNext()) {
                list.remove(0);
            } else {
                top.next();
            }
            this.printProgress(50, 100, ++currentSize, totalSize);
        }
        MVMap<String, int[]> files = store.openMap("files");
        for (Map.Entry e : filesTemp.entrySet()) {
            String k = (String)e.getKey();
            int[] ids = (int[])e.getValue();
            if (ids.length == 1) {
                files.put(k, ids);
                continue;
            }
            int[] newIds = Arrays.copyOf(ids, ids.length);
            int i2 = 0;
            while (i2 < ids.length) {
                int[] id = new int[]{ids[i2], ids[i2 + 1], ids[i2 + 2], ids[i2 + 3]};
                if (!keepSegment.containsKey(id)) {
                    newIds[i2 + 3] = 0;
                }
                i2 += 4;
            }
            files.put(k, newIds);
        }
        store.commit();
        storeTemp.close();
        FileUtils.delete(tempFileName);
        store.close();
        System.out.println();
        System.out.println("Compressed to " + FileUtils.size(this.fileName) / 1000000L + " MB");
        this.printDone();
    }

    private void start() {
        this.lastTime = this.start = System.nanoTime();
    }

    private void printProgress(int low, int high, long current, long total) {
        long now = System.nanoTime();
        if (now - this.lastTime > TimeUnit.SECONDS.toNanos(5L)) {
            System.out.print((long)low + (long)(high - low) * current / total + "% ");
            this.lastTime = now;
        }
    }

    private void printDone() {
        System.out.println("Done in " + TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.start) + " seconds");
    }

    private static long addFiles(String dir, ArrayList<String> list) {
        long size = 0L;
        for (String s : FileUtils.newDirectoryStream(dir)) {
            size = FileUtils.isDirectory(s) ? (size += ArchiveToolStore.addFiles(s, list)) : (size += FileUtils.size(s));
            list.add(s);
        }
        return size;
    }

    private void expand(String targetDir) throws Exception {
        String p;
        MVMap<int[], byte[]> fileData;
        this.start();
        long tempSize = 0x800000L;
        String tempFileName = this.fileName + ".temp";
        FileUtils.createDirectories(targetDir);
        MVStore store = new MVStore.Builder().fileName(this.fileName).open();
        MVMap files = store.openMap("files");
        System.out.println("Extracting " + files.size() + " files");
        MVStore storeTemp = null;
        FileUtils.delete(tempFileName);
        long totalSize = 0L;
        int lastSegment = 0;
        int i = 1;
        while (true) {
            if (!store.hasMap("data" + i)) break;
            ++i;
        }
        lastSegment = i - 1;
        storeTemp = new MVStore.Builder().fileName(tempFileName).autoCommitDisabled().open();
        MVMap<Integer, String> fileNames = storeTemp.openMap("fileNames");
        MVMap<String, int[]> filesTemp = storeTemp.openMap("files");
        int fileId = 0;
        for (Map.Entry e : files.entrySet()) {
            fileNames.put(fileId++, (String)e.getKey());
            filesTemp.put((String)e.getKey(), (int[])e.getValue());
            totalSize += (long)(((int[])e.getValue()).length / 4);
        }
        storeTemp.commit();
        files = filesTemp;
        long currentSize = 0L;
        int chunkSize = 0;
        int s = 1;
        while (s <= lastSegment) {
            MVMap segmentData = store.openMap("data" + s);
            fileData = storeTemp.openMap("fileData" + s);
            fileId = 0;
            for (Map.Entry e : files.entrySet()) {
                int[] keys = (int[])e.getValue();
                if (keys.length == 1) {
                    ++fileId;
                    continue;
                }
                int i2 = 0;
                while (i2 < keys.length) {
                    int[] dk = new int[]{keys[i2], keys[i2 + 1], keys[i2 + 2], keys[i2 + 3]};
                    byte[] bytes = (byte[])segmentData.get(dk);
                    if (bytes != null) {
                        int[] k = new int[]{fileId, i2 / 4};
                        fileData.put(k, bytes);
                        if ((long)(chunkSize += bytes.length) > tempSize) {
                            storeTemp.commit();
                            chunkSize = 0;
                        }
                        this.printProgress(0, 50, ++currentSize, totalSize);
                    }
                    i2 += 4;
                }
                ++fileId;
            }
            storeTemp.commit();
            ++s;
        }
        ArrayList list = new ArrayList(lastSegment - 1);
        totalSize = 0L;
        currentSize = 0L;
        int i3 = 1;
        while (i3 <= lastSegment) {
            fileData = storeTemp.openMap("fileData" + i3);
            totalSize += fileData.sizeAsLong();
            Cursor c = fileData.cursor(null);
            if (c.hasNext()) {
                c.next();
                list.add(c);
            }
            ++i3;
        }
        String lastFileName = null;
        OutputStream file = null;
        int[] lastKey = null;
        while (list.size() > 0) {
            list.sort((o1, o2) -> {
                int[] k1 = (int[])o1.getKey();
                int[] k2 = (int[])o2.getKey();
                int comp = 0;
                int i = 0;
                while (i < k1.length) {
                    long x1 = k1[i];
                    long x2 = k2[i];
                    if (x1 > x2) {
                        comp = 1;
                        break;
                    }
                    if (x1 < x2) {
                        comp = -1;
                        break;
                    }
                    ++i;
                }
                return comp;
            });
            Cursor top = (Cursor)list.get(0);
            int[] key = (int[])top.getKey();
            byte[] bytes = (byte[])top.getValue();
            String f = targetDir + "/" + (String)fileNames.get(key[0]);
            if (!f.equals(lastFileName)) {
                if (file != null) {
                    file.close();
                }
                if ((p = FileUtils.getParent(f)) != null) {
                    FileUtils.createDirectories(p);
                }
                file = new BufferedOutputStream(new FileOutputStream(f));
                lastFileName = f;
            } else if (key[0] != lastKey[0] || key[1] != lastKey[1] + true) {
                System.out.println("missing entry after " + Arrays.toString(lastKey));
            }
            lastKey = key;
            file.write(bytes);
            if (!top.hasNext()) {
                list.remove(0);
            } else {
                top.next();
            }
            this.printProgress(50, 100, ++currentSize, totalSize);
        }
        for (Map.Entry e : files.entrySet()) {
            String f = targetDir + "/" + (String)e.getKey();
            int[] keys = (int[])e.getValue();
            if (keys.length == 1) {
                FileUtils.createDirectories(f);
                continue;
            }
            if (keys.length != 0) continue;
            p = FileUtils.getParent(f);
            if (p != null) {
                FileUtils.createDirectories(p);
            }
            new FileOutputStream(f).close();
        }
        if (file != null) {
            file.close();
        }
        store.close();
        storeTemp.close();
        FileUtils.delete(tempFileName);
        System.out.println();
        this.printDone();
    }

    private int getChunkLength(byte[] data, int start, int maxPos) {
        int minLen = 4096;
        int mask = 4095;
        int factor = 31;
        int hash = 0;
        int mul = 1;
        int offset = 8;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int i = start;
        int[] rand = RANDOM;
        int j = 0;
        while (i < maxPos) {
            hash = hash * factor + rand[data[i] & 0xFF];
            if (j >= offset) {
                hash -= mul * rand[data[i - offset] & 0xFF];
            } else {
                mul *= factor;
            }
            if (hash < min) {
                min = hash;
            }
            if (hash > max) {
                max = hash;
            }
            if (j > minLen && (j > minLen * 4 || (hash & mask) == 1)) break;
            ++i;
            ++j;
        }
        this.bucket = min;
        return i;
    }

    private static int[] getKey(int bucket, byte[] buff) {
        int[] key = new int[4];
        int[] counts = new int[8];
        int len = buff.length;
        int i = 0;
        while (i < len) {
            int x = buff[i] & 0xFF;
            int n = x >> 5;
            counts[n] = counts[n] + 1;
            ++i;
        }
        int cs = 0;
        int i2 = 0;
        while (i2 < 8) {
            cs *= 2;
            if (counts[i2] > len / 32) {
                ++cs;
            }
            ++i2;
        }
        key[0] = cs;
        key[1] = bucket;
        key[2] = DataUtils.getFletcher32(buff, 0, buff.length);
        return key;
    }
}

