/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.dev.fs.FileZip2;
import org.h2.message.DbException;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.store.fs.disk.FilePathDisk;

public class FilePathZip2
extends FilePath {
    public static FilePathZip2 register() {
        FilePathZip2 instance = new FilePathZip2();
        FilePath.register(instance);
        return instance;
    }

    @Override
    public FilePathZip2 getPath(String path) {
        FilePathZip2 p = new FilePathZip2();
        p.name = path;
        return p;
    }

    @Override
    public void createDirectory() {
    }

    @Override
    public boolean createFile() {
        throw DbException.getUnsupportedException("write");
    }

    @Override
    public FilePath createTempFile(String suffix, boolean inTempDir) throws IOException {
        if (!inTempDir) {
            throw new IOException("File system is read-only");
        }
        return new FilePathDisk().getPath(this.name).createTempFile(suffix, true);
    }

    @Override
    public void delete() {
        throw DbException.getUnsupportedException("write");
    }

    @Override
    public boolean exists() {
        String entryName;
        block5: {
            entryName = this.getEntryName();
            if (entryName.length() != 0) break block5;
            return true;
        }
        try {
            ZipEntry entry;
            ZipInputStream file = this.openZip();
            boolean result = false;
            while ((entry = file.getNextEntry()) != null) {
                if (entry.getName().equals(entryName)) {
                    result = true;
                    break;
                }
                file.closeEntry();
            }
            file.close();
            return result;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public FilePath getParent() {
        int idx = this.name.lastIndexOf(47);
        return idx < 0 ? null : this.getPath(this.name.substring(0, idx));
    }

    @Override
    public boolean isAbsolute() {
        String fileName = FilePathZip2.translateFileName(this.name);
        return FilePath.get(fileName).isAbsolute();
    }

    @Override
    public FilePath unwrap() {
        return FilePath.get(this.name.substring(this.getScheme().length() + 1));
    }

    @Override
    public boolean isDirectory() {
        return this.isRegularOrDirectory(true);
    }

    @Override
    public boolean isRegularFile() {
        return this.isRegularOrDirectory(false);
    }

    private boolean isRegularOrDirectory(boolean directory) {
        try {
            ZipEntry entry;
            String entryName = this.getEntryName();
            if (entryName.length() == 0) {
                return directory;
            }
            ZipInputStream file = this.openZip();
            boolean result = false;
            while ((entry = file.getNextEntry()) != null) {
                String n = entry.getName();
                if (n.equals(entryName)) {
                    result = entry.isDirectory() == directory;
                    break;
                }
                if (n.startsWith(entryName) && n.length() == entryName.length() + 1 && n.equals(entryName + "/")) {
                    result = directory;
                    break;
                }
                file.closeEntry();
            }
            file.close();
            return result;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean setReadOnly() {
        return true;
    }

    @Override
    public long size() {
        try {
            ZipEntry entry;
            String entryName = this.getEntryName();
            ZipInputStream file = this.openZip();
            long result = 0L;
            while ((entry = file.getNextEntry()) != null) {
                if (entry.getName().equals(entryName)) {
                    long x;
                    result = entry.getSize();
                    if (result != -1L) break;
                    result = 0L;
                    while ((x = file.skip(65536L)) != 0L) {
                        result += x;
                    }
                    break;
                }
                file.closeEntry();
            }
            file.close();
            return result;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public ArrayList<FilePath> newDirectoryStream() {
        Object path = this.name;
        try {
            ZipEntry entry;
            if (((String)path).indexOf(33) < 0) {
                path = (String)path + "!";
            }
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            ZipInputStream file = this.openZip();
            String dirName = this.getEntryName();
            String prefix = ((String)path).substring(0, ((String)path).length() - dirName.length());
            ArrayList<FilePath> list = new ArrayList<FilePath>();
            while ((entry = file.getNextEntry()) != null) {
                int idx;
                String entryName = entry.getName();
                if (entryName.startsWith(dirName) && entryName.length() > dirName.length() && ((idx = entryName.indexOf(47, dirName.length())) < 0 || idx >= entryName.length() - 1)) {
                    list.add(this.getPath(prefix + entryName));
                }
                file.closeEntry();
            }
            file.close();
            return list;
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, "listFiles " + (String)path);
        }
    }

    @Override
    public FilePath toRealPath() {
        return this;
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return Channels.newInputStream(this.open("r"));
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        ZipEntry entry;
        String entryName = this.getEntryName();
        if (entryName.length() == 0) {
            throw new FileNotFoundException();
        }
        ZipInputStream in = this.openZip();
        while ((entry = in.getNextEntry()) != null) {
            if (entry.getName().equals(entryName)) {
                return new FileZip2(this.name, entryName, in, this.size());
            }
            in.closeEntry();
        }
        in.close();
        throw new FileNotFoundException(this.name);
    }

    @Override
    public OutputStream newOutputStream(boolean append) {
        throw DbException.getUnsupportedException("write");
    }

    @Override
    public void moveTo(FilePath newName, boolean atomicReplace) {
        throw DbException.getUnsupportedException("write");
    }

    private String getEntryName() {
        int idx = this.name.indexOf(33);
        String fileName = idx <= 0 ? "" : this.name.substring(idx + 1);
        if ((fileName = fileName.replace('\\', '/')).startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    private ZipInputStream openZip() throws IOException {
        String fileName = FilePathZip2.translateFileName(this.name);
        return new ZipInputStream(FileUtils.newInputStream(fileName));
    }

    private static String translateFileName(String fileName) {
        int idx;
        if (fileName.startsWith("zip2:")) {
            fileName = fileName.substring("zip2:".length());
        }
        if ((idx = fileName.indexOf(33)) >= 0) {
            fileName = fileName.substring(0, idx);
        }
        return FilePathDisk.expandUserHomeDirectory(fileName);
    }

    @Override
    public String getScheme() {
        return "zip2";
    }
}

