/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.ftp.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.h2.dev.ftp.server.FtpData;
import org.h2.dev.ftp.server.FtpEvent;
import org.h2.dev.ftp.server.FtpEventListener;
import org.h2.dev.ftp.server.FtpServer;
import org.h2.store.fs.FileUtils;
import org.h2.util.StringUtils;

public class FtpControl
extends Thread {
    private static final String SERVER_NAME = "Small FTP Server";
    private final FtpServer server;
    private final Socket control;
    private FtpData data;
    private PrintWriter output;
    private String userName;
    private boolean connected;
    private boolean readonly;
    private String currentDir = "/";
    private String serverIpAddress;
    private boolean stop;
    private String renameFrom;
    private boolean replied;
    private long restart;

    FtpControl(Socket control, FtpServer server, boolean stop) {
        this.server = server;
        this.control = control;
        this.stop = stop;
    }

    @Override
    public void run() {
        block7: {
            try {
                this.output = new PrintWriter(new OutputStreamWriter(this.control.getOutputStream(), StandardCharsets.UTF_8));
                if (this.stop) {
                    this.reply(421, "Too many users");
                    break block7;
                }
                this.reply(220, SERVER_NAME);
                this.serverIpAddress = this.control.getLocalAddress().getHostAddress().replace('.', ',');
                BufferedReader input = new BufferedReader(new InputStreamReader(this.control.getInputStream()));
                while (!this.stop) {
                    String command = null;
                    try {
                        command = input.readLine();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (command == null) break;
                    this.process(command);
                }
                if (this.data != null) {
                    this.data.close();
                }
            }
            catch (Throwable t) {
                this.server.traceError(t);
            }
        }
        this.server.closeConnection();
    }

    private void process(String command) throws IOException {
        int idx = command.indexOf(32);
        String param = "";
        if (idx >= 0) {
            param = command.substring(idx).trim();
            command = command.substring(0, idx);
        }
        if ((command = StringUtils.toUpperEnglish(command)).length() == 0) {
            this.reply(506, "No command");
            return;
        }
        this.server.trace(">" + command);
        FtpEventListener listener = this.server.getEventListener();
        FtpEvent event = null;
        if (listener != null) {
            event = new FtpEvent(this, command, param);
            listener.beforeCommand(event);
        }
        this.replied = false;
        if (this.connected) {
            this.processConnected(command, param);
        }
        if (!this.replied) {
            if ("USER".equals(command)) {
                this.userName = param;
                this.reply(331, "Need password");
            } else if ("QUIT".equals(command)) {
                this.reply(221, "Bye");
                this.stop = true;
            } else if ("PASS".equals(command)) {
                if (this.userName == null) {
                    this.reply(332, "Need username");
                } else if (this.server.checkUserPasswordWrite(this.userName, param)) {
                    this.reply(230, "Ok");
                    this.readonly = false;
                    this.connected = true;
                } else if (this.server.checkUserPasswordReadOnly(this.userName)) {
                    this.reply(230, "Ok, readonly");
                    this.readonly = true;
                    this.connected = true;
                } else {
                    this.reply(431, "Wrong user/password");
                }
            } else if ("REIN".equals(command)) {
                this.userName = null;
                this.connected = false;
                this.currentDir = "/";
                this.reply(200, "Ok");
            } else if ("HELP".equals(command)) {
                this.reply(214, SERVER_NAME);
            }
        }
        if (!this.replied) {
            if (listener != null) {
                listener.onUnsupportedCommand(event);
            }
            this.reply(506, "Invalid command");
        }
        if (listener != null) {
            listener.afterCommand(event);
        }
    }

    private void processConnected(String command, String param) throws IOException {
        switch (command.charAt(0)) {
            case 'C': {
                if ("CWD".equals(command)) {
                    Object path = this.getPath(param);
                    String fileName = this.getFileName((String)path);
                    if (FileUtils.exists(fileName) && FileUtils.isDirectory(fileName)) {
                        if (!((String)path).endsWith("/")) {
                            path = (String)path + "/";
                        }
                        this.currentDir = path;
                        this.reply(250, "Ok");
                        break;
                    }
                    this.reply(550, "Failed");
                    break;
                }
                if (!"CDUP".equals(command)) break;
                if (this.currentDir.length() > 1) {
                    int idx = this.currentDir.lastIndexOf(47, this.currentDir.length() - 2);
                    this.currentDir = this.currentDir.substring(0, idx + 1);
                    this.reply(250, "Ok");
                    break;
                }
                this.reply(550, "Failed");
                break;
            }
            case 'D': {
                if (!"DELE".equals(command)) break;
                String fileName = this.getFileName(param);
                if (!this.readonly && FileUtils.exists(fileName) && !FileUtils.isDirectory(fileName) && FileUtils.tryDelete(fileName)) {
                    if (this.server.getAllowTask() && fileName.endsWith(".task")) {
                        this.server.stopTask(fileName);
                    }
                    this.reply(250, "Ok");
                    break;
                }
                this.reply(500, "Delete failed");
                break;
            }
            case 'L': {
                if (!"LIST".equals(command)) break;
                this.processList(param, true);
                break;
            }
            case 'M': {
                if ("MKD".equals(command)) {
                    this.processMakeDir(param);
                    break;
                }
                if ("MODE".equals(command)) {
                    if ("S".equals(StringUtils.toUpperEnglish(param))) {
                        this.reply(200, "Ok");
                        break;
                    }
                    this.reply(504, "Invalid");
                    break;
                }
                if (!"MDTM".equals(command)) break;
                String fileName = this.getFileName(param);
                if (FileUtils.exists(fileName) && !FileUtils.isDirectory(fileName)) {
                    this.reply(213, this.server.formatLastModified(fileName));
                    break;
                }
                this.reply(550, "Failed");
                break;
            }
            case 'N': {
                if ("NLST".equals(command)) {
                    this.processList(param, false);
                    break;
                }
                if (!"NOOP".equals(command)) break;
                this.reply(200, "Ok");
                break;
            }
            case 'P': {
                if ("PWD".equals(command)) {
                    this.reply(257, StringUtils.quoteIdentifier(this.currentDir) + " directory");
                    break;
                }
                if ("PASV".equals(command)) {
                    ServerSocket dataSocket = FtpServer.createDataSocket();
                    this.data = new FtpData(this.server, this.control.getInetAddress(), dataSocket);
                    this.data.start();
                    int port = dataSocket.getLocalPort();
                    this.reply(227, "Passive Mode (" + this.serverIpAddress + "," + (port >> 8) + "," + (port & 0xFF) + ")");
                    break;
                }
                if (!"PORT".equals(command)) break;
                String[] list = StringUtils.arraySplit(param, ',', true);
                String host = list[0] + "." + list[1] + "." + list[2] + "." + list[3];
                int port = Integer.parseInt(list[4]) << 8 | Integer.parseInt(list[5]);
                InetAddress address = InetAddress.getByName(host);
                if (address.equals(this.control.getInetAddress())) {
                    this.data = new FtpData(this.server, address, port);
                    this.reply(200, "Ok");
                    break;
                }
                this.server.trace("Port REJECTED:" + String.valueOf(address) + " expected:" + String.valueOf(this.control.getInetAddress()));
                this.reply(550, "Failed");
                break;
            }
            case 'R': {
                if ("RNFR".equals(command)) {
                    String fileName = this.getFileName(param);
                    if (FileUtils.exists(fileName)) {
                        this.renameFrom = fileName;
                        this.reply(350, "Ok");
                        break;
                    }
                    this.reply(450, "Not found");
                    break;
                }
                if ("RNTO".equals(command)) {
                    if (this.renameFrom == null) {
                        this.reply(503, "RNFR required");
                        break;
                    }
                    String fileOld = this.renameFrom;
                    String fileNew = this.getFileName(param);
                    boolean ok = false;
                    if (!this.readonly) {
                        try {
                            FileUtils.move(fileOld, fileNew);
                            this.reply(250, "Ok");
                            ok = true;
                        }
                        catch (Exception e) {
                            this.server.traceError(e);
                        }
                    }
                    if (ok) break;
                    this.reply(550, "Failed");
                    break;
                }
                if ("RETR".equals(command)) {
                    String fileName = this.getFileName(param);
                    if (FileUtils.exists(fileName) && !FileUtils.isDirectory(fileName)) {
                        this.reply(150, "Starting transfer");
                        try {
                            this.data.send(fileName, this.restart);
                            this.reply(226, "Ok");
                        }
                        catch (IOException e) {
                            this.server.traceError(e);
                            this.reply(426, "Failed");
                        }
                        this.restart = 0L;
                        break;
                    }
                    this.processList(param, true);
                    break;
                }
                if ("RMD".equals(command)) {
                    this.processRemoveDir(param);
                    break;
                }
                if (!"REST".equals(command)) break;
                try {
                    this.restart = Integer.parseInt(param);
                    this.reply(350, "Ok");
                }
                catch (NumberFormatException e) {
                    this.reply(500, "Invalid");
                }
                break;
            }
            case 'S': {
                if ("SYST".equals(command)) {
                    this.reply(215, "UNIX Type: L8");
                    break;
                }
                if ("SITE".equals(command)) {
                    this.reply(500, "Not understood");
                    break;
                }
                if ("SIZE".equals(command)) {
                    if (FileUtils.exists(param = this.getFileName(param)) && !FileUtils.isDirectory(param)) {
                        this.reply(250, Long.toString(FileUtils.size(param)));
                        break;
                    }
                    this.reply(500, "Failed");
                    break;
                }
                if ("STOR".equals(command)) {
                    String fileName = this.getFileName(param);
                    if (!this.readonly && !FileUtils.exists(fileName) || !FileUtils.isDirectory(fileName)) {
                        this.reply(150, "Starting transfer");
                        try {
                            this.data.receive(fileName);
                            if (this.server.getAllowTask() && param.endsWith(".task")) {
                                this.server.startTask(fileName);
                            }
                            this.reply(226, "Ok");
                        }
                        catch (Exception e) {
                            this.server.traceError(e);
                            this.reply(426, "Failed");
                        }
                        break;
                    }
                    this.reply(550, "Failed");
                    break;
                }
                if (!"STRU".equals(command)) break;
                if ("F".equals(StringUtils.toUpperEnglish(param))) {
                    this.reply(200, "Ok");
                    break;
                }
                this.reply(504, "Invalid");
                break;
            }
            case 'T': {
                if (!"TYPE".equals(command)) break;
                if ("A".equals(param = StringUtils.toUpperEnglish(param)) || "A N".equals(param)) {
                    this.reply(200, "Ok");
                    break;
                }
                if ("I".equals(param) || "L 8".equals(param)) {
                    this.reply(200, "Ok");
                    break;
                }
                this.reply(500, "Invalid");
                break;
            }
            case 'X': {
                if ("XMKD".equals(command)) {
                    this.processMakeDir(param);
                    break;
                }
                if (!"XRMD".equals(command)) break;
                this.processRemoveDir(param);
            }
        }
    }

    private void processMakeDir(String param) {
        String fileName = this.getFileName(param);
        boolean ok = false;
        if (!this.readonly) {
            try {
                FileUtils.createDirectories(fileName);
                this.reply(257, StringUtils.quoteIdentifier(param) + " directory");
                ok = true;
            }
            catch (Exception e) {
                this.server.traceError(e);
            }
        }
        if (!ok) {
            this.reply(500, "Failed");
        }
    }

    private void processRemoveDir(String param) {
        String fileName = this.getFileName(param);
        if (!this.readonly && FileUtils.exists(fileName) && FileUtils.isDirectory(fileName) && FileUtils.tryDelete(fileName)) {
            this.reply(250, "Ok");
        } else {
            this.reply(500, "Failed");
        }
    }

    private String getFileName(String file) {
        return this.server.getFileName((String)(file.startsWith("/") ? file : this.currentDir + file));
    }

    private String getPath(String path) {
        return path.startsWith("/") ? path : this.currentDir + path;
    }

    private void processList(String param, boolean directories) throws IOException {
        String directory = this.getFileName(param);
        if (!FileUtils.exists(directory)) {
            this.reply(450, "Directory does not exist");
            return;
        }
        if (!FileUtils.isDirectory(directory)) {
            this.reply(450, "Not a directory");
            return;
        }
        String list = this.server.getDirectoryListing(directory, directories);
        this.reply(150, "Starting transfer");
        this.server.trace(list);
        this.data.send(list.getBytes());
        this.reply(226, "Done");
    }

    private void reply(int code, String message) {
        this.server.trace(code + " " + message);
        this.output.print(code + " " + message + "\r\n");
        this.output.flush();
        this.replied = true;
    }
}

