/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.sort;

import java.util.Comparator;

public class InPlaceStableQuicksort<T> {
    private static final int TEMP_SIZE = 1024;
    private static final int INSERTION_SORT_SIZE = 16;
    private T[] data;
    private Comparator<T> comp;
    private T[] temp;

    public static <T> void sort(T[] data, Comparator<T> comp) {
        new InPlaceStableQuicksort<T>().sortArray(data, comp);
    }

    public void sortArray(T[] d, Comparator<T> c) {
        this.data = d;
        this.comp = c;
        int len = Math.max((int)(100.0 * Math.log(d.length)), 1024);
        len = Math.min(d.length, len);
        Object[] t = new Object[len];
        this.temp = t;
        this.quicksort(0, d.length - 1);
    }

    private void quicksort(int from, int to) {
        while (to > from) {
            if (to - from < 16) {
                this.binaryInsertionSort(from, to);
                return;
            }
            T pivot = this.selectPivot(from, to);
            int second = this.partition(pivot, from, to);
            if (second > to) {
                pivot = this.selectPivot(from, to);
                pivot = this.data[to];
                second = this.partition(pivot, from, to);
                if (second > to) {
                    --second;
                }
            }
            this.quicksort(from, second - 1);
            from = second;
        }
    }

    private void binaryInsertionSort(int from, int to) {
        int i = from + 1;
        while (i <= to) {
            T x = this.data[i];
            int ins = this.binarySearch(x, from, i - 1);
            int j = i - 1;
            while (j >= ins) {
                this.data[j + 1] = this.data[j];
                --j;
            }
            this.data[ins] = x;
            ++i;
        }
    }

    private int binarySearch(T x, int from, int to) {
        while (from <= to) {
            int m = from + to >>> 1;
            if (this.comp.compare(x, this.data[m]) >= 0) {
                from = m + 1;
                continue;
            }
            to = m - 1;
        }
        return from;
    }

    private int partition(T pivot, int from, int to) {
        if (to - from < this.temp.length) {
            return this.partitionSmall(pivot, from, to);
        }
        int m = (from + to + 1) / 2;
        int m1 = this.partition(pivot, from, m - 1);
        int m2 = this.partition(pivot, m, to);
        this.swapBlocks(m1, m, m2 - 1);
        return m1 + m2 - m;
    }

    private int partitionSmall(T pivot, int from, int to) {
        int tempIndex = 0;
        int dataIndex = from;
        int i = from;
        while (i <= to) {
            T x = this.data[i];
            if (this.comp.compare(x, pivot) <= 0) {
                if (tempIndex > 0) {
                    this.data[dataIndex] = x;
                }
                ++dataIndex;
            } else {
                this.temp[tempIndex++] = x;
            }
            ++i;
        }
        if (tempIndex > 0) {
            System.arraycopy(this.temp, 0, this.data, dataIndex, tempIndex);
        }
        return dataIndex;
    }

    private void swapBlocks(int from, int second, int to) {
        int len1 = second - from;
        int len2 = to - second + 1;
        if (len1 == 0 || len2 == 0) {
            return;
        }
        if (len1 < this.temp.length) {
            System.arraycopy(this.data, from, this.temp, 0, len1);
            System.arraycopy(this.data, second, this.data, from, len2);
            System.arraycopy(this.temp, 0, this.data, from + len2, len1);
            return;
        }
        if (len2 < this.temp.length) {
            System.arraycopy(this.data, second, this.temp, 0, len2);
            System.arraycopy(this.data, from, this.data, from + len2, len1);
            System.arraycopy(this.temp, 0, this.data, from, len2);
            return;
        }
        this.reverseBlock(from, second - 1);
        this.reverseBlock(second, to);
        this.reverseBlock(from, to);
    }

    private void reverseBlock(int from, int to) {
        while (from < to) {
            T old = this.data[from];
            this.data[from++] = this.data[to];
            this.data[to--] = old;
        }
    }

    private T selectPivot(int from, int to) {
        int count = (int)(6.0 * Math.log10(to - from));
        count = Math.min(count, this.temp.length);
        int step = (to - from) / count;
        int i = from;
        int j = 0;
        while (i < to) {
            this.temp[j] = this.data[i];
            i += step;
            ++j;
        }
        T pivot = this.select(this.temp, 0, count - 1, count / 2);
        return pivot;
    }

    private T select(T[] d, int from, int to, int k) {
        int pivotIndex;
        int pivotNewIndex;
        int pivotDist;
        while ((pivotDist = (pivotNewIndex = this.selectPartition(d, from, to, pivotIndex = to + from >>> 1)) - from + 1) != k) {
            if (k < pivotDist) {
                to = pivotNewIndex - 1;
                continue;
            }
            k -= pivotDist;
            from = pivotNewIndex + 1;
        }
        return d[pivotNewIndex];
    }

    private int selectPartition(T[] d, int from, int to, int pivotIndex) {
        T pivotValue = d[pivotIndex];
        this.swap(d, pivotIndex, to);
        int storeIndex = from;
        int i = from;
        while (i <= to) {
            if (this.comp.compare(d[i], pivotValue) < 0) {
                this.swap(d, storeIndex, i);
                ++storeIndex;
            }
            ++i;
        }
        this.swap(d, to, storeIndex);
        return storeIndex;
    }

    private void swap(T[] d, int a, int b) {
        T t = d[a];
        d[a] = d[b];
        d[b] = t;
    }
}

