/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.util;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class AnsCompression {
    private static final long TOP = 0x1000000L;
    private static final int SHIFT = 12;
    private static final int MASK = 4095;
    private static final long MAX = 0x100000000000L;

    private AnsCompression() {
    }

    public static void countFrequencies(int[] freq, byte[] data) {
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte x = byArray[n2];
            int n3 = x & 0xFF;
            freq[n3] = freq[n3] + 1;
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void scaleFrequencies(int[] freq, int total) {
        len = freq.length;
        sum = 0;
        var7_4 = freq;
        var6_7 = freq.length;
        var5_8 = 0;
        while (var5_8 < var6_7) {
            x = var7_4[var5_8];
            sum += x;
            ++var5_8;
        }
        errors = new int[len];
        totalError = -total;
        i = 0;
        while (i < len) {
            old = freq[i];
            if (old != 0) {
                ideal = (int)((long)(old * total) * 256L / (long)sum);
                freq[i] = x = 1 + ideal / 256;
                totalError += x;
                errors[i] = (x * 256 - ideal << 8) + i;
            }
            ++i;
        }
        Arrays.sort(errors);
        if (totalError >= 0) ** GOTO lbl35
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            i = 0;
            while (totalError > 0 && i < len) {
                index = errors[i] & 255;
                if (freq[index] > 1) {
                    v0 = index;
                    freq[v0] = freq[v0] - 1;
                    --totalError;
                }
                ++i;
            }
lbl35:
            // 2 sources

            ** while (totalError > 0)
        }
lbl36:
        // 1 sources

    }

    static int[] generateCumulativeFrequencies(int[] freq) {
        int len = freq.length;
        int[] cumulativeFreq = new int[len + 1];
        int i = 0;
        int x = 0;
        while (i < len) {
            cumulativeFreq[i + 1] = x += freq[i];
            ++i;
        }
        return cumulativeFreq;
    }

    private static byte[] generateFrequencyToCode(int[] cumulativeFreq) {
        byte[] freqToCode = new byte[4096];
        int x = 0;
        int s = -1;
        int[] nArray = cumulativeFreq;
        int n = cumulativeFreq.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            while (x < i) {
                freqToCode[x++] = s;
            }
            s = (byte)(s + 1);
            ++n2;
        }
        return freqToCode;
    }

    public static byte[] encode(int[] freq, byte[] data) {
        AnsCompression.scaleFrequencies(freq, 4096);
        int[] cumulativeFreq = AnsCompression.generateCumulativeFrequencies(freq);
        ByteBuffer buff = ByteBuffer.allocate(data.length * 2);
        buff = AnsCompression.encode(data, freq, cumulativeFreq, buff);
        return Arrays.copyOfRange(buff.array(), buff.arrayOffset() + buff.position(), buff.arrayOffset() + buff.limit());
    }

    private static ByteBuffer encode(byte[] data, int[] freq, int[] cumulativeFreq, ByteBuffer buff) {
        long state = 0x1000000L;
        int b = buff.limit();
        int p = data.length - 1;
        while (p >= 0) {
            int x = data[p] & 0xFF;
            int f = freq[x];
            while (state >= 0x100000000000L * (long)f) {
                buff.putInt(b -= 4, (int)state);
                state >>>= 32;
            }
            state = (state / (long)f << 12) + state % (long)f + (long)cumulativeFreq[x];
            --p;
        }
        buff.putLong(b -= 8, state);
        buff.position(b);
        return buff.slice();
    }

    public static byte[] decode(int[] freq, byte[] data, int length) {
        AnsCompression.scaleFrequencies(freq, 4096);
        int[] cumulativeFreq = AnsCompression.generateCumulativeFrequencies(freq);
        byte[] freqToCode = AnsCompression.generateFrequencyToCode(cumulativeFreq);
        byte[] out = new byte[length];
        AnsCompression.decode(data, freq, cumulativeFreq, freqToCode, out);
        return out;
    }

    private static void decode(byte[] data, int[] freq, int[] cumulativeFreq, byte[] freqToCode, byte[] out) {
        ByteBuffer buff = ByteBuffer.wrap(data);
        long state = buff.getLong();
        int i = 0;
        int size = out.length;
        while (i < size) {
            int x = (int)state & 0xFFF;
            int c = freqToCode[x] & 0xFF;
            out[i] = (byte)c;
            state = (long)freq[c] * (state >> 12) + (long)x - (long)cumulativeFreq[c];
            while (state < 0x1000000L) {
                state = state << 32 | (long)buff.getInt() & 0xFFFFFFFFL;
            }
            ++i;
        }
    }
}

