/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.PriorityQueue;

public class BitStream {
    private BitStream() {
    }

    public static class Huffman {
        private final int[] codes;
        private final Node tree;

        public Huffman(int[] frequencies) {
            PriorityQueue<Node> queue = new PriorityQueue<Node>();
            int i = 0;
            while (i < frequencies.length) {
                int f = frequencies[i];
                if (f > 0) {
                    queue.offer(new Node(i, f));
                }
                ++i;
            }
            while (queue.size() > 1) {
                queue.offer(new Node((Node)queue.poll(), (Node)queue.poll()));
            }
            this.codes = new int[frequencies.length];
            this.tree = (Node)queue.poll();
            if (this.tree != null) {
                this.tree.initCodes(this.codes, 1);
            }
        }

        public void write(Out out, int value) {
            int bitCount;
            int code = this.codes[value];
            int i = bitCount = 30 - Integer.numberOfLeadingZeros(code);
            while (i >= 0) {
                out.writeBit(code >> i & 1);
                --i;
            }
        }

        public int read(In in) {
            Node n = this.tree;
            while (n.left != null) {
                Node node = n = in.readBit() == 1 ? n.right : n.left;
            }
            return n.value;
        }

        public int getBitCount(int value) {
            int code = this.codes[value];
            return 30 - Integer.numberOfLeadingZeros(code);
        }
    }

    public static class In {
        private final InputStream in;
        private int current = 65536;

        public In(InputStream in) {
            this.in = in;
        }

        public int readGolomb(int divisor) {
            int q = 0;
            while (this.readBit() == 1) {
                ++q;
            }
            int bit = 31 - Integer.numberOfLeadingZeros(divisor - 1);
            int r = 0;
            if (bit >= 0) {
                int cutOff = (2 << bit) - divisor;
                while (bit > 0) {
                    r = (r << 1) + this.readBit();
                    --bit;
                }
                if (r >= cutOff) {
                    r = (r << 1) + this.readBit() - cutOff;
                }
            }
            return q * divisor + r;
        }

        public int readBit() {
            if (this.current >= 65536) {
                try {
                    this.current = 0x100 | this.in.read();
                    if (this.current < 0) {
                        return -1;
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            int bit = this.current >>> 7 & 1;
            this.current <<= 1;
            return bit;
        }

        public void close() {
            try {
                this.in.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class Node
    implements Comparable<Node> {
        int value;
        Node left;
        Node right;
        private final int frequency;

        Node(int value, int frequency) {
            this.frequency = frequency;
            this.value = value;
        }

        Node(Node left, Node right) {
            this.left = left;
            this.right = right;
            this.frequency = left.frequency + right.frequency;
        }

        @Override
        public int compareTo(Node o) {
            return this.frequency - o.frequency;
        }

        void initCodes(int[] codes, int bits) {
            if (this.left == null) {
                codes[this.value] = bits;
            } else {
                this.left.initCodes(codes, bits << 1);
                this.right.initCodes(codes, (bits << 1) + 1);
            }
        }
    }

    public static class Out {
        private final OutputStream out;
        private int current = 1;

        public Out(OutputStream out) {
            this.out = out;
        }

        public void writeGolomb(int divisor, int value) {
            int q = value / divisor;
            int i = 0;
            while (i < q) {
                this.writeBit(1);
                ++i;
            }
            this.writeBit(0);
            int r = value - q * divisor;
            int bit = 31 - Integer.numberOfLeadingZeros(divisor - 1);
            if (r < (2 << bit) - divisor) {
                --bit;
            } else {
                r += (2 << bit) - divisor;
            }
            while (bit >= 0) {
                this.writeBit(r >>> bit & 1);
                --bit;
            }
        }

        public static int getGolombSize(int divisor, int value) {
            int q = value / divisor;
            int r = value - q * divisor;
            int bit = 31 - Integer.numberOfLeadingZeros(divisor - 1);
            if (r < (2 << bit) - divisor) {
                --bit;
            }
            return bit + q + 2;
        }

        public void writeBit(int bit) {
            this.current = (this.current << 1) + bit;
            if (this.current > 255) {
                try {
                    this.out.write(this.current & 0xFF);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                this.current = 1;
            }
        }

        public void flush() {
            while (this.current > 1) {
                this.writeBit(0);
            }
            try {
                this.out.flush();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public void close() {
            this.flush();
            try {
                this.out.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

