/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.h2.store.fs.FileUtils;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;

public class FileContentHash {
    private static final boolean WRITE_HASH_INDEX = true;
    private static final String HASH_INDEX = ".hash.prop";
    private static final int MIN_SIZE = 0;
    private final HashMap<String, String> hashes = new HashMap();
    private long nextLog;

    public static void main(String ... args) throws IOException {
        new FileContentHash().runTool(args);
    }

    private void runTool(String ... args) throws IOException {
        if (args.length == 0) {
            System.out.println("Usage: java " + this.getClass().getName() + " <dir>");
            return;
        }
        int i = 0;
        while (i < args.length) {
            Info info = this.hash(args[i]);
            System.out.println("size: " + info.size);
            ++i;
        }
    }

    private static MessageDigest createMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private Info hash(String path) throws IOException {
        int len;
        if (FileUtils.isDirectory(path)) {
            String newFile;
            long totalSize = 0L;
            SortedProperties propNew = new SortedProperties();
            String hashFileName = path + "/.hash.prop";
            SortedProperties propOld = FileUtils.exists(hashFileName) ? SortedProperties.loadProperties(hashFileName) : new SortedProperties();
            List<String> list = FileUtils.newDirectoryStream(path);
            Collections.sort(list);
            MessageDigest mdDir = FileContentHash.createMessageDigest();
            for (String f : list) {
                String name = FileUtils.getName(f);
                if (name.equals(HASH_INDEX)) continue;
                long length = FileUtils.size(f);
                String entry = "name_" + name + "-mod_" + FileUtils.lastModified(f) + "-size_" + length;
                String hash = propOld.getProperty(entry);
                if (hash == null || FileUtils.isDirectory(f)) {
                    Info info = this.hash(f);
                    byte[] b = info.hash;
                    hash = StringUtils.convertBytesToHex(b);
                    totalSize += info.size;
                    entry = "name_" + name + "-mod_" + FileUtils.lastModified(f) + "-size_" + info.size;
                } else {
                    totalSize += length;
                    this.checkCollision(f, length, StringUtils.convertHexToBytes(hash));
                }
                propNew.put(entry, hash);
                mdDir.update(entry.getBytes(StandardCharsets.UTF_8));
                mdDir.update(hash.getBytes(StandardCharsets.UTF_8));
            }
            String oldFile = propOld.toString();
            if (!oldFile.equals(newFile = propNew.toString())) {
                propNew.store(path + "/.hash.prop");
            }
            Info info = new Info();
            info.hash = mdDir.digest();
            info.size = totalSize;
            return info;
        }
        MessageDigest md = FileContentHash.createMessageDigest();
        InputStream in = FileUtils.newInputStream(path);
        long length = FileUtils.size(path);
        byte[] buff = new byte[0x100000];
        while ((len = in.read(buff)) >= 0) {
            md.update(buff, 0, len);
            long t = System.nanoTime();
            if (this.nextLog != 0L && t <= this.nextLog) continue;
            System.out.println("Checking " + path);
            this.nextLog = t + 5000000000L;
        }
        in.close();
        byte[] b = md.digest();
        this.checkCollision(path, length, b);
        Info info = new Info();
        info.hash = b;
        info.size = length;
        return info;
    }

    private void checkCollision(String path, long length, byte[] hash) {
        if (length < 0L) {
            return;
        }
        String s = StringUtils.convertBytesToHex(hash);
        String old = this.hashes.get(s);
        if (old != null) {
            System.out.println("Collision: " + old + "\n" + path + "\n");
        } else {
            this.hashes.put(s, path);
        }
    }

    static class Info {
        byte[] hash;
        long size;

        Info() {
        }
    }
}

