/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;

public class JavaProcessKiller {
    public static void main(String ... args) {
        new JavaProcessKiller().run(args);
    }

    private void run(String ... args) {
        TreeMap<Integer, String> map = JavaProcessKiller.getProcesses();
        System.out.println("Processes:");
        System.out.println(map);
        if (args.length == 0) {
            System.out.println("Kill a Java process");
            System.out.println("Usage: java " + this.getClass().getName() + " <name>");
            return;
        }
        String processName = args[0];
        int killCount = 0;
        for (Map.Entry<Integer, String> e : map.entrySet()) {
            String name = e.getValue();
            if (!name.equals(processName)) continue;
            int pid = e.getKey();
            System.out.println("Killing pid " + pid + "...");
            try {
                JavaProcessKiller.exec("taskkill", "/pid", "" + pid, "/f");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                JavaProcessKiller.exec("kill", "-9", "" + pid);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("done.");
            ++killCount;
        }
        if (killCount == 0) {
            System.out.println("Process " + processName + " not found");
        }
        map = JavaProcessKiller.getProcesses();
        System.out.println("Processes now:");
        System.out.println(map);
    }

    private static TreeMap<Integer, String> getProcesses() {
        String processList = JavaProcessKiller.exec("jps", "-l");
        String[] processes = processList.split("\n");
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        int i = 0;
        while (i < processes.length) {
            String p = processes[i].trim();
            int idx = p.indexOf(32);
            if (idx > 0) {
                int pid = Integer.parseInt(p.substring(0, idx));
                String n = p.substring(idx + 1);
                map.put(pid, n);
            }
            ++i;
        }
        return map;
    }

    private static String exec(String ... args) {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Process p = Runtime.getRuntime().exec(args);
            JavaProcessKiller.copyInThread(p.getInputStream(), out);
            JavaProcessKiller.copyInThread(p.getErrorStream(), err);
            p.waitFor();
            String e = new String(err.toByteArray(), StandardCharsets.UTF_8);
            if (e.length() > 0) {
                throw new RuntimeException(e);
            }
            String output = new String(out.toByteArray(), StandardCharsets.UTF_8);
            return output;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyInThread(final InputStream in, final OutputStream out) {
        new Thread("Stream copy"){

            @Override
            public void run() {
                byte[] buffer = new byte[4096];
                try {
                    int len;
                    while ((len = in.read(buffer, 0, buffer.length)) >= 0) {
                        out.write(buffer, 0, len);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }.start();
    }
}

