/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.h2.security.SHA256;
import org.h2.store.fs.FileUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class RemovePasswords {
    public static void main(String ... args) throws Exception {
        RemovePasswords.execute(args[0]);
    }

    private static void execute(String fileName) throws IOException {
        fileName = FileUtils.toRealPath(fileName);
        RandomAccessFile f = new RandomAccessFile(fileName, "rw");
        long length = f.length();
        MappedByteBuffer buff = f.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, length);
        byte[] data = new byte[200];
        int i = 0;
        while ((long)i < length - 200L) {
            if (buff.get(i) == 67 && buff.get(i + 1) == 82 && buff.get(i + 7) == 85 && buff.get(i + 8) == 83) {
                int saltIndex;
                buff.position(i);
                buff.get(data);
                String s = new String(data, StandardCharsets.UTF_8);
                if (s.startsWith("CREATE USER ") && (saltIndex = Utils.indexOf(s.getBytes(), "SALT ".getBytes(), 0)) >= 0) {
                    String userName = s.substring("CREATE USER ".length(), s.indexOf("SALT ") - 1);
                    if (userName.startsWith("IF NOT EXISTS ")) {
                        userName = userName.substring("IF NOT EXISTS ".length());
                    }
                    if (userName.startsWith("\"")) {
                        userName = userName.substring(1, userName.length() - 1);
                    }
                    System.out.println("User: " + userName);
                    byte[] userPasswordHash = SHA256.getKeyPasswordHash(userName, "".toCharArray());
                    byte[] salt = MathUtils.secureRandomBytes(8);
                    byte[] passwordHash = SHA256.getHashWithSalt(userPasswordHash, salt);
                    StringBuilder b = new StringBuilder();
                    b.append("SALT '").append(StringUtils.convertBytesToHex(salt)).append("' HASH '").append(StringUtils.convertBytesToHex(passwordHash)).append('\'');
                    byte[] replacement = b.toString().getBytes();
                    buff.position(i + saltIndex);
                    buff.put(replacement, 0, replacement.length);
                }
            }
            ++i;
        }
        f.close();
    }
}

