/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class ThreadDumpCleaner {
    private static final String[] PATTERN = new String[]{"\"Concurrent Mark-Sweep GC Thread\".*\n", "\"Exception Catcher Thread\".*\n", "JNI global references:.*\n\n", "\".*?\".*?\n   java.lang.Thread.State:.*\n\n", "\".*?\".*\n\n", "\\$\\$YJP\\$\\$", "\"(Attach|Service|VM|GC|DestroyJavaVM|Signal|AWT|AppKit|C2 |Low Mem|process reaper|YJPAgent-).*?\"(?s).*?\n\n", "   Locked ownable synchronizers:(?s).*?\n\n", "\".*?\".*?\n   java.lang.Thread.State: (TIMED_)?WAITING(?s).*?\n\n", "\".*?\".*?\n   java.lang.Thread.State:.*\n\tat sun.nio.ch.KQueueArrayWrapper.kevent0(?s).*?\n\n", "\".*?\".*?\n   java.lang.Thread.State:.*\n\tat java.io.FileInputStream.readBytes(?s).*?\n\n", "\".*?\".*?\n   java.lang.Thread.State:.*\n\tat sun.nio.ch.ServerSocketChannelImpl.accept(?s).*?\n\n", "\".*?\".*?\n   java.lang.Thread.State:.*\n\tat java.net.DualStackPlainSocketImpl.accept0(?s).*\n\n", "\".*?\".*?\n   java.lang.Thread.State:.*\n\tat sun.nio.ch.EPollArrayWrapper.epollWait(?s).*?\n\n", "\".*?\".*?\n   java.lang.Thread.State:.*\n\tat java.lang.Object.wait(?s).*?\n\n", "\".*?\".*?\n   java.lang.Thread.State:.*\n\tat java.net.PlainSocketImpl.socketAccept(?s).*?\n\n", "\".*?\".*?\n   java.lang.Thread.State:.*\n\tat java.net.SocketInputStream.socketRead0(?s).*?\n\n", "\".*?\".*?\n   java.lang.Thread.State:.*\n\tat sun.nio.ch.WindowsSelectorImpl\\$SubSelector.poll0(?s).*?\n\n"};
    private final ArrayList<Pattern> patterns = new ArrayList();

    public ThreadDumpCleaner() {
        String[] stringArray = PATTERN;
        int n = PATTERN.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.patterns.add(Pattern.compile(s));
            ++n2;
        }
    }

    public static void main(String ... args) throws IOException {
        String inFile = null;
        Object outFile = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-in")) {
                inFile = args[++i];
            } else if (args[i].equals("-out")) {
                outFile = args[++i];
            }
            ++i;
        }
        if (args.length == 0) {
            outFile = "-";
        }
        if (outFile == null) {
            outFile = inFile + ".clean.txt";
        }
        PrintWriter writer = "-".equals(outFile) ? new PrintWriter(System.out) : new PrintWriter(new BufferedWriter(new FileWriter((String)outFile)));
        InputStreamReader r = inFile != null ? new FileReader(inFile) : new InputStreamReader(System.in);
        new ThreadDumpCleaner().run(new LineNumberReader(new BufferedReader(r)), writer);
        writer.close();
        ((Reader)r).close();
    }

    private void run(LineNumberReader reader, PrintWriter writer) throws IOException {
        String line;
        StringBuilder buff = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            buff.append(line).append('\n');
            if (line.trim().length() != 0) continue;
            writer.print(this.filter(buff.toString()));
            buff = new StringBuilder();
        }
        writer.println(this.filter(buff.toString()));
    }

    private String filter(String s) {
        for (Pattern p : this.patterns) {
            s = p.matcher(s).replaceAll("");
        }
        return s;
    }
}

