/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.h2.api.DatabaseEventListener;
import org.h2.api.JavaObjectSerializer;
import org.h2.api.TableEngine;
import org.h2.command.Prepared;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.dml.SetTypes;
import org.h2.constraint.Constraint;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Comment;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.DbObject;
import org.h2.engine.DbSettings;
import org.h2.engine.DelayedDatabaseCloser;
import org.h2.engine.Engine;
import org.h2.engine.MetaRecord;
import org.h2.engine.Mode;
import org.h2.engine.OnExitDatabaseCloser;
import org.h2.engine.QueryStatisticsData;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.SessionLocal;
import org.h2.engine.Setting;
import org.h2.engine.SysProperties;
import org.h2.engine.User;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.mode.DefaultNullOrdering;
import org.h2.mode.PgCatalogSchema;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.db.LobStorageMap;
import org.h2.mvstore.db.Store;
import org.h2.result.Row;
import org.h2.result.RowFactory;
import org.h2.result.SearchRow;
import org.h2.schema.InformationSchema;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.security.auth.Authenticator;
import org.h2.store.DataHandler;
import org.h2.store.FileLock;
import org.h2.store.FileLockMethod;
import org.h2.store.FileStore;
import org.h2.store.InDoubtTransaction;
import org.h2.store.LobStorageInterface;
import org.h2.store.fs.FileUtils;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableLinkConnection;
import org.h2.table.TableSynonym;
import org.h2.table.TableType;
import org.h2.table.TableView;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.SmallLRUCache;
import org.h2.util.SourceCompiler;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.TimeZoneProvider;
import org.h2.util.Utils;
import org.h2.value.CaseInsensitiveConcurrentMap;
import org.h2.value.CaseInsensitiveMap;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.ValueInteger;
import org.h2.value.ValueTimestampTimeZone;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Database
implements DataHandler,
CastDataProvider {
    private static int initialPowerOffCount;
    private static final boolean ASSERT;
    private static final ThreadLocal<SessionLocal> META_LOCK_DEBUGGING;
    private static final ThreadLocal<Database> META_LOCK_DEBUGGING_DB;
    private static final ThreadLocal<Throwable> META_LOCK_DEBUGGING_STACK;
    private static final SessionLocal[] EMPTY_SESSION_ARRAY;
    private static final String SYSTEM_USER_NAME = "DBA";
    private final boolean persistent;
    private final String databaseName;
    private final String databaseShortName;
    private final String databaseURL;
    private final String cipher;
    private final byte[] filePasswordHash;
    private final ConcurrentHashMap<String, RightOwner> usersAndRoles = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Setting> settings = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Schema> schemas = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Right> rights = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Comment> comments = new ConcurrentHashMap();
    private final HashMap<String, TableEngine> tableEngines = new HashMap();
    private final Set<SessionLocal> userSessions = Collections.synchronizedSet(new HashSet());
    private final AtomicReference<SessionLocal> exclusiveSession = new AtomicReference();
    private final BitSet objectIds = new BitSet();
    private final Object lobSyncObject = new Object();
    private final Schema mainSchema;
    private final Schema infoSchema;
    private final Schema pgCatalogSchema;
    private int nextSessionId;
    private final AtomicInteger nextTempTableId = new AtomicInteger();
    private final User systemUser;
    private SessionLocal systemSession;
    private SessionLocal lobSession;
    private final Table meta;
    private final Index metaIdIndex;
    private FileLock lock;
    private volatile boolean starting;
    private final TraceSystem traceSystem;
    private final Trace trace;
    private final FileLockMethod fileLockMethod;
    private final Role publicRole;
    private final AtomicLong modificationDataId = new AtomicLong();
    private final AtomicLong modificationMetaId = new AtomicLong();
    private final AtomicLong remoteSettingsId = new AtomicLong();
    private CompareMode compareMode;
    private String cluster = "''";
    private boolean readOnly;
    private DatabaseEventListener eventListener;
    private int maxMemoryRows = SysProperties.MAX_MEMORY_ROWS;
    private int lockMode;
    private int maxLengthInplaceLob;
    private int allowLiterals = 2;
    private int powerOffCount = initialPowerOffCount;
    private volatile int closeDelay;
    private DelayedDatabaseCloser delayedCloser;
    private volatile boolean closing;
    private boolean ignoreCase;
    private boolean deleteFilesOnDisconnect;
    private boolean optimizeReuseResults = true;
    private final String cacheType;
    private boolean referentialIntegrity = true;
    private Mode mode = Mode.getRegular();
    private DefaultNullOrdering defaultNullOrdering = DefaultNullOrdering.LOW;
    private int maxOperationMemory = 100000;
    private SmallLRUCache<String, String[]> lobFileListCache;
    private final boolean closeAtVmShutdown;
    private final boolean autoServerMode;
    private final int autoServerPort;
    private Server server;
    private HashMap<TableLinkConnection, TableLinkConnection> linkConnections;
    private final TempFileDeleter tempFileDeleter = TempFileDeleter.getInstance();
    private int compactMode;
    private SourceCompiler compiler;
    private final LobStorageInterface lobStorage;
    private final int pageSize;
    private int defaultTableType = 0;
    private final DbSettings dbSettings;
    private final Store store;
    private boolean allowBuiltinAliasOverride;
    private final AtomicReference<DbException> backgroundException = new AtomicReference();
    private JavaObjectSerializer javaObjectSerializer;
    private String javaObjectSerializerName;
    private volatile boolean javaObjectSerializerInitialized;
    private volatile boolean queryStatistics;
    private int queryStatisticsMaxEntries = 100;
    private QueryStatisticsData queryStatisticsData;
    private RowFactory rowFactory = RowFactory.getRowFactory();
    private boolean ignoreCatalogs;
    private Authenticator authenticator;

    static {
        EMPTY_SESSION_ARRAY = new SessionLocal[0];
        boolean a = false;
        if (!$assertionsDisabled) {
            a = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERT = a;
        if (a) {
            META_LOCK_DEBUGGING = new ThreadLocal();
            META_LOCK_DEBUGGING_DB = new ThreadLocal();
            META_LOCK_DEBUGGING_STACK = new ThreadLocal();
        } else {
            META_LOCK_DEBUGGING = null;
            META_LOCK_DEBUGGING_DB = null;
            META_LOCK_DEBUGGING_STACK = null;
        }
    }

    public Database(ConnectionInfo ci, String cipher) {
        String lockMethodName;
        if (ASSERT) {
            META_LOCK_DEBUGGING.set(null);
            META_LOCK_DEBUGGING_DB.set(null);
            META_LOCK_DEBUGGING_STACK.set(null);
        }
        String databaseName = ci.getName();
        this.dbSettings = ci.getDbSettings();
        this.compareMode = CompareMode.getInstance(null, 0);
        this.persistent = ci.isPersistent();
        this.filePasswordHash = ci.getFilePasswordHash();
        this.databaseName = databaseName;
        this.databaseShortName = this.parseDatabaseShortName();
        this.maxLengthInplaceLob = this.persistent ? 256 : 0x7FFFFFF7;
        this.cipher = cipher;
        this.autoServerMode = ci.getProperty("AUTO_SERVER", false);
        this.autoServerPort = ci.getProperty("AUTO_SERVER_PORT", 0);
        this.pageSize = ci.getProperty("PAGE_SIZE", 4096);
        if (cipher != null && this.pageSize % 4096 != 0) {
            throw DbException.getUnsupportedException("CIPHER && PAGE_SIZE=" + this.pageSize);
        }
        String accessModeData = StringUtils.toLowerEnglish(ci.getProperty("ACCESS_MODE_DATA", "rw"));
        if ("r".equals(accessModeData)) {
            this.readOnly = true;
        }
        this.fileLockMethod = (lockMethodName = ci.getProperty("FILE_LOCK", null)) != null ? FileLock.getFileLockMethod(lockMethodName) : (this.autoServerMode ? FileLockMethod.FILE : FileLockMethod.FS);
        this.databaseURL = ci.getURL();
        String s = ci.removeProperty("DATABASE_EVENT_LISTENER", null);
        if (s != null) {
            this.setEventListenerClass(StringUtils.trim(s, true, true, '\''));
        }
        if ((s = ci.removeProperty("MODE", null)) != null) {
            this.mode = Mode.getInstance(s);
            if (this.mode == null) {
                throw DbException.get(90088, s);
            }
        }
        if ((s = ci.removeProperty("DEFAULT_NULL_ORDERING", null)) != null) {
            try {
                this.defaultNullOrdering = DefaultNullOrdering.valueOf(StringUtils.toUpperEnglish(s));
            }
            catch (RuntimeException e) {
                throw DbException.getInvalidValueException("DEFAULT_NULL_ORDERING", s);
            }
        }
        if ((s = ci.getProperty("JAVA_OBJECT_SERIALIZER", null)) != null) {
            this.javaObjectSerializerName = s = StringUtils.trim(s, true, true, '\'');
        }
        this.allowBuiltinAliasOverride = ci.getProperty("BUILTIN_ALIAS_OVERRIDE", false);
        if (this.autoServerMode && (this.readOnly || !this.persistent || this.fileLockMethod == FileLockMethod.NO || this.fileLockMethod == FileLockMethod.FS)) {
            throw DbException.getUnsupportedException("AUTO_SERVER=TRUE && (readOnly || inMemory || FILE_LOCK=NO || FILE_LOCK=FS)");
        }
        this.closeAtVmShutdown = ci.getProperty("DB_CLOSE_ON_EXIT", this.persistent);
        if (this.autoServerMode && !this.closeAtVmShutdown) {
            throw DbException.getUnsupportedException("AUTO_SERVER=TRUE && DB_CLOSE_ON_EXIT=FALSE");
        }
        int traceLevelFile = ci.getIntProperty(9, 1);
        int traceLevelSystemOut = ci.getIntProperty(8, 0);
        this.cacheType = StringUtils.toUpperEnglish(ci.removeProperty("CACHE_TYPE", "LRU"));
        this.ignoreCatalogs = ci.getProperty("IGNORE_CATALOGS", this.dbSettings.ignoreCatalogs);
        this.lockMode = ci.getProperty("LOCK_MODE", 3);
        String traceFile = this.persistent ? (this.readOnly ? (traceLevelFile >= 3 ? Utils.getProperty("java.io.tmpdir", ".") + "/h2_" + System.currentTimeMillis() + ".trace.db" : null) : databaseName + ".trace.db") : null;
        this.traceSystem = new TraceSystem(traceFile);
        this.traceSystem.setLevelFile(traceLevelFile);
        this.traceSystem.setLevelSystemOut(traceLevelSystemOut);
        this.trace = this.traceSystem.getTrace(2);
        this.trace.info("opening {0} (build {1})", databaseName, 229);
        try {
            String settingName;
            Setting setting;
            if (this.persistent) {
                String lockFileName = databaseName + ".lock.db";
                if (this.readOnly) {
                    if (FileUtils.exists(lockFileName)) {
                        throw DbException.get(90020, "Lock file exists: " + lockFileName);
                    }
                } else if (this.fileLockMethod != FileLockMethod.NO && this.fileLockMethod != FileLockMethod.FS) {
                    this.lock = new FileLock(this.traceSystem, lockFileName, 1000);
                    this.lock.lock(this.fileLockMethod);
                    if (this.autoServerMode) {
                        this.startServer(this.lock.getUniqueId());
                    }
                }
                this.deleteOldTempFiles();
            }
            this.starting = true;
            if (!this.dbSettings.mvStore) {
                throw new UnsupportedOperationException();
            }
            this.store = new Store(this, ci.getFileEncryptionKey());
            this.starting = false;
            this.systemUser = new User(this, 0, SYSTEM_USER_NAME, true);
            this.systemUser.setAdmin(true);
            this.mainSchema = new Schema(this, 0, this.sysIdentifier("PUBLIC"), this.systemUser, true);
            this.infoSchema = new InformationSchema(this, this.systemUser);
            this.schemas.put(this.mainSchema.getName(), this.mainSchema);
            this.schemas.put(this.infoSchema.getName(), this.infoSchema);
            if (this.mode.getEnum() == Mode.ModeEnum.PostgreSQL) {
                this.pgCatalogSchema = new PgCatalogSchema(this, this.systemUser);
                this.schemas.put(this.pgCatalogSchema.getName(), this.pgCatalogSchema);
            } else {
                this.pgCatalogSchema = null;
            }
            this.publicRole = new Role(this, 0, this.sysIdentifier("PUBLIC"), true);
            this.usersAndRoles.put(this.publicRole.getName(), this.publicRole);
            this.systemSession = this.createSession(this.systemUser);
            this.lobSession = this.createSession(this.systemUser);
            Set<String> settingKeys = this.dbSettings.getSettings().keySet();
            this.store.getTransactionStore().init(this.lobSession);
            settingKeys.removeIf(name -> name.startsWith("PAGE_STORE_"));
            CreateTableData data = this.createSysTableData();
            this.starting = true;
            this.meta = this.mainSchema.createTable(data);
            IndexColumn[] pkCols = IndexColumn.wrap(new Column[]{data.columns.get(0)});
            this.metaIdIndex = this.meta.addIndex(this.systemSession, "SYS_ID", 0, pkCols, 1, IndexType.createPrimaryKey(false, false), true, null);
            this.systemSession.commit(true);
            this.objectIds.set(0);
            this.executeMeta();
            this.systemSession.commit(true);
            this.store.getTransactionStore().endLeftoverTransactions();
            this.store.removeTemporaryMaps(this.objectIds);
            this.recompileInvalidViews();
            this.starting = false;
            if (!this.readOnly && (setting = this.settings.get(settingName = SetTypes.getTypeName(28))) == null) {
                setting = new Setting(this, this.allocateObjectId(), settingName);
                setting.setIntValue(229);
                this.lockMeta(this.systemSession);
                this.addDatabaseObject(this.systemSession, setting);
            }
            this.lobStorage = new LobStorageMap(this);
            this.lobSession.commit(true);
            this.systemSession.commit(true);
            this.trace.info("opened {0}", databaseName);
            if (this.persistent) {
                int writeDelay = ci.getProperty("WRITE_DELAY", 500);
                this.setWriteDelay(writeDelay);
            }
            if (this.closeAtVmShutdown || this.persistent) {
                OnExitDatabaseCloser.register(this);
            }
        }
        catch (Throwable e) {
            try {
                if (e instanceof OutOfMemoryError) {
                    e.fillInStackTrace();
                }
                if (e instanceof DbException) {
                    if (((DbException)e).getErrorCode() == 90020) {
                        this.stopServer();
                    } else {
                        this.trace.error(e, "opening {0}", databaseName);
                    }
                }
                this.traceSystem.close();
                this.closeOpenFilesAndUnlock();
            }
            catch (Throwable ex) {
                e.addSuppressed(ex);
            }
            throw DbException.convert(e);
        }
    }

    public int getLockTimeout() {
        Setting setting = this.findSetting(SetTypes.getTypeName(5));
        return setting == null ? 2000 : setting.getIntValue();
    }

    public RowFactory getRowFactory() {
        return this.rowFactory;
    }

    public void setRowFactory(RowFactory rowFactory) {
        this.rowFactory = rowFactory;
    }

    public static void setInitialPowerOffCount(int count) {
        initialPowerOffCount = count;
    }

    public void setPowerOffCount(int count) {
        if (this.powerOffCount == -1) {
            return;
        }
        this.powerOffCount = count;
    }

    public Store getStore() {
        return this.store;
    }

    public long getModificationDataId() {
        return this.modificationDataId.get();
    }

    public long getNextModificationDataId() {
        return this.modificationDataId.incrementAndGet();
    }

    public long getModificationMetaId() {
        return this.modificationMetaId.get();
    }

    public long getNextModificationMetaId() {
        this.modificationDataId.incrementAndGet();
        return this.modificationMetaId.incrementAndGet() - 1L;
    }

    public long getRemoteSettingsId() {
        return this.remoteSettingsId.get();
    }

    public long getNextRemoteSettingsId() {
        return this.remoteSettingsId.incrementAndGet();
    }

    public int getPowerOffCount() {
        return this.powerOffCount;
    }

    @Override
    public void checkPowerOff() {
        if (this.powerOffCount != 0) {
            this.checkPowerOff2();
        }
    }

    private void checkPowerOff2() {
        if (this.powerOffCount > 1) {
            --this.powerOffCount;
            return;
        }
        if (this.powerOffCount != -1) {
            try {
                this.powerOffCount = -1;
                this.store.closeImmediately();
                if (this.lock != null) {
                    this.stopServer();
                    this.lock.unlock();
                    this.lock = null;
                }
                if (this.traceSystem != null) {
                    this.traceSystem.close();
                }
            }
            catch (DbException e) {
                DbException.traceThrowable(e);
            }
        }
        Engine.close(this.databaseName);
        throw DbException.get(90098);
    }

    public Trace getTrace(int moduleId) {
        return this.traceSystem.getTrace(moduleId);
    }

    @Override
    public FileStore openFile(String name, String openMode, boolean mustExist) {
        if (mustExist && !FileUtils.exists(name)) {
            throw DbException.get(90124, name);
        }
        FileStore store = FileStore.open(this, name, openMode, this.cipher, this.filePasswordHash);
        try {
            store.init();
        }
        catch (DbException e) {
            store.closeSilently();
            throw e;
        }
        return store;
    }

    boolean validateFilePasswordHash(String testCipher, byte[] testHash) {
        if (!Objects.equals(testCipher, this.cipher)) {
            return false;
        }
        return Utils.compareSecure(testHash, this.filePasswordHash);
    }

    private String parseDatabaseShortName() {
        int l;
        String n = this.databaseName;
        int i = l = n.length();
        block3: while (--i >= 0) {
            char ch = n.charAt(i);
            switch (ch) {
                case '/': 
                case ':': 
                case '\\': {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        String string = n = ++i == l ? "UNNAMED" : n.substring(i);
        return StringUtils.truncateString(this.dbSettings.databaseToUpper ? StringUtils.toUpperEnglish(n) : (this.dbSettings.databaseToLower ? StringUtils.toLowerEnglish(n) : n), 256);
    }

    private CreateTableData createSysTableData() {
        CreateTableData data = new CreateTableData();
        ArrayList<Column> cols = data.columns;
        Column columnId = new Column("ID", TypeInfo.TYPE_INTEGER);
        columnId.setNullable(false);
        cols.add(columnId);
        cols.add(new Column("HEAD", TypeInfo.TYPE_INTEGER));
        cols.add(new Column("TYPE", TypeInfo.TYPE_INTEGER));
        cols.add(new Column("SQL", TypeInfo.TYPE_VARCHAR));
        data.tableName = "SYS";
        data.id = 0;
        data.temporary = false;
        data.persistData = this.persistent;
        data.persistIndexes = this.persistent;
        data.session = this.systemSession;
        return data;
    }

    private void executeMeta() {
        Cursor cursor = this.metaIdIndex.find(this.systemSession, null, null, false);
        ArrayList<MetaRecord> firstRecords = new ArrayList<MetaRecord>();
        ArrayList<MetaRecord> domainRecords = new ArrayList<MetaRecord>();
        ArrayList<MetaRecord> middleRecords = new ArrayList<MetaRecord>();
        ArrayList<MetaRecord> constraintRecords = new ArrayList<MetaRecord>();
        ArrayList<MetaRecord> lastRecords = new ArrayList<MetaRecord>();
        while (cursor.next()) {
            MetaRecord rec = new MetaRecord(cursor.get());
            this.objectIds.set(rec.getId());
            switch (rec.getObjectType()) {
                case 2: 
                case 6: 
                case 9: 
                case 10: {
                    firstRecords.add(rec);
                    break;
                }
                case 12: {
                    domainRecords.add(rec);
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 11: {
                    middleRecords.add(rec);
                    break;
                }
                case 5: {
                    constraintRecords.add(rec);
                    break;
                }
                default: {
                    lastRecords.add(rec);
                }
            }
        }
        SessionLocal systemSession = this.systemSession;
        systemSession.lock();
        try {
            this.executeMeta(firstRecords);
            int count = domainRecords.size();
            if (count > 0) {
                int j = 0;
                while (true) {
                    DbException exception = null;
                    int i = 0;
                    while (i < count) {
                        MetaRecord rec = (MetaRecord)domainRecords.get(i);
                        try {
                            rec.prepareAndExecute(this, systemSession, this.eventListener);
                        }
                        catch (DbException ex) {
                            if (exception == null) {
                                exception = ex;
                            }
                            domainRecords.set(j++, rec);
                        }
                        ++i;
                    }
                    if (exception == null) break;
                    if (count == j) {
                        throw exception;
                    }
                    count = j;
                }
            }
            this.executeMeta(middleRecords);
            count = constraintRecords.size();
            if (count > 0) {
                ArrayList<Prepared> constraints = new ArrayList<Prepared>(count);
                int i = 0;
                while (i < count) {
                    Prepared prepared = ((MetaRecord)constraintRecords.get(i)).prepare(this, systemSession, this.eventListener);
                    if (prepared != null) {
                        constraints.add(prepared);
                    }
                    ++i;
                }
                constraints.sort(MetaRecord.CONSTRAINTS_COMPARATOR);
                for (Prepared constraint : constraints) {
                    MetaRecord.execute(this, constraint, this.eventListener, constraint.getSQL());
                }
            }
            this.executeMeta(lastRecords);
        }
        finally {
            systemSession.unlock();
        }
    }

    private void executeMeta(ArrayList<MetaRecord> records) {
        if (!records.isEmpty()) {
            records.sort(null);
            for (MetaRecord rec : records) {
                rec.prepareAndExecute(this, this.systemSession, this.eventListener);
            }
        }
    }

    private void startServer(String key) {
        try {
            this.server = Server.createTcpServer("-tcpPort", Integer.toString(this.autoServerPort), "-tcpAllowOthers", "-tcpDaemon", "-key", key, this.databaseName);
            this.server.start();
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
        String localAddress = NetUtils.getLocalAddress();
        String address = localAddress + ":" + this.server.getPort();
        this.lock.setProperty("server", address);
        String hostName = NetUtils.getHostName(localAddress);
        this.lock.setProperty("hostName", hostName);
        this.lock.save();
    }

    private void stopServer() {
        if (this.server != null) {
            Server s = this.server;
            this.server = null;
            s.stop();
        }
    }

    private void recompileInvalidViews() {
        boolean atLeastOneRecompiledSuccessfully;
        do {
            atLeastOneRecompiledSuccessfully = false;
            for (Schema schema : this.schemas.values()) {
                for (Table obj : schema.getAllTablesAndViews(null)) {
                    TableView view;
                    if (!(obj instanceof TableView) || !(view = (TableView)obj).isInvalid()) continue;
                    view.recompile(this.systemSession, true, false);
                    if (view.isInvalid()) continue;
                    atLeastOneRecompiledSuccessfully = true;
                }
            }
        } while (atLeastOneRecompiledSuccessfully);
        TableView.clearIndexCaches(this);
    }

    private void addMeta(SessionLocal session, DbObject obj) {
        assert (Thread.holdsLock(this));
        int id = obj.getId();
        if (id > 0 && !obj.isTemporary() && !this.isReadOnly()) {
            Cursor cursor;
            Row r = this.meta.getTemplateRow();
            MetaRecord.populateRowFromDBObject(obj, r);
            assert (this.objectIds.get(id));
            if (SysProperties.CHECK) {
                this.verifyMetaLocked(session);
            }
            if (!(cursor = this.metaIdIndex.find(session, r, r, false)).next()) {
                this.meta.addRow(session, r);
            } else {
                assert (this.starting);
                Row oldRow = cursor.get();
                MetaRecord rec = new MetaRecord(oldRow);
                assert (rec.getId() == obj.getId());
                assert (rec.getObjectType() == obj.getType());
                if (!rec.getSQL().equals(obj.getCreateSQLForMeta())) {
                    this.meta.updateRow(session, oldRow, r);
                }
            }
        }
    }

    public void verifyMetaLocked(SessionLocal session) {
        if (this.lockMode != 0 && this.meta != null && !this.meta.isLockedExclusivelyBy(session)) {
            throw DbException.getInternalError();
        }
    }

    public boolean lockMeta(SessionLocal session) {
        if (this.meta == null) {
            return true;
        }
        if (ASSERT) {
            this.lockMetaAssertion(session);
        }
        return this.meta.lock(session, 2);
    }

    private void lockMetaAssertion(SessionLocal session) {
        if (META_LOCK_DEBUGGING_DB.get() != null && META_LOCK_DEBUGGING_DB.get() != this) {
            SessionLocal prev = META_LOCK_DEBUGGING.get();
            if (prev == null) {
                META_LOCK_DEBUGGING.set(session);
                META_LOCK_DEBUGGING_DB.set(this);
                META_LOCK_DEBUGGING_STACK.set(new Throwable("Last meta lock granted in this stack trace, this is debug information for following IllegalStateException"));
            } else if (prev != session) {
                META_LOCK_DEBUGGING_STACK.get().printStackTrace();
                throw new IllegalStateException("meta currently locked by " + String.valueOf(prev) + ", sessionid=" + prev.getId() + " and trying to be locked by different session, " + String.valueOf(session) + ", sessionid=" + session.getId() + " on same thread");
            }
        }
    }

    public void unlockMeta(SessionLocal session) {
        if (this.meta != null) {
            Database.unlockMetaDebug(session);
            this.meta.unlock(session);
            session.unlock(this.meta);
        }
    }

    static void unlockMetaDebug(SessionLocal session) {
        if (ASSERT && META_LOCK_DEBUGGING.get() == session) {
            META_LOCK_DEBUGGING.set(null);
            META_LOCK_DEBUGGING_DB.set(null);
            META_LOCK_DEBUGGING_STACK.set(null);
        }
    }

    public void removeMeta(SessionLocal session, int id) {
        if (id > 0 && !this.starting) {
            SearchRow r = this.meta.getRowFactory().createRow();
            r.setValue(0, ValueInteger.get(id));
            boolean wasLocked = this.lockMeta(session);
            try {
                Cursor cursor = this.metaIdIndex.find(session, r, r, false);
                if (cursor.next()) {
                    Row found = cursor.get();
                    this.meta.removeRow(session, found);
                    if (SysProperties.CHECK) {
                        this.checkMetaFree(session, id);
                    }
                }
            }
            finally {
                if (!wasLocked) {
                    this.unlockMeta(session);
                }
            }
            session.scheduleDatabaseObjectIdForRelease(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDatabaseObjectIds(BitSet idsToRelease) {
        BitSet bitSet = this.objectIds;
        synchronized (bitSet) {
            this.objectIds.andNot(idsToRelease);
        }
    }

    private ConcurrentHashMap<String, DbObject> getMap(int type) {
        ConcurrentHashMap<String, DbObject> result;
        switch (type) {
            case 2: 
            case 7: {
                result = this.usersAndRoles;
                break;
            }
            case 6: {
                result = this.settings;
                break;
            }
            case 8: {
                result = this.rights;
                break;
            }
            case 10: {
                result = this.schemas;
                break;
            }
            case 13: {
                result = this.comments;
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + type);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchemaObject(SessionLocal session, SchemaObject obj) {
        int id = obj.getId();
        if (id > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        this.lockMeta(session);
        Database database = this;
        synchronized (database) {
            obj.getSchema().add(obj);
            this.addMeta(session, obj);
        }
    }

    public synchronized void addDatabaseObject(SessionLocal session, DbObject obj) {
        User user;
        int id = obj.getId();
        if (id > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        ConcurrentHashMap<String, DbObject> map = this.getMap(obj.getType());
        if (obj.getType() == 2 && (user = (User)obj).isAdmin() && this.systemUser.getName().equals(SYSTEM_USER_NAME)) {
            this.systemUser.rename(user.getName());
        }
        String name = obj.getName();
        if (SysProperties.CHECK && map.get(name) != null) {
            throw DbException.getInternalError("object already exists");
        }
        this.lockMeta(session);
        this.addMeta(session, obj);
        map.put(name, obj);
    }

    public Comment findComment(DbObject object) {
        if (object.getType() == 13) {
            return null;
        }
        String key = Comment.getKey(object);
        return this.comments.get(key);
    }

    public Role findRole(String roleName) {
        RightOwner rightOwner = this.findUserOrRole(roleName);
        return rightOwner instanceof Role ? (Role)rightOwner : null;
    }

    public Schema findSchema(String schemaName) {
        if (schemaName == null) {
            return null;
        }
        return this.schemas.get(schemaName);
    }

    public Setting findSetting(String name) {
        return this.settings.get(name);
    }

    public User findUser(String name) {
        RightOwner rightOwner = this.findUserOrRole(name);
        return rightOwner instanceof User ? (User)rightOwner : null;
    }

    public User getUser(String name) {
        User user = this.findUser(name);
        if (user == null) {
            throw DbException.get(90032, name);
        }
        return user;
    }

    public RightOwner findUserOrRole(String name) {
        return this.usersAndRoles.get(StringUtils.toUpperEnglish(name));
    }

    synchronized SessionLocal createSession(User user, NetworkConnectionInfo networkConnectionInfo) {
        if (this.closing) {
            return null;
        }
        if (this.exclusiveSession.get() != null) {
            throw DbException.get(90135);
        }
        SessionLocal session = this.createSession(user);
        session.setNetworkConnectionInfo(networkConnectionInfo);
        this.userSessions.add(session);
        this.trace.info("connecting session #{0} to {1}", session.getId(), this.databaseName);
        if (this.delayedCloser != null) {
            this.delayedCloser.reset();
            this.delayedCloser = null;
        }
        return session;
    }

    private SessionLocal createSession(User user) {
        int id = ++this.nextSessionId;
        return new SessionLocal(this, user, id);
    }

    public synchronized void removeSession(SessionLocal session) {
        if (session != null) {
            this.exclusiveSession.compareAndSet(session, null);
            if (this.userSessions.remove(session)) {
                this.trace.info("disconnecting session #{0}", session.getId());
            }
        }
        if (this.isUserSession(session)) {
            if (this.userSessions.isEmpty()) {
                if (this.closeDelay == 0) {
                    this.close();
                } else {
                    if (this.closeDelay < 0) {
                        return;
                    }
                    this.delayedCloser = new DelayedDatabaseCloser(this, this.closeDelay * 1000);
                }
            }
            if (session != null) {
                this.trace.info("disconnected session #{0}", session.getId());
            }
        }
    }

    boolean isUserSession(SessionLocal session) {
        return session != this.systemSession && session != this.lobSession;
    }

    private synchronized void closeAllSessionsExcept(SessionLocal except) {
        SessionLocal s3;
        int n;
        int n2;
        SessionLocal[] sessionLocalArray;
        SessionLocal[] all = this.userSessions.toArray(EMPTY_SESSION_ARRAY);
        boolean done = true;
        SessionLocal[] sessionLocalArray2 = all;
        int n3 = all.length;
        int n4 = 0;
        while (n4 < n3) {
            SessionLocal s2 = sessionLocalArray2[n4];
            if (s2 != except) {
                s2.suspend();
                done = false;
            }
            ++n4;
        }
        if (done) {
            return;
        }
        int lockTimeout = this.getLockTimeout();
        long sleepMillis = Math.max(lockTimeout / 10, 1);
        long timeoutNanos = (long)lockTimeout * 2000000L;
        long start = System.nanoTime();
        do {
            done = true;
            sessionLocalArray = all;
            n2 = all.length;
            n = 0;
            while (n < n2) {
                s3 = sessionLocalArray[n];
                if (s3 != except && !s3.isClosed()) {
                    done = false;
                    break;
                }
                ++n;
            }
            if (done) {
                return;
            }
            try {
                this.wait(sleepMillis);
            }
            catch (InterruptedException s3) {
                // empty catch block
            }
        } while (System.nanoTime() - start <= timeoutNanos);
        sessionLocalArray = all;
        n2 = all.length;
        n = 0;
        while (n < n2) {
            s3 = sessionLocalArray[n];
            if (s3 != except && !s3.isClosed()) {
                try {
                    s3.close();
                }
                catch (Throwable e) {
                    this.trace.error(e, "disconnecting session #{0}", s3.getId());
                }
            }
            ++n;
        }
    }

    void close() {
        this.close(false);
    }

    void onShutdown() {
        if (this.closeAtVmShutdown) {
            this.close(true);
        } else if (this.persistent) {
            this.checkpoint();
        }
    }

    private void close(boolean fromShutdownHook) {
        DbException b = this.backgroundException.getAndSet(null);
        try {
            this.closeImpl(fromShutdownHook);
        }
        catch (Throwable t) {
            if (b != null) {
                t.addSuppressed(b);
            }
            throw t;
        }
        if (b != null) {
            throw DbException.get(b.getErrorCode(), b, b.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImpl(boolean fromShutdownHook) {
        Database database = this;
        synchronized (database) {
            if (this.closing || !fromShutdownHook && !this.userSessions.isEmpty()) {
                return;
            }
            this.closing = true;
            this.stopServer();
            if (!this.userSessions.isEmpty()) {
                assert (fromShutdownHook);
                this.trace.info("closing {0} from shutdown hook", this.databaseName);
                this.closeAllSessionsExcept(null);
            }
            this.trace.info("closing {0}", this.databaseName);
            if (this.eventListener != null) {
                this.closing = false;
                Iterator<Schema> e = this.eventListener;
                this.eventListener = null;
                e.closingDatabase();
                this.closing = true;
                if (!this.userSessions.isEmpty()) {
                    this.trace.info("event listener {0} left connection open", e.getClass().getName());
                    this.closeAllSessionsExcept(null);
                }
            }
        }
        try {
            try {
                if (this.systemSession != null) {
                    if (this.powerOffCount != -1) {
                        for (Schema schema : this.schemas.values()) {
                            for (Table table : schema.getAllTablesAndViews(null)) {
                                if (table.isGlobalTemporary()) {
                                    this.removeSchemaObject(this.systemSession, table);
                                    continue;
                                }
                                table.close(this.systemSession);
                            }
                        }
                        for (Schema schema : this.schemas.values()) {
                            for (Sequence sequence : schema.getAllSequences()) {
                                sequence.close();
                            }
                        }
                    }
                    for (Schema schema : this.schemas.values()) {
                        for (TriggerObject trigger : schema.getAllTriggers()) {
                            try {
                                trigger.close();
                            }
                            catch (SQLException e) {
                                this.trace.error(e, "close");
                            }
                        }
                    }
                    if (this.powerOffCount != -1) {
                        this.meta.close(this.systemSession);
                        this.systemSession.commit(true);
                    }
                    if (this.lobSession != null) {
                        this.lobSession.close();
                        this.lobSession = null;
                    }
                    this.systemSession.close();
                    this.systemSession = null;
                }
                this.tempFileDeleter.deleteAll();
                this.closeOpenFilesAndUnlock();
            }
            catch (DbException | MVStoreException e) {
                this.trace.error(e, "close");
            }
            this.trace.info("closed");
            this.traceSystem.close();
            OnExitDatabaseCloser.unregister(this);
            if (this.deleteFilesOnDisconnect && this.persistent) {
                this.deleteFilesOnDisconnect = false;
                try {
                    String directory = FileUtils.getParent(this.databaseName);
                    String name = FileUtils.getName(this.databaseName);
                    DeleteDbFiles.execute(directory, name, true);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            Engine.close(this.databaseName);
        }
    }

    private synchronized void closeOpenFilesAndUnlock() {
        try {
            if (this.lobStorage != null) {
                this.lobStorage.close();
            }
            if (this.store != null && !this.store.getMvStore().isClosed()) {
                if (this.compactMode == 81) {
                    this.store.closeImmediately();
                } else {
                    int allowedCompactionTime = this.compactMode == 82 || this.compactMode == 84 || this.dbSettings.defragAlways ? -1 : this.dbSettings.maxCompactTime;
                    this.store.close(allowedCompactionTime);
                }
                if (this.persistent && (this.lock != null || this.fileLockMethod == FileLockMethod.NO || this.fileLockMethod == FileLockMethod.FS)) {
                    this.deleteOldTempFiles();
                }
            }
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
                this.lock = null;
            }
        }
    }

    private synchronized void closeFiles() {
        try {
            this.store.closeImmediately();
        }
        catch (DbException e) {
            this.trace.error(e, "close");
        }
    }

    private void checkMetaFree(SessionLocal session, int id) {
        SearchRow r = this.meta.getRowFactory().createRow();
        r.setValue(0, ValueInteger.get(id));
        Cursor cursor = this.metaIdIndex.find(session, r, r, false);
        if (cursor.next()) {
            throw DbException.getInternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocateObjectId() {
        int i;
        BitSet bitSet = this.objectIds;
        synchronized (bitSet) {
            i = this.objectIds.nextClearBit(0);
            this.objectIds.set(i);
        }
        return i;
    }

    public User getSystemUser() {
        return this.systemUser;
    }

    public Schema getMainSchema() {
        return this.mainSchema;
    }

    public ArrayList<Comment> getAllComments() {
        return new ArrayList<Comment>(this.comments.values());
    }

    public int getAllowLiterals() {
        if (this.starting) {
            return 2;
        }
        return this.allowLiterals;
    }

    public ArrayList<Right> getAllRights() {
        return new ArrayList<Right>(this.rights.values());
    }

    public ArrayList<Table> getAllTablesAndViews() {
        ArrayList<Table> list = new ArrayList<Table>();
        for (Schema schema : this.schemas.values()) {
            list.addAll(schema.getAllTablesAndViews(null));
        }
        return list;
    }

    public ArrayList<TableSynonym> getAllSynonyms() {
        ArrayList<TableSynonym> list = new ArrayList<TableSynonym>();
        for (Schema schema : this.schemas.values()) {
            list.addAll(schema.getAllSynonyms());
        }
        return list;
    }

    public Collection<Schema> getAllSchemas() {
        return this.schemas.values();
    }

    public Collection<Schema> getAllSchemasNoMeta() {
        return this.schemas.values();
    }

    public Collection<Setting> getAllSettings() {
        return this.settings.values();
    }

    public Collection<RightOwner> getAllUsersAndRoles() {
        return this.usersAndRoles.values();
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public String getCluster() {
        return this.cluster;
    }

    @Override
    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    @Override
    public String getDatabasePath() {
        if (this.persistent) {
            return FileUtils.toRealPath(this.databaseName);
        }
        return null;
    }

    public String getShortName() {
        return this.databaseShortName;
    }

    public String getName() {
        return this.databaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionLocal[] getSessions(boolean includingSystemSession) {
        ArrayList<SessionLocal> list;
        Database database = this;
        synchronized (database) {
            list = new ArrayList<SessionLocal>(this.userSessions);
        }
        if (includingSystemSession) {
            SessionLocal s = this.systemSession;
            if (s != null) {
                list.add(s);
            }
            if ((s = this.lobSession) != null) {
                list.add(s);
            }
        }
        return list.toArray(new SessionLocal[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMeta(SessionLocal session, DbObject obj) {
        int id = obj.getId();
        if (id > 0) {
            if (!this.starting && !obj.isTemporary()) {
                Row newRow = this.meta.getTemplateRow();
                MetaRecord.populateRowFromDBObject(obj, newRow);
                Row oldRow = this.metaIdIndex.getRow(session, id);
                if (oldRow != null) {
                    this.meta.updateRow(session, oldRow, newRow);
                }
            }
            BitSet bitSet = this.objectIds;
            synchronized (bitSet) {
                this.objectIds.set(id);
            }
        }
    }

    public synchronized void renameSchemaObject(SessionLocal session, SchemaObject obj, String newName) {
        this.checkWritingAllowed();
        obj.getSchema().rename(obj, newName);
        this.updateMetaAndFirstLevelChildren(session, obj);
    }

    private synchronized void updateMetaAndFirstLevelChildren(SessionLocal session, DbObject obj) {
        ArrayList<DbObject> list = obj.getChildren();
        Comment comment = this.findComment(obj);
        if (comment != null) {
            throw DbException.getInternalError(comment.toString());
        }
        this.updateMeta(session, obj);
        if (list != null) {
            for (DbObject o : list) {
                if (o.getCreateSQL() == null) continue;
                this.updateMeta(session, o);
            }
        }
    }

    public synchronized void renameDatabaseObject(SessionLocal session, DbObject obj, String newName) {
        this.checkWritingAllowed();
        int type = obj.getType();
        ConcurrentHashMap<String, DbObject> map = this.getMap(type);
        if (SysProperties.CHECK) {
            if (!map.containsKey(obj.getName())) {
                throw DbException.getInternalError("not found: " + obj.getName());
            }
            if (obj.getName().equals(newName) || map.containsKey(newName)) {
                throw DbException.getInternalError("object already exists: " + newName);
            }
        }
        obj.checkRename();
        map.remove(obj.getName());
        obj.rename(newName);
        map.put(newName, obj);
        this.updateMetaAndFirstLevelChildren(session, obj);
    }

    private void deleteOldTempFiles() {
        String path = FileUtils.getParent(this.databaseName);
        for (String name : FileUtils.newDirectoryStream(path)) {
            if (!name.endsWith(".temp.db") || !name.startsWith(this.databaseName)) continue;
            FileUtils.tryDelete(name);
        }
    }

    public Schema getSchema(String schemaName) {
        Schema schema = this.findSchema(schemaName);
        if (schema == null) {
            throw DbException.get(90079, schemaName);
        }
        return schema;
    }

    public synchronized void removeDatabaseObject(SessionLocal session, DbObject obj) {
        this.checkWritingAllowed();
        String objName = obj.getName();
        int type = obj.getType();
        ConcurrentHashMap<String, DbObject> map = this.getMap(type);
        if (SysProperties.CHECK && !map.containsKey(objName)) {
            throw DbException.getInternalError("not found: " + objName);
        }
        Comment comment = this.findComment(obj);
        this.lockMeta(session);
        if (comment != null) {
            this.removeDatabaseObject(session, comment);
        }
        int id = obj.getId();
        obj.removeChildrenAndResources(session);
        map.remove(objName);
        this.removeMeta(session, id);
    }

    public Table getDependentTable(SchemaObject obj, Table except) {
        switch (obj.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 13: {
                return null;
            }
        }
        HashSet<DbObject> set = new HashSet<DbObject>();
        for (Schema schema : this.schemas.values()) {
            for (Table t : schema.getAllTablesAndViews(null)) {
                if (except == t || TableType.VIEW == t.getTableType()) continue;
                set.clear();
                t.addDependencies(set);
                if (!set.contains(obj)) continue;
                return t;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(SessionLocal session, SchemaObject obj) {
        Constraint constraint;
        Table table;
        int type = obj.getType();
        if (type == 0) {
            Table table2 = (Table)obj;
            if (table2.isTemporary() && !table2.isGlobalTemporary()) {
                session.removeLocalTempTable(table2);
                return;
            }
        } else if (type == 1) {
            Index index = (Index)obj;
            table = index.getTable();
            if (table.isTemporary() && !table.isGlobalTemporary()) {
                session.removeLocalTempTableIndex(index);
                return;
            }
        } else if (type == 5 && (constraint = (Constraint)obj).getConstraintType() != Constraint.Type.DOMAIN && (table = constraint.getTable()).isTemporary() && !table.isGlobalTemporary()) {
            session.removeLocalTempTableConstraint(constraint);
            return;
        }
        this.checkWritingAllowed();
        this.lockMeta(session);
        Database database = this;
        synchronized (database) {
            Comment comment = this.findComment(obj);
            if (comment != null) {
                this.removeDatabaseObject(session, comment);
            }
            obj.getSchema().remove(obj);
            int id = obj.getId();
            if (!this.starting) {
                Table t = this.getDependentTable(obj, null);
                if (t != null) {
                    obj.getSchema().add(obj);
                    throw DbException.get(90107, obj.getTraceSQL(), t.getTraceSQL());
                }
                obj.removeChildrenAndResources(session);
            }
            this.removeMeta(session, id);
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public TraceSystem getTraceSystem() {
        return this.traceSystem;
    }

    public synchronized void setCacheSize(int kb) {
        if (this.starting) {
            int max = MathUtils.convertLongToInt(Utils.getMemoryMax()) / 2;
            kb = Math.min(kb, max);
        }
        this.store.setCacheSize(Math.max(1, kb));
    }

    public synchronized void setMasterUser(User user) {
        this.lockMeta(this.systemSession);
        this.addDatabaseObject(this.systemSession, user);
        this.systemSession.commit(true);
    }

    public Role getPublicRole() {
        return this.publicRole;
    }

    public String getTempTableName(String baseName, SessionLocal session) {
        String tempName;
        int maxBaseLength = 227;
        if (baseName.length() > maxBaseLength) {
            baseName = baseName.substring(0, maxBaseLength);
        }
        while (this.mainSchema.findTableOrView(session, tempName = baseName + "_COPY_" + session.getId() + "_" + this.nextTempTableId.getAndIncrement()) != null) {
        }
        return tempName;
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    @Override
    public void checkWritingAllowed() {
        if (this.readOnly) {
            throw DbException.get(90097);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getWriteDelay() {
        return this.store.getMvStore().getAutoCommitDelay();
    }

    public void setWriteDelay(int value) {
        this.store.getMvStore().setAutoCommitDelay(value < 0 ? 0 : value);
    }

    public int getRetentionTime() {
        return this.store.getMvStore().getRetentionTime();
    }

    public void setRetentionTime(int value) {
        this.store.getMvStore().setRetentionTime(value);
    }

    public void setAllowBuiltinAliasOverride(boolean b) {
        this.allowBuiltinAliasOverride = b;
    }

    public boolean isAllowBuiltinAliasOverride() {
        return this.allowBuiltinAliasOverride;
    }

    public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
        return this.store.getInDoubtTransactions();
    }

    synchronized void prepareCommit(SessionLocal session, String transaction) {
        if (!this.readOnly) {
            this.store.prepareCommit(session, transaction);
        }
    }

    void throwLastBackgroundException() {
        DbException b = this.backgroundException.getAndSet(null);
        if (b != null) {
            throw DbException.get(b.getErrorCode(), b, b.getMessage());
        }
    }

    public void setBackgroundException(DbException e) {
        TraceSystem t;
        if (this.backgroundException.compareAndSet(null, e) && (t = this.getTraceSystem()) != null) {
            t.getTrace(2).error(e, "flush");
        }
    }

    public Throwable getBackgroundException() {
        MVStoreException exception = this.store.getMvStore().getPanicException();
        if (exception != null) {
            return exception;
        }
        return this.backgroundException.getAndSet(null);
    }

    public synchronized void flush() {
        if (!this.readOnly) {
            try {
                this.store.flush();
            }
            catch (RuntimeException e) {
                this.backgroundException.compareAndSet(null, DbException.convert(e));
                throw e;
            }
        }
    }

    public void setEventListener(DatabaseEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void setEventListenerClass(String className) {
        if (className == null || className.isEmpty()) {
            this.eventListener = null;
        } else {
            try {
                this.eventListener = (DatabaseEventListener)JdbcUtils.loadUserClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Object url = this.databaseURL;
                if (this.cipher != null) {
                    url = (String)url + ";CIPHER=" + this.cipher;
                }
                this.eventListener.init((String)url);
            }
            catch (Throwable e) {
                throw DbException.get(90099, e, className, e.toString());
            }
        }
    }

    public void setProgress(int state, String name, long x, long max) {
        if (this.eventListener != null) {
            try {
                this.eventListener.setProgress(state, name, x, max);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void exceptionThrown(SQLException e, String sql) {
        if (this.eventListener != null) {
            try {
                this.eventListener.exceptionThrown(e, sql);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void sync() {
        if (this.readOnly) {
            return;
        }
        this.store.sync();
    }

    public int getMaxMemoryRows() {
        return this.maxMemoryRows;
    }

    public void setMaxMemoryRows(int value) {
        this.maxMemoryRows = value;
    }

    public void setLockMode(int lockMode) {
        switch (lockMode) {
            case 0: 
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                lockMode = 3;
                break;
            }
            default: {
                throw DbException.getInvalidValueException("lock mode", lockMode);
            }
        }
        this.lockMode = lockMode;
    }

    public int getLockMode() {
        return this.lockMode;
    }

    public void setCloseDelay(int value) {
        this.closeDelay = value;
    }

    public SessionLocal getSystemSession() {
        return this.systemSession;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setMaxLengthInplaceLob(int value) {
        this.maxLengthInplaceLob = value;
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return this.maxLengthInplaceLob;
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public boolean getIgnoreCase() {
        if (this.starting) {
            return false;
        }
        return this.ignoreCase;
    }

    public void setIgnoreCatalogs(boolean b) {
        this.ignoreCatalogs = b;
    }

    public boolean getIgnoreCatalogs() {
        return this.ignoreCatalogs;
    }

    public synchronized void setDeleteFilesOnDisconnect(boolean b) {
        this.deleteFilesOnDisconnect = b;
    }

    public void setAllowLiterals(int value) {
        this.allowLiterals = value;
    }

    public boolean getOptimizeReuseResults() {
        return this.optimizeReuseResults;
    }

    public void setOptimizeReuseResults(boolean b) {
        this.optimizeReuseResults = b;
    }

    @Override
    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }

    public int getSessionCount() {
        return this.userSessions.size();
    }

    public void setReferentialIntegrity(boolean b) {
        this.referentialIntegrity = b;
    }

    public boolean getReferentialIntegrity() {
        return this.referentialIntegrity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryStatistics(boolean b) {
        this.queryStatistics = b;
        Database database = this;
        synchronized (database) {
            if (!b) {
                this.queryStatisticsData = null;
            }
        }
    }

    public boolean getQueryStatistics() {
        return this.queryStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryStatisticsMaxEntries(int n) {
        this.queryStatisticsMaxEntries = n;
        if (this.queryStatisticsData != null) {
            Database database = this;
            synchronized (database) {
                if (this.queryStatisticsData != null) {
                    this.queryStatisticsData.setMaxQueryEntries(this.queryStatisticsMaxEntries);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryStatisticsData getQueryStatisticsData() {
        if (!this.queryStatistics) {
            return null;
        }
        if (this.queryStatisticsData == null) {
            Database database = this;
            synchronized (database) {
                if (this.queryStatisticsData == null) {
                    this.queryStatisticsData = new QueryStatisticsData(this.queryStatisticsMaxEntries);
                }
            }
        }
        return this.queryStatisticsData;
    }

    public boolean isStarting() {
        return this.starting;
    }

    void opened() {
        if (this.eventListener != null) {
            this.eventListener.opened();
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.getNextRemoteSettingsId();
    }

    @Override
    public Mode getMode() {
        return this.mode;
    }

    public void setDefaultNullOrdering(DefaultNullOrdering defaultNullOrdering) {
        this.defaultNullOrdering = defaultNullOrdering;
    }

    public DefaultNullOrdering getDefaultNullOrdering() {
        return this.defaultNullOrdering;
    }

    public void setMaxOperationMemory(int maxOperationMemory) {
        this.maxOperationMemory = maxOperationMemory;
    }

    public int getMaxOperationMemory() {
        return this.maxOperationMemory;
    }

    public SessionLocal getExclusiveSession() {
        return this.exclusiveSession.get();
    }

    public boolean setExclusiveSession(SessionLocal session, boolean closeOthers) {
        if (this.exclusiveSession.get() != session && !this.exclusiveSession.compareAndSet(null, session)) {
            return false;
        }
        if (closeOthers) {
            this.closeAllSessionsExcept(session);
        }
        return true;
    }

    public boolean unsetExclusiveSession(SessionLocal session) {
        return this.exclusiveSession.get() == null || this.exclusiveSession.compareAndSet(session, null);
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        if (this.lobFileListCache == null) {
            this.lobFileListCache = SmallLRUCache.newInstance(128);
        }
        return this.lobFileListCache;
    }

    public boolean isSysTableLocked() {
        return this.meta == null || this.meta.isLockedExclusively();
    }

    public boolean isSysTableLockedBy(SessionLocal session) {
        return this.meta == null || this.meta.isLockedExclusivelyBy(session);
    }

    public TableLinkConnection getLinkConnection(String driver, String url, String user, String password) {
        if (this.linkConnections == null) {
            this.linkConnections = new HashMap();
        }
        return TableLinkConnection.open(this.linkConnections, driver, url, user, password, this.dbSettings.shareLinkedConnections);
    }

    public String toString() {
        return this.databaseShortName + ":" + super.toString();
    }

    public void shutdownImmediately() {
        this.closing = true;
        this.setPowerOffCount(1);
        try {
            this.checkPowerOff();
        }
        catch (DbException dbException) {
            // empty catch block
        }
        this.closeFiles();
        this.powerOffCount = 0;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return this.tempFileDeleter;
    }

    public Table getFirstUserTable() {
        for (Schema schema : this.schemas.values()) {
            for (Table table : schema.getAllTablesAndViews(null)) {
                if (table.getCreateSQL() == null || schema.getId() == -1 && table.getName().equalsIgnoreCase("LOB_BLOCKS")) continue;
                return table;
            }
        }
        return null;
    }

    public void checkpoint() {
        if (this.persistent) {
            this.store.flush();
        }
        this.getTempFileDeleter().deleteUnused();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setCompactMode(int compactMode) {
        this.compactMode = compactMode;
    }

    public SourceCompiler getCompiler() {
        if (this.compiler == null) {
            this.compiler = new SourceCompiler();
        }
        return this.compiler;
    }

    @Override
    public LobStorageInterface getLobStorage() {
        return this.lobStorage;
    }

    public SessionLocal getLobSession() {
        return this.lobSession;
    }

    public int getDefaultTableType() {
        return this.defaultTableType;
    }

    public void setDefaultTableType(int defaultTableType) {
        this.defaultTableType = defaultTableType;
    }

    public DbSettings getSettings() {
        return this.dbSettings;
    }

    public <V> HashMap<String, V> newStringMap() {
        return this.dbSettings.caseInsensitiveIdentifiers ? new CaseInsensitiveMap() : new HashMap();
    }

    public <V> HashMap<String, V> newStringMap(int initialCapacity) {
        return this.dbSettings.caseInsensitiveIdentifiers ? new CaseInsensitiveMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public <V> ConcurrentHashMap<String, V> newConcurrentStringMap() {
        return this.dbSettings.caseInsensitiveIdentifiers ? new CaseInsensitiveConcurrentMap() : new ConcurrentHashMap();
    }

    public boolean equalsIdentifiers(String a, String b) {
        return a.equals(b) || this.dbSettings.caseInsensitiveIdentifiers && a.equalsIgnoreCase(b);
    }

    public String sysIdentifier(String upperName) {
        assert (Database.isUpperSysIdentifier(upperName));
        return this.dbSettings.databaseToLower ? StringUtils.toLowerEnglish(upperName) : upperName;
    }

    private static boolean isUpperSysIdentifier(String upperName) {
        int l = upperName.length();
        if (l == 0) {
            return false;
        }
        char c = upperName.charAt(0);
        if (c < 'A' || c > 'Z') {
            return false;
        }
        --l;
        int i = 1;
        while (i < l) {
            c = upperName.charAt(i);
            if ((c < 'A' || c > 'Z') && c != '_') {
                return false;
            }
            ++i;
        }
        return l <= 0 || (c = upperName.charAt(l)) >= 'A' && c <= 'Z';
    }

    @Override
    public int readLob(long lobId, byte[] hmac, long offset, byte[] buff, int off, int length) {
        throw DbException.getInternalError();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public JavaObjectSerializer getJavaObjectSerializer() {
        this.initJavaObjectSerializer();
        return this.javaObjectSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJavaObjectSerializer() {
        if (this.javaObjectSerializerInitialized) {
            return;
        }
        Database database = this;
        synchronized (database) {
            if (this.javaObjectSerializerInitialized) {
                return;
            }
            String serializerName = this.javaObjectSerializerName;
            if (serializerName != null && !(serializerName = serializerName.trim()).isEmpty() && !serializerName.equals("null")) {
                try {
                    this.javaObjectSerializer = (JavaObjectSerializer)JdbcUtils.loadUserClass(serializerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw DbException.convert(e);
                }
            }
            this.javaObjectSerializerInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaObjectSerializerName(String serializerName) {
        Database database = this;
        synchronized (database) {
            this.javaObjectSerializerInitialized = false;
            this.javaObjectSerializerName = serializerName;
            this.getNextRemoteSettingsId();
        }
    }

    public TableEngine getTableEngine(String tableEngine) {
        assert (Thread.holdsLock(this));
        TableEngine engine = this.tableEngines.get(tableEngine);
        if (engine == null) {
            try {
                engine = (TableEngine)JdbcUtils.loadUserClass(tableEngine).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw DbException.convert(e);
            }
            this.tableEngines.put(tableEngine, engine);
        }
        return engine;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        if (authenticator != null) {
            authenticator.init(this);
        }
        this.authenticator = authenticator;
    }

    @Override
    public ValueTimestampTimeZone currentTimestamp() {
        Session session = SessionLocal.getThreadLocalSession();
        if (session != null) {
            return session.currentTimestamp();
        }
        throw DbException.getUnsupportedException("Unsafe comparison or cast");
    }

    @Override
    public TimeZoneProvider currentTimeZone() {
        Session session = SessionLocal.getThreadLocalSession();
        if (session != null) {
            return session.currentTimeZone();
        }
        throw DbException.getUnsupportedException("Unsafe comparison or cast");
    }

    @Override
    public boolean zeroBasedEnums() {
        return this.dbSettings.zeroBasedEnums;
    }
}

